/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.charts.Bar;
import com.extentech.formats.XLS.charts.ChartFormat;
import com.extentech.formats.XLS.charts.ChartLine;
import com.extentech.formats.XLS.charts.ChartSeries;
import com.extentech.formats.XLS.charts.ChartType;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.HashMap;

public class ColChart
extends ChartType {
    protected Bar col = null;

    public ColChart(GenericChartObject charttype, ChartFormat cf, WorkBook wb) {
        super(charttype, cf, wb);
        this.col = (Bar)charttype;
        this.defaultShape = 0;
    }

    @Override
    public boolean isClustered() {
        return !this.isStacked() && !this.is100PercentStacked();
    }

    @Override
    public String getSVG(HashMap<String, Double> chartMetrics, HashMap<String, Object> axisMetrics, ChartSeries s) {
        double x = chartMetrics.get("x");
        double y = chartMetrics.get("y");
        double w = chartMetrics.get("w");
        double h = chartMetrics.get("h");
        double max = chartMetrics.get("max");
        double min = chartMetrics.get("min");
        Object[] categories = s.getCategories();
        ArrayList series = s.getSeriesValues();
        String[] seriescolors = s.getSeriesBarColors();
        String[] legends = s.getLegends();
        if (series.size() == 0) {
            Logger.logErr("Bar.getSVG: error in series");
            return "";
        }
        int n = series.size();
        int[] dls = this.getDataLabelInts();
        boolean isXReversed = (Boolean)axisMetrics.get("xAxisReversed");
        boolean isYReversed = (Boolean)axisMetrics.get("yAxisReversed");
        StringBuffer svg = new StringBuffer();
        svg.append("<g>\r\n");
        double barw = 0.0;
        double yfactor = 0.0;
        if (n > 0) {
            barw = w / ((double)categories.length * ((double)n + 1.0) + 1.0);
            if (max != 0.0) {
                yfactor = h / max;
            }
        }
        int rfX = !isXReversed ? 1 : -1;
        int rfY = !isYReversed ? 1 : -1;
        int i = 0;
        while (i < n) {
            svg.append("<g>\r\n");
            double y0 = y + (!isYReversed ? h : 0.0);
            double[] curseries = (double[])series.get(i);
            String[] curranges = (String[])s.getSeriesRanges().get(i);
            int j = 0;
            while (j < curseries.length) {
                double xx = x + barw * (double)(i + 1) + (double)(j * (n + 1)) * barw;
                double hh = yfactor * curseries[j];
                double yy = y0 - (!isYReversed ? hh : 0.0);
                svg.append("<rect id='series_" + (i + 1) + "' " + ColChart.getScript(curranges[j]) + " fill='" + seriescolors[i] + "' fill-opacity='1' stroke='black' stroke-opacity='1' stroke-width='1' stroke-linecap='butt' stroke-linejoin='miter' stroke-miterlimit='4'" + " x='" + xx + "' y='" + yy + "' width='" + barw + "' height='" + hh + "' fill-rule='evenodd'/>");
                String l = this.getSVGDataLabels(dls, axisMetrics, curseries[j], 0.0, i, legends, categories[j].toString());
                if (l != null) {
                    svg.append("<text x='" + (xx + barw / 2.0) + "' y='" + (y0 - (hh + 10.0) * (double)rfY) + "' style='text-anchor: middle;' " + ColChart.getDataLabelFontSVG() + ">" + l + "</text>\r\n");
                }
                ++j;
            }
            svg.append("</g>\r\n");
            ++i;
        }
        svg.append("</g>\r\n");
        return svg.toString();
    }

    @Override
    public StringBuffer getOOXML(String catAxisId, String valAxisId, String serAxisId) {
        ChartLine cl;
        StringBuffer cooxml = new StringBuffer();
        cooxml.append("<c:barChart>");
        cooxml.append("\r\n");
        cooxml.append("<c:barDir val=\"col\"/>");
        cooxml.append("<c:grouping val=\"");
        if (this.is100PercentStacked()) {
            cooxml.append("percentStacked");
        } else if (this.isStacked()) {
            cooxml.append("stacked");
        } else if (this.isClustered()) {
            cooxml.append("clustered");
        } else {
            cooxml.append("standard");
        }
        cooxml.append("\"/>");
        cooxml.append("\r\n");
        cooxml.append(this.getParentChart().getChartSeries().getOOXML(this.getChartType(), false, 0));
        if (!this.getChartOption("Gap").equals("150")) {
            cooxml.append("<c:gapWidth val=\"" + this.getChartOption("Gap") + "\"/>");
        }
        if (!this.getChartOption("Overlap").equals("0")) {
            cooxml.append("<c:overlap val=\"" + this.getChartOption("Overlap") + "\"/>");
        }
        if ((cl = this.cf.getChartLinesRec()) != null) {
            cooxml.append(cl.getOOXML());
        }
        cooxml.append("<c:axId val=\"" + catAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("<c:axId val=\"" + valAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("</c:barChart>");
        cooxml.append("\r\n");
        return cooxml;
    }
}

