/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ChartHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.OOXMLConstants;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Label;
import com.extentech.formats.XLS.MSODrawing;
import com.extentech.formats.XLS.Obj;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.Area;
import com.extentech.formats.XLS.charts.Area3DChart;
import com.extentech.formats.XLS.charts.AreaChart;
import com.extentech.formats.XLS.charts.Bar;
import com.extentech.formats.XLS.charts.Bar3DChart;
import com.extentech.formats.XLS.charts.BarChart;
import com.extentech.formats.XLS.charts.Boppop;
import com.extentech.formats.XLS.charts.BubbleChart;
import com.extentech.formats.XLS.charts.Chart;
import com.extentech.formats.XLS.charts.ChartAxes;
import com.extentech.formats.XLS.charts.ChartConstants;
import com.extentech.formats.XLS.charts.ChartFormat;
import com.extentech.formats.XLS.charts.ChartLine;
import com.extentech.formats.XLS.charts.ChartSeries;
import com.extentech.formats.XLS.charts.Col3DChart;
import com.extentech.formats.XLS.charts.ColChart;
import com.extentech.formats.XLS.charts.ConeBarChart;
import com.extentech.formats.XLS.charts.ConeChart;
import com.extentech.formats.XLS.charts.CylinderBarChart;
import com.extentech.formats.XLS.charts.CylinderChart;
import com.extentech.formats.XLS.charts.DoughnutChart;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.Legend;
import com.extentech.formats.XLS.charts.Line;
import com.extentech.formats.XLS.charts.Line3DChart;
import com.extentech.formats.XLS.charts.LineChart;
import com.extentech.formats.XLS.charts.OfPieChart;
import com.extentech.formats.XLS.charts.Pie;
import com.extentech.formats.XLS.charts.Pie3dChart;
import com.extentech.formats.XLS.charts.PieChart;
import com.extentech.formats.XLS.charts.PyramidBarChart;
import com.extentech.formats.XLS.charts.PyramidChart;
import com.extentech.formats.XLS.charts.Radar;
import com.extentech.formats.XLS.charts.RadarArea;
import com.extentech.formats.XLS.charts.RadarAreaChart;
import com.extentech.formats.XLS.charts.RadarChart;
import com.extentech.formats.XLS.charts.Scatter;
import com.extentech.formats.XLS.charts.ScatterChart;
import com.extentech.formats.XLS.charts.Series;
import com.extentech.formats.XLS.charts.SeriesList;
import com.extentech.formats.XLS.charts.SeriesText;
import com.extentech.formats.XLS.charts.StackedAreaChart;
import com.extentech.formats.XLS.charts.StackedColumn;
import com.extentech.formats.XLS.charts.StockChart;
import com.extentech.formats.XLS.charts.Surface;
import com.extentech.formats.XLS.charts.Surface3DChart;
import com.extentech.formats.XLS.charts.SurfaceChart;
import com.extentech.formats.XLS.charts.ThreeD;
import com.extentech.formats.cellformat.CellFormatFactory;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;

public abstract class ChartType
implements ChartConstants,
Serializable {
    private static final long serialVersionUID = -7862828186455339066L;
    protected GenericChartObject chartobj;
    protected Legend legend = null;
    protected ChartFormat cf = null;
    protected transient WorkBook wb = null;
    protected int defaultShape = 0;

    public ChartType() {
    }

    public ChartType(GenericChartObject charttype, ChartFormat cf, WorkBook wb) {
        this.chartobj = charttype;
        this.wb = wb;
        this.cf = cf;
    }

    public Chart getParentChart() {
        return this.chartobj.getParentChart();
    }

    public static ChartType create(int chartType, Chart parentChart, ChartFormat cf) {
        GenericChartObject co = ChartType.createUnderlyingChartObject(chartType, parentChart, cf);
        ChartType ct = ChartType.createChartTypeObject(co, cf, parentChart.getWorkBook());
        return ct;
    }

    public static ChartType createChartTypeObject(GenericChartObject ch, ChartFormat cf, WorkBook wb) {
        if (cf == null) {
            return null;
        }
        int barshape = cf.getBarShape();
        boolean threeD = cf.isThreeD(ch.chartType);
        boolean isStacked = ch.isStacked();
        boolean is100Percent = ch.is100Percent();
        switch (ch.chartType) {
            case 0: {
                if (barshape == 0) {
                    if (isStacked || is100Percent) {
                        return new StackedColumn(ch, cf, wb);
                    }
                    if (threeD) {
                        return new Col3DChart(ch, cf, wb);
                    }
                    return new ColChart(ch, cf, wb);
                }
                if (barshape == 257) {
                    return new ConeChart(ch, cf, wb);
                }
                if (barshape == 1) {
                    return new CylinderChart(ch, cf, wb);
                }
                if (barshape == 256) {
                    return new PyramidChart(ch, cf, wb);
                }
            }
            case 1: {
                if (barshape == 0) {
                    if (threeD) {
                        return new Bar3DChart(ch, cf, wb);
                    }
                    return new BarChart(ch, cf, wb);
                }
                if (barshape == 257) {
                    return new ConeBarChart(ch, cf, wb);
                }
                if (barshape == 1) {
                    return new CylinderBarChart(ch, cf, wb);
                }
                if (barshape == 256) {
                    return new PyramidBarChart(ch, cf, wb);
                }
            }
            case 2: {
                if (threeD) {
                    return new Line3DChart(ch, cf, wb);
                }
                return new LineChart(ch, cf, wb);
            }
            case 18: {
                return new StockChart(ch, cf, wb);
            }
            case 3: {
                cf.setPercentage(0);
                if (threeD) {
                    return new Pie3dChart(ch, cf, wb);
                }
                return new PieChart(ch, cf, wb);
            }
            case 4: {
                if (((Area)ch).isStacked()) {
                    return new StackedAreaChart(ch, cf, wb);
                }
                if (threeD) {
                    return new Area3DChart(ch, cf, wb);
                }
                return new AreaChart(ch, cf, wb);
            }
            case 5: {
                return new ScatterChart(ch, cf, wb);
            }
            case 6: {
                return new RadarChart(ch, cf, wb);
            }
            case 7: {
                if (((Surface)ch).getIs3d()) {
                    return new Surface3DChart(ch, cf, wb);
                }
                return new SurfaceChart(ch, cf, wb);
            }
            case 8: {
                cf.setPercentage(0);
                return new DoughnutChart(ch, cf, wb);
            }
            case 9: {
                return new BubbleChart(ch, cf, wb);
            }
            case 17: {
                return new RadarAreaChart(ch, cf, wb);
            }
            case 10: {
                cf.setPercentage(0);
                return new OfPieChart(ch, cf, wb);
            }
        }
        return null;
    }

    public static GenericChartObject createUnderlyingChartObject(int chartType, Chart parentchart, ChartFormat cf) {
        GenericChartObject c = null;
        switch (chartType) {
            case 0: {
                Bar col = (Bar)Bar.getPrototype();
                col.setAsColumnChart();
                c = col;
                break;
            }
            case 1: {
                Bar bar = (Bar)Bar.getPrototype();
                bar.setAsBarChart();
                c = bar;
                break;
            }
            case 3: {
                Pie p = (Pie)Pie.getPrototype();
                p.setAsPieChart();
                c = p;
                break;
            }
            case 18: {
                Line st = (Line)Line.getPrototype();
                st.setAsStockChart();
                c = st;
                break;
            }
            case 2: {
                Line l;
                c = l = (Line)Line.getPrototype();
                break;
            }
            case 4: {
                Area a = (Area)Area.getPrototype();
                c = a;
                break;
            }
            case 5: {
                Scatter s = (Scatter)Scatter.getPrototype();
                s.setAsScatterChart();
                c = s;
                break;
            }
            case 6: {
                Radar r2 = (Radar)Radar.getPrototype();
                c = r2;
                break;
            }
            case 7: {
                Surface su = (Surface)Surface.getPrototype();
                c = su;
                break;
            }
            case 8: {
                Pie d = (Pie)Pie.getPrototype();
                d.setAsDoughnutChart();
                c = d;
                break;
            }
            case 9: {
                Scatter bu = (Scatter)Scatter.getPrototype();
                bu.setAsBubbleChart();
                c = bu;
                break;
            }
            case 17: {
                RadarArea ra = (RadarArea)RadarArea.getPrototype();
                c = ra;
                break;
            }
            case 11: {
                Bar pyramid = (Bar)Bar.getPrototype();
                pyramid.setAsColumnChart();
                cf.setBarShape(256);
                c = pyramid;
                break;
            }
            case 13: {
                Bar cone = (Bar)Bar.getPrototype();
                cone.setAsColumnChart();
                cf.setBarShape(257);
                c = cone;
                break;
            }
            case 12: {
                Bar cy = (Bar)Bar.getPrototype();
                cy.setAsColumnChart();
                cf.setBarShape(1);
                c = cy;
                break;
            }
            case 14: {
                Bar pb = (Bar)Bar.getPrototype();
                pb.setAsBarChart();
                cf.setBarShape(256);
                c = pb;
                break;
            }
            case 16: {
                Bar cb = (Bar)Bar.getPrototype();
                cb.setAsBarChart();
                cf.setBarShape(257);
                c = cb;
                break;
            }
            case 15: {
                Bar cyb = (Bar)Bar.getPrototype();
                cyb.setAsBarChart();
                cf.setBarShape(1);
                c = cyb;
                break;
            }
            case 10: {
                Boppop ofpie = (Boppop)Boppop.getPrototype();
                c = ofpie;
            }
        }
        if (c != null) {
            c.setParentChart(parentchart);
        }
        return c;
    }

    public void setOptions(EnumSet<ChartHandle.ChartOptions> options) {
        ChartAxes ca = this.getParentChart().getAxes();
        int chartType = this.getChartType();
        if (options.contains((Object)ChartHandle.ChartOptions.STACKED)) {
            this.chartobj.setIsStacked(true);
        }
        if (options.contains((Object)ChartHandle.ChartOptions.PERCENTSTACKED)) {
            this.chartobj.setIs100Percent(true);
        }
        if (options.contains((Object)ChartHandle.ChartOptions.CLUSTERED)) {
            this.cf.setIsClustered(true);
        }
        if (options.contains((Object)ChartHandle.ChartOptions.SERLINES)) {
            this.cf.addChartLines(ChartLine.TYPE_SERIESLINE);
        }
        if (options.contains((Object)ChartHandle.ChartOptions.HILOWLINES)) {
            this.cf.addChartLines(ChartLine.TYPE_HILOWLINE);
        }
        if (options.contains((Object)ChartHandle.ChartOptions.DROPLINES)) {
            this.cf.addChartLines(ChartLine.TYPE_DROPLINE);
        }
        if (options.contains((Object)ChartHandle.ChartOptions.UPDOWNBARS)) {
            this.cf.addUpDownBars();
        }
        if (options.contains((Object)ChartHandle.ChartOptions.HASLINES)) {
            this.cf.setHasLines();
        }
        if (options.contains((Object)ChartHandle.ChartOptions.SMOOTHLINES)) {
            this.cf.setHasSmoothLines(true);
        }
        this.cf.setChartObject(this.chartobj);
        boolean use3Ddefaults = true;
        ThreeD threeD = this.cf.getThreeDRec(false);
        if (threeD == null) {
            if (options.contains((Object)ChartHandle.ChartOptions.THREED) || chartType == 7) {
                if (chartType != 9 && chartType != 5) {
                    threeD = this.initThreeD(chartType);
                } else if (chartType == 9) {
                    this.cf.setHas3DBubbles(true);
                }
            }
        } else {
            use3Ddefaults = false;
        }
        switch (chartType) {
            case 0: 
            case 1: {
                if (use3Ddefaults && threeD != null) {
                    threeD.setChartOption("AnRot", "20");
                    threeD.setChartOption("AnElev", "15");
                    threeD.setChartOption("TwoDWalls", "true");
                    threeD.setChartOption("ThreeDScaling", "false");
                    threeD.setChartOption("Cluster", "false");
                    threeD.setChartOption("PcDepth", "100");
                    threeD.setChartOption("PcDist", "30");
                    threeD.setChartOption("PcGap", "150");
                    threeD.setChartOption("PcHeight", "72");
                    threeD.setChartOption("Perspective", "false");
                    if (options.contains((Object)ChartHandle.ChartOptions.CLUSTERED)) {
                        threeD.setChartOption("Cluster", "true");
                        threeD.setChartOption("PcHeight", "62");
                        if (chartType == 0) {
                            threeD.setChartOption("Perspective", "true");
                        } else {
                            threeD.setChartOption("Perspective", "false");
                            threeD.setChartOption("ThreeDScaling", "true");
                            threeD.setChartOption("PcHeight", "150");
                        }
                    }
                }
                ca.setChartOption(0, "AddArea", "true");
                ca.setChartOption(1, "AddArea", "true");
                if (this.isStacked() || this.isClustered()) break;
                ca.createAxis(2);
                ca.setChartOption(2, "AddArea", "true");
                break;
            }
            case 2: {
                if (!options.contains((Object)ChartHandle.ChartOptions.THREED)) break;
                ca.setChartOption(0, "AddArea", "true");
                ca.setChartOption(1, "AddArea", "true");
                if (this.isStacked()) break;
                ca.createAxis(2);
                ca.setChartOption(2, "AddArea", "true");
                break;
            }
            case 18: {
                this.cf.addChartLines(ChartLine.TYPE_HILOWLINE);
                this.cf.setMarkers(0);
                break;
            }
            case 5: {
                if (options.contains((Object)ChartHandle.ChartOptions.HASLINES)) break;
                this.cf.setHasLines(5);
                break;
            }
            case 4: {
                if (use3Ddefaults && threeD != null) {
                    threeD.setChartOption("AnRot", "20");
                    threeD.setChartOption("TwoDWalls", "true");
                    threeD.setChartOption("ThreeDScaling", "false");
                    threeD.setChartOption("Perspective", "true");
                }
                this.setChartOption("Percentage", "25");
                this.setChartOption("SmoothedLine", "true");
                ca.setChartOption(0, "CrossBetween", "false");
                if (!options.contains((Object)ChartHandle.ChartOptions.THREED)) break;
                ca.setChartOption(0, "AddArea", "true");
                ca.setChartOption(1, "AddArea", "true");
                if (this.isStacked()) break;
                ca.createAxis(2);
                ca.setChartOption(2, "AddArea", "true");
                break;
            }
            case 9: {
                if (!options.contains((Object)ChartHandle.ChartOptions.THREED)) break;
                this.setChartOption("Percentage", "25");
                this.setChartOption("SmoothedLine", "true");
                this.setChartOption("ThreeDBubbles", "true");
                break;
            }
            case 3: {
                this.cf.setVaryColor(true);
                if (options.contains((Object)ChartHandle.ChartOptions.EXPLODED)) {
                    this.setChartOption("SmoothedLine", "true");
                    this.setChartOption("Percentage", "25");
                }
                if (use3Ddefaults && options.contains((Object)ChartHandle.ChartOptions.THREED)) {
                    this.setChartOption("AnRot", "236");
                }
                ca.removeAxes();
                break;
            }
            case 8: {
                if (options.contains((Object)ChartHandle.ChartOptions.EXPLODED)) {
                    this.setChartOption("SmoothedLine", "true");
                    this.setChartOption("Percentage", "25");
                }
                this.cf.setVaryColor(true);
                ca.removeAxes();
                break;
            }
            case 7: {
                if (use3Ddefaults && threeD != null) {
                    threeD.setChartOption("Cluster", "false");
                    threeD.setChartOption("TwoDWalls", "true");
                    threeD.setChartOption("ThreeDScaling", "true");
                    threeD.setChartOption("Perspective", "true");
                }
                ca.setChartOption(0, "AddArea", "true");
                ca.setChartOption(0, "AreaFg", "8");
                ca.setChartOption(0, "AreaBg", "78");
                ca.setChartOption(1, "AddArea", "true");
                ca.setChartOption(1, "AreaFg", "22");
                ca.setChartOption(1, "AreaBg", "78");
                ca.createAxis(2);
                if (use3Ddefaults && options.contains((Object)ChartHandle.ChartOptions.THREED)) {
                    threeD.setChartOption("AnElev", "15");
                    threeD.setChartOption("AnRot", "20");
                    threeD.setChartOption("PcDepth", "100");
                    threeD.setChartOption("PcDist", "30");
                    threeD.setChartOption("PcGap", "150");
                    threeD.setChartOption("PcHeight", "50");
                } else if (use3Ddefaults) {
                    threeD.setChartOption("AnElev", "90");
                    threeD.setChartOption("AnRot", "0");
                    threeD.setChartOption("PcDepth", "100");
                    threeD.setChartOption("PcDist", "0");
                    threeD.setChartOption("PcGap", "150");
                    threeD.setChartOption("PcHeight", "50");
                }
                if (options.contains((Object)ChartHandle.ChartOptions.WIREFRAME)) {
                    ((Surface)this.chartobj).setIsWireframe(true);
                }
                if (!options.contains((Object)ChartHandle.ChartOptions.WIREFRAME) && options.contains((Object)ChartHandle.ChartOptions.THREED)) {
                    this.chartobj.setChartOption("ColorFill", "true");
                    this.chartobj.setChartOption("Shading", "true");
                    break;
                }
                if (options.contains((Object)ChartHandle.ChartOptions.WIREFRAME)) {
                    this.chartobj.setChartOption("Shading", "true");
                    break;
                }
                this.chartobj.setChartOption("ColorFill", "true");
                break;
            }
            case 6: {
                if (!options.contains((Object)ChartHandle.ChartOptions.FILLED)) break;
                ((RadarChart)this).setFilled(true);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                if (threeD == null) {
                    threeD = this.initThreeD(chartType);
                }
                if (use3Ddefaults) {
                    threeD.setChartOption("AnElev", "15");
                    threeD.setChartOption("AnRot", "20");
                    threeD.setChartOption("Cluster", "true");
                    threeD.setChartOption("TwoDWalls", "true");
                    if (!options.contains((Object)ChartHandle.ChartOptions.THREED)) {
                        threeD.setChartOption("ThreeDScaling", "false");
                        threeD.setChartOption("Cluster", "true");
                    }
                    threeD.setChartOption("Perspective", "false");
                    threeD.setChartOption("PcDepth", "100");
                    threeD.setChartOption("PcDist", "30");
                    threeD.setChartOption("PcGap", "150");
                    threeD.setChartOption("PcHeight", "52");
                }
                if (chartType == 11 || chartType == 14) {
                    this.cf.setBarShape(256);
                    break;
                }
                if (chartType == 13 || chartType == 16) {
                    this.cf.setBarShape(257);
                    break;
                }
                if (chartType != 12 && chartType != 15) break;
                this.cf.setBarShape(1);
            }
        }
    }

    public static ChartType parseOOXML(XmlPullParser xpp, WorkBookHandle wbh, Chart parentChart, int nChart) {
        try {
            String endTag = xpp.getName();
            String tnm = xpp.getName();
            int eventType = xpp.getEventType();
            int chartType = 1;
            ChartAxes ca = parentChart.getAxes();
            Stack<String> lastTag = new Stack<String>();
            ChartFormat cf = parentChart.getChartOjectParent(nChart);
            EnumSet<ChartHandle.ChartOptions> options = EnumSet.noneOf(ChartHandle.ChartOptions.class);
            if (tnm.equals("bubble3D")) {
                options.add(ChartHandle.ChartOptions.THREED);
            } else if (tnm.equals(OOXMLConstants.twoDchartTypes[1])) {
                chartType = 1;
            } else if (tnm.equals(OOXMLConstants.twoDchartTypes[2])) {
                chartType = 2;
            } else if (tnm.equals(OOXMLConstants.twoDchartTypes[3])) {
                chartType = 3;
                parentChart.getAxes().removeAxes();
            } else if (tnm.equals(OOXMLConstants.twoDchartTypes[4])) {
                chartType = 4;
            } else if (tnm.equals(OOXMLConstants.twoDchartTypes[5])) {
                chartType = 5;
                ca.removeAxis(0);
                ca.createAxis(3);
            } else if (tnm.equals(OOXMLConstants.twoDchartTypes[6])) {
                chartType = 6;
            } else if (tnm.equals(OOXMLConstants.twoDchartTypes[7])) {
                chartType = 7;
            } else if (tnm.equals(OOXMLConstants.twoDchartTypes[8])) {
                chartType = 8;
                parentChart.getAxes().removeAxes();
            } else if (tnm.equals(OOXMLConstants.twoDchartTypes[9])) {
                chartType = 9;
                ca.removeAxis(0);
                ca.createAxis(3);
            } else if (tnm.equals(OOXMLConstants.threeDchartTypes[1])) {
                chartType = 1;
                options.add(ChartHandle.ChartOptions.THREED);
            } else if (tnm.equals(OOXMLConstants.threeDchartTypes[2])) {
                chartType = 2;
                options.add(ChartHandle.ChartOptions.THREED);
            } else if (tnm.equals(OOXMLConstants.threeDchartTypes[3])) {
                chartType = 3;
                options.add(ChartHandle.ChartOptions.THREED);
                parentChart.getAxes().removeAxes();
            } else if (tnm.equals(OOXMLConstants.threeDchartTypes[4])) {
                chartType = 4;
                options.add(ChartHandle.ChartOptions.THREED);
            } else if (tnm.equals(OOXMLConstants.threeDchartTypes[5])) {
                chartType = 5;
                ca.removeAxis(0);
                ca.createAxis(3);
                options.add(ChartHandle.ChartOptions.THREED);
            } else if (tnm.equals(OOXMLConstants.threeDchartTypes[6])) {
                chartType = 6;
                options.add(ChartHandle.ChartOptions.THREED);
            } else if (tnm.equals(OOXMLConstants.threeDchartTypes[7])) {
                chartType = 7;
                options.add(ChartHandle.ChartOptions.THREED);
            } else if (tnm.equals(OOXMLConstants.threeDchartTypes[8])) {
                chartType = 8;
                options.add(ChartHandle.ChartOptions.THREED);
                parentChart.getAxes().removeAxes();
            } else if (tnm.equals(OOXMLConstants.twoDchartTypes[10])) {
                chartType = 10;
                ca.removeAxis(0);
                ca.removeAxis(1);
            } else if (tnm.equals(OOXMLConstants.twoDchartTypes[18])) {
                chartType = 18;
            }
            GenericChartObject co = ChartType.createUnderlyingChartObject(chartType, parentChart, cf);
            cf.setChartObject(co);
            if (chartType == 7 && tnm.equals(OOXMLConstants.threeDchartTypes[7])) {
                ((Surface)co).setIs3d(true);
            }
            ChartType ct = ChartType.createChartTypeObject(co, cf, parentChart.getWorkBook());
            parentChart.addChartType(ct, nChart);
            while (eventType != 1) {
                if (eventType == 2) {
                    ChartLine cl;
                    tnm = xpp.getName();
                    lastTag.push(tnm);
                    String v = null;
                    try {
                        v = xpp.getAttributeValue(0);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (tnm.equals("grouping")) {
                        if (v.equals("stacked")) {
                            co.setIsStacked(true);
                        } else if (v.equals("percentStacked")) {
                            co.setIs100Percent(true);
                        } else if (v.equals("clustered")) {
                            cf.setIsClustered(true);
                        } else if (v.equals("standard")) {
                            co.setIsStacked(false);
                            co.setIs100Percent(false);
                        }
                    } else if (tnm.equals("barDir")) {
                        if (v.equals("col")) {
                            ((Bar)co).setAsColumnChart();
                            ct = ChartType.createChartTypeObject(co, cf, parentChart.getWorkBook());
                            parentChart.addChartType(ct, nChart);
                        }
                    } else if (tnm.equals("shape")) {
                        cf.setBarShape(ct.convertShape(v));
                        if (ct.defaultShape != 0) {
                            ct = ChartType.createChartTypeObject(co, cf, parentChart.getWorkBook());
                            parentChart.addChartType(ct, nChart);
                        }
                    } else if (tnm.equals("radarStyle")) {
                        if (v.equals("filled")) {
                            ((RadarChart)ct).setFilled(true);
                        } else {
                            v.equals("marker");
                        }
                    } else if (tnm.equals("wireframe")) {
                        ((Surface)co).setIsWireframe(v != null && v.equals("1"));
                    } else if (tnm.equals("scatterStyle")) {
                        if (v.equals("lineMarker")) {
                            cf.setHasLines();
                        } else if (v.equals("smoothMarker")) {
                            cf.setHasSmoothLines(true);
                        } else if (!v.equals("marker")) {
                            if (v.equals("line")) {
                                cf.setHasLines();
                            } else if (v.equals("smooth")) {
                                cf.setHasSmoothLines(true);
                            }
                        }
                    } else if (tnm.equals("varyColors")) {
                        cf.setVaryColor(xpp.getAttributeValue(0).equals("1"));
                    } else if (tnm.equals("dropLines")) {
                        cl = cf.addChartLines(ChartLine.TYPE_DROPLINE);
                        cl.parseOOXML(xpp, lastTag, cf, wbh);
                    } else if (tnm.equals("hiLowLines")) {
                        cl = cf.addChartLines(ChartLine.TYPE_HILOWLINE);
                        cl.parseOOXML(xpp, lastTag, cf, wbh);
                    } else if (tnm.equals("upDownBars")) {
                        cf.parseUpDownBarsOOXML(xpp, lastTag, wbh);
                    } else if (tnm.equals("serLines")) {
                        cl = cf.addChartLines(ChartLine.TYPE_SERIESLINE);
                        cl.parseOOXML(xpp, lastTag, cf, wbh);
                    } else if (tnm.equals("overlap")) {
                        co.setChartOption("Overlap", v);
                    } else if (tnm.equals("gapWidth")) {
                        co.setChartOption("Gap", v);
                    } else if (tnm.equals("ofPieType")) {
                        ((Boppop)co).setIsPieOfPie("pie".equals(v));
                    } else if (tnm.equals("gapDepth")) {
                        cf.setGapDepth(Integer.valueOf(v));
                    } else if (tnm.equals("firstSliceAn")) {
                        ((Pie)co).setAnStart(Integer.valueOf(v));
                    } else if (tnm.equals("holeSize")) {
                        ((Pie)co).setDoughnutSize(Integer.valueOf(v));
                    } else if (tnm.equals("secondPieSize")) {
                        ((Boppop)co).setSecondPieSize(Integer.valueOf(v));
                    } else if (tnm.equals("splitType")) {
                        ((Boppop)co).setSplitType(v);
                    } else if (tnm.equals("splitPos")) {
                        ((Boppop)co).setSplitPos(Integer.valueOf(v));
                    } else if (tnm.equals("ser")) {
                        Series series = ChartSeries.parseOOXML(xpp, wbh, ct, false, lastTag);
                    } else if (!tnm.equals("dLbls")) {
                        tnm.equals("marker");
                    }
                } else if (eventType == 3 && xpp.getName().equals(endTag)) break;
                eventType = xpp.next();
            }
            return ct;
        }
        catch (Exception e) {
            Logger.logErr("ChartType.parseChartType: " + e.toString());
            return null;
        }
    }

    protected int[] getDataLabelInts() {
        return this.chartobj.getParentChart().getDataLabelsPerSeries(this.cf.getDataLabelsInt());
    }

    protected int getDataLabel() {
        return this.cf.getDataLabelsInt();
    }

    protected int[] getMarkerFormats() {
        int mf = this.cf.getMarkerFormat();
        int[] markers = new int[this.getParentChart().getAllSeries(this.getParentChart().getChartOrder(this)).size()];
        if (mf > 0) {
            int i = 0;
            while (i < markers.length) {
                markers[i] = mf;
                ++i;
            }
        }
        return markers;
    }

    protected void setVaryColor(boolean b) {
        this.cf.setVaryColor(b);
    }

    public boolean getHasSmoothLines() {
        return this.cf.getHasSmoothLines();
    }

    public void setHasSmoothLines(boolean b) {
        this.cf.setHasSmoothLines(b);
    }

    public int getChartType() {
        return this.chartobj.chartType;
    }

    public void addLegend(Legend l) {
        this.legend = l;
    }

    public String getSVG() {
        return null;
    }

    public String getJSON() {
        return null;
    }

    public JSONObject getOptionsJSON() {
        return null;
    }

    public StringBuffer getOOXML(String catAxisId, String valAxisId, String serAxisId) {
        return null;
    }

    public JSONObject getJSON(ChartSeries s, WorkBookHandle wbh, Double[] minMax) throws JSONException {
        JSONObject chartObjectJSON = new JSONObject();
        chartObjectJSON.put("type", (Object)this.getTypeJSON());
        double yMax = 0.0;
        double yMin = 0.0;
        int nSeries = 0;
        JSONArray seriesJSON = new JSONArray();
        JSONArray seriesCOLORS = new JSONArray();
        try {
            ArrayList series = s.getSeriesRanges();
            String[] scolors = s.getSeriesBarColors();
            int i = 0;
            while (i < series.size()) {
                JSONArray seriesvals = CellRange.getValuesAsJSON(series.get(i).toString(), wbh);
                nSeries = Math.max(nSeries, seriesvals.length());
                int j = 0;
                while (j < seriesvals.length()) {
                    try {
                        yMax = Math.max(yMax, seriesvals.getDouble(j));
                        yMin = Math.min(yMin, seriesvals.getDouble(j));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ++j;
                }
                seriesJSON.put((Object)seriesvals);
                seriesCOLORS.put((Object)scolors[i]);
                ++i;
            }
            chartObjectJSON.put("Series", (Object)seriesJSON);
            chartObjectJSON.put("SeriesFills", (Object)seriesCOLORS);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        minMax[0] = new Double(yMin);
        minMax[1] = new Double(yMax);
        minMax[2] = new Double(nSeries);
        return chartObjectJSON;
    }

    public JSONObject getTypeJSON() throws JSONException {
        JSONObject typeJSON = new JSONObject();
        typeJSON.put("type", (Object)"Default");
        return typeJSON;
    }

    public String getSVG(HashMap<String, Double> chartMetrics, HashMap<String, Object> axisMetrics, ChartSeries s) {
        return "";
    }

    public String getSVGDataLabels(int[] datalabels, HashMap<String, Object> axisMetrics, double val, double percentage, int s, String[] legends, String cat) {
        boolean showValue;
        if (s >= datalabels.length) {
            return null;
        }
        boolean showValueLabel = (datalabels[s] & 0x40) == 64;
        boolean showValuePercent = (datalabels[s] & 2) == 2;
        boolean showCatPercent = (datalabels[s] & 4) == 4;
        boolean showCategories = (datalabels[s] & 0x10) == 16;
        boolean showBubbleLabel = (datalabels[s] & 0x20) == 32;
        boolean bl = showValue = (datalabels[s] & 1) == 1;
        if (showValue || showCategories || showValueLabel || showValuePercent || showBubbleLabel) {
            String l = "";
            if (showValueLabel) {
                l = String.valueOf(l) + legends[s] + " ";
            }
            if (showCategories) {
                l = String.valueOf(l) + CellFormatFactory.fromPatternString((String)axisMetrics.get("xPattern")).format(cat) + " ";
            }
            if (showValue || showBubbleLabel) {
                l = String.valueOf(l) + CellFormatFactory.fromPatternString((String)axisMetrics.get("yPattern")).format(String.valueOf(val));
            }
            if (showValuePercent) {
                l = String.valueOf(l) + (int)Math.round(percentage * 100.0) + "%";
            }
            return l;
        }
        return null;
    }

    public boolean hasDataLegend() {
        return this.legend != null;
    }

    public Legend getDataLegend() {
        return this.legend;
    }

    public void showLegend(boolean bShow, boolean vertical) {
        if (bShow && this.legend == null) {
            this.legend = Legend.createDefaultLegend(this.wb);
            this.legend.setParentChart(this.chartobj.getParentChart());
            int j = 0;
            while (j < this.legend.chartArr.size()) {
                ((GenericChartObject)this.legend.chartArr.get(j)).setParentChart(this.chartobj.getParentChart());
                ++j;
            }
            this.legend.setVertical(vertical);
            this.cf.chartArr.add(this.legend);
        } else if (bShow) {
            this.legend.setVertical(vertical);
        } else if (this.legend != null) {
            int i = Chart.findRecPosition(this.cf.chartArr, Legend.class);
            this.cf.chartArr.remove(i);
            this.legend = null;
        }
    }

    public String getDataLabels() {
        return this.cf.getDataLabels();
    }

    public int getDataLabelsInt() {
        return this.cf.getDataLabelsInt();
    }

    public int getBarShape() {
        return 0;
    }

    public int getMarkerFormat() {
        return this.cf.getMarkerFormat();
    }

    public boolean getHasLines() {
        return this.cf.getHasLines();
    }

    public boolean getHasDropLines() {
        return this.cf.getHasDropLines();
    }

    public void setHasDropLines() {
        this.cf.setHasDropLines();
    }

    public String getChartOption(String op) {
        String ret = this.chartobj.getChartOption(op);
        if (ret == null) {
            return this.cf.getChartOption(op);
        }
        return ret;
    }

    public String getChartOptionsXML() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.chartobj.getOptionsXML());
        sb.append(this.cf.getChartOptionsXML());
        return sb.toString();
    }

    public boolean setChartOption(String op, String val) {
        if (!this.chartobj.setChartOption(op, val)) {
            this.cf.setOption(op, val);
        }
        return true;
    }

    public boolean isThreeD() {
        return this.cf.isThreeD(this.chartobj.chartType);
    }

    public String getThreeDXML() {
        return this.cf.getThreeDXML();
    }

    public ThreeD initThreeD(int charttype) {
        ThreeD td = this.cf.getThreeDRec(true);
        td.setIsPie(charttype == 3 || charttype == 8);
        return td;
    }

    public ThreeD getThreeDRec(boolean bCreate) {
        return this.cf.getThreeDRec(bCreate);
    }

    public boolean isStacked() {
        return this.chartobj.isStacked();
    }

    public boolean is100PercentStacked() {
        return this.chartobj.is100Percent();
    }

    public void setIsStacked(boolean isstacked) {
        this.chartobj.setIsStacked(isstacked);
    }

    public void setIs100Psercent(boolean ispercentage) {
        this.chartobj.setIs100Percent(ispercentage);
    }

    public boolean isClustered() {
        return false;
    }

    public void addLegend() {
    }

    public static String getScript(String range) {
        return "onmouseover='highLight(evt); showRange(\"" + range + "\");' onclick='handleClick(evt);' onmouseout='restore(evt); hideRange();'";
    }

    public static String getFillOpacity() {
        return ".75";
    }

    public static String getTextColor() {
        return "#222222";
    }

    public static String getLightColor() {
        return "#CCCCCC";
    }

    public static String getMediumColor() {
        return "#555555";
    }

    public static String getDarkColor() {
        return "#333333";
    }

    protected String getFontSVG() {
        return this.getFontSVG(-1);
    }

    public static String getDataLabelFontSVG() {
        int sz = 9;
        return "font-family='Arial' font-size='" + sz + "' fill='" + ChartType.getDarkColor() + "' ";
    }

    public static String getStrokeSVG() {
        return ChartType.getStrokeSVG(1.0f, ChartType.getMediumColor());
    }

    public static String getStrokeSVG(float sz, String strokeclr) {
        String stk = " stroke='" + strokeclr + "'  stroke-opacity='1' stroke-width='" + sz + "' stroke-linecap='butt' stroke-linejoin='miter' stroke-miterlimit='4'";
        return stk;
    }

    protected String getFontSVG(int sz) {
        return "font-family='Arial' font-size='" + sz + "' fill='" + ChartType.getDarkColor() + "' ";
    }

    public int convertShape(String shape) {
        this.defaultShape = 0;
        if (shape.equals("box")) {
            this.defaultShape = 0;
        }
        if (shape.equals("cone")) {
            this.defaultShape = 257;
        }
        if (shape.equals("coneToMax")) {
            this.defaultShape = 513;
        }
        if (shape.equals("cylinder")) {
            this.defaultShape = 1;
        }
        if (shape.equals("pyramid")) {
            this.defaultShape = 256;
        }
        if (shape.equals("pyramidToMax")) {
            this.defaultShape = 512;
        }
        return this.defaultShape;
    }

    public String getShape() {
        switch (this.defaultShape) {
            case 0: {
                return "box";
            }
            case 1: {
                return "cylinder";
            }
            case 256: {
                return "pyramid";
            }
            case 257: {
                return "cone";
            }
            case 512: {
                return "pyramidToMax";
            }
            case 513: {
                return "coneToMax";
            }
        }
        return null;
    }

    public int getGapDepth() {
        return this.cf.getGapDepth();
    }

    protected SeriesList getSeriesList() {
        return (SeriesList)Chart.findRec(this.cf.chartArr, SeriesList.class);
    }

    public void WriteMainChartRecs(String fName) {
        try {
            File f = new File(fName);
            BufferedWriter writer = new BufferedWriter(new FileWriter(f));
            class Util {
                Util() {
                }

                public void writeRecs(BiffRec b, BufferedWriter writer, int level) throws IOException {
                    String tabs = "\t\t\t\t\t\t\t\t\t\t";
                    if (b == null) {
                        return;
                    }
                    writer.write(String.valueOf(tabs.substring(0, level)) + b.getClass().toString().substring(b.getClass().toString().lastIndexOf(46) + 1));
                    if (b instanceof SeriesText) {
                        writer.write("\t[" + ((SeriesText)b).toString() + "]");
                    } else if (b instanceof MSODrawing) {
                        writer.write("\t[" + ((MSODrawing)b).toString() + "]");
                        writer.write(((MSODrawing)b).debugOutput());
                        writer.write("\t[" + ByteTools.getByteDump(b.getData(), 0).substring(11) + "]");
                    } else if (b instanceof Obj) {
                        writer.write(((Obj)b).debugOutput());
                    } else if (b instanceof Label) {
                        writer.write("\t[" + ((Label)b).getStringVal() + "]");
                    } else {
                        writer.write("\t[" + ByteTools.getByteDump(ByteTools.shortToLEBytes(b.getOpcode()), 0) + "][" + ByteTools.getByteDump(b.getData(), 0).substring(11) + "]");
                    }
                    writer.newLine();
                    try {
                        if (((GenericChartObject)b).chartArr.size() > 0) {
                            ArrayList<XLSRecord> chartArr = ((GenericChartObject)b).chartArr;
                            int i = 0;
                            while (i < chartArr.size()) {
                                this.writeRecs(chartArr.get(i), writer, level + 1);
                                ++i;
                            }
                        }
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
            Util u = new Util();
            Vector v = this.getParentChart().getAllSeries();
            int i = 0;
            while (i < v.size()) {
                u.writeRecs((BiffRec)v.get(i), writer, 0);
                ++i;
            }
            writer.newLine();
            ArrayList chartArr = this.cf.chartArr;
            int i2 = 0;
            while (i2 < chartArr.size()) {
                u.writeRecs((BiffRec)chartArr.get(i2), writer, 0);
                ++i2;
            }
            writer.flush();
            writer.close();
            Object var3_4 = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

