/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.DLbls;
import com.extentech.formats.OOXML.DPt;
import com.extentech.formats.OOXML.Marker;
import com.extentech.formats.OOXML.SpPr;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.OOXMLAdapter;
import com.extentech.formats.XLS.WorkBookException;
import com.extentech.formats.XLS.Xf;
import com.extentech.formats.XLS.charts.Ai;
import com.extentech.formats.XLS.charts.Chart;
import com.extentech.formats.XLS.charts.ChartConstants;
import com.extentech.formats.XLS.charts.ChartType;
import com.extentech.formats.XLS.charts.PieChart;
import com.extentech.formats.XLS.charts.Series;
import com.extentech.formats.XLS.charts.SeriesList;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;

public class ChartSeries
implements ChartConstants,
Serializable {
    private static final long serialVersionUID = -7862828186455339066L;
    private ArrayList<Object[]> series = new ArrayList();
    private JSONArray seriesJSON = null;
    protected double[] minmaxcache = null;
    protected String[] legends;
    protected ArrayList seriesranges;
    protected Object[] categories;
    protected ArrayList seriesvalues;
    protected String[] seriescolors;
    protected Chart parentChart;
    int seriesNumber = 0;

    public void add(Object[] o) {
        this.series.add(o);
    }

    public void setParentChart(Chart c) {
        this.parentChart = c;
    }

    public double[] getMetrics(boolean isDirty) {
        int j;
        String[] sranges;
        double[] seriesvals;
        CellHandle[] ch;
        CellRange cr;
        Series myseries;
        Vector s;
        Boundsheet sht;
        ChartType co;
        block43: {
            if (!isDirty && this.minmaxcache != null) {
                return this.minmaxcache;
            }
            co = this.parentChart.getChartObject();
            this.seriesvalues = new ArrayList();
            this.seriesranges = new ArrayList();
            sht = this.parentChart.getSheet();
            s = this.getAllSeries(-1);
            if (s.size() > 0) {
                try {
                    CellRange cr2 = new CellRange(((Series)s.get(0)).getCategoryValueAi().toString(), this.parentChart.wbh, true);
                    CellHandle[] ch2 = cr2.getCells();
                    if (ch2 != null) {
                        this.categories = new Object[ch2.length];
                        int j2 = 0;
                        while (j2 < ch2.length) {
                            try {
                                this.categories[j2] = ch2[j2].getFormattedStringVal(true);
                            }
                            catch (IllegalArgumentException e) {
                                this.categories[j2] = ch2[j2].getStringVal();
                            }
                            ++j2;
                        }
                        break block43;
                    }
                    if (s.size() > 0) {
                        cr2 = new CellRange(((Series)s.get(0)).getSeriesValueAi().toString(), this.parentChart.wbh, true);
                        int sz = cr2.getCells().length;
                        this.categories = new Object[sz];
                        int j3 = 0;
                        while (j3 < sz) {
                            this.categories[j3] = Integer.valueOf(j3 + 1).toString();
                            ++j3;
                        }
                    }
                }
                catch (Exception e) {
                    Logger.logWarn("ChartSeries.getMinMax: " + e.toString());
                }
            }
        }
        double yMax = 0.0;
        double yMin = Double.MAX_VALUE;
        int nseries = 0;
        this.seriescolors = null;
        this.legends = null;
        int charttype = co.getChartType();
        if (charttype != 3 && charttype != 8) {
            this.seriescolors = new String[s.size()];
            this.legends = new String[s.size()];
            int i = 0;
            while (i < s.size()) {
                myseries = (Series)s.get(i);
                this.seriescolors[i] = myseries.getSeriesColor();
                this.legends[i] = OOXMLAdapter.stripNonAscii(myseries.getLegendText()).toString();
                cr = new CellRange(myseries.getSeriesValueAi().toString(), this.parentChart.wbh, true);
                ch = cr.getCells();
                nseries = Math.max(nseries, ch.length);
                if (!myseries.hasBubbleSizes()) {
                    seriesvals = new double[nseries];
                    sranges = new String[nseries];
                } else {
                    seriesvals = new double[nseries * 2];
                    sranges = new String[nseries * 2];
                }
                j = 0;
                while (j < ch.length) {
                    try {
                        sranges[j] = ch[j].getCellAddressWithSheet();
                        seriesvals[j] = ch[j].getDoubleVal();
                        if (Double.isNaN(seriesvals[j])) {
                            seriesvals[j] = 0.0;
                        }
                        yMax = Math.max(yMax, seriesvals[j]);
                        yMin = Math.min(yMin, seriesvals[j]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ++j;
                }
                if (myseries.hasBubbleSizes()) {
                    int z = ch.length;
                    CellRange crb = new CellRange(myseries.getBubbleValueAi().toString(), this.parentChart.wbh, true);
                    CellHandle[] chb = crb.getCells();
                    int j4 = 0;
                    while (j4 < ch.length) {
                        seriesvals[j4 + z] = chb[j4].getDoubleVal();
                        sranges[j4 + z] = chb[j4].getCellAddressWithSheet();
                        ++j4;
                    }
                }
                this.seriesvalues.add(seriesvals);
                this.seriesranges.add(sranges);
                ++i;
            }
        } else if (charttype == 8 && s.size() > 1) {
            this.legends = new String[this.categories.length];
            int i = 0;
            while (i < this.categories.length) {
                this.legends[i] = OOXMLAdapter.stripNonAscii(this.categories[i].toString()).toString();
                ++i;
            }
            i = 0;
            while (i < s.size()) {
                myseries = (Series)s.get(i);
                cr = new CellRange(myseries.getSeriesValueAi().toString(), this.parentChart.wbh, true);
                ch = cr.getCells();
                seriesvals = new double[ch.length];
                sranges = new String[ch.length];
                if (this.seriescolors == null) {
                    this.seriescolors = new String[ch.length];
                }
                j = 0;
                while (j < ch.length) {
                    try {
                        seriesvals[j] = ch[j].getDoubleVal();
                        if (ch[j].getWorkSheetHandle().getMysheet().equals(sht)) {
                            sranges[j] = ch[j].getCellAddress();
                        }
                        yMax = Math.max(yMax, seriesvals[j]);
                        yMin = Math.min(yMin, seriesvals[j]);
                        if (i == 0) {
                            this.seriescolors[j] = myseries.getPieSliceColor(j);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ++j;
                }
                this.seriesvalues.add(seriesvals);
                this.seriesranges.add(sranges);
                ++i;
            }
        } else if (s.size() > 0) {
            CellHandle[] cats = new CellRange(((Series)s.get(0)).getCategoryValueAi().toString(), this.parentChart.wbh, true).getCells();
            if (cats != null) {
                nseries = cats.length;
                this.legends = new String[cats.length];
                int i = 0;
                while (i < cats.length) {
                    this.legends[i] = cats[i].getFormattedStringVal(true);
                    ++i;
                }
            }
            this.seriescolors = new String[nseries];
            myseries = (Series)s.get(0);
            try {
                cr = new CellRange(myseries.getSeriesValueAi().toString(), this.parentChart.wbh, true);
                ch = cr.getCells();
                if (ch.length != nseries) {
                    Logger.logWarn("ChartHandle.getSeriesInfo: unexpected Pie Chart structure");
                    nseries = Math.min(nseries, ch.length);
                }
                seriesvals = new double[nseries];
                sranges = new String[nseries];
                int i = 0;
                while (i < nseries) {
                    this.seriescolors[i] = myseries.getPieSliceColor(i);
                    seriesvals[i] = ch[i].getDoubleVal();
                    if (ch[i].getWorkSheetHandle().getMysheet().equals(sht)) {
                        sranges[i] = ch[i].getCellAddress();
                    }
                    yMax = Math.max(yMax, seriesvals[i]);
                    yMin = Math.min(yMin, seriesvals[i]);
                    ++i;
                }
                this.seriesvalues.add(seriesvals);
                this.seriesranges.add(sranges);
            }
            catch (IllegalArgumentException cr3) {
                // empty catch block
            }
        }
        if (co.isStacked()) {
            double[] sum = new double[nseries];
            int i = 0;
            while (i < this.seriesvalues.size()) {
                double[] seriesv = (double[])this.seriesvalues.get(i);
                int j5 = 0;
                while (j5 < seriesv.length) {
                    sum[j5] = sum[j5] + seriesv[j5];
                    ++j5;
                }
                ++i;
            }
            yMax = 0.0;
            i = 0;
            while (i < nseries) {
                yMax = Math.max(sum[i], yMax);
                ++i;
            }
        }
        this.minmaxcache = new double[2];
        this.minmaxcache[0] = yMin;
        this.minmaxcache[1] = yMax;
        return this.minmaxcache;
    }

    public boolean changeSeriesRange(String originalrange, String newrange) {
        boolean changed = false;
        int i = 0;
        while (i < this.series.size()) {
            Series s = (Series)this.series.get(i)[0];
            Ai ai = s.getSeriesValueAi();
            if (ai != null && ai.toString().equalsIgnoreCase(originalrange)) {
                changed = ai.changeAiLocation(originalrange, newrange);
            }
            ++i;
        }
        return changed;
    }

    public String[] getSeries(int nChart) {
        Vector seriesperchart = this.getAllSeries(nChart);
        String[] retStr = new String[seriesperchart.size()];
        int i = 0;
        while (i < seriesperchart.size()) {
            Series s = (Series)seriesperchart.get(i);
            Ai a = s.getSeriesValueAi();
            retStr[i] = a.toString();
            ++i;
        }
        return retStr;
    }

    public String[] getCategories(int nChart) {
        Vector seriesperchart = this.getAllSeries(nChart);
        String[] retStr = new String[seriesperchart.size()];
        int i = 0;
        while (i < seriesperchart.size()) {
            Series s = (Series)seriesperchart.get(i);
            Ai a = s.getCategoryValueAi();
            retStr[i] = a.toString();
            ++i;
        }
        return retStr;
    }

    public Vector getAllSeries() {
        return this.getAllSeries(-1);
    }

    public Vector getAllSeries(int nChart) {
        Vector<Series> retVec = new Vector<Series>();
        int i = 0;
        while (i < this.series.size()) {
            Integer chart = (Integer)this.series.get(i)[1];
            if (nChart == -1 || nChart == chart) {
                Series s = (Series)this.series.get(i)[0];
                retVec.add(s);
            }
            ++i;
        }
        return retVec;
    }

    public Series addSeries(String seriesRange, String categoryRange, String bubbleRange, String legendRange, String legendText, ChartType chartObject, int nChart) {
        Series s = Series.getPrototype(seriesRange, categoryRange, bubbleRange, legendRange, legendText, chartObject);
        s.setParentChart(chartObject.getParentChart());
        s.setShape(chartObject.getBarShape());
        this.series.add(new Object[]{s, nChart});
        ArrayList chartArr = s.getParentChart().chartArr;
        int i = 0;
        while (i < chartArr.size()) {
            BiffRec br = (BiffRec)chartArr.get(i);
            BiffRec br2 = null;
            if (i < chartArr.size() - 1) {
                br2 = (BiffRec)chartArr.get(i + 1);
            }
            if (br != null && (br.getOpcode() == 4099 && br2.getOpcode() != 4099 || br.getOpcode() == 4146 && br2.getOpcode() == 4164)) {
                chartArr.add(i + 1, s);
                break;
            }
            ++i;
        }
        if (chartObject.getChartType() == 18) {
            s.setHasLines(5);
        }
        return s;
    }

    public void removeSeries(int index) {
        Vector v = this.getAllSeries();
        this.removeSeries((Series)v.get(index));
    }

    public void removeSeries(Series seriestodelete) {
        int z = 0;
        while (z < this.series.size()) {
            Series ss = (Series)this.series.get(z)[0];
            if (ss.equals(seriestodelete)) {
                this.series.remove(z);
                break;
            }
            ++z;
        }
    }

    public Series getSeries(String seriesName, int nChart) {
        Vector seriesperchart = this.getAllSeries(nChart);
        int i = 0;
        while (i < seriesperchart.size()) {
            Series s = (Series)seriesperchart.get(i);
            if (s.getLegendText().equalsIgnoreCase(seriesName)) {
                return s;
            }
            ++i;
        }
        return null;
    }

    public boolean changeCategoryRange(String originalrange, String newrange) {
        boolean changed = false;
        int i = 0;
        while (i < this.series.size()) {
            Series s = (Series)this.series.get(i)[0];
            Ai ai = s.getCategoryValueAi();
            if (ai.toString().equalsIgnoreCase(originalrange)) {
                changed = ai.changeAiLocation(originalrange, newrange);
            }
            ++i;
        }
        return changed;
    }

    public boolean changeTextValue(String originalval, String newval) {
        boolean changed = false;
        int i = 0;
        while (i < this.series.size()) {
            Series s = (Series)this.series.get(i)[0];
            Ai ai = s.getCategoryValueAi();
            if (ai.getText().equals(originalval)) {
                ai.setText(newval);
            }
            ++i;
        }
        return changed;
    }

    public JSONObject getDataRangeJSON() {
        JSONObject seriesJSON = new JSONObject();
        Vector allseries = this.getAllSeries(-1);
        try {
            JSONArray series = new JSONArray();
            int i = 0;
            while (i < allseries.size()) {
                try {
                    Series thisseries = (Series)allseries.get(i);
                    Ai serAi = thisseries.getSeriesValueAi();
                    if (i == 0) {
                        Ai catAi = thisseries.getCategoryValueAi();
                        seriesJSON.put("c", (Object)catAi.toString());
                    }
                    JSONObject seriesvals = new JSONObject();
                    seriesvals.put("v", (Object)serAi.toString());
                    seriesvals.put("l", (Object)thisseries.getLegendRef());
                    if (thisseries.hasBubbleSizes()) {
                        seriesvals.put("b", (Object)thisseries.getBubbleValueAi().toString());
                    }
                    series.put((Object)seriesvals);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            seriesJSON.put("Series", (Object)series);
        }
        catch (JSONException e) {
            Logger.logErr("ChartSeries.getDataRangeJSON:  Error retrieving Series Information: " + e.toString());
        }
        return seriesJSON;
    }

    public JSONArray getSeriesJSON() {
        return this.seriesJSON;
    }

    public void setSeriesJSON(JSONArray s) throws JSONException {
        this.seriesJSON = new JSONArray(s.toString());
    }

    public Ptg[] getCellRangePtgs() {
        CompatibleVector locptgs = new CompatibleVector();
        int i = 0;
        while (i < this.series.size()) {
            Series s = (Series)this.series.get(i)[0];
            int j = 0;
            while (j < s.chartArr.size()) {
                BiffRec br = (BiffRec)s.chartArr.get(j);
                if (br.getOpcode() == 4177) {
                    try {
                        Ptg[] ps = ((Ai)br).getCellRangePtgs();
                        int t = 0;
                        while (t < ps.length) {
                            locptgs.add(ps[t]);
                            ++t;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++j;
            }
            ++i;
        }
        Object[] ret = new Ptg[locptgs.size()];
        locptgs.toArray(ret);
        return ret;
    }

    public HashMap getSeriesPtgs() {
        HashMap<Series, Ptg[]> seriesPtgs = new HashMap<Series, Ptg[]>();
        int i = 0;
        while (i < this.series.size()) {
            Series s = (Series)this.series.get(i)[0];
            int j = 0;
            while (j < s.chartArr.size()) {
                BiffRec br = (BiffRec)s.chartArr.get(j);
                if (br.getOpcode() == 4177 && ((Ai)br).getType() == 1) {
                    try {
                        Ptg[] ps = ((Ai)br).getCellRangePtgs();
                        seriesPtgs.put(s, ps);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++j;
            }
            ++i;
        }
        return seriesPtgs;
    }

    public void addSeriesMapping(int nCharts, int[] seriesList) {
        int i = 0;
        while (i < seriesList.length) {
            try {
                int idx = seriesList[i] - 1;
                Series s = (Series)this.series.get(idx)[0];
                this.series.add(idx, new Object[]{s, nCharts});
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            ++i;
        }
    }

    public String[] getLegends(int nChart) {
        Vector seriesperchart = this.getAllSeries(nChart);
        String[] ret = new String[seriesperchart.size()];
        int i = 0;
        while (i < seriesperchart.size()) {
            ret[i] = ((Series)seriesperchart.get(i)).getLegendText();
            ++i;
        }
        return ret;
    }

    public int[] getMarkerFormats() {
        int[] markers = new int[this.series.size()];
        int i = 0;
        while (i < this.series.size()) {
            Series s = (Series)this.series.get(i)[0];
            markers[i] = s.getMarkerFormat();
            ++i;
        }
        return markers;
    }

    public static Series parseOOXML(XmlPullParser xpp, WorkBookHandle wbh, ChartType parentChart, boolean hasPivotTableSource, Stack<String> lastTag) {
        try {
            int eventType = xpp.getEventType();
            int idx = 0;
            int seriesidx = parentChart.getParentChart().getAllSeries().size();
            String[] ranges = new String[]{"", "", "", ""};
            String legendText = "";
            SpPr sp = null;
            DLbls d = null;
            Marker m = null;
            boolean smooth = false;
            ArrayList<DPt> dpts = null;
            String cache = null;
            while (eventType != 1) {
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("ser")) {
                        idx = 0;
                    } else if (!tnm.equals("order")) {
                        if (tnm.equals("cat") || tnm.equals("xVal")) {
                            idx = 1;
                        } else if (tnm.equals("val") || tnm.equals("yVal")) {
                            idx = 2;
                        } else if (tnm.equals("dLbls")) {
                            lastTag.push(tnm);
                            d = (DLbls)DLbls.parseOOXML(xpp, lastTag, wbh).cloneElement();
                            if (d.showBubbleSize()) {
                                parentChart.setChartOption("ShowBubbleSizes", "1");
                            }
                            if (d.showCatName()) {
                                parentChart.setChartOption("ShowCatLabel", "1");
                            }
                            if (d.showLeaderLines()) {
                                parentChart.setChartOption("ShowLdrLines", "1");
                            }
                            if (d.showLegendKey()) {
                                // empty if block
                            }
                            if (d.showPercent()) {
                                parentChart.setChartOption("ShowLabelPct", "1");
                            }
                            if (d.showSerName()) {
                                parentChart.setChartOption("ShowLabel", "1");
                            }
                            if (d.showVal()) {
                                parentChart.setChartOption("ShowValueLabel", "1");
                            }
                        } else if (tnm.equals("dPt")) {
                            if (dpts == null) {
                                dpts = new ArrayList<DPt>();
                            }
                            lastTag.push(tnm);
                            dpts.add((DPt)DPt.parseOOXML(xpp, lastTag, wbh).cloneElement());
                        } else if (tnm.equals("spPr")) {
                            lastTag.push(tnm);
                            sp = (SpPr)SpPr.parseOOXML(xpp, lastTag, wbh).cloneElement();
                        } else if (tnm.equals("marker")) {
                            lastTag.push(tnm);
                            m = (Marker)Marker.parseOOXML(xpp, lastTag, wbh).cloneElement();
                        } else if (tnm.equals("bubbleSize")) {
                            idx = 3;
                        } else if (tnm.equals("shape")) {
                            parentChart.convertShape(xpp.getAttributeValue(0));
                        } else if (tnm.equals("smooth")) {
                            smooth = xpp.getAttributeCount() == 0 || !xpp.getAttributeValue(0).equals("0");
                        } else if (tnm.equals("explosion")) {
                            String v = xpp.getAttributeValue(0);
                            parentChart.setChartOption("Percentage", v);
                        } else if (tnm.equals("formatCode")) {
                            Xf.addFormatPattern(wbh.getWorkBook(), OOXMLAdapter.getNextText(xpp));
                        } else if (tnm.equals("f")) {
                            ranges[idx] = OOXMLAdapter.getNextText(xpp);
                        } else if (tnm.equals("v")) {
                            if (idx == 0) {
                                legendText = OOXMLAdapter.getNextText(xpp);
                            } else if (idx == -1 || ranges[idx].equals("")) {
                                Logger.logWarn("ChartSeries.parseOOXML: unexpected text value");
                            }
                        } else if (tnm.equals("numCache") || tnm.equals("strCache") || tnm.equals("multiLvlStrRef")) {
                            cache = tnm;
                        } else if (tnm.equals("ptCount") && hasPivotTableSource) {
                            int npoints = Integer.valueOf(xpp.getAttributeValue(0));
                            if (!ranges[idx].equals("") && ranges[idx].indexOf(",") == -1) {
                                try {
                                    CellRange cells = new CellRange(ranges[idx], wbh, false, true);
                                    if (cells.getCells().length != npoints) {
                                        boolean z = false;
                                        CellHandle[] clist = cells.getCells();
                                        while (eventType != 1) {
                                            if (eventType == 2) {
                                                tnm = xpp.getName();
                                                if (!tnm.equals("pt")) {
                                                    tnm.equals("v");
                                                }
                                            } else if (eventType == 3 && xpp.getName().equals(cache)) {
                                                cache = null;
                                                break;
                                            }
                                            eventType = xpp.next();
                                        }
                                        if (npoints >= clist.length) continue;
                                        int[] rc = cells.getRangeCoords();
                                        rc[0] = rc[0] - 1;
                                        rc[2] = rc[2] - 1;
                                        if (rc[0] == rc[2]) {
                                            rc[3] = rc[3] - (clist.length - npoints);
                                        } else {
                                            rc[2] = rc[2] - (clist.length - npoints);
                                        }
                                        ranges[idx] = String.valueOf(cells.getSheet().getQualifiedSheetName()) + "!" + ExcelTools.formatLocation(rc);
                                        continue;
                                    }
                                }
                                catch (Exception e) {
                                    Logger.logErr("ChartSeries.parseOOXML: Error adjusting pivot range for " + parentChart + ":" + e.toString());
                                }
                            }
                        }
                    }
                } else if (eventType == 3 && xpp.getName().equals("ser")) {
                    lastTag.pop();
                    Series s = parentChart.getParentChart().getChartSeries().addSeries(ranges[2], ranges[1], ranges[3], ranges[0], legendText, parentChart, parentChart.getParentChart().getChartOrder(parentChart));
                    if (sp != null) {
                        s.setSpPr(sp);
                    } else if (seriesidx < 7) {
                        if (seriesidx > 0 && parentChart instanceof PieChart) {
                            Logger.logWarn("ChartSeries.parseOOXML:  more than 1 series encountered for a Pie-style chart");
                        } else {
                            s.setColor(wbh.getWorkBook().getTheme().genericThemeClrs[seriesidx + 4]);
                        }
                    }
                    if (d != null) {
                        s.setDLbls(d);
                    }
                    if (dpts != null) {
                        int z = 0;
                        while (z < dpts.size()) {
                            s.addDpt((DPt)dpts.get(z));
                            ++z;
                        }
                    }
                    if (m != null) {
                        s.setMarker(m);
                    }
                    if (smooth) {
                        s.setHasSmoothLines(smooth);
                    }
                    return s;
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("ChartSeries.parseOOXML: Error parsing series for " + parentChart + ":" + e.toString());
        }
        return null;
    }

    public void resetSeriesNumber() {
        this.seriesNumber = 0;
    }

    public String getOOXML(int ct, boolean isBubble3d, int nChart) {
        String catstr = ct == 5 || ct == 9 ? "xVal" : "cat";
        String valstr = ct == 5 || ct == 9 ? "yVal" : "val";
        StringBuffer ooxml = new StringBuffer();
        Vector v = this.parentChart.getAllSeries(nChart);
        int defaultDL = this.parentChart.getDataLabel();
        boolean from2003 = !this.parentChart.getWorkBook().getIsExcel2007();
        String[] cats = this.getCategories(nChart);
        int i = 0;
        while (i < v.size()) {
            int dl;
            Series s = (Series)v.get(i);
            ooxml.append("<c:ser>");
            ooxml.append("\r\n");
            ooxml.append("<c:idx val=\"" + this.seriesNumber + "\"/>");
            ooxml.append("\r\n");
            ooxml.append("<c:order val=\"" + this.seriesNumber++ + "\"/>");
            ooxml.append("\r\n");
            ooxml.append(s.getLegendOOXML(from2003));
            if (ct == 3) {
                ooxml.append("<c:explosion val=\"" + this.parentChart.getChartOption("Percentage") + "\"/>");
            }
            if (s.getMarker() != null) {
                ooxml.append(s.getMarker().getOOXML());
            }
            if (s.getDPt() != null) {
                DPt[] datapoints = s.getDPt();
                int z = 0;
                while (z < datapoints.length) {
                    ooxml.append(datapoints[z].getOOXML());
                    ++z;
                }
            }
            if (s.getDLbls() != null) {
                ooxml.append(s.getDLbls().getOOXML());
            } else if (from2003 && (dl = s.getDataLabel() | defaultDL) > 0) {
                DLbls dlbl = new DLbls((dl | 1) == 1, (dl | 8) == 8, false, (dl | 0x10) == 16, (dl | 0x40) == 64, (dl | 2) == 2, (dl | 0x20) == 32, null, null);
                ooxml.append(dlbl.getOOXML());
            }
            if (s.getHasSmoothedLines()) {
                ooxml.append("<c:smooth val=\"1\"/>");
                ooxml.append("\r\n");
            }
            ooxml.append(s.getCatOOXML(cats[i], catstr));
            ooxml.append(s.getValOOXML(valstr));
            if (ct == 9) {
                ooxml.append(s.getBubbleOOXML(isBubble3d));
            }
            ooxml.append("</c:ser>");
            ooxml.append("\r\n");
            ++i;
        }
        return ooxml.toString();
    }

    protected void updateSeriesMappings(SeriesList sl, int thischartnumber) {
        if (sl == null) {
            return;
        }
        ArrayList<Integer> seriesmappings = new ArrayList<Integer>();
        int z = 0;
        while (z < this.series.size()) {
            int chartnumber = (Integer)this.series.get(z)[1];
            if (chartnumber == thischartnumber) {
                seriesmappings.add(z + 1);
            }
            ++z;
        }
        int[] mappings = new int[seriesmappings.size()];
        int z2 = 0;
        while (z2 < seriesmappings.size()) {
            mappings[z2] = (Integer)seriesmappings.get(z2);
            ++z2;
        }
        try {
            sl.setSeriesMappings(mappings);
        }
        catch (Exception e) {
            throw new WorkBookException("ChartSeries.updateSeriesMappings failed:" + e.toString(), 4);
        }
    }

    public int[] getDataLabelsPerSeries(int defaultDL, int charttype) {
        if ((charttype == 3 || charttype == 8) && this.series.size() > 0) {
            Series s = (Series)this.series.get(0)[0];
            int[] dls = s.getDataLabelsPIE(defaultDL);
            if (dls == null) {
                dls = new int[]{defaultDL};
            }
            return dls;
        }
        int[] datalabels = new int[this.series.size()];
        int i = 0;
        while (i < this.series.size()) {
            Series s = (Series)this.series.get(i)[0];
            datalabels[i] = s.getDataLabel();
            int n = i++;
            datalabels[n] = datalabels[n] | defaultDL;
        }
        return datalabels;
    }

    public String[] getLegends() {
        if (this.legends == null) {
            this.getMetrics(true);
        }
        return this.legends;
    }

    public Object[] getCategories() {
        if (this.categories == null) {
            this.getMetrics(true);
        }
        return this.categories;
    }

    public ArrayList getSeriesRanges() {
        if (this.seriesranges == null) {
            this.getMetrics(true);
        }
        return this.seriesranges;
    }

    public ArrayList getSeriesValues() {
        if (this.seriesvalues == null) {
            this.getMetrics(true);
        }
        return this.seriesvalues;
    }

    public String[] getSeriesBarColors() {
        if (this.seriescolors == null) {
            this.getMetrics(true);
        }
        return this.seriescolors;
    }
}

