/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.XLS.Font;
import com.extentech.formats.XLS.charts.Axis;
import com.extentech.formats.XLS.charts.AxisParent;
import com.extentech.formats.XLS.charts.Chart;
import com.extentech.formats.XLS.charts.ChartConstants;
import com.extentech.formats.XLS.charts.Pos;
import com.extentech.formats.XLS.charts.TextDisp;
import com.extentech.formats.XLS.charts.Tick;
import com.extentech.formats.XLS.charts.ValueRange;
import com.extentech.formats.cellformat.CellFormatFactory;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;

public class ChartAxes
implements ChartConstants,
Serializable {
    private static final long serialVersionUID = -7862828186455339066L;
    private AxisParent ap;
    ArrayList axes = new ArrayList();
    HashMap<String, Object> axisMetrics = new HashMap();

    public ChartAxes(AxisParent ap) {
        this.ap = ap;
    }

    public void add(Axis a) {
        this.axes.add(a);
        a.setAP(this.ap);
    }

    public void setTd(int axisType, TextDisp td) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            a.setTd(td);
        }
    }

    public boolean hasAxis(int axisType) {
        int i = 0;
        while (i < this.axes.size()) {
            if (((Axis)this.axes.get(i)).getAxis() == axisType) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void createAxis(int axisType) {
        Axis a = this.getAxis(axisType, true);
    }

    private Axis getAxis(int axisType, boolean bCreateIfNecessary) {
        int i = 0;
        while (i < this.axes.size()) {
            if (((Axis)this.axes.get(i)).getAxis() == axisType) {
                return (Axis)this.axes.get(i);
            }
            ++i;
        }
        if (bCreateIfNecessary) {
            this.axes.add(this.ap.getAxis(axisType, bCreateIfNecessary));
            return (Axis)this.axes.get(this.axes.size() - 1);
        }
        return null;
    }

    protected boolean isReversed(int axisType) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            return a.isReversed();
        }
        return false;
    }

    protected String getNumberFormat(int axisType) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            return a.getNumberFormat();
        }
        return null;
    }

    public void removeAxes() {
        this.ap.removeAxes();
        while (this.axes.size() > 0) {
            this.axes.remove(0);
        }
    }

    public void removeAxis(int axisType) {
        this.ap.removeAxis(axisType);
        int i = 0;
        while (i < this.axes.size()) {
            if (((Axis)this.axes.get(i)).getAxis() == axisType) {
                this.axes.remove(i);
                break;
            }
            ++i;
        }
    }

    public float[] getPlotAreaCoords(float w, float h) {
        float[] plotcoords;
        Pos p = (Pos)Chart.findRec(this.ap.chartArr, Pos.class);
        if (p != null && (plotcoords = p.getCoords()) != null) {
            plotcoords[0] = Pos.convertFromSPRC(plotcoords[0], w, 0.0f);
            plotcoords[1] = Pos.convertFromSPRC(plotcoords[1], 0.0f, h);
            plotcoords[2] = Pos.convertFromSPRC(plotcoords[2], w, 0.0f);
            plotcoords[3] = Pos.convertFromSPRC(plotcoords[3], 0.0f, h);
            return plotcoords;
        }
        return null;
    }

    public String getPlotAreaBgColor() {
        return this.ap.getPlotAreaBgColor();
    }

    public void setPlotAreaBgColor(int bg) {
        this.ap.setPlotAreaBgColor(bg);
    }

    public void setPlotAreaBorder(int lw, int lclr) {
        this.ap.setPlotAreaBorder(lw, lclr);
    }

    public String getAxisOptionsXML(int axisType) {
        return this.ap.getAxisOptionsXML(axisType);
    }

    public String getTitle(int axisType) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            return a.getTitle();
        }
        return "";
    }

    public void setTitle(int axisType, String Title2) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            boolean defaultIsVert = axisType == 1 && "".equals(a.getTitle());
            a.setTitle(Title2);
            if (defaultIsVert) {
                a.getTd().setRotation(90);
            }
        }
    }

    public int getLabelRotation(int axisType) {
        Tick t;
        int rot = 0;
        Axis a = this.getAxis(axisType, false);
        if (a != null && (t = (Tick)Chart.findRec(a.chartArr, Tick.class)) != null) {
            rot = t.getRotation();
            switch (rot) {
                case 0: {
                    break;
                }
                case 1: {
                    rot = 180;
                    break;
                }
                case 2: {
                    rot = -90;
                    break;
                }
                case 3: {
                    rot = 90;
                }
            }
        }
        return rot;
    }

    public int getTitleRotation(int axisType) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            TextDisp td = a.getTd();
            return td.getRotation();
        }
        return 0;
    }

    public float[] getCoords(int axisType) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            TextDisp td = a.getTd();
            return td.getCoords();
        }
        return new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    }

    public double[] getMinMax(double ymin, double ymax) {
        return this.getMinMax(ymin, ymax, 1);
    }

    public double[] getMinMax(double ymin, double ymax, int axisType) {
        Axis a = this.getAxis(axisType, false);
        double[] ret = new double[4];
        if (a != null) {
            ValueRange v = (ValueRange)Chart.findRec(a.getChartRecords(), ValueRange.class);
            if (v.isAutomaticScale()) {
                v.setMaxMin(ymax, ymin);
            }
            ret[0] = v.getMin();
            ret[1] = v.getMax();
            ret[2] = v.getMinorTick();
            ret[3] = v.getMajorTick();
        }
        return ret;
    }

    public int getAxisMajorUnit(int axisType) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            return a.getMajorUnit();
        }
        return 10;
    }

    public int getAxisMinorUnit(int axisType) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            return a.getMinorUnit();
        }
        return 1;
    }

    public void setAxisMax(int axisType, int MaxValue) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            a.setMaxScale(MaxValue);
        }
    }

    public void setAxisMin(int axisType, int MinValue) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            a.setMinScale(MinValue);
        }
    }

    public void setAxisAutomaticScale(int axisType, boolean b) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            a.setAutomaticScale(b);
        }
    }

    public boolean getAxisAutomaticScale(int axisType) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            return a.isAutomaticScale();
        }
        return false;
    }

    public boolean getAxisAutomaticScale() {
        Axis a = this.getAxis(1, false);
        if (a != null) {
            return a.isAutomaticScale();
        }
        return false;
    }

    public void setAxisAutomaticScale(boolean b) {
        Axis a = this.getAxis(1, false);
        if (a != null) {
            a.setAutomaticScale(b);
        }
    }

    public void setAxisMax(int MaxValue) {
        Axis a = this.getAxis(1, false);
        if (a != null) {
            a.setMaxScale(MaxValue);
        }
    }

    public void setAxisMin(int MinValue) {
        Axis a = this.getAxis(1, false);
        if (a != null) {
            a.setMinScale(MinValue);
        }
    }

    public String getSVG(int axisType, Map<String, Double> chartMetrics, Object[] categories) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            return a.getSVG(this, chartMetrics, categories);
        }
        return null;
    }

    public String getOOXML(int axisType, int type, String id, String crossId) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            return a.getOOXML(type, id, crossId);
        }
        return "";
    }

    public void setTitleFont(int axisType, int fondId) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            a.setFont(fondId);
        }
    }

    public Font getTitleFont(int axisType) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            return a.getFont();
        }
        return null;
    }

    public Font getLabelFont(int axisType) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            return a.getLabelFont();
        }
        return null;
    }

    public JSONObject getJSON(int axisType, WorkBookHandle wbh, int chartType, double yMax, double yMin, int nSeries) {
        return this.ap.getAxis(axisType, false).getJSON(wbh, chartType, yMax, yMin, nSeries);
    }

    public void setChartOption(int axisType, String op, String val) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            a.setChartOption(op, val);
        }
    }

    public int getAxisPlacement(int axisType) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            return a.getAxisPlacement();
        }
        return -1;
    }

    public void setAxisPlacement(int axisType, int placement) {
        Axis a = this.getAxis(axisType, false);
        if (a != null) {
            a.setAxisPlacement(placement);
        }
    }

    public void parseOOXML(int axisType, XmlPullParser xpp, String tnm, Stack<String> lastTag, WorkBookHandle bk) {
        Axis a = this.getAxis(axisType, true);
        if (a != null) {
            a.removeTitle();
            a.setChartOption("MajorGridLines", "false");
            a.parseOOXML(xpp, tnm, lastTag, bk);
        }
    }

    public void close() {
        this.axes.clear();
        this.axes = null;
        this.ap = null;
        this.axisMetrics.clear();
    }

    public HashMap getMetrics() {
        return this.axisMetrics;
    }

    public Object getMetric(String metric) {
        return this.axisMetrics.get(metric);
    }

    public HashMap<String, Object> getMetrics(int charttype, HashMap<String, Double> chartMetrics, float[] plotcoords, Object[] categories) {
        String pattern;
        double[] minmax = this.getMinMax(chartMetrics.get("min"), chartMetrics.get("max"));
        chartMetrics.put("min", minmax[0]);
        chartMetrics.put("max", minmax[1]);
        this.axisMetrics.put("minor", minmax[2]);
        this.axisMetrics.put("major", minmax[3]);
        this.axisMetrics.put("xAxisReversed", this.isReversed(0));
        this.axisMetrics.put("xPattern", this.getNumberFormat(0));
        this.axisMetrics.put("yAxisReversed", this.isReversed(1));
        this.axisMetrics.put("yPattern", this.getNumberFormat(1));
        this.axisMetrics.put("XAXISLABELOFFSET", 0.0);
        this.axisMetrics.put("XAXISTITLEOFFSET", 0.0);
        this.axisMetrics.put("YAXISLABELOFFSET", 0.0);
        this.axisMetrics.put("YAXISTITLEOFFSET", 0.0);
        if (!this.getTitle(0).equals("")) {
            Font ef = this.getTitleFont(0);
            java.awt.Font f = new java.awt.Font(ef.getFontName(), ef.getFontWeight(), (int)ef.getFontHeightInPoints());
            AtomicInteger h = new AtomicInteger(0);
            double w = this.getRotatedWidth(f, h, this.getTitle(0), this.getTitleRotation(0));
            this.axisMetrics.put("XAXISTITLEOFFSET", new Double(h.intValue() + 10));
        }
        if (this.hasAxis(1)) {
            String title = this.getTitle(1);
            if (!title.equals("")) {
                Font ef = this.getTitleFont(1);
                java.awt.Font f = new java.awt.Font(ef.getFontName(), ef.getFontWeight(), (int)ef.getFontHeightInPoints());
                AtomicInteger h = new AtomicInteger(0);
                double w = this.getRotatedWidthVert(f, h, this.getTitle(1), this.getTitleRotation(1));
                this.axisMetrics.put("YAXISTITLEOFFSET", w);
            } else {
                this.axisMetrics.put("YAXISTITLEOFFSET", 20.0);
            }
        }
        StringBuffer[] series = new StringBuffer[]{};
        try {
            double major = (Double)this.getMetric("major");
            double min = chartMetrics.get("min");
            double max = chartMetrics.get("max");
            if (major > 0.0) {
                int nSeries = 0;
                nSeries = min == 0.0 ? (major != 0.0 ? (int)(max / major) + 1 : 0) : (major != 0.0 ? (int)((max - min) / major) + 1 : 0);
                nSeries = Math.abs(nSeries);
                series = new StringBuffer[nSeries];
                if (Math.floor(major) != major) {
                    String s = String.valueOf(major);
                    int z = s.indexOf(".");
                    int scale = 0;
                    if (z != -1) {
                        scale = s.length() - (z + 1);
                    }
                    z = 0;
                    double i = min;
                    while (i <= max) {
                        BigDecimal bd = new BigDecimal(i).setScale(scale, 4);
                        series[z++] = new StringBuffer(CellFormatFactory.fromPatternString((String)this.getMetric("yPattern")).format(bd.toString()));
                        i += major;
                    }
                } else {
                    int z = 0;
                    double i = min;
                    while (i <= max) {
                        series[z++] = new StringBuffer(CellFormatFactory.fromPatternString((String)this.getMetric("yPattern")).format(i));
                        i += major;
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.logWarn("ChartAxes.getMetrics.  Error obtaining Series: " + e.toString());
        }
        if (this.hasAxis(0) && charttype != 6 && charttype != 17) {
            Object[] s;
            if (charttype != 1) {
                s = categories;
                pattern = (String)this.getMetric("xPattern");
            } else {
                s = series;
                pattern = (String)this.getMetric("yPattern");
            }
            double width = chartMetrics.get("w") / (double)s.length - 6.0;
            Font lf = this.getLabelFont(0);
            AtomicInteger rot = new AtomicInteger(this.getLabelRotation(0));
            double off = this.getLabelOffsets(lf, width, s, rot, pattern, true);
            this.axisMetrics.put("xAxisRotate", rot.intValue());
            this.axisMetrics.put("XAXISLABELOFFSET", off);
        }
        if (this.hasAxis(1) && charttype != 6 && charttype != 17) {
            Object[] s;
            if (charttype != 1) {
                s = series;
                pattern = (String)this.getMetric("yPattern");
            } else {
                s = categories;
                pattern = (String)this.getMetric("xPattern");
            }
            AtomicInteger rot = new AtomicInteger(this.getLabelRotation(1));
            Font lf = this.getLabelFont(1);
            double width = chartMetrics.get("w") / 2.0 - 10.0;
            double off = this.getLabelOffsets(lf, width, s, rot, pattern, false);
            this.axisMetrics.put("yAxisRotate", rot.intValue());
            this.axisMetrics.put("YAXISLABELOFFSET", off);
        }
        return this.axisMetrics;
    }

    private double getLabelOffsets(Font lf, double width, Object[] strings, AtomicInteger rot, String pattern, boolean horiz) {
        double retwidth = 0.0;
        java.awt.Font f = null;
        double h = 0.0;
        try {
            f = new java.awt.Font(lf.getFontName(), lf.getFontWeight(), (int)lf.getFontHeightInPoints());
            int i = 0;
            while (i < strings.length) {
                AtomicInteger height = new AtomicInteger(0);
                StringBuffer s = null;
                try {
                    s = new StringBuffer(CellFormatFactory.fromPatternString(pattern).format(strings[i].toString()));
                }
                catch (IllegalArgumentException e) {
                    s = new StringBuffer(strings[i].toString());
                }
                double w = horiz ? this.getRotatedWidth(f, height, s.toString(), rot.intValue()) : this.getRotatedWidthVert(f, height, s.toString(), rot.intValue());
                h = Math.max((double)height.intValue(), h);
                w = this.addLinesToFit(f, s, rot, w, width, height);
                if (w > width) {
                    width = w;
                }
                strings[i] = s;
                retwidth = Math.max(w, retwidth);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (horiz) {
            return h;
        }
        return retwidth;
    }

    private double getRotatedWidth(java.awt.Font f, AtomicInteger height, String s, int rot) {
        double retWidth = 0.0;
        String[] slines = s.split("\n");
        int i = 0;
        while (i < slines.length) {
            double width;
            if (rot == 0) {
                width = StringTool.getApproximateStringWidth(f, CellFormatFactory.fromPatternString(null).format(slines[i]));
                height.set((int)Math.ceil(f.getSize() * 3));
            } else if (Math.abs(rot) == 90) {
                width = Math.ceil(f.getSize() * 2);
                height.set((int)Math.max((double)height.intValue(), StringTool.getApproximateStringWidth(f, CellFormatFactory.fromPatternString(null).format(slines[i]))));
            } else {
                width = StringTool.getApproximateStringWidth(f, CellFormatFactory.fromPatternString(null).format(slines[i]));
                width = Math.ceil(width * Math.cos(Math.toRadians(rot)));
                height.set((int)Math.ceil(width * Math.sin(Math.toRadians(rot))));
            }
            retWidth = Math.max(width, retWidth);
            ++i;
        }
        return retWidth;
    }

    private double getRotatedWidthVert(java.awt.Font f, AtomicInteger height, String s, int rot) {
        double retWidth = 0.0;
        String[] slines = s.split("\n");
        int i = 0;
        while (i < slines.length) {
            double width;
            if (Math.abs(rot) == 90) {
                height.set((int)StringTool.getApproximateStringWidth(f, CellFormatFactory.fromPatternString(null).format(slines[i])));
                width = Math.ceil(f.getSize() * 2);
            } else if (rot == 0) {
                height.set((int)Math.ceil(f.getSize() * 3));
                width = Math.max((double)height.intValue(), StringTool.getApproximateStringWidth(f, CellFormatFactory.fromPatternString(null).format(slines[i])));
            } else {
                width = StringTool.getApproximateStringWidth(f, CellFormatFactory.fromPatternString(null).format(slines[i]));
                width = Math.ceil(width * Math.cos(Math.toRadians(rot)));
                height.set((int)Math.ceil(width * Math.sin(Math.toRadians(rot))));
            }
            retWidth = Math.max(width, retWidth);
            ++i;
        }
        return retWidth;
    }

    private double addLinesToFit(java.awt.Font f, StringBuffer s, AtomicInteger rot, double len, double width, AtomicInteger height) {
        double retLen = Math.min(width, len);
        String str = s.toString().trim();
        while (len > width) {
            int lastSpace = -1;
            int j = s.lastIndexOf("\n") + 1;
            len = -1.0;
            while (len < width && j < str.length()) {
                len += StringTool.getApproximateCharWidth(f, Character.valueOf(str.charAt(j)));
                if (str.charAt(j) == ' ') {
                    lastSpace = j;
                }
                ++j;
            }
            if (len < width) break;
            if (lastSpace == -1) {
                if (str.indexOf(32) == -1) {
                    if (rot.intValue() != -90) {
                        rot.set(45);
                        len = this.getRotatedWidth(f, height, str, rot.intValue());
                        if (!(len > width)) {
                            rot.set(-90);
                        }
                    }
                    if (rot.intValue() == -90) {
                        len = this.getRotatedWidth(f, height, str, rot.intValue());
                    }
                    retLen = Math.max(len, retLen);
                    break;
                }
                lastSpace = s.toString().indexOf(32);
            }
            s.replace(lastSpace, lastSpace + 1, "\n");
            str = s.toString();
        }
        return retLen;
    }
}

