/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;

public class Boppop
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = 8071801452993935943L;
    boolean fAutoSplit;
    boolean fHasShadow;
    short split;
    short iSplitPos;
    short pcSplitPercent;
    short pcPieSize;
    short pcGap;
    float numSplitValue;
    byte pst;
    private byte[] PROTOTYPE_BYTES;

    public Boppop() {
        byte[] byArray = new byte[22];
        byArray[0] = 1;
        byArray[1] = 1;
        byArray[8] = 75;
        byArray[10] = 100;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        byte[] data = this.getData();
        this.pst = data[0];
        this.fAutoSplit = data[1] == 1;
        this.split = ByteTools.readShort(data[2], data[3]);
        this.iSplitPos = ByteTools.readShort(data[4], data[5]);
        this.pcSplitPercent = ByteTools.readShort(data[6], data[7]);
        this.pcPieSize = ByteTools.readShort(data[8], data[9]);
        this.pcGap = ByteTools.readShort(data[10], data[11]);
        this.numSplitValue = (float)ByteTools.eightBytetoLEDouble(this.getBytesAt(12, 8));
        this.fHasShadow = (data[20] & 1) == 1;
        this.chartType = 10;
    }

    public static XLSRecord getPrototype() {
        Boppop b = new Boppop();
        b.setOpcode((short)4193);
        b.setData(b.PROTOTYPE_BYTES);
        b.init();
        return b;
    }

    public boolean isPieOfPie() {
        return this.pst == 1;
    }

    public void setIsPieOfPie(boolean b) {
        this.pst = b ? (byte)1 : (byte)2;
        this.getData()[0] = this.pst;
    }

    public void setpcGap(int g) {
        this.pcGap = (short)g;
        byte[] b = ByteTools.shortToLEBytes(this.pcGap);
        this.getData()[10] = b[0];
        this.getData()[11] = b[1];
    }

    public int getpcGap() {
        return this.pcGap;
    }

    public void setSecondPieSize(int s) {
        this.pcPieSize = (short)s;
        byte[] b = ByteTools.shortToLEBytes(this.pcPieSize);
        this.getData()[8] = b[0];
        this.getData()[9] = b[1];
    }

    public int getSecondPieSize() {
        return this.pcPieSize;
    }

    public void setSplitType(int t) {
        this.fAutoSplit = false;
        this.getData()[1] = 0;
        this.split = (short)t;
        byte[] b = ByteTools.shortToLEBytes(this.split);
        this.getData()[2] = b[0];
        this.getData()[3] = b[1];
    }

    public void setSplitType(String s) {
        if (s == null) {
            this.fAutoSplit = true;
            this.getData()[1] = 0;
            return;
        }
        this.fAutoSplit = false;
        this.getData()[1] = 0;
        if (s.equals("pos")) {
            this.split = 0;
        } else if (s.equals("val")) {
            this.split = 1;
        } else if (s.equals("percent")) {
            this.split = (short)2;
        } else if (s.equals("cust")) {
            this.split = (short)3;
        }
        byte[] b = ByteTools.shortToLEBytes(this.split);
        this.getData()[2] = b[0];
        this.getData()[3] = b[1];
    }

    public int getSplitType() {
        if (this.fAutoSplit) {
            return -1;
        }
        return this.split;
    }

    public String getSplitTypeOOXML() {
        if (this.fAutoSplit) {
            return "auto";
        }
        switch (this.split) {
            case 0: {
                return "pos";
            }
            case 1: {
                return "val";
            }
            case 2: {
                return "percent";
            }
            case 3: {
                return "cust";
            }
        }
        return "auto";
    }

    public void setSplitPos(int sp) {
        this.iSplitPos = (short)sp;
        byte[] b = ByteTools.shortToLEBytes(this.iSplitPos);
        this.getData()[4] = b[0];
        this.getData()[5] = b[1];
    }

    public int getSplitPos() {
        return this.iSplitPos;
    }

    @Override
    public boolean setChartOption(String op, String val) {
        if (op.equalsIgnoreCase("Gap")) {
            this.setpcGap(Integer.parseInt(val));
        }
        return true;
    }
}

