/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.charts.Bar;
import com.extentech.formats.XLS.charts.BarChart;
import com.extentech.formats.XLS.charts.ChartFormat;
import com.extentech.formats.XLS.charts.GenericChartObject;

public class Bar3DChart
extends BarChart {
    public Bar3DChart(GenericChartObject charttype, ChartFormat cf, WorkBook wb) {
        super(charttype, cf, wb);
        this.bar = (Bar)charttype;
    }

    @Override
    public StringBuffer getOOXML(String catAxisId, String valAxisId, String serAxisId) {
        int gapdepth;
        StringBuffer cooxml = new StringBuffer();
        cooxml.append("<c:bar3DChart>");
        cooxml.append("\r\n");
        cooxml.append("<c:barDir val=\"bar\"/>");
        cooxml.append("<c:grouping val=\"");
        if (this.is100PercentStacked()) {
            cooxml.append("percentStacked");
        } else if (this.isStacked()) {
            cooxml.append("stacked");
        } else if (this.cf.is3DClustered()) {
            cooxml.append("clustered");
        } else {
            cooxml.append("standard");
        }
        cooxml.append("\"/>");
        cooxml.append("\r\n");
        cooxml.append(this.getParentChart().getChartSeries().getOOXML(this.getChartType(), false, 0));
        if (!this.getChartOption("Gap").equals("150")) {
            cooxml.append("<c:gapWidth val=\"" + this.getChartOption("Gap") + "\"/>");
        }
        if ((gapdepth = this.getGapDepth()) != 0) {
            cooxml.append("<c:gapDepth val=\"" + gapdepth + "\"/>");
        }
        cooxml.append("<c:shape val=\"" + this.getShape() + "\"/>");
        cooxml.append("<c:axId val=\"" + catAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("<c:axId val=\"" + valAxisId + "\"/>");
        cooxml.append("\r\n");
        if (this.getParentChart().getAxes().hasAxis(2)) {
            cooxml.append("<c:axId val=\"" + serAxisId + "\"/>");
            cooxml.append("\r\n");
        } else {
            cooxml.append("<c:axId val=\"0\"/>");
            cooxml.append("\r\n");
        }
        cooxml.append("</c:bar3DChart>");
        cooxml.append("\r\n");
        return cooxml;
    }
}

