/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;

public class Bar
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = 8917510368688674273L;
    private short grbit = 0;
    protected boolean fStacked = false;
    protected boolean f100 = false;
    protected boolean fHasShadow = false;
    protected short pcOverlap = 0;
    protected short pcGap = (short)50;
    private byte[] PROTOTYPE_BYTES;

    public Bar() {
        byte[] byArray = new byte[6];
        byArray[2] = -106;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        this.pcOverlap = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.pcGap = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.grbit = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.chartType = (this.grbit & 1) == 1 ? 1 : 0;
        this.fStacked = (this.grbit & 2) == 2;
        this.f100 = (this.grbit & 4) == 4;
        this.fHasShadow = (this.grbit & 8) == 8;
    }

    @Override
    public boolean isStacked() {
        return this.fStacked;
    }

    @Override
    public boolean is100Percent() {
        return this.f100;
    }

    @Override
    public boolean hasShadow() {
        return this.fHasShadow;
    }

    public int getGap() {
        return this.pcGap;
    }

    public int getOverlap() {
        return this.pcOverlap;
    }

    @Override
    public void setIsStacked(boolean bIsStacked) {
        this.fStacked = bIsStacked;
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fStacked, 1);
        if (bIsStacked) {
            this.pcOverlap = (short)-100;
            this.pcGap = (short)150;
        }
        this.updateRecord();
    }

    @Override
    public void setIs100Percent(boolean bOn) {
        this.f100 = bOn;
        this.grbit = ByteTools.updateGrBit(this.grbit, this.f100, 2);
        if (bOn) {
            this.pcOverlap = (short)-100;
            this.pcGap = (short)150;
        }
        this.updateRecord();
    }

    public void setHasShadow(boolean bHasShadow) {
        this.fHasShadow = bHasShadow;
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fHasShadow, 3);
        this.updateRecord();
    }

    public void setIsClustered() {
        this.setIsStacked(false);
        this.setIs100Percent(false);
    }

    public void setpcOverlap(int overlap) {
        this.pcOverlap = (short)overlap;
        this.updateRecord();
    }

    public void setpcGap(int gap) {
        this.pcGap = (short)gap;
        this.updateRecord();
    }

    public void setAsBarChart() {
        this.grbit = ByteTools.updateGrBit(this.grbit, true, 0);
        this.chartType = 1;
        this.updateRecord();
    }

    public void setAsColumnChart() {
        this.grbit = ByteTools.updateGrBit(this.grbit, false, 0);
        this.chartType = 0;
        this.updateRecord();
    }

    private void updateRecord() {
        byte[] b = ByteTools.shortToLEBytes(this.pcOverlap);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
        b = ByteTools.shortToLEBytes(this.pcGap);
        this.getData()[2] = b[0];
        this.getData()[3] = b[1];
        b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[4] = b[0];
        this.getData()[5] = b[1];
    }

    public static XLSRecord getPrototype() {
        Bar b = new Bar();
        b.setOpcode((short)4119);
        b.setData(b.PROTOTYPE_BYTES);
        b.init();
        b.setAsColumnChart();
        return b;
    }

    @Override
    public boolean setChartOption(String op, String val) {
        boolean bHandled = false;
        if (op.equalsIgnoreCase("Stacked")) {
            this.setIsStacked(true);
            bHandled = true;
        } else if (op.equalsIgnoreCase("PercentageDisplay")) {
            this.setIs100Percent(true);
            bHandled = true;
        } else if (op.equalsIgnoreCase("Shadow")) {
            this.setHasShadow(true);
            bHandled = true;
        } else if (op.equalsIgnoreCase("Overlap")) {
            this.setpcOverlap(Integer.parseInt(val));
            bHandled = true;
        } else if (op.equalsIgnoreCase("Gap")) {
            this.setpcGap(Integer.parseInt(val));
            bHandled = true;
        }
        return bHandled;
    }

    @Override
    public String getChartOption(String op) {
        if (op.equals("Gap")) {
            return String.valueOf(this.getGap());
        }
        if (op.equals("Overlap")) {
            return String.valueOf(this.getOverlap());
        }
        return super.getChartOption(op);
    }
}

