/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.ExpressionParser;
import com.extentech.formats.XLS.FormulaNotFoundException;
import com.extentech.formats.XLS.WorkSheetNotFoundException;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.SeriesText;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.IxtiListener;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArea3d;
import com.extentech.formats.XLS.formulas.PtgMemFunc;
import com.extentech.formats.XLS.formulas.PtgMystery;
import com.extentech.formats.XLS.formulas.PtgParen;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.formats.XLS.formulas.PtgRef3d;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import java.util.List;
import java.util.Stack;

public final class Ai
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = -6647823755603289012L;
    private Stack expression;
    protected int id = -1;
    protected int ifmt = -1;
    protected int cce = -1;
    private short grbit = (short)-1;
    private short rt = (short)-1;
    private boolean fCustomIfmt = false;
    private SeriesText st = null;
    public static final int TYPE_TEXT = 0;
    public static final int TYPE_VALS = 1;
    public static final int TYPE_CATEGORIES = 2;
    public static final int TYPE_BUBBLES = 3;
    private String boundName = "";
    private String origSheetName = "";
    private int boundXti = -1;
    protected static byte[] AI_TYPE_LEGEND;
    protected static byte[] AI_TYPE_SERIES;
    protected static byte[] AI_TYPE_CATEGORY;
    protected static byte[] AI_TYPE_BUBBLE;
    protected static byte[] AI_TYPE_NULL_LEGEND;

    static {
        byte[] byArray = new byte[8];
        byArray[1] = 2;
        AI_TYPE_LEGEND = byArray;
        byte[] byArray2 = new byte[8];
        byArray2[0] = 1;
        byArray2[1] = 2;
        AI_TYPE_SERIES = byArray2;
        byte[] byArray3 = new byte[8];
        byArray3[0] = 2;
        byArray3[1] = 2;
        AI_TYPE_CATEGORY = byArray3;
        byte[] byArray4 = new byte[8];
        byArray4[0] = 3;
        byArray4[1] = 1;
        AI_TYPE_BUBBLE = byArray4;
        byte[] byArray5 = new byte[8];
        byArray5[1] = 1;
        AI_TYPE_NULL_LEGEND = byArray5;
    }

    public String getBoundName() {
        return this.boundName;
    }

    public int getBoundXti() {
        return this.boundXti;
    }

    public void populateForTransfer(String origSheetName) {
        if ("".equals(this.boundName)) {
            this.origSheetName = origSheetName;
            int t = 0;
            while (t < this.expression.size()) {
                PtgRef pt;
                Ptg p = (Ptg)this.expression.get(t);
                if (p instanceof PtgArea3d) {
                    pt = (PtgArea3d)p;
                    try {
                        this.boundName = ((PtgArea3d)pt).getSheetName();
                        this.boundXti = ((PtgArea3d)pt).getIxti();
                    }
                    catch (Exception e) {
                        Logger.logErr("Ai.populateForTransfer: Chart contains links to other data sources");
                    }
                } else if (p instanceof PtgRef3d) {
                    pt = (PtgRef3d)p;
                    try {
                        this.boundName = ((PtgRef3d)pt).getSheetName();
                        this.boundXti = ((PtgRef3d)pt).getIxti();
                    }
                    catch (Exception e) {
                        Logger.logErr("Ai.populateForTransfer: Chart contains links to other data sources");
                    }
                } else if (p instanceof PtgMemFunc) {
                    PtgRef pr;
                    Ptg ptg = ((PtgMemFunc)p).getFirstloc();
                    if (ptg instanceof PtgRef3d) {
                        pr = (PtgRef3d)ptg;
                        try {
                            this.boundName = ((PtgRef3d)pr).getSheetName();
                            this.boundXti = ((PtgRef3d)pr).getIxti();
                        }
                        catch (Exception e) {
                            Logger.logErr("Ai.populateForTransfer: Chart contains links to other data sources");
                        }
                    } else {
                        pr = (PtgArea3d)ptg;
                        try {
                            this.boundName = ((PtgArea3d)pr).getSheetName();
                            this.boundXti = ((PtgArea3d)pr).getIxti();
                        }
                        catch (Exception e) {
                            Logger.logErr("Ai.populateForTransfer: Chart contains links to other data sources");
                        }
                    }
                }
                ++t;
            }
        }
    }

    public void setLegend(String newLegend) {
        this.setRt(1);
        this.st.setText(newLegend);
        this.expression = null;
    }

    public boolean setText(String txt) {
        try {
            this.st.setText(txt);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String getText() {
        try {
            if (this.st != null) {
                return this.st.toString();
            }
        }
        catch (Exception e) {
            if (this.DEBUGLEVEL > 0) {
                Logger.logWarn("Error getting Chart String value: " + e);
            }
            return this.getDefinition();
        }
        return "undefined";
    }

    @Override
    public String toString() {
        switch (this.id) {
            case 0: {
                return this.getText();
            }
            case 1: {
                return this.getDefinition();
            }
            case 2: {
                return this.getDefinition();
            }
            case 3: {
                return this.getDefinition();
            }
        }
        return super.toString();
    }

    public void setSeriesText(SeriesText s) {
        this.st = s;
    }

    public void setExternsheetRef(int x) throws WorkSheetNotFoundException {
        byte[] dt = this.getData();
        int pos = 8;
        int t = 0;
        while (t < this.expression.size()) {
            Ptg pr;
            Ptg p = (Ptg)this.expression.get(t);
            if (p instanceof PtgArea3d) {
                PtgArea3d pt = (PtgArea3d)p;
                pt.setIxti((short)x);
                pt.addToRefTracker();
                if (this.DEBUGLEVEL > 3) {
                    Logger.logInfo("Setting sheet reference for: " + pt.toString() + "  in Ai record.");
                }
                this.getWorkBook().getExternSheet().addPtgListener(pt);
                this.updateRecord();
            } else if (p instanceof PtgRef3d) {
                pr = (PtgRef3d)p;
                ((PtgRef3d)pr).setIxti((short)x);
                ((PtgRef)pr).addToRefTracker();
                if (this.DEBUGLEVEL > 3) {
                    Logger.logInfo("Setting sheet reference for: " + ((PtgRef3d)pr).toString() + "  in Ai record.");
                }
                this.getWorkBook().getExternSheet().addPtgListener((IxtiListener)((Object)pr));
                this.updateRecord();
            } else if (p instanceof PtgMemFunc) {
                pr = ((PtgMemFunc)p).getFirstloc();
                if (pr instanceof PtgRef3d) {
                    ((PtgRef3d)pr).setIxti((short)x);
                    ((PtgRef3d)pr).addToRefTracker();
                    this.getWorkBook().getExternSheet().addPtgListener((PtgRef3d)pr);
                } else {
                    ((PtgArea3d)pr).setIxti((short)x);
                    ((PtgArea3d)pr).addToRefTracker();
                    this.getWorkBook().getExternSheet().addPtgListener((PtgArea3d)pr);
                }
                if (this.DEBUGLEVEL > 3) {
                    Logger.logInfo("Setting sheet reference for: " + pr.toString() + "  in Ai record.");
                }
                this.updateRecord();
            } else {
                Logger.logInfo("Ai.setExternsheetRef: unknown Ptg");
            }
            ++t;
        }
    }

    public void setExternsheetRef(int oldRef, int newRef) throws WorkSheetNotFoundException {
        int t = 0;
        while (t < this.expression.size()) {
            Ptg pr;
            short oRef;
            Ptg p = (Ptg)this.expression.get(t);
            if (p instanceof PtgArea3d) {
                PtgArea3d pt = (PtgArea3d)p;
                oRef = pt.getIxti();
                if (oRef == oldRef) {
                    pt.removeFromRefTracker();
                    pt.setSheetName(this.getSheet().getSheetName());
                    pt.setIxti((short)newRef);
                    pt.addToRefTracker();
                    if (this.DEBUGLEVEL > 3) {
                        Logger.logInfo("Setting sheet reference for: " + pt.toString() + "  in Ai record.");
                    }
                    this.getWorkBook().getExternSheet().addPtgListener(pt);
                    this.updateRecord();
                }
            } else if (p instanceof PtgRef3d) {
                pr = (PtgRef3d)p;
                oRef = ((PtgRef3d)pr).getIxti();
                if (oRef == oldRef) {
                    ((PtgRef)pr).removeFromRefTracker();
                    ((PtgRef)pr).setSheetName(this.getSheet().getSheetName());
                    ((PtgRef3d)pr).setIxti((short)newRef);
                    if (!((PtgRef)pr).getIsRefErr()) {
                        ((PtgRef)pr).addToRefTracker();
                    }
                    if (this.DEBUGLEVEL > 3) {
                        Logger.logInfo("Setting sheet reference for: " + ((PtgRef3d)pr).toString() + "  in Ai record.");
                    }
                    this.getWorkBook().getExternSheet().addPtgListener((IxtiListener)((Object)pr));
                    this.updateRecord();
                }
            } else if (p instanceof PtgMemFunc) {
                pr = ((PtgMemFunc)p).getFirstloc();
                if (pr instanceof PtgRef3d) {
                    oRef = ((PtgRef3d)pr).getIxti();
                    if (oRef == oldRef) {
                        ((PtgRef3d)pr).removeFromRefTracker();
                        ((PtgArea3d)pr).setSheetName(this.getSheet().getSheetName());
                        ((PtgRef3d)pr).setIxti((short)newRef);
                        ((PtgRef3d)pr).addToRefTracker();
                        this.getWorkBook().getExternSheet().addPtgListener((PtgRef3d)pr);
                    }
                } else {
                    oRef = ((PtgRef3d)pr).getIxti();
                    if (oRef == oldRef) {
                        ((PtgRef3d)pr).removeFromRefTracker();
                        ((PtgArea3d)pr).setSheetName(this.getSheet().getSheetName());
                        ((PtgArea3d)pr).setIxti((short)newRef);
                        ((PtgArea3d)pr).addToRefTracker();
                        this.getWorkBook().getExternSheet().addPtgListener((PtgArea3d)pr);
                    }
                }
                if (this.DEBUGLEVEL > 3) {
                    Logger.logInfo("Setting sheet reference for: " + pr.toString() + "  in Ai record.");
                }
                this.updateRecord();
            } else {
                boolean cfr_ignored_0 = p instanceof PtgMystery;
            }
            ++t;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void updateSheetRef(String newSheetName, String origWorkBookName) {
        block8: {
            try {
                block9: {
                    if (this.boundXti <= -1) break block8;
                    newSheetNum = -1;
                    try {
                        newSheetNum = !this.boundName.equalsIgnoreCase(this.origSheetName) ? this.getWorkBook().getWorkSheetByName(this.boundName).getSheetNum() : this.getWorkBook().getWorkSheetByName(newSheetName).getSheetNum();
                        break block9;
                    }
                    catch (Exception e) {
                        t = 0;
                        ** while (t < this.expression.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (this.expression.get(t) instanceof PtgArea3d) {
                            p = (PtgArea3d)this.expression.get(t);
                            Logger.logWarn("External References are unsupported: External reference found in Chart: " + p.getSheetName());
                            p.setSheetName(this.boundName);
                            p.setExternalReference(origWorkBookName);
                            this.setExternsheetRef(p.getIxti());
                        } else {
                            Logger.logInfo("Ai.updateSheetRef:");
                        }
                        ++t;
                        continue;
                    }
                }
                if (newSheetNum != -1) {
                    this.setSheet(this.getWorkBook().getWorkSheetByName(newSheetName));
                    xsht = this.getWorkBook().getExternSheet(true);
                    newXRef = xsht.insertLocation(newSheetNum, newSheetNum);
                    this.setExternsheetRef(this.boundXti, newXRef);
                    this.boundXti = newXRef;
                    this.boundName = newSheetName;
                }
            }
            catch (Exception e) {
                Logger.logErr("Ai.updateSheetRef: " + e.toString());
            }
        }
    }

    String getName() {
        return "Chart Ai";
    }

    public String getDefinition() {
        StringBuffer sb = new StringBuffer();
        Ptg[] ep = new Ptg[this.expression.size()];
        ep = this.expression.toArray(ep);
        int t = 0;
        while (t < ep.length) {
            if (!(ep[t] instanceof PtgParen)) {
                sb.append(ep[t].getString());
            }
            ++t;
        }
        return sb.toString();
    }

    public Ptg[] getCellRangePtgs() throws FormulaNotFoundException {
        return ExpressionParser.getCellRangePtgs(this.expression);
    }

    public int getType() {
        return this.id;
    }

    public int getIfmt() {
        return this.ifmt;
    }

    public List getPtgsByLocation(String loc) {
        try {
            return ExpressionParser.getPtgsByLocation(loc, this.expression);
        }
        catch (FormulaNotFoundException e) {
            Logger.logWarn("failed to update Chart Series Location: " + e);
            return null;
        }
    }

    public boolean setLocationPolicy(String loc, int l) {
        List dx = this.getPtgsByLocation(loc);
        for (Ptg d : dx) {
            if (d == null) continue;
            d.setLocationPolicy(l);
        }
        return true;
    }

    public boolean changeAiLocation(Ptg p, String newLoc) {
        String[] aiLocs = StringTool.splitString(newLoc, ",");
        int i = 0;
        while (i < aiLocs.length) {
            try {
                if (this.expression.get(0) instanceof PtgMemFunc) {
                    try {
                        p.setLocation(aiLocs[i]);
                    }
                    catch (Exception ex) {
                        Logger.logErr("Ai.changeAiLocation: Error updating Location in non-contiguous range " + ex.toString());
                    }
                } else {
                    p.setLocation(aiLocs[i]);
                    this.expression.set(0, p);
                    if (this.getType() == 0) {
                        try {
                            Object o = ((PtgRef)p).getValue();
                            this.setText(o.toString());
                        }
                        catch (Exception o) {}
                    }
                }
            }
            catch (Exception e) {
                Logger.logErr("Ai.changeAiLocation: Error updating Location to " + newLoc + ":" + e.toString());
                return false;
            }
            ++i;
        }
        this.updateRecord();
        return true;
    }

    public boolean changeAiLocation(String loc, String newLoc) {
        Ptg ptg = null;
        int z = -1;
        try {
            if (this.expression.size() > 0) {
                z = ExpressionParser.getExpressionLocByLocation(loc, this.expression);
                ptg = (Ptg)this.expression.get(z);
            }
            if (ptg != null) {
                ((PtgRef)ptg).removeFromRefTracker();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (z == -1 && newLoc.equals("")) {
            this.getData()[1] = 1;
            return false;
        }
        ptg = PtgRef.createPtgRefFromString(newLoc, this);
        if (z != -1) {
            this.expression.set(z, ptg);
        } else {
            this.expression.add(ptg);
        }
        this.updateRecord();
        return true;
    }

    public void updateRecord() {
        int offy = 8;
        byte[] rkdata = this.getData();
        byte[] updated = new byte[rkdata.length];
        System.arraycopy(rkdata, 0, updated, 0, offy);
        int i = 0;
        while (i < this.expression.size()) {
            Object o = this.expression.elementAt(i);
            Ptg ptg = (Ptg)o;
            byte[] b = ptg.getRecord();
            int len = b.length;
            if (updated.length - offy < len) {
                byte[] newArr = new byte[offy + len];
                System.arraycopy(updated, 0, newArr, 0, updated.length);
                this.cce += newArr.length - updated.length;
                updated = newArr;
                byte[] ix = ByteTools.shortToLEBytes((short)this.cce);
                System.arraycopy(ix, 0, updated, 6, 2);
            }
            System.arraycopy(b, 0, updated, offy, len);
            offy += len;
            ++i;
        }
        this.setData(updated);
    }

    @Override
    public void init() {
        super.init();
        this.id = this.getByteAt(0);
        this.rt = this.getByteAt(1);
        this.grbit = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.fCustomIfmt = (this.grbit & 1) == 1;
        this.ifmt = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.cce = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
        int pos = 8;
        byte[] expressionbytes = this.getBytesAt(pos, this.cce);
        this.expression = ExpressionParser.parseExpression(expressionbytes, this);
        pos += this.cce;
        if (this.DEBUGLEVEL > 10) {
            Logger.logInfo(String.valueOf(this.getName()) + ":" + this.getDefinition());
        }
    }

    public void setRt(int i) {
        this.rt = (short)i;
        this.getData()[1] = (byte)this.rt;
    }

    public static ChartObject getPrototype(byte[] aiType) {
        Ai ai = new Ai();
        ai.setOpcode((short)4177);
        ai.setData(aiType);
        ai.init();
        return ai;
    }

    public Stack getExpression() {
        return this.expression;
    }

    @Override
    public void close() {
        if (this.expression != null) {
            while (!this.expression.isEmpty()) {
                GenericPtg p = (GenericPtg)this.expression.pop();
                if (p instanceof PtgRef) {
                    ((PtgRef)p).close();
                } else {
                    p.close();
                }
                Object var1_1 = null;
            }
        }
        super.close();
    }

    protected void finalize() {
        this.close();
    }
}

