/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.LEO.BlockByteConsumer;
import com.extentech.formats.LEO.BlockByteReader;
import com.extentech.formats.LEO.LEOFile;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Bof;
import com.extentech.formats.XLS.Book;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.Dimensions;
import com.extentech.formats.XLS.InvalidRecordException;
import com.extentech.formats.XLS.R;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.XLSRecordFactory;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.ProgressListener;
import com.extentech.toolkit.ProgressNotifier;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class WorkBookFactory
implements ProgressNotifier,
XLSConstants,
Serializable {
    public static final long serialVersionUID = 1233423412323L;
    protected int DEBUGLEVEL = 0;
    protected LEOFile myLEO;
    private String fname;
    private ProgressListener progresslistener;
    private int progress = 0;
    private boolean done = false;
    private String progresstext = "";

    public void setDebugLevel(int d) {
        this.DEBUGLEVEL = d;
    }

    public int getDebugLevel() {
        return this.DEBUGLEVEL;
    }

    @Override
    public void register(ProgressListener j) {
        this.progresslistener = j;
        j.addTarget(this);
    }

    @Override
    public void fireProgressChanged() {
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public String getProgressText() {
        return this.progresstext;
    }

    @Override
    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Override
    public void setProgressText(String s) {
        this.progresstext = s;
    }

    @Override
    public boolean iscompleted() {
        return this.done;
    }

    public String getFileName() {
        if (this.fname == null) {
            this.fname = this.myLEO.getFileName();
        }
        return this.fname;
    }

    public void setFileName(String f) {
        this.fname = f;
    }

    public short lookAhead(BiffRec rec) {
        int i = rec.getOffset() + rec.getLength();
        BlockByteReader parsedata = rec.getByteReader();
        if (parsedata == null) {
            return rec.getOpcode();
        }
        byte[] b1 = parsedata.getHeaderBytes(i);
        short opcode = ByteTools.readShort(b1[0], b1[1]);
        return opcode;
    }

    LEOFile getLEOFile() {
        return this.myLEO;
    }

    public Book getWorkBook(BlockByteReader parsedata, LEOFile leo) throws InvalidRecordException {
        WorkBook book = new WorkBook();
        return this.initWorkBook(book, parsedata, leo);
    }

    public Book initWorkBook(Book book, BlockByteReader parsedata, LEOFile leo) throws InvalidRecordException {
        BlockByteReader blockByteReader = parsedata;
        blockByteReader.setApplyRelativePosition(true);
        boolean bPerformRecordLevelValidation = false;
        if (System.getProperty("com.extentech.formats.LEO.validateworkbook") != null && System.getProperty("com.extentech.formats.LEO.validateworkbook").equals("true")) {
            bPerformRecordLevelValidation = true;
        }
        LinkedHashMap<Short, R> curSubstream = null;
        LinkedHashMap<Short, R> sheetSubstream = null;
        if (bPerformRecordLevelValidation) {
            LinkedHashMap<Short, R> globalSubstream = new LinkedHashMap<Short, R>();
            this.fillGlobalSubstream(globalSubstream);
            sheetSubstream = new LinkedHashMap<Short, R>();
            this.fillWorksSheetSubstream(sheetSubstream);
            curSubstream = globalSubstream;
        }
        this.myLEO = leo;
        book.setDebugLevel(this.DEBUGLEVEL);
        book.setFactory(this);
        boolean infile = false;
        boolean isWBBOF = true;
        short opcode = 0;
        short reclen = 0;
        int lastOpcode = 0;
        int BofCount = 0;
        BiffRec rec = null;
        int blen = parsedata.getLength();
        this.progresstext = "Initializing Workbook...";
        this.progress = 0;
        if (this.progresslistener != null) {
            this.progresslistener.setMaxProgress(blen);
        }
        this.fireProgressChanged();
        if (this.DEBUGLEVEL > 1) {
            Logger.logInfo("XLS File Size: " + String.valueOf(blen));
        }
        int i = 0;
        while (i <= blen - 4) {
            this.fireProgressChanged();
            byte[] headerbytes = parsedata.getHeaderBytes(i);
            opcode = ByteTools.readShort(headerbytes[0], headerbytes[1]);
            reclen = ByteTools.readShort(headerbytes[2], headerbytes[3]);
            if (lastOpcode == 10 && opcode == 0 || opcode == -1) {
                int startpos = i - 3;
                int junkreclen = 0;
                int offset = 0;
                junkreclen = offset != 0 ? offset - startpos : blen - i;
                i += junkreclen - 1;
                i += junkreclen - 1;
                continue;
            }
            if (reclen < 0) {
                throw new InvalidRecordException("WorkBookFactory.getWorkBook() Negative Reclen encountered pos:" + i + " opcode:0x" + Integer.toHexString(opcode));
            }
            if (reclen + 1 > blen) {
                throw new InvalidRecordException("WorkBookFactory.getWorkBook() Reclen longer than data pos:" + i + " opcode:0x" + Integer.toHexString(opcode));
            }
            if (opcode == 2057 || infile) {
                infile = true;
                rec = this.parse(book, opcode, i, reclen, blockByteReader);
                if (this.progresslistener != null) {
                    this.progresslistener.setValue(i);
                }
                if (bPerformRecordLevelValidation && curSubstream != null) {
                    this.markRecord(curSubstream, rec, opcode);
                }
                if (WorkBookHandle.dump_input != null) {
                    try {
                        WorkBookHandle.dump_input.write("--------------------------------------------------------------\n" + ((XLSRecord)rec).getRecDesc() + ByteTools.getByteDump(blockByteReader.get((XLSRecord)rec, 0, (int)reclen), 0) + "\n");
                        WorkBookHandle.dump_input.flush();
                    }
                    catch (Exception e) {
                        Logger.logErr("error writing to dump file, ceasing dump output: " + e);
                        WorkBookHandle.dump_input = null;
                    }
                }
                if (rec == null) {
                    if (this.DEBUGLEVEL > 0) {
                        Logger.logInfo("done parsing WorkBook storage.");
                    }
                    this.done = true;
                    this.progresstext = "Done Reading WorkBook.";
                    this.fireProgressChanged();
                    return book;
                }
                int thisrecpos = i + reclen + 4;
                if (opcode == 2057) {
                    if (isWBBOF) {
                        book.setFirstBof((Bof)rec);
                        isWBBOF = false;
                    } else if (bPerformRecordLevelValidation && BofCount == 0 && lastOpcode != 10 && curSubstream != null) {
                        this.validateRecords(curSubstream, book, rec.getSheet());
                    }
                    ++BofCount;
                    if (bPerformRecordLevelValidation && curSubstream == null) {
                        this.reInitSubstream(sheetSubstream);
                        curSubstream = sheetSubstream;
                        curSubstream.get((Object)Short.valueOf((short)2057)).isPresent = true;
                        curSubstream.get((Object)Short.valueOf((short)2057)).recordPos = 0;
                    }
                } else if (opcode == 10 && bPerformRecordLevelValidation && --BofCount == 0 && curSubstream != null) {
                    this.validateRecords(curSubstream, book, rec.getSheet());
                    curSubstream = null;
                }
                if (BofCount == -1) {
                    if (this.DEBUGLEVEL > 2) {
                        Logger.logInfo("Last Bof");
                    }
                    i += reclen;
                    thisrecpos = blen;
                }
                if (thisrecpos > 0) {
                    i = thisrecpos;
                }
                lastOpcode = opcode;
                continue;
            }
            throw new InvalidRecordException("No valid record found.");
        }
        if (this.DEBUGLEVEL > 0) {
            Logger.logInfo("done");
        }
        this.progress = blen;
        this.progresstext = "Done Reading WorkBook.";
        this.fireProgressChanged();
        this.done = true;
        return book;
    }

    protected synchronized BiffRec parse(Book book, short opcode, int offset, int datalen, BlockByteReader bytebuf) throws InvalidRecordException {
        if (datalen < 0 || datalen > 8224) {
            throw new InvalidRecordException("InvalidRecordException BAD RECORD LENGTH:  off: " + offset + " op: " + Integer.toHexString(opcode) + " len: " + datalen);
        }
        if (offset + datalen > bytebuf.getLength()) {
            throw new InvalidRecordException("InvalidRecordException RECORD LENGTH LONGER THAN FILE:  off: " + offset + " op: " + Integer.toHexString(opcode) + " len: " + datalen + " buflen:" + bytebuf.getLength());
        }
        BiffRec rec = XLSRecordFactory.getBiffRecord(opcode);
        rec.setWorkBook((WorkBook)book);
        rec.setByteReader(bytebuf);
        rec.setLength((short)datalen);
        rec.setOffset(offset);
        rec.setDebugLevel(this.DEBUGLEVEL);
        rec.setStreamer(book.getStreamer());
        book.getContinueHandler().addRec(rec, (short)datalen);
        return book.addRecord(rec, true);
    }

    protected static int getNextOpcodeOffset(short op, BlockByteConsumer rec, BlockByteReader parsedata) {
        boolean found = false;
        int x = rec.getOffset();
        short opcode = 0;
        while (!found && x < parsedata.getLength() - 2) {
            opcode = ByteTools.readShort(parsedata.get(rec, x), parsedata.get(rec, ++x));
            if (opcode != op) continue;
            found = true;
            break;
        }
        if (!found) {
            return 0;
        }
        return x - 3;
    }

    private void fillGlobalSubstream(LinkedHashMap<Short, R> map) {
        map.put((short)2057, new R(true));
        map.put((short)134, new R(false));
        map.put((short)47, new R(false));
        map.put((short)96, new R(false));
        map.put((short)225, new R(true));
        map.put((short)193, new R(true));
        map.put((short)226, new R(true));
        map.put((short)92, new R(true));
        map.put((short)91, new R(false));
        map.put((short)66, new R(true));
        map.put((short)441, new R(false));
        map.put((short)353, new R(true));
        map.put((short)448, new R(false));
        map.put((short)317, new R(true));
        map.put((short)211, new R(false));
        map.put((short)445, new R(false));
        map.put((short)442, new R(false));
        map.put((short)156, new R(false));
        map.put((short)154, new R(false));
        map.put((short)2200, new R(false));
        map.put((short)222, new R(false));
        map.put((short)25, new R(true));
        map.put((short)18, new R(true));
        map.put((short)19, new R(true));
        map.put((short)431, new R(true));
        map.put((short)444, new R(true));
        map.put((short)61, new R(true));
        map.put((short)64, new R(true));
        map.put((short)141, new R(true));
        map.put((short)34, new R(true));
        map.put((short)14, new R(true));
        map.put((short)439, new R(true));
        map.put((short)218, new R(true));
        map.put((short)49, new R(true));
        map.put((short)1054, new R(true));
        map.put((short)224, new R(true));
        map.put((short)2172, new R(false));
        map.put((short)2173, new R(false));
        map.put((short)2189, new R(false));
        map.put((short)659, new R(true));
        map.put((short)2194, new R(false));
        map.put((short)2190, new R(false));
        map.put((short)2191, new R(false));
        map.put((short)2192, new R(false));
        map.put((short)146, new R(false));
        map.put((short)4188, new R(false));
        map.put((short)213, new R(false));
        map.put((short)227, new R(false));
        map.put((short)82, new R(false));
        map.put((short)437, new R(false));
        map.put((short)81, new R(false));
        map.put((short)208, new R(false));
        map.put((short)210, new R(false));
        map.put((short)209, new R(false));
        map.put((short)205, new R(false));
        map.put((short)220, new R(false));
        map.put((short)2148, new R(false));
        map.put((short)184, new R(false));
        map.put((short)185, new R(false));
        map.put((short)425, new R(false));
        map.put((short)352, new R(true));
        map.put((short)133, new R(true));
        map.put((short)2180, new R(false));
        map.put((short)2181, new R(false));
        map.put((short)2182, new R(false));
        map.put((short)2183, new R(false));
        map.put((short)2184, new R(false));
        map.put((short)2185, new R(false));
        map.put((short)2186, new R(false));
        map.put((short)2202, new R(false));
        map.put((short)2211, new R(false));
        map.put((short)140, new R(true));
        map.put((short)430, new R(false));
        map.put((short)35, new R(false));
        map.put((short)89, new R(false));
        map.put((short)90, new R(false));
        map.put((short)23, new R(false));
        map.put((short)24, new R(false));
        map.put((short)2196, new R(false));
        map.put((short)2201, new R(false));
        map.put((short)2195, new R(false));
        map.put((short)2067, new R(false));
        map.put((short)449, new R(false));
        map.put((short)2150, new R(false));
        map.put((short)235, new R(false));
        map.put((short)252, new R(true));
        map.put((short)255, new R(true));
        map.put((short)2049, new R(false));
        map.put((short)2059, new R(false));
        map.put((short)2149, new R(false));
        map.put((short)2147, new R(false));
        map.put((short)2151, new R(false));
        map.put((short)2166, new R(false));
        map.put((short)2198, new R(false));
        map.put((short)2203, new R(false));
        map.put((short)2188, new R(false));
        map.put((short)2199, new R(false));
        map.put((short)10, new R(true));
    }

    private void fillWorksSheetSubstream(LinkedHashMap<Short, R> map) {
        map.put((short)2057, new R(true));
        map.put((short)94, new R(false));
        map.put((short)523, new R(true));
        map.put((short)13, new R(true));
        map.put((short)12, new R(true));
        map.put((short)15, new R(true));
        map.put((short)17, new R(true));
        map.put((short)16, new R(true));
        map.put((short)95, new R(true));
        map.put((short)42, new R(true));
        map.put((short)43, new R(true));
        map.put((short)130, new R(true));
        map.put((short)128, new R(true));
        map.put((short)549, new R(true));
        map.put((short)129, new R(true));
        map.put((short)151, new R(false));
        map.put((short)152, new R(false));
        map.put((short)27, new R(false));
        map.put((short)26, new R(false));
        map.put((short)20, new R(true));
        map.put((short)21, new R(true));
        map.put((short)131, new R(true));
        map.put((short)132, new R(true));
        map.put((short)38, new R(false));
        map.put((short)39, new R(false));
        map.put((short)40, new R(false));
        map.put((short)41, new R(false));
        map.put((short)77, new R(false));
        map.put((short)161, new R(true));
        map.put((short)2204, new R(false));
        map.put((short)233, new R(false));
        map.put((short)1048, new R(false));
        map.put((short)18, new R(false));
        map.put((short)221, new R(false));
        map.put((short)99, new R(false));
        map.put((short)19, new R(false));
        map.put((short)85, new R(true));
        map.put((short)125, new R(false));
        map.put((short)174, new R(false));
        map.put((short)175, new R(false));
        map.put((short)144, new R(false));
        map.put((short)2197, new R(false));
        map.put((short)155, new R(false));
        map.put((short)2164, new R(false));
        map.put((short)157, new R(false));
        map.put((short)158, new R(false));
        map.put((short)2174, new R(false));
        map.put((short)2197, new R(false));
        map.put((short)512, new R(true));
        map.put((short)520, new R(false));
        map.put((short)513, new R(false));
        map.put((short)190, new R(false));
        map.put((short)638, new R(false));
        map.put((short)517, new R(false));
        map.put((short)515, new R(false));
        map.put((short)253, new R(false));
        map.put((short)94, new R(false));
        map.put((short)6, new R(false));
        map.put((short)189, new R(false));
        map.put((short)519, new R(false));
        map.put((short)1212, new R(false));
        map.put((short)545, new R(false));
        map.put((short)566, new R(false));
        map.put((short)450, new R(false));
        map.put((short)236, new R(false));
        map.put((short)438, new R(false));
        map.put((short)93, new R(false));
        map.get((Object)Short.valueOf((short)93)).altPrecedor = new short[]{236};
        map.put((short)2128, new R(false));
        map.put((short)2130, new R(false));
        map.put((short)2205, new R(false));
        map.put((short)2215, new R(false));
        map.put((short)2134, new R(false));
        map.put((short)2154, new R(false));
        map.put((short)2155, new R(false));
        map.put((short)2138, new R(false));
        map.put((short)2213, new R(false));
        map.put((short)2214, new R(false));
        map.put((short)2212, new R(false));
        map.put((short)2206, new R(false));
        map.put((short)2131, new R(false));
        map.put((short)2132, new R(false));
        map.put((short)2129, new R(false));
        map.put((short)2133, new R(false));
        map.put((short)237, new R(false));
        map.put((short)2150, new R(false));
        map.put((short)28, new R(false));
        map.put((short)176, new R(false));
        map.put((short)177, new R(false));
        map.put((short)178, new R(false));
        map.put((short)256, new R(false));
        map.put((short)180, new R(false));
        map.put((short)182, new R(false));
        map.put((short)197, new R(false));
        map.put((short)181, new R(false));
        map.put((short)241, new R(false));
        map.put((short)247, new R(false));
        map.put((short)240, new R(false));
        map.put((short)251, new R(false));
        map.put((short)244, new R(false));
        map.put((short)2050, new R(false));
        map.put((short)2051, new R(false));
        map.put((short)2052, new R(false));
        map.put((short)205, new R(false));
        map.put((short)2060, new R(false));
        map.put((short)2061, new R(false));
        map.put((short)2062, new R(false));
        map.put((short)256, new R(false));
        map.put((short)2064, new R(false));
        map.put((short)2148, new R(false));
        map.put((short)80, new R(false));
        map.put((short)82, new R(false));
        map.put((short)437, new R(false));
        map.put((short)81, new R(false));
        map.put((short)574, new R(true));
        map.put((short)2187, new R(false));
        map.put((short)160, new R(false));
        map.put((short)65, new R(false));
        map.put((short)29, new R(false));
        map.put((short)426, new R(false));
        map.put((short)427, new R(false));
        map.put((short)319, new R(false));
        map.put((short)153, new R(false));
        map.put((short)229, new R(false));
        map.put((short)351, new R(false));
        map.put((short)239, new R(false));
        map.put((short)432, new R(false));
        map.put((short)433, new R(false));
        map.put((short)2169, new R(false));
        map.put((short)2170, new R(false));
        map.put((short)2171, new R(false));
        map.put((short)440, new R(false));
        map.put((short)2048, new R(false));
        map.put((short)434, new R(false));
        map.put((short)446, new R(false));
        map.put((short)442, new R(false));
        map.put((short)2049, new R(false));
        map.put((short)2156, new R(false));
        map.put((short)2146, new R(false));
        map.put((short)2151, new R(false));
        map.put((short)2152, new R(false));
        map.put((short)2248, new R(false));
        map.put((short)10, new R(true));
    }

    private void validateRecords(LinkedHashMap<Short, R> map, Book book, Boundsheet bs) {
        Short[] opcodes = new Short[]{};
        Set<Short> ss = map.keySet();
        opcodes = ss.toArray(opcodes);
        R lastR = new R(false);
        lastR.recordPos = 0;
        short lastOp = -1;
        if (bs != null && bs.isChartOnlySheet()) {
            return;
        }
        int i = 0;
        while (i < opcodes.length) {
            short op = opcodes[i];
            R r2 = map.get(op);
            if (!r2.isPresent && r2.isRequired) {
                BiffRec rec = this.createMissingRequiredRecord(op, book, bs);
                rec.setDebugLevel(this.DEBUGLEVEL);
                int recPos = lastR.recordPos + 1;
                try {
                    while (true) {
                        BiffRec lastRec;
                        BiffRec biffRec = lastRec = bs == null ? book.getStreamer().getRecordAt(recPos) : (BiffRec)bs.getSheetRecs().get(recPos);
                        if (lastRec.getOpcode() == lastOp) {
                            ++recPos;
                            continue;
                        }
                        break;
                    }
                }
                catch (IndexOutOfBoundsException lastRec) {
                    // empty catch block
                }
                book.getStreamer().addRecordAt(rec, recPos);
                book.addRecord(rec, false);
                if (bs != null) {
                    rec.setSheet(bs);
                }
                r2.recordPos = rec.getRecordIndex();
                int zz = 0;
                while (zz < opcodes.length) {
                    R nextR = map.get(opcodes[zz]);
                    if (nextR.isPresent && !r2.equals(nextR) && nextR.recordPos >= r2.recordPos) {
                        ++nextR.recordPos;
                    }
                    ++zz;
                }
                r2.isPresent = true;
            }
            if (r2.isPresent) {
                lastR = r2;
                lastOp = op;
            }
            ++i;
        }
        this.validateRecordOrder(map, bs == null ? book.getStreamer().records : bs.getSheetRecs(), opcodes);
    }

    /*
     * Unable to fully structure code
     */
    private void validateRecordOrder(LinkedHashMap<Short, R> map, List list, Short[] opcodes) {
        lastR = map.get((short)2057);
        lastOp = 2057;
        i = 1;
        while (i < opcodes.length) {
            block10: {
                block11: {
                    block12: {
                        op = opcodes[i];
                        r = map.get(op);
                        if (!r.isPresent) break block10;
                        if (r.recordPos >= lastR.recordPos || r.recordPos < 0) break block11;
                        if (r.altPrecedor == null) break block12;
                        zz = 0;
                        while (zz < r.altPrecedor.length) {
                            newR = map.get(r.altPrecedor[zz]);
                            if (r.recordPos > newR.recordPos) {
                                lastR = newR;
                                break;
                            }
                            ++zz;
                        }
                        if (r.recordPos > lastR.recordPos) break block10;
                    }
                    origRecPos = r.recordPos;
                    zz = i - 1;
                    while (zz > 0) {
                        prevr = map.get(opcodes[zz]);
                        if (prevr.isPresent && r.recordPos < prevr.recordPos) {
                            recsMovedCount = 0;
                            recToMove = (BiffRec)list.get(origRecPos);
                            do {
                                list.remove(origRecPos);
                                list.add(prevr.recordPos, recToMove);
                                if (recsMovedCount == 0) {
                                    r.recordPos = recToMove.getRecordIndex();
                                }
                                ++recsMovedCount;
                            } while ((recToMove = (BiffRec)list.get(origRecPos)).getOpcode() == op);
                            jj = 0;
                            while (jj < opcodes.length) {
                                nextR = map.get(opcodes[jj]);
                                if (nextR.isPresent && nextR.recordPos >= origRecPos && nextR.recordPos <= r.recordPos && opcodes[jj] != op) {
                                    nextR.recordPos -= recsMovedCount;
                                }
                                ++jj;
                            }
                            ** break;
                        }
                        --zz;
                    }
                }
                lastR = r;
                lastOp = op;
            }
            ++i;
        }
    }

    private BiffRec createMissingRequiredRecord(short opcode, Book book, Boundsheet bs) {
        BiffRec record = XLSRecordFactory.getBiffRecord(opcode);
        if (bs != null) {
            record.setSheet(bs);
        }
        byte[] data = null;
        try {
            switch (opcode) {
                case 225: {
                    data = new byte[]{-80, 4};
                    break;
                }
                case 193: {
                    data = new byte[2];
                    break;
                }
                case 226: {
                    data = new byte[]{};
                    break;
                }
                case 92: {
                    data = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
                    break;
                }
                case 66: {
                    data = new byte[]{-80, 4};
                    break;
                }
                case 353: {
                    data = new byte[2];
                    break;
                }
                case 317: {
                    int nSheets = 0;
                    int z = book.getStreamer().records.size() - 1;
                    while (z > 0) {
                        BiffRec b = (BiffRec)book.getStreamer().records.get(z);
                        if (b.getOpcode() == 133) {
                            while (z > 0 && b.getOpcode() == 133) {
                                ++nSheets;
                                b = (BiffRec)book.getStreamer().records.get(--z);
                            }
                            break;
                        }
                        --z;
                    }
                    data = new byte[]{};
                    int i = 0;
                    while (i < nSheets) {
                        data = ByteTools.append(ByteTools.shortToLEBytes((short)i), data);
                        ++i;
                    }
                    break;
                }
                case 25: {
                    data = new byte[2];
                    break;
                }
                case 18: {
                    data = new byte[2];
                    break;
                }
                case 19: {
                    data = new byte[2];
                    break;
                }
                case 431: {
                    data = new byte[2];
                    break;
                }
                case 444: {
                    data = new byte[2];
                    break;
                }
                case 61: {
                    byte[] byArray = new byte[18];
                    byArray[0] = -32;
                    byArray[1] = 1;
                    byArray[2] = 105;
                    byArray[4] = 19;
                    byArray[5] = 56;
                    byArray[6] = 31;
                    byArray[7] = 29;
                    byArray[8] = 56;
                    byArray[14] = 1;
                    byArray[16] = 88;
                    byArray[17] = 2;
                    data = byArray;
                    break;
                }
                case 64: {
                    data = new byte[2];
                    break;
                }
                case 141: {
                    data = new byte[2];
                    break;
                }
                case 34: {
                    data = new byte[2];
                    break;
                }
                case 14: {
                    byte[] byArray = new byte[2];
                    byArray[0] = 1;
                    data = byArray;
                    break;
                }
                case 439: {
                    data = new byte[2];
                    break;
                }
                case 218: {
                    data = new byte[2];
                    break;
                }
                case 49: {
                    byte[] byArray = new byte[26];
                    byArray[0] = -56;
                    byArray[4] = -1;
                    byArray[5] = 127;
                    byArray[6] = -112;
                    byArray[7] = 1;
                    byArray[14] = 5;
                    byArray[15] = 1;
                    byArray[16] = 65;
                    byArray[18] = 114;
                    byArray[20] = 105;
                    byArray[22] = 97;
                    byArray[24] = 108;
                    data = byArray;
                    break;
                }
                case 224: {
                    byte[] byArray = new byte[20];
                    byArray[4] = -11;
                    byArray[5] = -1;
                    byArray[6] = 32;
                    byArray[18] = -64;
                    byArray[19] = 32;
                    data = byArray;
                    break;
                }
                case 140: {
                    byte[] byArray = new byte[4];
                    byArray[0] = 1;
                    byArray[2] = 1;
                    data = byArray;
                    break;
                }
                case 252: {
                    data = new byte[8];
                    break;
                }
                case 255: {
                    data = new byte[2];
                    break;
                }
                case 352: {
                    data = new byte[2];
                    break;
                }
                case 523: {
                    byte[] byArray = new byte[16];
                    byArray[8] = 1;
                    byArray[12] = 78;
                    byArray[13] = 6;
                    data = byArray;
                    break;
                }
                case 13: {
                    byte[] byArray = new byte[2];
                    byArray[0] = 1;
                    data = byArray;
                    break;
                }
                case 12: {
                    byte[] byArray = new byte[2];
                    byArray[0] = 100;
                    data = byArray;
                    break;
                }
                case 15: {
                    byte[] byArray = new byte[2];
                    byArray[0] = 1;
                    data = byArray;
                    break;
                }
                case 17: {
                    data = new byte[2];
                    break;
                }
                case 16: {
                    data = new byte[]{-4, -87, -15, -46, 77, 98, 80, 63};
                }
                case 95: {
                    byte[] byArray = new byte[2];
                    byArray[0] = 1;
                    data = byArray;
                    break;
                }
                case 42: {
                    data = new byte[2];
                    break;
                }
                case 43: {
                    data = new byte[2];
                    break;
                }
                case 130: {
                    data = new byte[2];
                    break;
                }
                case 128: {
                    data = new byte[8];
                    break;
                }
                case 549: {
                    byte[] byArray = new byte[4];
                    byArray[2] = -1;
                    data = byArray;
                    break;
                }
                case 129: {
                    data = new byte[]{-63, 4};
                    break;
                }
                case 20: 
                case 21: {
                    data = new byte[]{};
                    break;
                }
                case 131: {
                    data = new byte[2];
                    break;
                }
                case 132: {
                    data = new byte[2];
                    break;
                }
                case 161: {
                    byte[] byArray = new byte[34];
                    byArray[2] = -1;
                    byArray[4] = 1;
                    byArray[6] = 1;
                    byArray[8] = 1;
                    byArray[10] = 4;
                    byArray[22] = -32;
                    byArray[23] = 63;
                    byArray[30] = -32;
                    byArray[31] = 63;
                    data = byArray;
                    break;
                }
                case 85: {
                    byte[] byArray = new byte[2];
                    byArray[0] = 8;
                    data = byArray;
                    break;
                }
                case 512: {
                    data = new byte[14];
                    record.setData(data);
                    if (bs == null) break;
                    bs.setDimensions((Dimensions)record);
                    if (bs.getRowMap().size() <= 0) break;
                    int z = bs.getRows()[bs.getRowMap().size() - 1].getRowNumber();
                    ((Dimensions)record).setRowLast(z);
                    break;
                }
                case 574: {
                    byte[] byArray = new byte[18];
                    byArray[0] = -74;
                    byArray[1] = 6;
                    byArray[6] = 64;
                    data = byArray;
                    break;
                }
                case 10: {
                    break;
                }
                default: {
                    System.out.println("Must create required rec: " + opcode);
                }
            }
            record.setData(data);
            try {
                record.init();
            }
            catch (Exception nSheets) {}
        }
        catch (Exception e) {
            Logger.logErr("Record Validation: Error creating missing record: " + opcode);
        }
        return record;
    }

    private void reInitSubstream(LinkedHashMap<Short, R> map) {
        for (short op : map.keySet()) {
            R r2 = map.get(op);
            r2.isPresent = false;
            r2.recordPos = -1;
        }
    }

    private void markRecord(LinkedHashMap<Short, R> map, BiffRec rec, short opcode) {
        try {
            R r2 = map.get(opcode);
            if (!r2.isPresent) {
                r2.isPresent = true;
                r2.recordPos = rec.getRecordIndex();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void displayRecsInStream(LinkedHashMap<Short, R> map) {
        Iterator<Short> ii = map.keySet().iterator();
        System.out.println("Present Records");
        while (ii.hasNext()) {
            short op = ii.next();
            R r2 = map.get(op);
            if (!r2.isPresent) continue;
            System.out.println(String.valueOf(op) + " at " + r2.recordPos);
        }
    }
}

