/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.Dbcell;
import com.extentech.formats.XLS.Dimensions;
import com.extentech.formats.XLS.MSODrawing;
import com.extentech.formats.XLS.Mergedcells;
import com.extentech.formats.XLS.Mulblank;
import com.extentech.formats.XLS.Obj;
import com.extentech.formats.XLS.Row;
import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.Chart;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class WorkBookAssembler
implements XLSConstants {
    public static List assembleSheetRecs(Boundsheet thissheet) {
        List addVec = new ArrayList();
        WorkBookAssembler.preProcessSheet(thissheet);
        addVec.addAll(thissheet.getSheetRecs());
        if (!thissheet.isChartOnlySheet()) {
            addVec = WorkBookAssembler.assembleRows(thissheet, addVec);
        }
        if (thissheet.getWorkBook().getCharts().length > 0) {
            addVec = WorkBookAssembler.assembleChartRecs(thissheet, addVec);
        }
        return addVec;
    }

    private static void preProcessSheet(Boundsheet thissheet) {
        if (thissheet.hasMergedCells()) {
            for (Mergedcells mrg : thissheet.getMergedCellsRecs()) {
                mrg.update();
            }
        }
    }

    private static List assembleRows(Boundsheet thissheet, List addVec) {
        Dbcell d;
        Dimensions dim = thissheet.getDimensions();
        Random gen = new Random();
        int randomNumber = gen.nextInt();
        int insertRowidx = 0;
        if (dim != null) {
            insertRowidx = dim.getRecordIndex() + 1;
        }
        int insertValidx = insertRowidx;
        int rowCount = 0;
        int dbOffset = 0;
        int maxRow = 0;
        short maxCol = 0;
        ArrayList<Short> dbOffsets = new ArrayList<Short>();
        int valrecOffset = 0;
        if (thissheet.getSheetIDX() != null) {
            thissheet.getSheetIDX().resetDBCells();
        }
        Iterator outRows = thissheet.getSortedRows().keySet().iterator();
        while (outRows.hasNext()) {
            if (rowCount == 32) {
                d = (Dbcell)Dbcell.getPrototype();
                dbOffsets.add(0, (short)((rowCount - 1) * 20));
                d.initDbCell(dbOffset, dbOffsets);
                addVec.add(insertValidx++, d);
                if (thissheet.getSheetIDX() != null) {
                    thissheet.getSheetIDX().addDBCell(d);
                }
                insertRowidx = insertValidx;
                dbOffsets = new ArrayList();
                rowCount = 0;
                dbOffset = 0;
            }
            Row r2 = (Row)thissheet.getRowMap().get(outRows.next());
            ++rowCount;
            maxRow = Math.max(r2.getRowNumber(), maxRow);
            dbOffset += r2.getLength();
            addVec.add(insertRowidx++, r2);
            ++insertValidx;
            Mulblank skipMull = null;
            List outRecs = r2.getValRecs(randomNumber);
            Iterator it = outRecs.iterator();
            while (it.hasNext()) {
                BiffRec or = (BiffRec)it.next();
                if (skipMull != null) {
                    if (or == skipMull) continue;
                    skipMull = null;
                }
                addVec.add(insertValidx++, or);
                valrecOffset += or.getLength();
                dbOffset += or.getLength();
                short orc = or.getColNumber();
                if (!it.hasNext() && orc > maxCol) {
                    maxCol = orc;
                }
                if (or.getOpcode() != 190) continue;
                skipMull = (Mulblank)or;
            }
            dbOffsets.add((short)valrecOffset);
            valrecOffset = 0;
        }
        if (dbOffsets.size() > 0) {
            d = (Dbcell)Dbcell.getPrototype();
            dbOffsets.add(0, (short)((rowCount - 1) * 20));
            d.initDbCell(dbOffset, dbOffsets);
            d.setOffset(dbOffset);
            addVec.add(insertValidx++, d);
            if (thissheet.getSheetIDX() != null) {
                thissheet.getSheetIDX().addDBCell(d);
            }
        }
        thissheet.updateDimensions(maxRow, maxCol);
        return addVec;
    }

    private static int getLastDBCellLocation(List addVec) {
        int i = addVec.size() - 1;
        while (i >= 0) {
            BiffRec b = (BiffRec)addVec.get(i);
            if (b.getOpcode() == 215) {
                return i;
            }
            --i;
        }
        return 0;
    }

    private static List assembleChartRecs(Boundsheet thissheet, List addVec) {
        List l;
        int insertValidx = WorkBookAssembler.getLastDBCellLocation(addVec);
        ArrayList<String> insertedCharts = new ArrayList<String>();
        int chartInsert = insertValidx;
        while (chartInsert < addVec.size()) {
            Obj o;
            XLSRecord x = (XLSRecord)addVec.get(chartInsert);
            if (x.getOpcode() == 93 && (o = (Obj)x).getChart() != null) {
                insertedCharts.add(o.getChart().getTitle());
                l = o.getChart().assembleChartRecords();
                addVec.addAll(chartInsert + 1, l);
                chartInsert += l.size();
                insertValidx += l.size();
            }
            ++chartInsert;
        }
        Chart[] chts = thissheet.getWorkBook().getCharts();
        chartInsert = insertValidx;
        int i = 0;
        while (i < chts.length) {
            if (!insertedCharts.contains(chts[i].getTitle()) && chts[i].getSheet().equals(thissheet)) {
                if (insertValidx == 0) {
                    insertValidx = addVec.size();
                }
                l = chts[i].assembleChartRecords();
                if (chts[i].getObj() != null) {
                    l.add(0, chts[i].getObj());
                }
                if (chts[i].getMsodrawobj() != null) {
                    l.add(0, chts[i].getMsodrawobj());
                }
                int spid = 0;
                boolean isHeader = false;
                if (l.get(0) instanceof MSODrawing) {
                    isHeader = ((MSODrawing)l.get(0)).isHeader();
                    spid = ((MSODrawing)l.get(0)).getSPID();
                }
                while (chartInsert < addVec.size()) {
                    MSODrawing mm;
                    XLSRecord x = (XLSRecord)addVec.get(chartInsert);
                    if (x.getOpcode() == 236 && ((mm = (MSODrawing)x).getSPID() > spid && spid != 0 && !mm.isHeader() || isHeader)) {
                        insertValidx = chartInsert;
                        chartInsert = addVec.size();
                    }
                    if (x.getOpcode() == 574 || x.getOpcode() == 237 || x.getOpcode() == 28) {
                        insertValidx = chartInsert;
                        chartInsert = addVec.size();
                    }
                    ++chartInsert;
                }
                addVec.addAll(insertValidx, l);
                insertValidx += l.size();
            }
            ++i;
        }
        return addVec;
    }
}

