/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.SXPI_Item;
import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.Arrays;

public class SxPI
extends XLSRecord
implements XLSConstants {
    private static final long serialVersionUID = 2639291289806138985L;
    private SXPI_Item[] sxpis;

    @Override
    public void init() {
        super.init();
        byte[] rgsxpi = this.getData();
        if (rgsxpi != null) {
            if (rgsxpi.length % 6 != 0) {
                Logger.logWarn("PivotTable: Irregular SxPI structure");
            }
            this.sxpis = new SXPI_Item[rgsxpi.length / 6];
            int j = 0;
            while (j < this.sxpis.length) {
                this.sxpis[j] = new SXPI_Item(rgsxpi, j * 6);
                ++j;
            }
            if (this.DEBUGLEVEL > 3) {
                Logger.logInfo("SXPI - n: " + this.sxpis.length + ": " + Arrays.toString(this.data));
            }
        } else if (this.DEBUGLEVEL > 3) {
            Logger.logInfo("SXPI - NULL");
        }
    }

    @Override
    public String toString() {
        if (this.sxpis != null) {
            return "SXPI - n: " + this.sxpis.length + ": " + Arrays.toString(this.sxpis);
        }
        return "SXPI - NULL";
    }

    public int[] getPivotFieldItem(int i) {
        if (i >= 0 && i < this.sxpis.length) {
            return new int[]{this.sxpis[i].isxvd, this.sxpis[i].idObj};
        }
        return new int[]{-1, -1};
    }

    public void setPageFieldIndex(int i, int fieldindex, int itemindex) {
        if (i >= 0 && i < this.sxpis.length) {
            this.sxpis[i].isxvd = (short)fieldindex;
            this.sxpis[i].isxvi = (short)itemindex;
            byte[] b = ByteTools.shortToLEBytes((short)fieldindex);
            this.getData()[i * 6] = b[0];
            this.getData()[i * 6 + 1] = b[1];
            b = ByteTools.shortToLEBytes((short)itemindex);
            this.getData()[i * 6 + 2] = b[0];
            this.getData()[i * 6 + 3] = b[1];
        }
    }

    public static XLSRecord getPrototype() {
        SxPI sp = new SxPI();
        sp.setOpcode((short)182);
        sp.setData(new byte[0]);
        sp.init();
        return sp;
    }

    public void addPageField(int fieldIndex, int itemIndex) {
        this.getData();
        this.data = ByteTools.append(new byte[6], this.data);
        SXPI_Item[] tmp = new SXPI_Item[this.sxpis.length + 1];
        System.arraycopy(this.sxpis, 0, tmp, 0, this.sxpis.length);
        this.sxpis = tmp;
        this.sxpis[this.sxpis.length - 1] = new SXPI_Item();
        this.setPageFieldIndex(this.sxpis.length - 1, fieldIndex, itemIndex);
    }
}

