/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.PivotCacheRecord;
import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.Arrays;

public class SxDBB
extends XLSRecord
implements XLSConstants,
PivotCacheRecord {
    private static final long serialVersionUID = 9027599480633995587L;
    short[] cacheitems;

    @Override
    public void init() {
        super.init();
        byte[] data = this.getData();
        this.cacheitems = new short[data.length];
        int i = 0;
        while (i < data.length) {
            this.cacheitems[i] = data[i];
            ++i;
        }
        if (this.DEBUGLEVEL > 3) {
            Logger.logInfo("SXDBB -" + Arrays.toString(this.cacheitems));
        }
    }

    @Override
    public String toString() {
        return "SXDBB: " + Arrays.toString(this.cacheitems) + Arrays.toString(this.getRecord());
    }

    public static XLSRecord getPrototype() {
        SxDBB sxdbb = new SxDBB();
        sxdbb.setOpcode((short)200);
        sxdbb.setData(new byte[1]);
        sxdbb.init();
        return sxdbb;
    }

    public void setCacheItemIndexes(byte[] cacheitems) {
        this.setData(cacheitems);
        this.init();
    }

    public short[] getCacheItemIndexes() {
        return this.cacheitems;
    }

    @Override
    public byte[] getRecord() {
        byte[] b = new byte[4];
        System.arraycopy(ByteTools.shortToLEBytes(this.getOpcode()), 0, b, 0, 2);
        System.arraycopy(ByteTools.shortToLEBytes((short)this.getData().length), 0, b, 2, 2);
        return ByteTools.append(this.getData(), b);
    }
}

