/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.Logger;
import java.util.Arrays;

public final class Supbook
extends XLSRecord {
    private static final long serialVersionUID = 5010774855281594364L;
    int cstab = -1;
    int nSheets = -1;
    CompatibleVector tabs = new CompatibleVector();
    private String filename;
    static byte[] protocXTI;
    static byte[] AddInProto;
    static int defaultsize;

    static {
        byte[] byArray = new byte[4];
        byArray[2] = 1;
        byArray[3] = 4;
        protocXTI = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[0] = 1;
        byArray2[2] = 1;
        byArray2[3] = 58;
        AddInProto = byArray2;
        defaultsize = 4;
    }

    @Override
    public void init() {
        super.init();
        this.getData();
        if (this.isGlobalRecord()) {
            this.nSheets = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        } else if (!this.isAddInRecord()) {
            try {
                byte[] f;
                this.cstab = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
                short ln = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
                byte compression = this.getByteAt(4);
                byte encoding = this.getByteAt(5);
                int pos = 6;
                if (compression == 0) {
                    f = this.getBytesAt(pos, ln - 1);
                    this.filename = new String(f);
                    pos += ln - 1;
                } else {
                    f = this.getBytesAt(pos, ln * 2 - 1);
                    this.filename = new String(f, "UTF-16LE");
                    pos += ln * 2 - 1;
                }
                if (this.DEBUGLEVEL > 5) {
                    Logger.logInfo("Supbook File: " + this.filename);
                }
                int i = 0;
                while (i < this.cstab) {
                    byte[] f2;
                    ln = ByteTools.readShort(this.getByteAt(pos), this.getByteAt(pos + 1));
                    compression = this.getByteAt(pos + 2);
                    pos += 3;
                    String sheetname = "";
                    if (compression == 0) {
                        f2 = this.getBytesAt(pos, ln);
                        sheetname = new String(f2);
                        pos += ln;
                    } else {
                        f2 = this.getBytesAt(pos, ln * 2);
                        sheetname = new String(f2, "UTF-16LE");
                        pos += ln * 2;
                    }
                    this.tabs.add(sheetname);
                    if (this.DEBUGLEVEL > 5) {
                        Logger.logInfo("Supbook Sheet Reference: " + sheetname);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                Logger.logErr("Supbook.init External Record: " + e.toString());
            }
        }
    }

    protected static XLSRecord getPrototype(int numtabs) {
        Supbook x = new Supbook();
        x.setLength((short)defaultsize);
        x.setOpcode((short)430);
        byte[] dta = new byte[defaultsize];
        System.arraycopy(protocXTI, 0, dta, 0, protocXTI.length);
        dta[0] = (byte)numtabs;
        x.setData(dta);
        x.originalsize = defaultsize;
        x.init();
        return x;
    }

    protected static XLSRecord getAddInPrototype() {
        Supbook x = new Supbook();
        x.setLength((short)defaultsize);
        x.setOpcode((short)430);
        byte[] dta = new byte[AddInProto.length];
        System.arraycopy(AddInProto, 0, dta, 0, AddInProto.length);
        x.setData(dta);
        x.originalsize = defaultsize;
        x.init();
        return x;
    }

    protected static XLSRecord getExternalPrototype(String externalWorkbook) {
        Supbook x = new Supbook();
        x.setLength((short)defaultsize);
        x.setOpcode((short)430);
        x.originalsize = defaultsize;
        boolean compression = false;
        boolean encoding = true;
        int n = 2;
        byte[] f = externalWorkbook.getBytes();
        int ln = f.length + 1;
        byte[] dta = new byte[4 + n + ln - 1];
        System.arraycopy(ByteTools.shortToLEBytes((short)0), 0, dta, 0, 2);
        System.arraycopy(ByteTools.shortToLEBytes((short)ln), 0, dta, 2, 2);
        int pos = 4;
        dta[pos + 1] = (byte)(compression ? 1 : 0);
        dta[pos + 2] = (byte)(encoding ? 1 : 0);
        System.arraycopy(f, 0, dta, pos += n, ln - 1);
        x.setData(dta);
        x.init();
        return x;
    }

    public short addExternalSheetReference(String externalSheet) {
        int i = 0;
        while (i < this.cstab) {
            if (((String)this.tabs.get(i)).equalsIgnoreCase(externalSheet)) {
                return (short)i;
            }
            ++i;
        }
        ++this.cstab;
        System.arraycopy(ByteTools.shortToLEBytes((short)this.cstab), 0, this.getData(), 0, 2);
        byte[] f = externalSheet.getBytes();
        int ln = f.length;
        boolean encoding = false;
        int pos = this.getData().length;
        byte[] newData = new byte[pos + ln + 3];
        System.arraycopy(this.getData(), 0, newData, 0, pos);
        System.arraycopy(ByteTools.shortToLEBytes((short)ln), 0, newData, pos, 2);
        newData[pos + 2] = (byte)(encoding ? 1 : 0);
        System.arraycopy(f, 0, newData, pos + 3, ln);
        this.setData(newData);
        this.tabs.add(externalSheet);
        if (this.DEBUGLEVEL > 5) {
            Logger.logInfo("Supbook Sheet Reference: " + externalSheet);
        }
        return (short)(this.cstab - 1);
    }

    public String getExternalSheetName(int i) {
        if (i < 0 || i > this.tabs.size() - 1) {
            return "#REF";
        }
        return (String)this.tabs.get(i);
    }

    public boolean isAddInRecord() {
        byte[] supBookCode = new byte[4];
        System.arraycopy(this.getData(), 0, supBookCode, 0, 4);
        return Arrays.equals(supBookCode, AddInProto);
    }

    public boolean isGlobalRecord() {
        byte[] supBookCode = new byte[4];
        System.arraycopy(this.getData(), 2, supBookCode, 2, 2);
        return Arrays.equals(supBookCode, protocXTI);
    }

    public boolean isExternalRecord() {
        byte[] supBookCode = new byte[4];
        System.arraycopy(this.getData(), 2, supBookCode, 2, 2);
        return !Arrays.equals(supBookCode, protocXTI) && !Arrays.equals(supBookCode, AddInProto);
    }

    public String getExternalWorkBook() {
        if (!this.isExternalRecord()) {
            return null;
        }
        return this.filename;
    }

    @Override
    public void preStream() {
        WorkBook b;
        if (this.isGlobalRecord() && (b = this.getWorkBook()) != null) {
            this.nSheets = b.getNumWorkSheets();
            byte[] bite = ByteTools.shortToLEBytes((short)this.nSheets);
            byte[] rkdata = this.getData();
            rkdata[0] = bite[0];
            rkdata[1] = bite[1];
            this.setData(rkdata);
        }
    }

    @Override
    public String toString() {
        if (this.nSheets != -1) {
            return "SUPBOOK: Number of Sheets: " + this.nSheets;
        }
        String ret = "";
        if (this.filename != null) {
            ret = "SUPBOOK: External Ref: " + this.filename + " Sheets:";
            int i = 0;
            while (i < this.cstab) {
                ret = String.valueOf(ret) + " " + this.tabs.get(i);
                ++i;
            }
        } else {
            return "SUPBOOK: ADD-IN";
        }
        return ret;
    }
}

