/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.CellNotFoundException;
import com.extentech.formats.XLS.Dbcell;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class Row
extends XLSRecord {
    private static final long serialVersionUID = 6848429681761792740L;
    private short colMic;
    private short colMac;
    private int miyRw;
    private Dbcell dbc;
    private BiffRec firstcell;
    private BiffRec lastcell;
    private boolean fCollapsed;
    private boolean fHidden;
    private boolean fUnsynced;
    private boolean fGhostDirty;
    private boolean fBorderTop;
    private boolean fBorderBottom;
    private boolean fPhonetic;
    private int outlineLevel = 0;
    static final int defaultsize = 16;

    public Row() {
    }

    public Row(int rowNum, WorkBook book) {
        this.setWorkBook(book);
        this.setLength(16);
        this.setOpcode((short)520);
        byte[] dta = new byte[16];
        dta[6] = -1;
        dta[13] = 1;
        dta[14] = 15;
        this.setData(dta);
        this.originalsize = 16;
        this.init();
        this.setRowNumber(rowNum);
    }

    @Override
    public void close() {
        this.dbc = null;
        this.firstcell = null;
        this.lastcell = null;
        this.setWorkBook(null);
        this.setSheet(null);
    }

    public void setRowHeight(int x) {
        if (this.DEBUGLEVEL > 3) {
            Logger.logInfo("Updating Row Height: " + this.getRowNumber() + " to: " + x);
        }
        this.fUnsynced = true;
        this.updateGrbit();
        byte[] rw = ByteTools.shortToLEBytes((short)x);
        System.arraycopy(rw, 0, this.getData(), 6, 2);
        this.miyRw = x;
    }

    public int getRowHeight() {
        if (this.miyRw < 0) {
            this.miyRw = (this.miyRw + 1) * -1;
        }
        return this.miyRw;
    }

    @Override
    public void setRowNumber(int n) {
        if (this.DEBUGLEVEL > 3) {
            Logger.logInfo("Updating Row Number: " + this.getRowNumber() + " to: " + n);
        }
        this.rw = n;
        byte[] rwb = ByteTools.shortToLEBytes((short)this.rw);
        System.arraycopy(rwb, 0, this.getData(), 0, 2);
    }

    @Override
    public int getRowNumber() {
        if (this.rw < 0) {
            int rowi = this.rw * -1;
            this.rw = 0x100000 - rowi;
        }
        return this.rw;
    }

    public void setDBCell(Dbcell d) {
        this.dbc = d;
    }

    Dbcell getDBCell() {
        return this.dbc;
    }

    void addCell(BiffRec c) {
        c.setRow(this);
    }

    void removeCell(BiffRec c) {
        this.getSheet().removeCell(c);
    }

    void removeCell(short c) {
        this.getSheet().removeCell(this.getRowNumber(), c);
    }

    int getRealMaxCol() {
        short collast = 0;
        for (BiffRec c : this.getCells()) {
            if (c.getColNumber() <= collast) continue;
            collast = c.getColNumber();
        }
        return collast;
    }

    int getMaxCol() {
        this.preStream();
        return this.colMac;
    }

    int getMinCol() {
        this.preStream();
        return this.colMic;
    }

    public BiffRec getCell(short d) throws CellNotFoundException {
        return this.getSheet().getCell(this.getRowNumber(), d);
    }

    public Collection<BiffRec> getCells() {
        try {
            return this.getSheet().getCellsByRow(this.getRowNumber());
        }
        catch (CellNotFoundException cellNotFoundException) {
            return new ArrayList<BiffRec>();
        }
    }

    public Object[] getCellArray() {
        Collection<BiffRec> cells = this.getCells();
        Object[] br = new Object[cells.size()];
        br = cells.toArray();
        return br;
    }

    public int getNumberOfCells() {
        return this.getCells().size();
    }

    public List getValRecs(int outputId) {
        ArrayList<BiffRec> v = new ArrayList<BiffRec>();
        Collection<BiffRec> cx = this.getCells();
        for (BiffRec br : cx) {
            v.add(br);
            if (br instanceof Formula) {
                ((Formula)br).preStream();
                List itx = ((Formula)br).getInternalRecords();
                BiffRec[] brints = itx.toArray(new BiffRec[itx.size()]);
                int x = 0;
                while (x < brints.length) {
                    if (!v.contains(brints[x])) {
                        v.add(brints[x]);
                    }
                    ++x;
                }
            }
            if (br.getHyperlink() == null) continue;
            v.add(br.getHyperlink());
        }
        return v;
    }

    public int getLastRecIndex() {
        if (this.lastcell != null) {
            return this.lastcell.getRecordIndex();
        }
        return this.getRecordIndex();
    }

    @Override
    public void init() {
        super.init();
        this.getData();
        this.rw = ByteTools.readUnsignedShort(this.getByteAt(0), this.getByteAt(1));
        this.colMic = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.colMac = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.miyRw = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
        byte byte12 = this.getByteAt(12);
        this.outlineLevel = byte12 & 7;
        this.fCollapsed = (byte12 & 0x10) != 0;
        this.fHidden = (byte12 & 0x20) != 0;
        this.fUnsynced = (byte12 & 0x40) != 0;
        this.fGhostDirty = (byte12 & 0x80) != 0;
        byte byte15 = this.getByteAt(15);
        byte byte14 = this.getByteAt(14);
        if (this.fGhostDirty) {
            this.ixfe = byte14 & 0xFF | (byte15 & 0xFF) << 8 & 0xFFF;
            if (this.ixfe < 0 || this.ixfe > this.getWorkBook().getNumXfs()) {
                this.ixfe = 15;
                this.fGhostDirty = false;
            }
        } else {
            this.ixfe = 15;
        }
        this.fBorderTop = (byte15 & 0x10) != 0;
        this.fBorderBottom = (byte15 & 0x20) != 0;
        this.fPhonetic = (byte15 & 0x40) != 0;
    }

    @Override
    public void preStream() {
        if (this.getSheet() != null) {
            this.updateColDimensions(this.colMac);
            this.updateColDimensions(this.colMic);
        } else if (this.DEBUGLEVEL > -1) {
            Logger.logWarn("Missing Boundsheet in Row.prestream for Row: " + this.getRowNumber() + this.getCellAddress());
        }
        byte[] data = new byte[16];
        data[0] = (byte)(this.rw & 0xFF);
        data[1] = (byte)((this.rw & 0xFF00) >>> 8);
        data[2] = (byte)(this.colMic & 0xFF);
        data[3] = (byte)((this.colMic & 0xFF00) >>> 8);
        data[4] = (byte)(this.colMac & 0xFF);
        data[5] = (byte)((this.colMac & 0xFF00) >>> 8);
        data[6] = (byte)(this.miyRw & 0xFF);
        data[7] = (byte)((this.miyRw & 0xFF00) >>> 8);
        if (this.outlineLevel != 0) {
            data[12] = (byte)(data[12] | this.outlineLevel);
        }
        if (this.fCollapsed) {
            data[12] = (byte)(data[12] | 0x10);
        }
        if (this.fHidden) {
            data[12] = (byte)(data[12] | 0x20);
        }
        if (this.fUnsynced) {
            data[12] = (byte)(data[12] | 0x40);
        }
        if (this.fGhostDirty) {
            data[12] = (byte)(data[12] | 0x80);
        }
        data[13] = 1;
        data[14] = (byte)(this.ixfe & 0xFF);
        data[15] = (byte)(this.ixfe >> 8);
        if (this.fBorderTop) {
            data[15] = (byte)(data[15] | 0x10);
        }
        if (this.fBorderBottom) {
            data[15] = (byte)(data[15] | 0x20);
        }
        if (this.fPhonetic) {
            data[15] = (byte)(data[15] | 0x40);
        }
        this.setData(data);
    }

    public void setUnsynched(boolean bUnsynced) {
        this.fUnsynced = bUnsynced;
        this.updateGrbit();
    }

    public boolean getExplicitFormatSet() {
        return this.fGhostDirty;
    }

    public int[] getColDimensions() {
        return new int[]{this.colMic, this.colMac};
    }

    public void updateColDimensions(short col) {
        if (col > 16384) {
            return;
        }
        byte[] cl = null;
        if (col < this.colMic) {
            this.colMic = col;
            cl = ByteTools.shortToLEBytes(this.colMic);
            System.arraycopy(cl, 0, this.getData(), 2, 2);
        }
        if (col > this.colMac) {
            this.colMac = col;
            this.colMac = col = (short)(col + 1);
            cl = ByteTools.shortToLEBytes(this.colMac);
            System.arraycopy(cl, 0, this.getData(), 4, 2);
        }
    }

    @Override
    public String toString() {
        StringBuffer celladdrs = new StringBuffer();
        Collection<BiffRec> cx = this.getCells();
        Iterator<BiffRec> it = cx.iterator();
        while (it.hasNext()) {
            celladdrs.append("{");
            celladdrs.append(it.next().toString());
            celladdrs.append("}");
        }
        return String.valueOf(String.valueOf(this.getRowNumber()) + celladdrs.toString());
    }

    public void setHeight(int twips) {
        if (twips < 2 || twips > 8192) {
            throw new IllegalArgumentException("twips value " + String.valueOf(twips) + " is out of range, must be between 2 and 8192 inclusive");
        }
        this.miyRw = twips;
        this.fUnsynced = true;
    }

    public void clearHeight() {
        this.fUnsynced = false;
    }

    public void setCollapsed(boolean b) {
        Row r2;
        this.fCollapsed = b;
        this.fHidden = b;
        boolean keepgoing = true;
        int counter = 1;
        while (keepgoing) {
            r2 = this.getSheet().getRowByNumber(this.getRowNumber() + counter);
            if (r2 != null && r2.getOutlineLevel() == this.getOutlineLevel()) {
                r2.setHidden(b);
            } else {
                keepgoing = false;
            }
            ++counter;
        }
        counter = 1;
        keepgoing = true;
        while (keepgoing) {
            r2 = this.getSheet().getRowByNumber(this.getRowNumber() - counter);
            if (r2 != null && r2.getOutlineLevel() == this.getOutlineLevel()) {
                r2.setHidden(b);
            } else {
                keepgoing = false;
            }
            ++counter;
        }
        this.updateGrbit();
    }

    public void setHidden(boolean b) {
        this.fHidden = b;
        this.updateGrbit();
    }

    public void setOutlineLevel(int x) {
        this.outlineLevel = x;
        this.getSheet().getGuts().setRowGutterSize(10 + 10 * x);
        this.getSheet().getGuts().setMaxRowLevel(x + 1);
        this.updateGrbit();
    }

    private void updateGrbit() {
        this.preStream();
    }

    public int getOutlineLevel() {
        return this.outlineLevel;
    }

    public boolean isCollapsed() {
        return this.fCollapsed;
    }

    public boolean isHidden() {
        return this.fHidden;
    }

    public boolean isAlteredHeight() {
        return this.fUnsynced;
    }

    @Override
    public void setIxfe(int ixfe) {
        if ((ixfe & 0xFFFFF000) != 0) {
            throw new IllegalArgumentException("ixfe value 0x" + Integer.toHexString(ixfe) + " out of range, must be between 0x0 and 0xfff");
        }
        this.ixfe = ixfe;
        if (ixfe != this.getWorkBook().getDefaultIxfe()) {
            this.fGhostDirty = true;
        }
    }

    public void clearIxfe() {
        this.ixfe = 0;
        this.fGhostDirty = false;
    }

    @Override
    public int getIxfe() {
        return this.fGhostDirty ? this.ixfe : this.getWorkBook().getDefaultIxfe();
    }

    public boolean hasIxfe() {
        return this.fGhostDirty;
    }

    public boolean getHasThickTopBorder() {
        if (!this.fGhostDirty) {
            return false;
        }
        if (this.fBorderTop) {
            try {
                short bs = this.getXfRec().getTopBorderLineStyle();
                return bs == 6 || bs == 5;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean getHasAnyThickTopBorder() {
        return this.fBorderTop;
    }

    public boolean getHasThickBottomBorder() {
        if (!this.fGhostDirty) {
            return false;
        }
        if (this.fBorderBottom) {
            try {
                short bs = this.getXfRec().getBottomBorderLineStyle();
                return bs == 6 || bs == 5;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fBorderBottom;
    }

    public boolean getHasAnyBottomBorder() {
        return this.fBorderBottom;
    }

    public void setHasThickTopBorder(boolean hasBorder) {
        this.fBorderTop = hasBorder;
        if (hasBorder) {
            FormatHandle fh = new FormatHandle(null, this.getXfRec());
            fh.setTopBorderLineStyle(5);
            this.ixfe = fh.getFormatId();
            this.myxf = null;
        }
        this.fGhostDirty = true;
    }

    public void setHasThickBottomBorder(boolean hasBorder) {
        this.fBorderBottom = hasBorder;
        if (hasBorder) {
            FormatHandle fh = new FormatHandle(null, this.getXfRec());
            fh.setBottomBorderLineStyle(5);
            this.ixfe = fh.getFormatId();
            this.myxf = null;
        }
        this.fGhostDirty = true;
    }

    public void setHasAnyThickTopBorder(boolean hasBorder) {
        this.fBorderTop = hasBorder;
    }

    public void setHasAnyThickBottomBorder(boolean hasBorder) {
        this.fBorderBottom = hasBorder;
    }
}

