/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.Mul;
import com.extentech.formats.XLS.Mulled;
import com.extentech.formats.XLS.Mulrk;
import com.extentech.formats.XLS.XLSCellRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.text.NumberFormat;

public final class Rk
extends XLSCellRecord
implements Mulled {
    private static final long serialVersionUID = -3027662614434608240L;
    int rkType;
    double Rkdouble;
    int RKint;
    Mulrk mymul;
    public static final int RK_FP = 0;
    public static final int RK_FP_100 = 1;
    public static final int RK_INT = 2;
    public static final int RK_INT_100 = 3;
    public boolean DEBUG = false;

    @Override
    public void setMyMul(Mul m) {
        this.mymul = (Mulrk)m;
    }

    @Override
    public Mul getMyMul() {
        return this.mymul;
    }

    @Override
    public void setNoMul() {
        this.mymul = null;
    }

    public Rk() {
    }

    Rk(byte[] b, int r2, int c) {
        this.rw = r2;
        this.col = (short)c;
        this.setData(b);
        this.setOpcode((short)638);
        this.setLength(10);
        this.init(b);
    }

    void init(byte[] b, int r2, int c) {
        this.rw = r2;
        this.col = (short)c;
        byte[] rwbt = ByteTools.shortToLEBytes((short)r2);
        byte[] colbt = ByteTools.shortToLEBytes((short)c);
        byte[] newData = new byte[10];
        newData[0] = rwbt[0];
        newData[1] = rwbt[1];
        newData[2] = colbt[0];
        newData[3] = colbt[1];
        System.arraycopy(b, 0, newData, 4, b.length);
        this.setData(newData);
        this.setOpcode((short)638);
        this.init(b);
    }

    void init(byte[] rkdata) {
        super.init();
        byte[] rknum = new byte[4];
        if (rkdata.length > 6) {
            super.initRowCol();
            short s = ByteTools.readShort(rkdata[4], rkdata[5]);
            this.ixfe = s;
            System.arraycopy(rkdata, 6, rknum, 0, 4);
        } else {
            short s = ByteTools.readShort(rkdata[0], rkdata[1]);
            this.ixfe = s;
            System.arraycopy(rkdata, 2, rknum, 0, 4);
        }
        this.translateRK(rknum);
    }

    @Override
    public void init() {
        super.init();
        this.getData();
        byte[] rknum = new byte[4];
        if (this.getLength() > 6) {
            super.initRowCol();
            short s = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
            this.ixfe = s;
            byte[] numdat = this.getBytesAt(6, 4);
            System.arraycopy(numdat, 0, rknum, 0, 4);
        } else {
            short s = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
            this.ixfe = s;
            byte[] numdat = this.getBytesAt(2, 4);
            System.arraycopy(numdat, 0, rknum, 0, 4);
        }
        this.translateRK(rknum);
    }

    /*
     * Unable to fully structure code
     */
    void translateRK(byte[] rkval) {
        l = 0;
        num1 = ByteTools.readShort(rkval[0], rkval[1]);
        num2 = ByteTools.readShort(rkval[2], rkval[3]);
        l = ByteTools.readInt(num2, (int)num1);
        num = l;
        bitset = l & 1;
        bitset2 = l & 2;
        this.rkType = bitset + bitset2;
        d = 1.0;
        this.Rkdouble = Rk.getRealVal(this.rkType, num);
        if (this.DEBUG) {
            Logger.logInfo(String.valueOf(this.rkType));
        }
        if (this.DEBUG) {
            Logger.logInfo(String.valueOf(this.Rkdouble));
        }
        this.setIsValueForCell(true);
        this.isDoubleNumber = false;
        switch (this.rkType) {
            case 0: {
                newnum = String.valueOf(this.Rkdouble);
                if (newnum.length() > 12) {
                    this.isDoubleNumber = true;
                }
                mantindex = newnum.indexOf(".");
                newnum = newnum.substring(mantindex + 1);
                try {
                    if (Integer.parseInt(newnum) > 0) {
                        this.isFPNumber = true;
                        this.isIntNumber = false;
                    } else {
                        this.isFPNumber = false;
                        this.isIntNumber = true;
                        this.RKint = (int)this.Rkdouble;
                    }
                }
                catch (NumberFormatException e) {
                    this.isFPNumber = true;
                    this.isIntNumber = false;
                }
                if (!(this.Rkdouble > 3.4028234663852886E38)) break;
                this.isDoubleNumber = true;
                break;
            }
            case 1: {
                this.isFPNumber = true;
                this.isIntNumber = false;
                break;
            }
            case 2: {
                this.isFPNumber = false;
                this.isIntNumber = true;
                this.RKint = (int)this.Rkdouble;
                break;
            }
            case 3: {
                newnum = String.valueOf(this.Rkdouble);
                if (newnum.toUpperCase().indexOf("E") <= -1) ** GOTO lbl61
                nmf = NumberFormat.getInstance();
                try {
                    nm = nmf.parse(newnum);
                    v = nm.floatValue();
                    if (this.DEBUGLEVEL > 5) {
                        Logger.logInfo("Rk number format: " + v);
                    }
                    ** GOTO lbl63
                }
                catch (Exception var14_17) {}
                ** GOTO lbl63
lbl61:
                // 1 sources

                mantindex = newnum.indexOf(".");
                newnum = newnum.substring(mantindex + 1);
lbl63:
                // 4 sources

                try {
                    if (Long.parseLong(newnum) > 0L) {
                        this.isFPNumber = true;
                        this.isIntNumber = false;
                        break;
                    }
                    this.isFPNumber = false;
                    this.isIntNumber = true;
                    this.RKint = (int)this.Rkdouble;
                    break;
                }
                catch (NumberFormatException e) {
                    this.isFPNumber = false;
                    this.isIntNumber = true;
                    this.RKint = (int)this.Rkdouble;
                }
            }
        }
    }

    @Override
    public int getRecordIndex() {
        if (super.getRecordIndex() < 0) {
            if (this.mymul == null) {
                return -1;
            }
            return this.mymul.getRecordIndex();
        }
        return super.getRecordIndex();
    }

    public static double parseRkNumber(byte[] rkbytes) {
        int num = 0;
        short num1 = ByteTools.readShort(rkbytes[0], rkbytes[1]);
        short num2 = ByteTools.readShort(rkbytes[2], rkbytes[3]);
        num = ByteTools.readInt(num2, (int)num1);
        int bitset = num & 1;
        int bitset2 = num & 2;
        int rkType = bitset + bitset2;
        return Rk.getRealVal(rkType, num);
    }

    private static double getRealVal(int RKType, long waknum) {
        waknum &= 0xFFFFFFFFFFFFFFFCL;
        switch (RKType) {
            case 0: {
                String testq = Long.toBinaryString(waknum <<= 32);
                return Double.longBitsToDouble(waknum);
            }
            case 1: {
                double res = Double.longBitsToDouble(waknum << 32);
                return res /= 100.0;
            }
            case 2: {
                return waknum >>= 2;
            }
            case 3: {
                if (waknum >= 4290773292L) {
                    Logger.logWarn("Erroneous Rk");
                }
                double ddd = waknum >>= 2;
                return ddd / 100.0;
            }
        }
        Logger.logInfo("incorrect RK type for RK record: " + String.valueOf(RKType));
        return 0.0;
    }

    @Override
    public int getIntVal() throws RuntimeException {
        if (this.isFPNumber) {
            long l = (long)this.Rkdouble;
            if (l > Integer.MAX_VALUE) {
                throw new NumberFormatException("Cell value is larger than the maximum java signed int size");
            }
            if (l < Integer.MIN_VALUE) {
                throw new NumberFormatException("Cell value is smaller than the minimum java signed int size");
            }
            return (int)this.Rkdouble;
        }
        return this.RKint;
    }

    @Override
    public double getDblVal() {
        if (this.isIntNumber) {
            return this.RKint;
        }
        return this.Rkdouble;
    }

    @Override
    public float getFloatVal() {
        if (this.isIntNumber) {
            return this.RKint;
        }
        return (float)this.Rkdouble;
    }

    @Override
    public String getStringVal() {
        if (this.isIntNumber) {
            return String.valueOf(this.RKint);
        }
        return ExcelTools.getNumberAsString(this.Rkdouble);
    }

    @Override
    public void setStringVal(String s) {
        try {
            if (s.indexOf(".") > -1) {
                double f = new Double(s);
                this.setDoubleVal(f);
            } else {
                int i = Integer.parseInt(s);
                this.setIntVal(i);
            }
        }
        catch (NumberFormatException f) {
            Logger.logWarn("in Rk " + s + " is not a number.");
        }
    }

    @Override
    public void setFloatVal(float f) {
        try {
            this.setRKVal(f);
        }
        catch (Exception x) {
            Logger.logWarn("Rk.setFloatVal() problem.  Fallback to floating point Number.");
            Rk.convertRkToNumber(this, f);
        }
    }

    @Override
    public void setIntVal(int f) {
        try {
            this.setRKVal(f);
        }
        catch (Exception x) {
            Logger.logWarn("Rk.setIntVal() problem.  Fallback to floating point Number.");
            Rk.convertRkToNumber(this, f);
        }
    }

    @Override
    public void setDoubleVal(double f) {
        try {
            this.setRKVal(f);
        }
        catch (Exception x) {
            Logger.logWarn("Rk.setDoubleVal() problem.  Fallback to floating point Number.");
            Rk.convertRkToNumber(this, f);
        }
    }

    public String getTypeName() {
        return "Rkdouble";
    }

    void setMulrkRow(int i) {
        super.setRowNumber(i);
        if (this.mymul != null) {
            this.mymul.setRow(i);
        }
    }

    public static byte[] getRkBytes(double d) {
        long bitlong = Double.doubleToLongBits(d);
        long bigger = Double.doubleToLongBits(d * 100.0);
        long l = (long)d;
        l = Math.abs(l);
        byte[] rkbytes = new byte[5];
        rkbytes[4] = -1;
        byte[] doublebytes = new byte[8];
        if (bitlong << 30 == 0L) {
            doublebytes = ByteTools.doubleToByteArray(d);
            int mask = -4;
            doublebytes[3] = (byte)(doublebytes[3] & mask);
            rkbytes[0] = doublebytes[3];
            rkbytes[1] = doublebytes[2];
            rkbytes[2] = doublebytes[1];
            rkbytes[3] = doublebytes[0];
            rkbytes[4] = 0;
        } else if (l << 2 >>> 30 == 0L && d % 1.0 == 0.0) {
            long lo = (long)d;
            doublebytes = ByteTools.longToByteArray(lo <<= 2);
            int mask = 2;
            doublebytes[7] = (byte)(doublebytes[7] | mask);
            rkbytes[0] = doublebytes[7];
            rkbytes[1] = doublebytes[6];
            rkbytes[2] = doublebytes[5];
            rkbytes[3] = doublebytes[4];
            rkbytes[4] = 2;
        } else if (bigger << 30 == 0L) {
            doublebytes = ByteTools.doubleToByteArray(d * 100.0);
            byte mask = 1;
            doublebytes[3] = (byte)(doublebytes[3] | mask);
            rkbytes[0] = doublebytes[3];
            rkbytes[1] = doublebytes[2];
            rkbytes[2] = doublebytes[1];
            rkbytes[3] = doublebytes[0];
            rkbytes[4] = 1;
        } else if (d * 100.0 % 1.0 == 0.0 && l * 100L >>> 30 == 0L) {
            long lo = (long)(d * 100.0);
            doublebytes = ByteTools.longToByteArray(lo <<= 2);
            int mask = 3;
            doublebytes[7] = (byte)(doublebytes[7] | mask);
            rkbytes[0] = doublebytes[7];
            rkbytes[1] = doublebytes[6];
            rkbytes[2] = doublebytes[5];
            rkbytes[3] = doublebytes[4];
            rkbytes[4] = 3;
        }
        if (rkbytes[4] != -1 && d != Rk.parseRkNumber(rkbytes)) {
            throw new RuntimeException(String.valueOf(d) + " could not be translated to Rk value");
        }
        return rkbytes;
    }

    protected void setRKVal(double d) {
        byte[] b = Rk.getRkBytes(d);
        this.rkType = b[4];
        switch (this.rkType) {
            case 0: {
                this.isFPNumber = true;
                break;
            }
            case 2: {
                this.isIntNumber = true;
                break;
            }
            case 1: {
                this.isFPNumber = true;
                break;
            }
            case 3: {
                this.isIntNumber = true;
                break;
            }
            default: {
                Rk.convertRkToNumber(this, d);
                return;
            }
        }
        System.arraycopy(b, 0, this.getData(), 6, 4);
        this.init(this.getData());
        if (this.Rkdouble != d) {
            Logger.logWarn("Rk.setRKVal() problem.  Fallback to floating point Number.");
            Rk.convertRkToNumber(this, d);
        }
    }

    public static void convertRkToNumber(Rk reek, double d) {
        int fmt = reek.ixfe;
        String addy = reek.getCellAddress();
        Boundsheet bs = reek.getSheet();
        bs.removeCell(reek);
        BiffRec addedrec = bs.addValue(new Double(d), addy);
        addedrec.setIxfe(reek.getIxfe());
    }

    public int getType() {
        return this.rkType;
    }

    @Override
    public void setXFRecord(int i) {
        if (this.mymul != null) {
            byte[] b = this.getData();
            this.ixfe = i;
            byte[] newxfe = ByteTools.cLongToLEBytes(i);
            System.arraycopy(newxfe, 0, b, 4, 2);
            this.mymul.updateRks();
        } else {
            super.setIxfe(i);
        }
        super.setXFRecord();
    }

    @Override
    public void close() {
        super.close();
        if (this.mymul != null) {
            this.mymul.close();
        }
        this.mymul = null;
    }

    public static void testVALUES() {
        int v = Integer.MAX_VALUE;
        while (v >= Integer.MIN_VALUE) {
            Rk.getRkBytes(v);
            --v;
        }
    }
}

