/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.Window2;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;

public final class Pane
extends XLSRecord {
    private static final long serialVersionUID = 5314818835334217157L;
    short px;
    short py;
    short visRow;
    short visCol;
    byte pActive;
    boolean bFrozen;
    Window2 win2;
    private byte[] PROTOTYPE_BYTES = new byte[10];

    @Override
    public void init() {
        super.init();
        this.px = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.py = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.visRow = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.visCol = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
        this.pActive = this.getByteAt(8);
    }

    public static XLSRecord getPrototype() {
        Pane p = new Pane();
        p.setOpcode((short)65);
        p.setData(p.PROTOTYPE_BYTES);
        p.init();
        return p;
    }

    public void setSplitColumn(int col, int nCols) {
        this.setFrozenColumn(col);
        this.win2.setFreezePanes(false);
        this.visCol = (short)col;
        this.px = (short)nCols;
        this.py = 0;
        this.pActive = (byte)3;
        this.updateData();
    }

    public void setFrozenColumn(int col) {
        this.win2.setFreezePanes(true);
        this.visCol = (short)col;
        this.px = (short)col;
        this.pActive = 0;
        this.updateData();
    }

    public void setSplitRow(int row, int rsz) {
        this.setFrozenRow(row);
        this.win2.setFreezePanes(false);
        this.visRow = (short)row;
        this.py = (short)rsz;
        this.px = 0;
        this.pActive = (byte)3;
        this.updateData();
    }

    public int getVisibleRow() {
        return this.visRow;
    }

    public int getVisibleCol() {
        return this.visCol;
    }

    public int getRowSplitLoc() {
        return this.py;
    }

    public void setFrozenRow(int row) {
        this.win2.setFreezePanes(true);
        this.visRow = (short)row;
        this.py = (short)row;
        this.pActive = 0;
        this.updateData();
    }

    public String getTopLeftCell() {
        return ExcelTools.formatLocation(new int[]{this.visRow, this.visCol});
    }

    protected void updateData() {
        this.getData();
        byte[] b = ByteTools.shortToLEBytes(this.px);
        this.data[0] = b[0];
        this.data[1] = b[1];
        b = ByteTools.shortToLEBytes(this.py);
        this.data[2] = b[0];
        this.data[3] = b[1];
        b = ByteTools.shortToLEBytes(this.visRow);
        this.data[4] = b[0];
        this.data[5] = b[1];
        b = ByteTools.shortToLEBytes(this.visCol);
        this.data[6] = b[0];
        this.data[7] = b[1];
        this.data[8] = this.pActive;
    }

    public void setWindow2(Window2 win2) {
        this.win2 = win2;
    }
}

