/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ChartHandle;
import com.extentech.ExtenXLS.CommentHandle;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.FormulaHandle;
import com.extentech.ExtenXLS.ImageHandle;
import com.extentech.ExtenXLS.RowHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.ExtenXLS.WorkSheetHandle;
import com.extentech.formats.OOXML.Border;
import com.extentech.formats.OOXML.Dxf;
import com.extentech.formats.OOXML.Fill;
import com.extentech.formats.OOXML.NumFmt;
import com.extentech.formats.OOXML.OOXMLConstants;
import com.extentech.formats.OOXML.OneCellAnchor;
import com.extentech.formats.OOXML.SheetView;
import com.extentech.formats.OOXML.TwoCellAnchor;
import com.extentech.formats.XLS.Colinfo;
import com.extentech.formats.XLS.Condfmt;
import com.extentech.formats.XLS.FormatConstants;
import com.extentech.formats.XLS.FormulaNotFoundException;
import com.extentech.formats.XLS.Labelsst;
import com.extentech.formats.XLS.Mergedcells;
import com.extentech.formats.XLS.Name;
import com.extentech.formats.XLS.OOXMLAdapter;
import com.extentech.formats.XLS.Xf;
import com.extentech.formats.XLS.charts.Chart;
import com.extentech.formats.XLS.charts.OOXMLChart;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipOutputStream;

public class OOXMLWriter
extends OOXMLAdapter
implements OOXMLConstants {
    public void getOOXML(WorkBookHandle bk, OutputStream out) throws IOException {
        this.mainContentList = new ArrayList();
        this.wbContentList = new ArrayList();
        this.drContentList = new ArrayList();
        this.shContentList = new ArrayList();
        this.sheetsContentList = new ArrayList();
        this.vmlId = 0;
        this.drawingId = 0;
        this.commentsId = 0;
        this.activeXId = 0;
        this.activeXBinaryId = 0;
        this.printerSettingsId = 0;
        this.oleObjectsId = 0;
        this.chartId = 0;
        this.imgId = 0;
        this.zip = new ZipOutputStream(out);
        this.writer = new OutputStreamWriter((OutputStream)this.zip, inputEncoding);
        this.externalDir = OOXMLWriter.getTempDir(bk.getWorkBook().getFactory().getFileName());
        this.writeOOXML(bk);
        this.writeRels(this.mainContentList, "_rels/.rels");
        this.writeContentType();
        this.writeDeferredFiles();
        this.writer.flush();
        this.writer.close();
        if (this.zip != null) {
            this.zip.flush();
            this.zip.close();
        }
        if (!bk.getWorkBook().getFactory().getFileName().endsWith(".tmp")) {
            OOXMLWriter.deleteDir(new File(this.externalDir));
        }
        this.zip = null;
    }

    protected void writeDeferredFiles() throws IOException {
        Iterator its = this.deferredFiles.keySet().iterator();
        while (its.hasNext()) {
            String k = its.next().toString();
            String fx = (String)this.deferredFiles.get(k);
            this.writeFileToZIP(fx, k);
            File fdel = new File(fx);
            fdel.deleteOnExit();
            fdel.delete();
        }
    }

    private void writeSheetLevelExternalReferenceOOXML(Writer out, String type, List externalOOXML) {
        ArrayList refs = this.getExternalRefType(type, externalOOXML);
        if (refs.size() > 0) {
            StringBuffer ooxml = new StringBuffer();
            int rId = -1;
            try {
                if (type.equals("oleObject")) {
                    ooxml.append(this.writeExOOMXLElement("oleObject", refs, false));
                } else if (type.equals("activeX")) {
                    ooxml.append(this.writeExOOMXLElement("control", refs, false));
                } else if (type.equalsIgnoreCase("printerSettings")) {
                    ooxml.append(this.writeExOOMXLElement("pageSetup", refs, true));
                } else {
                    Logger.logWarn("Unknown External Type " + type);
                }
            }
            catch (IOException e) {
                Logger.logErr("OOXMLWriter.writeSheetLevelExternalReferenceOOXML: " + e.toString());
            }
            try {
                out.write(ooxml.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private ArrayList getExternalRefType(String type, List externalOOXML) {
        ArrayList<String[]> refs = new ArrayList<String[]>();
        int i = 0;
        while (i < externalOOXML.size()) {
            String[] s = (String[])externalOOXML.get(i);
            if (s != null && s.length >= 0 && s[0].equalsIgnoreCase(type)) {
                refs.add(s);
            }
            ++i;
        }
        return refs;
    }

    private void writeExternalOOXML(WorkBookHandle bk) throws IOException {
        List externalOOXML = bk.getWorkBook().getOOXMLObjects();
        int i = 0;
        while (i < externalOOXML.size()) {
            String type;
            String[] s = (String[])externalOOXML.get(i);
            if (s != null && s.length >= 3 && ((type = s[this.EX_TYPE]).equalsIgnoreCase("props") || type.equals("exprops") || type.equals("custprops") || type.equals("connections") || type.equals("externalLink") || type.equals("theme") || type.equals("vba"))) {
                if (type.equals("props") || type.equals("exprops")) {
                    this.writeExOOXMLFile(s, this.mainContentList);
                } else {
                    this.writeExOOXMLFile(s, this.wbContentList);
                }
            }
            ++i;
        }
    }

    private int writeExOOXMLFile(String[] s, ArrayList contentList) throws IOException {
        String p = s[this.EX_PATH];
        String f = s[this.EX_FNAME];
        int rId = -1;
        File finx = new File(f);
        if (finx.exists()) {
            String fname = this.getExOOXMLFileName(f);
            if (s.length > this.EX_EMBEDINFO) {
                ArrayList<String[]> cl = new ArrayList<String[]>();
                String[] embeds = StringTool.splitString(s[this.EX_EMBEDINFO].substring(1, s[this.EX_EMBEDINFO].length() - 1), ",");
                if (embeds != null) {
                    int i = 0;
                    while (i < embeds.length) {
                        String pp = embeds[i].trim();
                        String typ = pp.substring(0, pp.indexOf("/"));
                        pp = pp.substring(pp.indexOf("/") + 1);
                        String pth = pp.substring(0, pp.lastIndexOf("/") + 1);
                        String ff = pp = pp.substring(pp.lastIndexOf("/") + 1);
                        if (!typ.equals("externalLinkPath")) {
                            ff = this.getExOOXMLFileName(pp);
                            this.deferredFiles.put(String.valueOf(pth) + ff, String.valueOf(this.externalDir) + pp);
                            cl.add(new String[]{"/" + pth + ff, typ});
                            this.sheetsContentList.addAll(cl);
                        } else {
                            cl.add(new String[]{"/" + pth + ff, typ});
                        }
                        ++i;
                    }
                }
                this.writeRels(cl, String.valueOf(p) + "_rels/" + fname + ".rels");
            }
            this.deferredFiles.put(String.valueOf(p) + fname, f);
            contentList.add(new String[]{"/" + p + fname, s[this.EX_TYPE]});
            rId = contentList.size();
        }
        return rId;
    }

    private String writeExOOMXLElement(String xmlElement, ArrayList refs, boolean onlyOne) throws IOException {
        StringBuffer ooxml = new StringBuffer();
        if (!onlyOne) {
            ooxml.append("<" + xmlElement + "s>");
            ooxml.append("\r\n");
        }
        int i = 0;
        while (i < refs.size()) {
            String[] s = (String[])refs.get(i);
            if (s.length > this.EX_EXTRAINFO && s[this.EX_EXTRAINFO] != null) {
                ooxml.append("<" + xmlElement + " " + s[this.EX_EXTRAINFO] + " r:id=\"rId" + (this.shContentList.size() + 1) + "\"/>");
                ooxml.append("\r\n");
            } else {
                ooxml.append("<" + xmlElement + " r:id=\"rId" + (this.shContentList.size() + 1) + "\"/>");
                ooxml.append("\r\n");
            }
            this.writeExOOXMLFile(s, this.shContentList);
            ++i;
        }
        if (!onlyOne) {
            ooxml.append("</" + xmlElement + "s>");
            ooxml.append("\r\n");
        }
        return ooxml.toString();
    }

    protected void writeRels(ArrayList cl, String relsfname) throws IOException {
        if (cl == null || cl.size() == 0) {
            return;
        }
        StringBuffer rels = new StringBuffer();
        rels.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        rels.append("\r\n");
        rels.append("<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">");
        rels.append("\r\n");
        int i = 0;
        while (i < cl.size()) {
            rels.append("<Relationship Id=\"rId" + (i + 1));
            String type = ((String[])cl.get(i))[1];
            if (!type.equals("hyperlink") && !type.equals("externalLinkPath")) {
                rels.append("\" Type=\"" + this.getRelationshipType(type) + "\" Target=\"" + ((String[])cl.get(i))[0] + "\"/>");
            } else {
                rels.append("\" Type=\"" + this.getRelationshipType(type) + "\" Target=\"" + ((String[])cl.get(i))[0] + "\" TargetMode=\"External\"/>");
            }
            rels.append("\r\n");
            ++i;
        }
        rels.append("</Relationships>");
        rels.append("\r\n");
        this.addDeferredFile(rels, relsfname);
    }

    protected void writeContentType() throws IOException {
        StringBuffer ct = new StringBuffer();
        ct.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        ct.append("\r\n");
        ct.append("<Types xmlns=\"http://schemas.openxmlformats.org/package/2006/content-types\">");
        ct.append("\r\n");
        ct.append("<Default Extension=\"rels\" ContentType=\"application/vnd.openxmlformats-package.relationships+xml\"/>");
        ct.append("\r\n");
        ct.append("<Default Extension=\"xml\" ContentType=\"application/xml\"/>");
        ct.append("\r\n");
        ct.append("<Default Extension=\"png\" ContentType=\"image/png\"/>");
        ct.append("\r\n");
        ct.append("<Default Extension=\"jpeg\" ContentType=\"image/jpeg\"/>");
        ct.append("\r\n");
        ct.append("<Default Extension=\"emf\" ContentType=\"image/x-emf\"/>");
        ct.append("\r\n");
        ct.append("<Default Extension=\"bin\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.printerSettings\"/>");
        ct.append("\r\n");
        ct.append("<Default Extension=\"vml\" ContentType=\"application/vnd.openxmlformats-officedocument.vmlDrawing\"/>");
        ct.append("\r\n");
        int i = 0;
        while (i < this.mainContentList.size()) {
            ct.append("<Override PartName=\"" + ((String[])this.mainContentList.get(i))[0] + "\" ContentType=\"" + this.getContentType(((String[])this.mainContentList.get(i))[1]) + "\"/>");
            ct.append("\r\n");
            ++i;
        }
        i = 0;
        while (i < this.wbContentList.size()) {
            ct.append("<Override PartName=\"" + ((String[])this.wbContentList.get(i))[0] + "\" ContentType=\"" + this.getContentType(((String[])this.wbContentList.get(i))[1]) + "\"/>");
            ct.append("\r\n");
            ++i;
        }
        i = 0;
        while (i < this.sheetsContentList.size()) {
            if (!(((String[])this.sheetsContentList.get(i))[1].equals("printerSettings") || ((String[])this.sheetsContentList.get(i))[1].equals("vmldrawing") || ((String[])this.sheetsContentList.get(i))[1].equals("hyperlink") || ((String[])this.sheetsContentList.get(i))[1].equals("image"))) {
                ct.append("<Override PartName=\"" + ((String[])this.sheetsContentList.get(i))[0] + "\" ContentType=\"" + this.getContentType(((String[])this.sheetsContentList.get(i))[1]) + "\"/>");
                ct.append("\r\n");
            }
            ++i;
        }
        i = 0;
        while (i < this.drContentList.size()) {
            if (!((String[])this.drContentList.get(i))[1].equals("image")) {
                ct.append("<Override PartName=\"" + ((String[])this.drContentList.get(i))[0] + "\" ContentType=\"" + this.getContentType(((String[])this.drContentList.get(i))[1]) + "\"/>");
            }
            ct.append("\r\n");
            ++i;
        }
        ct.append("</Types>");
        this.addDeferredFile(ct, "[Content_Types].xml");
    }

    public void getOOXML(WorkBookHandle bk, String path) throws Exception {
        if (!OOXMLAdapter.hasMacros(bk)) {
            path = StringTool.replaceExtension(path, ".xlsx");
            this.format = 101;
        } else {
            path = StringTool.replaceExtension(path, ".xlsm");
            this.format = 102;
        }
        File fout = new File(path);
        File dirs = fout.getParentFile();
        if (dirs != null && !dirs.exists()) {
            dirs.mkdirs();
        }
        this.getOOXML(bk, new FileOutputStream(path));
    }

    private void writeSSTOOXML(WorkBookHandle bk) throws IOException {
        this.nextZipEntry("xl/sharedStrings.xml");
        bk.getWorkBook().getSharedStringTable().writeOOXML(this.writer);
        this.wbContentList.add(new String[]{"/xl/sharedStrings.xml", "sst"});
    }

    protected void writeOOXML(WorkBookHandle bk) throws IOException {
        int origcalcmode = bk.getWorkBook().getCalcMode();
        bk.getWorkBook().setCalcMode(1);
        this.writeExternalOOXML(bk);
        this.writeSSTOOXML(bk);
        this.wbContentList.add(new String[]{"/xl/styles.xml", "styles"});
        this.writeWorkBookOOXML(bk);
        WorkSheetHandle[] wsh = bk.getWorkSheets();
        bk.getWorkBook().setDxfs(null);
        int i = 0;
        while (i < wsh.length) {
            this.writeSheetOOXML(bk, wsh[i], i);
            ++i;
        }
        this.writeStylesOOXML(bk);
        bk.getWorkBook().setCalcMode(origcalcmode);
    }

    private void writeStylesOOXML(WorkBookHandle bk) throws IOException {
        ArrayList dxfs;
        StringBuffer stylesooxml = new StringBuffer();
        stylesooxml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        stylesooxml.append("<styleSheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\">");
        stylesooxml.append("\r\n");
        AbstractList xfs = bk.getWorkBook().getXfrecs();
        ArrayList cellxfs = new ArrayList();
        ArrayList<String> fills = new ArrayList<String>();
        ArrayList<String> borders = new ArrayList<String>();
        ArrayList numfmts = new ArrayList();
        ArrayList fonts = new ArrayList();
        fills.add(Fill.getOOXML(0, -1, -1));
        fills.add(Fill.getOOXML(17, -1, -1));
        borders.add(Border.getOOXML(new int[]{-1, -1, -1, -1, -1}, new int[5]));
        int i = 0;
        while (i < xfs.size()) {
            Xf xf = (Xf)xfs.get(i);
            this.addXFToStyle(xf, cellxfs, fills, borders, numfmts, fonts);
            ++i;
        }
        if (numfmts.size() > 0) {
            stylesooxml.append("<numFmts count=\"" + numfmts.size() + "\">");
            stylesooxml.append("\r\n");
            i = 0;
            while (i < numfmts.size()) {
                stylesooxml.append((String)numfmts.get(i));
                stylesooxml.append("\r\n");
                ++i;
            }
            stylesooxml.append("</numFmts>");
            stylesooxml.append("\r\n");
        }
        stylesooxml.append("<fonts count=\"" + fonts.size() + "\">");
        stylesooxml.append("\r\n");
        i = 0;
        while (i < fonts.size()) {
            stylesooxml.append((String)fonts.get(i));
            stylesooxml.append("\r\n");
            ++i;
        }
        stylesooxml.append("</fonts>");
        stylesooxml.append("\r\n");
        stylesooxml.append("<fills count=\"" + fills.size() + "\">");
        stylesooxml.append("\r\n");
        i = 0;
        while (i < fills.size()) {
            stylesooxml.append((String)fills.get(i));
            stylesooxml.append("\r\n");
            ++i;
        }
        stylesooxml.append("</fills>");
        stylesooxml.append("\r\n");
        stylesooxml.append("<borders count=\"" + borders.size() + "\">");
        stylesooxml.append("\r\n");
        i = 0;
        while (i < borders.size()) {
            stylesooxml.append((String)borders.get(i));
            stylesooxml.append("\r\n");
            ++i;
        }
        stylesooxml.append("</borders>");
        stylesooxml.append("\r\n");
        stylesooxml.append("<cellXfs count=\"" + cellxfs.size() + "\">");
        stylesooxml.append("\r\n");
        i = 0;
        while (i < cellxfs.size()) {
            boolean protectblock;
            stylesooxml.append("<xf ");
            int[] refs = (int[])cellxfs.get(i);
            int ftId = refs[0];
            int fId = refs[1];
            int bId = refs[2];
            int nId = refs[3];
            int ha = refs[4];
            int va = refs[5];
            int wr = refs[6];
            int ind = refs[7];
            int rot = refs[8];
            int hidden = refs[9];
            int locked = refs[10];
            int shrink = refs[11];
            int rtoleft = refs[12];
            if (nId > -1) {
                stylesooxml.append(" numFmtId=\"" + nId + "\"");
            }
            if (ftId > -1) {
                stylesooxml.append(" fontId=\"" + ftId + "\"");
            }
            if (fId > -1) {
                stylesooxml.append(" fillId=\"" + fId + "\"");
            }
            if (fId > 0) {
                stylesooxml.append(" applyFill=\"1\"");
            }
            if (bId > -1) {
                stylesooxml.append(" borderId=\"" + bId + "\"");
            }
            boolean alignblock = ha != 0 || va != 2 || wr != 0 || ind != 0 || rot != 0;
            boolean bl = protectblock = hidden == 1 || locked == 0;
            if (alignblock || protectblock) {
                stylesooxml.append(">");
            }
            if (ha != 0 || va != 2 || wr != 0 || ind != 0 || rot != 0) {
                stylesooxml.append("<alignment");
                if (ha != 0) {
                    stylesooxml.append(" horizontal=\"" + horizontalAlignment[ha] + "\"");
                }
                if (va != 2) {
                    stylesooxml.append(" vertical=\"" + verticalAlignment[va] + "\"");
                }
                if (wr == 1) {
                    stylesooxml.append(" wrapText=\"1\"");
                }
                if (ind > 0) {
                    stylesooxml.append(" indent=\"" + ind + "\"");
                }
                if (rot != 0) {
                    stylesooxml.append(" textRotation=\"" + rot + "\"");
                }
                if (shrink == 1) {
                    stylesooxml.append(" shrinkToFit=\"1\"");
                }
                if (rtoleft != 0) {
                    stylesooxml.append(" readingOrder=\"" + rtoleft + "\"");
                }
                stylesooxml.append("/>\r\n");
            }
            if (hidden == 1 || locked == 0) {
                stylesooxml.append("<protection");
                if (hidden == 1) {
                    stylesooxml.append(" hidden=\"1\"");
                }
                if (locked == 0) {
                    stylesooxml.append(" locked=\"0\"");
                }
                stylesooxml.append("/>\r\n");
            }
            if (alignblock || protectblock) {
                stylesooxml.append("</xf>\r\n");
            } else {
                stylesooxml.append("/>\r\n");
            }
            ++i;
        }
        stylesooxml.append("</cellXfs>");
        stylesooxml.append("\r\n");
        if (bk.getWorkBook().getDxfs() != null && (dxfs = bk.getWorkBook().getDxfs()).size() > 0) {
            stylesooxml.append("<dxfs count=\"" + dxfs.size() + "\">");
            int i2 = 0;
            while (i2 < dxfs.size()) {
                stylesooxml.append(((Dxf)dxfs.get(i2)).getOOXML());
                ++i2;
            }
            stylesooxml.append("</dxfs>");
        }
        stylesooxml.append("<colors>");
        stylesooxml.append("\r\n");
        stylesooxml.append("<indexedColors>");
        stylesooxml.append("\r\n");
        i = 0;
        while (i < bk.getWorkBook().getColorTable().length) {
            stylesooxml.append("<rgbColor rgb=\"00" + FormatHandle.colorToHexString(bk.getWorkBook().getColorTable()[i]).substring(1) + "\"/>");
            stylesooxml.append("\r\n");
            ++i;
        }
        stylesooxml.append("</indexedColors>");
        stylesooxml.append("\r\n");
        stylesooxml.append("</colors>");
        stylesooxml.append("\r\n");
        stylesooxml.append("</styleSheet>");
        this.addDeferredFile(stylesooxml, "xl/styles.xml");
    }

    private void addXFToStyle(Xf xf, ArrayList cellxfs, ArrayList fills, ArrayList borders, ArrayList numfmts, ArrayList fonts) {
        int[] refs = new int[13];
        String s = xf.getFont().getOOXML();
        int id = fonts.indexOf(s);
        if (id == -1) {
            fonts.add(s);
            refs[0] = fonts.size() - 1;
        } else {
            refs[0] = id;
        }
        id = 0;
        if (xf.getFill() != null) {
            s = xf.getFill().getOOXML();
            id = fills.indexOf(s);
        } else if (xf.getFillPattern() > 0) {
            s = Fill.getOOXML(xf);
            id = fills.indexOf(s);
        }
        if (id == -1) {
            fills.add(s);
            refs[1] = fills.size() - 1;
        } else {
            refs[1] = id;
        }
        s = Border.getOOXML(xf);
        id = borders.indexOf(s);
        if (id == -1) {
            borders.add(s);
            refs[2] = borders.size() - 1;
        } else {
            refs[2] = id;
        }
        if (xf.getIfmt() > FormatConstants.BUILTIN_FORMATS.length && (id = numfmts.indexOf(s = NumFmt.getOOXML(xf))) == -1) {
            numfmts.add(s);
        }
        refs[3] = xf.getIfmt();
        refs[4] = xf.getHorizontalAlignment();
        refs[5] = xf.getVerticalAlignment();
        refs[6] = xf.getWrapText() ? 1 : 0;
        refs[7] = xf.getIndent();
        refs[8] = xf.getRotation();
        refs[9] = xf.isFormulaHidden() ? 1 : 0;
        refs[10] = xf.isLocked() ? 1 : 0;
        refs[11] = xf.isShrinkToFit() ? 1 : 0;
        refs[12] = xf.getRightToLeftReadingOrder();
        cellxfs.add(refs);
    }

    private void writeWorkBookOOXML(WorkBookHandle bk) throws IOException {
        Name[] names;
        int i;
        this.nextZipEntry("xl/workbook.xml");
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        this.writer.write("\r\n");
        this.writer.write("<workbook xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">");
        this.writer.write("\r\n");
        if (bk.getWorkBook().getCodename() != null) {
            this.writer.write("<workbookPr codeName=\"" + bk.getWorkBook().getCodename() + "\"/>");
            this.writer.write("\r\n");
        }
        this.writer.write("<bookViews>");
        this.writer.write("\r\n");
        this.writer.write("<workbookView");
        this.writer.write(" firstSheet=\"" + bk.getWorkBook().getFirstSheet() + "\"");
        this.writer.write(" activeTab=\"" + bk.getWorkBook().getSelectedSheetNum() + "\"");
        if (!bk.showSheetTabs()) {
            this.writer.write(" showSheetTabs=\"0\"");
        }
        this.writer.write("/>\r\n");
        this.writer.write("</bookViews>");
        this.writer.write("\r\n");
        this.writer.write("<sheets>");
        this.writer.write("\r\n");
        WorkSheetHandle[] wsh = bk.getWorkSheets();
        int i2 = 0;
        while (i2 < wsh.length) {
            String s = "sheet" + (i2 + 1);
            this.writer.write("<sheet name=\"" + OOXMLWriter.stripNonAscii(wsh[i2].getSheetName()) + "\" sheetId=\"" + (i2 + 1) + "\" r:id=\"rId" + (i2 + 1) + "\"");
            if (wsh[i2].getVeryHidden()) {
                this.writer.write(" state=\"veryHidden\"");
            } else if (wsh[i2].getHidden()) {
                this.writer.write(" state=\"hidden\"");
            }
            this.writer.write("/>");
            this.writer.write("\r\n");
            this.wbContentList.add(i2, new String[]{"/xl/worksheets/" + s + ".xml", "sheet"});
            ++i2;
        }
        this.writer.write("</sheets>");
        this.writer.write("\r\n");
        int rId = wsh.length;
        if (this.getExternalRefType("externalLink", bk.getWorkBook().getOOXMLObjects()).size() > 0) {
            ArrayList refs = this.getExternalRefType("externalLink", bk.getWorkBook().getOOXMLObjects());
            this.writer.write("<externalReferences>");
            this.writer.write("\r\n");
            i = 0;
            while (i < refs.size()) {
                String[] r2 = (String[])refs.get(i);
                r2[3] = "rId" + (rId + 1);
                refs.remove(i);
                refs.add(i, r2);
                this.writer.write("<externalReference r:id=\"rId" + ++rId + "\"/>");
                this.writer.write("\r\n");
                ++i;
            }
            this.writer.write("</externalReferences>");
            this.writer.write("\r\n");
        }
        if ((names = bk.getWorkBook().getNames()) != null && names.length > 0) {
            this.writer.write("<definedNames>");
            this.writer.write("\r\n");
            i = 0;
            while (i < names.length) {
                String s = OOXMLWriter.stripNonAsciiRetainQuote(names[i].getExpressionString().substring(1)).toString();
                if (s != null && s.length() != 0 && !s.startsWith("#REF!")) {
                    if (!names[i].isBuiltIn()) {
                        this.writer.write("<definedName name=\"" + OOXMLWriter.stripNonAscii(names[i].toString()) + "\"");
                        if (names[i].getItab() > 0) {
                            this.writer.write(" localSheetId=\"" + (names[i].getItab() - 1) + "\">");
                        } else {
                            this.writer.write(">");
                        }
                    } else {
                        this.writer.write("<definedName name=\"" + builtInNames[names[i].getBuiltInType()] + "\"");
                        if (names[i].getItab() > 0) {
                            this.writer.write(" localSheetId=\"" + (names[i].getItab() - 1) + "\">");
                        } else {
                            this.writer.write(">");
                        }
                    }
                    this.writer.write(s);
                    this.writer.write("</definedName>");
                    this.writer.write("\r\n");
                }
                ++i;
            }
            this.writer.write("</definedNames>");
            this.writer.write("\r\n");
        }
        this.writer.write("</workbook>");
        this.writer.write("\r\n");
        if (this.format == 104) {
            this.mainContentList.add(new String[]{"/xl/workbook.xml", "documentTemplateMacroEnabled"});
        } else if (this.format == 102 || OOXMLWriter.hasMacros(bk)) {
            this.mainContentList.add(new String[]{"/xl/workbook.xml", "documentMacroEnabled"});
            this.format = 102;
        } else if (this.format == 103) {
            this.mainContentList.add(new String[]{"/xl/workbook.xml", "documentTemplate"});
        } else {
            this.mainContentList.add(new String[]{"/xl/workbook.xml", "document"});
        }
        this.writeRels(this.wbContentList, "xl/_rels/workbook.xml.rels");
    }

    protected void writeSheetPrefix(WorkSheetHandle sheet, WorkBookHandle bk, int id) throws IOException {
        int last;
        String slx = "xl/worksheets/sheet" + (id + 1) + ".xml";
        this.nextZipEntry(slx);
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        this.writer.write("\r\n");
        this.writer.write("<worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">");
        if (sheet.getMysheet().getSheetPr() != null) {
            this.writer.write(sheet.getMysheet().getSheetPr().getOOXML());
        }
        if ((last = sheet.getLastCol() - 1) == 16383) {
            last = 16383;
        }
        if (last < 0) {
            last = 0;
        }
        String d = String.valueOf(ExcelTools.formatLocation(new int[]{sheet.getFirstRow(), sheet.getFirstCol()})) + ":" + ExcelTools.formatLocation(new int[]{sheet.getLastRow(), last});
        this.writer.write("<dimension ref=\"" + d + "\"/>");
        this.writer.write("\r\n");
        this.writer.write("<sheetViews>");
        this.writer.write("\r\n");
        if (sheet.getMysheet().getSheetView() == null) {
            sheet.getMysheet().setSheetView(new SheetView());
        }
        if (!sheet.getShowGridlines()) {
            sheet.getMysheet().getSheetView().setAttr("showGridLines", "0");
        }
        if (!sheet.getShowSheetHeaders()) {
            sheet.getMysheet().getSheetView().setAttr("showRowColHeaders", "0");
        }
        if (!sheet.getShowZeroValues()) {
            sheet.getMysheet().getSheetView().setAttr("showZeros", "0");
        }
        if (sheet.getSelected()) {
            sheet.getMysheet().getSheetView().setAttr("tabSelected", "1");
        } else {
            sheet.getMysheet().getSheetView().removeSelection();
        }
        if ((double)sheet.getZoom() != 1.0) {
            sheet.getMysheet().getSheetView().setAttr("zoomScale", String.valueOf(new Double(sheet.getZoom() * 100.0f).intValue()));
        }
        sheet.getMysheet().getSheetView().setAttr("workbookViewId", "0");
        this.writer.write(sheet.getMysheet().getSheetView().getOOXML());
        this.writer.write("\r\n");
        this.writer.write("</sheetViews>");
        this.writer.write("\r\n");
        this.writer.write("<sheetFormatPr");
        if (sheet.getMysheet().getDefaultColumnWidth() > -1.0f) {
            this.writer.write(" defaultColWidth=\"" + sheet.getMysheet().getDefaultColumnWidth() + "\"");
        }
        this.writer.write(" defaultRowHeight=\"" + sheet.getMysheet().getDefaultRowHeight() + "\"");
        if (sheet.getMysheet().hasCustomHeight()) {
            this.writer.write(" customHeight=\"1\"");
        }
        if (sheet.getMysheet().hasZeroHeight()) {
            this.writer.write(" zeroHeight=\"1\"");
        }
        if (sheet.getMysheet().hasThickTop()) {
            this.writer.write(" thickTop=\"1\"");
        }
        if (sheet.getMysheet().hasThickBottom()) {
            this.writer.write(" thickBottom=\"1\"");
        }
        this.writer.write("/>");
        this.writer.write("\r\n");
        this.writer.write(this.getColOOXML(bk, sheet).toString());
        this.writer.write("<sheetData>");
        this.writer.write("\r\n");
    }

    protected void writeSheetOOXML(WorkBookHandle bk, WorkSheetHandle sheet, int id) throws IOException {
        ArrayList hyperlinks = new ArrayList();
        this.writeSheetPrefix(sheet, bk, id);
        RowHandle[] rows = sheet.getRows();
        int xd = 0;
        while (xd < rows.length) {
            RowHandle row = rows[xd];
            try {
                this.writeRow(row, hyperlinks);
            }
            catch (Exception e) {
                Logger.logErr("OOXMLWriter.writeSheetOOXML writing rows: " + e.toString());
                e.printStackTrace();
            }
            ++xd;
        }
        this.writer.write("</sheetData>");
        this.writer.write("\r\n");
        if (sheet.getProtected()) {
            String pwd = sheet.getHashedProtectionPassword();
            if (pwd != null) {
                this.writer.write("<sheetProtection password=\"" + sheet.getHashedProtectionPassword() + "\" sheet=\"1\" objects=\"1\" scenarios=\"1\"/>");
            } else {
                this.writer.write("<sheetProtection sheet=\"1\" objects=\"1\" scenarios=\"1\"/>");
            }
            this.writer.write("\r\n");
        }
        if (sheet.getMysheet().getOOAutoFilter() != null) {
            this.writer.write(sheet.getMysheet().getOOAutoFilter().getOOXML());
        }
        this.writeMergedCellRecords(sheet);
        if (sheet.getMysheet().getConditionalFormats() != null) {
            List condfmts = sheet.getMysheet().getConditionalFormats();
            int[] priority = new int[]{1};
            int i = 0;
            while (i < condfmts.size()) {
                String cfmt = ((Condfmt)condfmts.get(i)).getOOXML(bk, priority);
                this.writer.write(cfmt);
                this.writer.write("\r\n");
                ++i;
            }
        }
        if (sheet.hasDataValidations()) {
            this.writer.write(sheet.getMysheet().getDvalRec().getOOXML());
        }
        if (hyperlinks.size() > 0) {
            this.writer.write("<hyperlinks>");
            this.writer.write("\r\n");
            int i = 0;
            while (i < hyperlinks.size()) {
                String[] s = (String[])hyperlinks.get(i);
                if (!s[2].equals("")) {
                    this.writer.write("<hyperlink ref=\"" + s[0] + "\" r:id=\"rId" + (this.shContentList.size() + 1) + "\" display=\"" + s[2] + "\"/>");
                } else {
                    this.writer.write("<hyperlink ref=\"" + s[0] + "\" r:id=\"rId" + (this.shContentList.size() + 1) + "\"/>");
                }
                this.writer.write("\r\n");
                this.shContentList.add(new String[]{s[1], "hyperlink"});
                ++i;
            }
            hyperlinks.clear();
            this.writer.write("</hyperlinks>");
            this.writer.write("\r\n");
        }
        List externalOOXML = sheet.getMysheet().getOOXMLObjects();
        this.writeSheetLevelExternalReferenceOOXML(this.writer, "printerSettings", externalOOXML);
        this.writeDrawingObjects(this.writer, sheet, bk);
        if (this.writeLegacyDrawingObjects(this.writer, sheet, bk)) {
            this.writer.write("<legacyDrawing r:id=\"rId" + this.shContentList.size() + "\"/>\r\n");
        }
        this.writeSheetLevelExternalReferenceOOXML(this.writer, "oleObject", externalOOXML);
        this.writeSheetLevelExternalReferenceOOXML(this.writer, "activeX", externalOOXML);
        this.writeComments(this.writer, sheet, bk);
        this.writer.write("</worksheet>");
        this.writeRels(this.shContentList, "xl/worksheets/_rels/sheet" + (id + 1) + ".xml.rels");
        this.sheetsContentList.addAll(this.shContentList);
        this.shContentList.clear();
    }

    protected void writeMergedCellRecords(WorkSheetHandle sheet) throws IOException {
        List mcs = sheet.getMysheet().getMergedCells();
        if (mcs != null && mcs.size() > 0) {
            StringBuffer mc = new StringBuffer();
            int cnt = 0;
            int i = 0;
            while (i < mcs.size()) {
                CellRange[] cr = ((Mergedcells)mcs.get(i)).getMergedRanges();
                if (cr != null) {
                    int j = 0;
                    while (j < cr.length) {
                        String rng = cr[j].getRange();
                        if (rng != null) {
                            int z = rng.indexOf("!");
                            mc.append("<mergeCell ref=\"" + cr[j].getRange().substring(z + 1) + "\"/>");
                            mc.append("\r\n");
                            ++cnt;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (mc.length() > 0) {
                this.writer.write("<mergeCells count=\"" + cnt + "\">");
                this.writer.write("\r\n");
                this.writer.write(mc.toString());
                this.writer.write("</mergeCells>");
                this.writer.write("\r\n");
            }
        }
    }

    public void writeRow(RowHandle row, ArrayList hyperlinks) throws IOException {
        String h = "";
        if (row.getHeight() != 255) {
            h = " ht=\"" + (double)row.getHeight() / 20.0 + "\" customHeight=\"1\"";
        }
        this.writer.write("<row r=\"" + (row.getRowNumber() + 1) + "\"" + h);
        if (row.getFormatId() > 0 && row.getFormatId() > row.getWorkBook().getWorkBook().getDefaultIxfe()) {
            this.writer.write(" s=\"" + row.getFormatId() + "\" customFormat=\"1\"");
        }
        if (row.getHasAnyThickTopBorder()) {
            this.writer.write(" thickTop=\"1\"");
        }
        if (row.getHasAnyBottomBorder()) {
            this.writer.write(" thickBot=\"1\"");
        }
        if (row.isHidden()) {
            this.writer.write(" hidden=\"1\"");
        }
        if (row.isCollapsed()) {
            this.writer.write(" collapsed=\"1\"");
        }
        if (row.getOutlineLevel() != 0) {
            this.writer.write(" outlineLevel=\"" + row.getOutlineLevel() + "\"");
        }
        this.writer.write(">");
        this.writer.write("\r\n");
        CellHandle[] ch = row.getCells();
        int j = 0;
        while (j < ch.length) {
            int styleId = ch[j].getCell().getIxfe();
            int dataType = ch[j].getCellType();
            if (ch[j].hasHyperlink()) {
                hyperlinks.add(new String[]{ch[j].getCellAddress(), ch[j].getURL(), ch[j].getURLDescription()});
            }
            this.writer.write("<c r=\"" + ch[j].getCellAddress() + "\"");
            if (styleId > 0) {
                this.writer.write(" s=\"" + styleId + "\"");
            }
            switch (dataType) {
                case 0: {
                    String s = ch[j].getStringVal();
                    boolean isErrVal = false;
                    if (s.indexOf("#") == 0) {
                        boolean bl = isErrVal = Collections.binarySearch(Arrays.asList("#DIV/0!", "#N/A", "#NAME?", "#NULL!", "#NUM!", "#REF!", "#VALUE!"), s.trim()) > -1;
                    }
                    if (!isErrVal) {
                        this.writer.write(" t=\"s\">");
                        int v = ((Labelsst)ch[j].getCell()).isst;
                        this.writer.write("<v>" + v + "</v>");
                        break;
                    }
                    this.writer.write(" t=\"e\">");
                    this.writer.write("<v>" + s + "</v>");
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    this.writer.write(" t=\"n\"><v>" + ch[j].getVal() + "</v>");
                    break;
                }
                case 3: {
                    try {
                        FormulaHandle fh = ch[j].getFormulaHandle();
                        this.writer.write(fh.getOOXML());
                    }
                    catch (FormulaNotFoundException e) {
                        Logger.logErr("Error getting formula handle in OOXML Writer");
                    }
                    break;
                }
                case 4: {
                    this.writer.write(" t=\"b\"><v>" + ch[j].getIntVal() + "</v>");
                    break;
                }
                case -1: {
                    this.writer.write(">");
                }
            }
            this.writer.write("</c>");
            this.writer.write("\r\n");
            ++j;
        }
        this.writer.write("</row>");
        this.writer.write("\r\n");
    }

    private StringBuffer getColOOXML(WorkBookHandle bk, WorkSheetHandle sheet) {
        StringBuffer colooxml = new StringBuffer();
        Iterator<Colinfo> iter = sheet.getMysheet().getColinfos().iterator();
        if (iter.hasNext()) {
            colooxml.append("<cols>");
            colooxml.append("\r\n");
            while (iter.hasNext()) {
                try {
                    Colinfo c = iter.next();
                    int collast = c.getColLast() + 1;
                    double w = (double)c.getColWidth() / 256.0;
                    colooxml.append("<col min=\"" + (c.getColFirst() + 1) + "\" max=\"" + collast + "\" width=\"" + (double)c.getColWidth() / 256.0 + "\" customWidth=\"1\"");
                    if (c.isHidden()) {
                        colooxml.append(" hidden=\"1\"");
                    }
                    if (c.getIxfe() > 0) {
                        colooxml.append(" style=\"" + c.getIxfe() + "\"");
                    }
                    colooxml.append("/>");
                    colooxml.append("\r\n");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            colooxml.append("</cols>");
            colooxml.append("\r\n");
        }
        return colooxml;
    }

    private String getImageOOXML(ImageHandle im) {
        String ret = "";
        try {
            ret = im.getOOXML(this.drContentList.size() + 1);
            String ext = im.getType();
            if (ext.equals("undefined")) {
                ext = "emf";
            }
            String imageName = "image" + ++this.imgId + "." + ext;
            this.addDeferredFile(im.getImageBytes(), "xl/media/" + imageName);
            this.drContentList.add(new String[]{"/xl/media/" + imageName, "image"});
        }
        catch (Exception e) {
            Logger.logErr("OOXMLWriter.getImageOOXML: " + e.toString());
            ret = "";
        }
        return ret;
    }

    private void writeDrawingObjects(Writer out, WorkSheetHandle sheet, WorkBookHandle bk) throws IOException {
        StringBuffer drawing = new StringBuffer();
        ImageHandle[] imz = sheet.getImages();
        if (imz.length > 0) {
            int i = 0;
            while (i < imz.length) {
                drawing.append(this.getImageOOXML(imz[i]));
                drawing.append("\r\n");
                ++i;
            }
        }
        List charts = sheet.getMysheet().getCharts();
        int nUserShapes = 0;
        if (charts.size() > 0) {
            int i = 0;
            while (i < charts.size()) {
                try {
                    ArrayList chartEmbeds;
                    Chart c = (Chart)charts.get(i);
                    drawing.append(this.getChartDrawingOOXML(new ChartHandle(c, bk)));
                    drawing.append("\r\n");
                    if (c instanceof OOXMLChart && (chartEmbeds = ((OOXMLChart)charts.get(i)).getChartEmbeds()) != null) {
                        int origDrawingId = this.drawingId;
                        ArrayList chContentList = new ArrayList();
                        int j = 0;
                        while (j < chartEmbeds.size()) {
                            String f;
                            String[] embed = (String[])chartEmbeds.get(j);
                            if (embed[0].equals("userShape")) {
                                this.drawingId += nUserShapes + 1;
                                f = embed[1];
                                ++nUserShapes;
                                this.writeExOOXMLFile(new String[]{embed[0], "xl/drawings/", f}, chContentList);
                            } else if (embed[0].equals("image")) {
                                f = embed[1];
                                this.writeExOOXMLFile(new String[]{embed[0], "xl/media/", f}, chContentList);
                            } else if (embed[0].equals("themeOverride")) {
                                f = embed[1];
                                this.writeExOOXMLFile(new String[]{embed[0], "xl/theme/", f}, chContentList);
                            }
                            ++j;
                        }
                        this.writeRels(chContentList, "xl/charts/_rels/chart" + this.chartId + ".xml.rels");
                        this.sheetsContentList.addAll(chContentList);
                        this.drawingId = origDrawingId;
                    }
                }
                catch (Exception e) {
                    Logger.logErr("OOXMLWriter.writeDrawingObjects failed getting Chart: " + e.toString());
                }
                ++i;
            }
        }
        if (sheet.getMysheet().getOOXMLShapes() != null) {
            HashMap shapes = sheet.getMysheet().getOOXMLShapes();
            for (String key : shapes.keySet()) {
                if (key.equals("vml")) continue;
                Object o = shapes.get(key);
                if (o instanceof TwoCellAnchor) {
                    TwoCellAnchor t = (TwoCellAnchor)o;
                    drawing.append(t.getOOXML());
                    if (t.getEmbedFilename() != null) {
                        String f = t.getEmbedFilename();
                        int rId = this.writeExOOXMLFile(new String[]{"image", "xl/media/", String.valueOf(this.externalDir) + f}, this.drContentList);
                        t.setEmbed("rId" + rId);
                    }
                } else if (o instanceof OneCellAnchor) {
                    OneCellAnchor oca = (OneCellAnchor)o;
                    drawing.append(oca.getOOXML());
                }
                drawing.append("\r\n");
            }
        }
        if (drawing.length() > 0) {
            out.write("<drawing r:id=\"rId" + (this.shContentList.size() + 1) + "\"/>");
            out.write("\r\n");
            StringBuffer drawingml = new StringBuffer();
            drawingml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            drawingml.append("\r\n");
            drawingml.append("<xdr:wsDr xmlns:xdr=\"http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing\" xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\">");
            drawingml.append("\r\n");
            drawingml.append(drawing);
            drawingml.append("</xdr:wsDr>");
            drawingml.append("\r\n");
            this.addDeferredFile(drawingml, "xl/drawings/drawing" + ++this.drawingId + ".xml");
            this.shContentList.add(new String[]{"/xl/drawings/drawing" + this.drawingId + ".xml", "drawing"});
            this.writeRels(this.drContentList, "xl/drawings/_rels/drawing" + this.drawingId + ".xml.rels");
            this.sheetsContentList.addAll(this.drContentList);
            this.drContentList.clear();
            this.drawingId += nUserShapes;
        }
    }

    private String getChartDrawingOOXML(ChartHandle ch) {
        String ret = "";
        try {
            StringBuffer chartml = new StringBuffer();
            chartml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            chartml.append("\r\n");
            chartml.append("<c:chartSpace xmlns:c=\"http://schemas.openxmlformats.org/drawingml/2006/chart\" xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">");
            chartml.append("\r\n");
            chartml.append(ch.getOOXML(this.drContentList.size() + 1));
            chartml.append("</c:chartSpace>");
            chartml.append("\r\n");
            ret = ch.getChartDrawingOOXML(this.drContentList.size() + 1);
            this.addDeferredFile(chartml, "xl/charts/chart" + ++this.chartId + ".xml");
            this.drContentList.add(new String[]{"/xl/charts/chart" + this.chartId + ".xml", "chart"});
        }
        catch (Exception e) {
            Logger.logErr("er: " + e.toString());
            ret = "";
        }
        return ret;
    }

    private void writeComments(Writer out, WorkSheetHandle sheet, WorkBookHandle bk) throws IOException {
        CommentHandle[] nh = sheet.getCommentHandles();
        if (nh == null || nh.length == 0) {
            return;
        }
        StringBuffer comments = new StringBuffer();
        comments.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        comments.append("<comments xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\">\r\n<authors>");
        ArrayList<String> authors = new ArrayList<String>();
        int i = 0;
        while (i < nh.length) {
            if (!authors.contains(nh[i].getAuthor())) {
                comments.append("\r\n<author>" + OOXMLAdapter.stripNonAscii(nh[i].getAuthor()) + "</author>");
                authors.add(nh[i].getAuthor());
            }
            ++i;
        }
        comments.append("\r\n</authors>\r\n<commentList>");
        i = 0;
        while (i < nh.length) {
            comments.append("\r\n" + nh[i].getOOXML(authors.indexOf(nh[i].getAuthor())));
            ++i;
        }
        comments.append("\r\n</commentList>\r\n</comments>");
        this.addDeferredFile(comments, "xl/comments" + ++this.commentsId + ".xml");
        this.shContentList.add(new String[]{"/xl/comments" + this.commentsId + ".xml", "comments"});
    }

    private boolean writeLegacyDrawingObjects(Writer out, WorkSheetHandle sheet, WorkBookHandle bk) throws IOException {
        CommentHandle[] nh;
        String[] embeds = null;
        StringBuffer vml = null;
        if (sheet.getMysheet().getOOXMLShapes() != null) {
            if (sheet.getMysheet().getOOXMLShapes().get("vml") instanceof Object[]) {
                Object[] o = (Object[])sheet.getMysheet().getOOXMLShapes().get("vml");
                vml = (StringBuffer)o[0];
                embeds = (String[])o[1];
            } else {
                vml = (StringBuffer)sheet.getMysheet().getOOXMLShapes().get("vml");
            }
        }
        if ((nh = sheet.getCommentHandles()) != null && nh.length > 0) {
            if (vml == null) {
                vml = new StringBuffer();
                vml.append("<o:shapelayout v:ext=\"edit\"><o:idmap v:ext=\"edit\" data=\"1\"/></o:shapelayout>");
            }
            vml.append("<v:shapetype id=\"_x0000_t202\" coordsize=\"21600,21600\" o:spt=\"202\" path=\"m,l,21600r21600,l21600,xe\"><v:stroke joinstyle=\"miter\"/><v:path gradientshapeok=\"t\" o:connecttype=\"rect\"/></v:shapetype>");
            int i = 0;
            while (i < nh.length) {
                boolean hidden = nh[i].getIsHidden();
                int row = nh[i].getRowNum();
                int col = nh[i].getColNum();
                short[] bounds = nh[i].getTextBoxBounds();
                int spid = nh[i].getInternalNoteRec().getSPID();
                vml.append("<v:shape id=\"_x0000_s" + spid + "\"" + " type=\"#_x0000_t202\"" + " style=\"position:absolute;" + "margin-left:203.25pt;" + "margin-top:37.5pt;" + "width:96pt;" + "height:55.5pt;" + "z-index:1;" + "visibility:" + (hidden ? "hidden" : "visible") + "\"" + " fillcolor=\"#ffffe1\"" + " o:insetmode=\"auto\">");
                vml.append("<v:fill color2=\"#ffffe1\"/> <v:shadow on=\"t\" color=\"black\" obscured=\"t\"/> <v:path o:connecttype=\"none\"/><v:textbox style=\"mso-direction-alt:auto\"><div style=\"text-align:left\"/> </v:textbox>");
                vml.append("<x:ClientData ObjectType=\"Note\"><x:MoveWithCells/><x:SizeWithCells/>");
                vml.append("<x:Anchor>");
                int j = 0;
                while (j < bounds.length) {
                    vml.append(String.valueOf(bounds[j]) + (j < bounds.length - 1 ? "," : ""));
                    ++j;
                }
                vml.append("</x:Anchor>");
                vml.append("<x:AutoFill>False</x:AutoFill><x:Row>" + row + "</x:Row>" + "<x:Column>" + col + "</x:Column>");
                if (!hidden) {
                    vml.append("<x:Visible/>");
                }
                vml.append("</x:ClientData></v:shape>");
                ++i;
            }
        }
        if (vml != null && vml.length() > 0) {
            vml.insert(0, "<xml xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:x=\"urn:schemas-microsoft-com:office:excel\">");
            vml.append("</xml>");
            this.addDeferredFile(vml, "xl/drawings/vmlDrawing" + ++this.vmlId + ".vml");
            this.shContentList.add(new String[]{"/xl/drawings/vmlDrawing" + this.vmlId + ".vml", "vmldrawing"});
            if (embeds != null) {
                ArrayList<String[]> vmlContentList = new ArrayList<String[]>();
                int i = 0;
                while (i < embeds.length) {
                    String pp = embeds[i].trim();
                    String typ = pp.substring(0, pp.indexOf("/"));
                    pp = pp.substring(pp.indexOf("/") + 1);
                    int z = pp.lastIndexOf("/") + 1;
                    String pth = pp.substring(0, z);
                    pp = pp.substring(z);
                    String ff = this.getExOOXMLFileName(pp);
                    this.deferredFiles.put(String.valueOf(pth) + ff, String.valueOf(this.externalDir) + pp);
                    vmlContentList.add(new String[]{"/" + pth + ff, typ});
                    ++i;
                }
                this.writeRels(vmlContentList, "xl/drawings/_rels/vmlDrawing" + this.vmlId + ".vml.rels");
            }
            return true;
        }
        return false;
    }
}

