/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.ChartHandle;
import com.extentech.ExtenXLS.Document;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.OOXMLConstants;
import com.extentech.formats.XLS.OOXMLReader;
import com.extentech.formats.XML.UnicodeInputStream;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import com.extentech.toolkit.TempFileManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class OOXMLAdapter
implements OOXMLConstants {
    protected boolean DEBUG = false;
    ZipOutputStream zip;
    Writer writer;
    Map deferredFiles = new HashMap();
    ArrayList mainContentList = new ArrayList();
    ArrayList wbContentList = new ArrayList();
    ArrayList drContentList = new ArrayList();
    ArrayList shContentList = new ArrayList();
    ArrayList sheetsContentList = new ArrayList();
    String externalDir = "";
    int drawingId = 0;
    int vmlId = 0;
    int commentsId = 0;
    int activeXId = 0;
    int activeXBinaryId = 0;
    int printerSettingsId = 0;
    int oleObjectsId = 0;
    int chartId = 0;
    int imgId = 0;
    static final double rowHtFactor = 20.0;
    static final double colWFactor = 256.0;
    int EX_TYPE = 0;
    int EX_PATH = 1;
    int EX_FNAME = 2;
    int EX_EXTRAINFO = 4;
    int EX_EMBEDINFO = 5;
    int format = 101;
    static String inputEncoding = "UTF-8";

    public void setFormat(int format) {
        this.format = format;
    }

    public int getFormat() {
        return this.format;
    }

    public static final boolean parseBoolean(String value) {
        String trimmed = value.trim();
        if (trimmed.equals("true") || trimmed.equals("1")) {
            return true;
        }
        if (trimmed.equals("false") || trimmed.equals("0")) {
            return false;
        }
        throw new IllegalArgumentException("'" + value + "' is not a valid boolean value");
    }

    public static String getStandaloneChartDrawingOOXML(ChartHandle ch) {
        String ret = "";
        try {
            StringBuffer chartml = new StringBuffer();
            chartml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            chartml.append("\r\n");
            chartml.append("<c:chartSpace xmlns:c=\"http://schemas.openxmlformats.org/drawingml/2006/chart\" xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">");
            chartml.append("\r\n");
            chartml.append(ch.getOOXML(1));
            chartml.append("</c:chartSpace>");
            chartml.append("\r\n");
            return chartml.toString();
        }
        catch (Exception e) {
            Logger.logErr("OOXMLAdapter.getStandaloneChartDrawingOOXML: " + e.toString());
            ret = "";
            return ret;
        }
    }

    protected String getExOOXMLFileName(String f) {
        String fname = f.substring(f.lastIndexOf("/") + 1);
        String ext = fname.substring(fname.lastIndexOf("."));
        String root = fname.substring(0, fname.indexOf("."));
        int z = root.length() - 1;
        while (Character.isDigit(root.charAt(z))) {
            --z;
        }
        if ((root = root.substring(0, z + 1)).equalsIgnoreCase("image")) {
            fname = String.valueOf(root) + ++this.imgId + ext;
        } else if (root.equalsIgnoreCase("oleObject")) {
            fname = String.valueOf(root) + ++this.oleObjectsId + ext;
        } else if (root.equalsIgnoreCase("activeX")) {
            if (ext.toLowerCase().equals(".xml")) {
                fname = String.valueOf(root) + ++this.activeXId + ext;
            } else if (ext.toLowerCase().equals(".bin")) {
                fname = String.valueOf(root) + ++this.activeXBinaryId + ext;
            }
        } else if (root.equalsIgnoreCase("printerSettings")) {
            fname = String.valueOf(root) + ++this.printerSettingsId + ext;
        } else if (root.equalsIgnoreCase("drawing")) {
            fname = String.valueOf(root) + ++this.drawingId + ext;
        } else if (!(root.equalsIgnoreCase("app") || root.equalsIgnoreCase("core") || root.equalsIgnoreCase("theme") || root.equalsIgnoreCase("themeOverride") || root.equalsIgnoreCase("app") || root.equalsIgnoreCase("custom") || root.equalsIgnoreCase("connections") || root.equalsIgnoreCase("externalLink") || root.equalsIgnoreCase("calcChain") || root.equalsIgnoreCase("styles") || root.equalsIgnoreCase("sharedStrings") || root.equalsIgnoreCase("vbaProject"))) {
            Logger.logErr("Unknown External Type: " + root);
        }
        return fname;
    }

    protected void addDeferredFile(StringBuffer sb, String fn) {
        try {
            File fx = this.addDeferredFile(fn);
            FileOutputStream fos = new FileOutputStream(fx);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, inputEncoding);
            OOXMLAdapter.writeSBToStreamEfficiently(sb, out);
            ((Writer)out).close();
        }
        catch (Exception e) {
            Logger.logErr("OOXMLAdapter addDeferredFile failed.", e);
        }
    }

    public static void writeSBToStreamEfficiently(StringBuffer aSB, Writer ous) throws IOException {
        int aLength = aSB.length();
        int aChunk = 1024;
        char[] aChars = new char[1024];
        int aPosStart = 0;
        while (aPosStart < aLength) {
            int aByte;
            int aPosEnd = Math.min(aPosStart + 1024, aLength);
            aSB.getChars(aPosStart, aPosEnd, aChars, 0);
            CharArrayReader aCARead = new CharArrayReader(aChars);
            int i = 0;
            while ((aByte = aCARead.read()) != -1 && i++ < aPosEnd - aPosStart) {
                ous.write(aByte);
            }
            aPosStart += 1024;
        }
    }

    protected File addDeferredFile(String name) throws IOException {
        File file = TempFileManager.createTempFile("OOXMLOutput_", ".tmp");
        this.deferredFiles.put(name.toString(), file.getAbsolutePath());
        return file;
    }

    protected void addDeferredFile(byte[] b, String fn) throws IOException {
        File fx = this.addDeferredFile(fn);
        FileOutputStream fos = new FileOutputStream(fx);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        bos.write(b);
        bos.close();
    }

    private boolean hasObject(WorkBookHandle bk, String type) {
        List externalOOXML = bk.getWorkBook().getOOXMLObjects();
        int i = 0;
        while (i < externalOOXML.size()) {
            String[] s = (String[])externalOOXML.get(i);
            if (s != null && s.length == 3 && s[0].equalsIgnoreCase(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasMacros(Document bk) {
        if (bk instanceof WorkBookHandle) {
            List externalOOXML = ((WorkBookHandle)bk).getWorkBook().getOOXMLObjects();
            int i = 0;
            while (i < externalOOXML.size()) {
                String[] s = (String[])externalOOXML.get(i);
                if (s != null && s.length == 3 && (s[0].equalsIgnoreCase("vba") || s[0].equalsIgnoreCase("macro"))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void writeFileToZIP(String f2write, String fname) throws IOException {
        this.nextZipEntry(fname);
        FileInputStream fis = new FileInputStream(f2write);
        BufferedInputStream bis = new BufferedInputStream(fis);
        int i = bis.read();
        while (i != -1) {
            this.zip.write(i);
            i = bis.read();
        }
        bis.close();
    }

    protected void nextZipEntry(String name) throws IOException {
        try {
            this.writer.flush();
        }
        catch (Exception e) {
            Logger.logErr("Flush failing on zip entry, likely due to streaming first sheet " + e);
        }
        this.zip.putNextEntry(new ZipEntry(name));
    }

    protected String getContentType(String type) {
        int i = 0;
        while (i < contentTypes.length) {
            if (contentTypes[i][0].equalsIgnoreCase(type)) {
                return contentTypes[i][1];
            }
            ++i;
        }
        return "UNKNOWN TYPE " + type;
    }

    protected String getRelationshipType(String type) {
        int i = 0;
        while (i < relsContentTypes.length) {
            if (relsContentTypes[i][0].equalsIgnoreCase(type)) {
                return relsContentTypes[i][1];
            }
            ++i;
        }
        return "UNKNOWN TYPE " + type;
    }

    protected static String getRelationshipTypeAbbrev(String type) {
        int i = 0;
        while (i < relsContentTypes.length) {
            if (relsContentTypes[i][1].equalsIgnoreCase(type)) {
                return relsContentTypes[i][0];
            }
            ++i;
        }
        return "UNKNOWN TYPE " + type;
    }

    private void getZipEntries(ZipFile zf) {
        try {
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                Logger.logInfo(ze.getName());
            }
        }
        catch (Exception e) {
            Logger.logErr("getZipEntries: " + e.toString());
        }
    }

    public static StringBuffer stripNonAscii(String s) {
        StringBuffer out = new StringBuffer();
        if (s == null) {
            return out;
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            char charCode = c;
            if (charCode == '\t' || charCode == '\n' || charCode == '\r' || charCode >= ' ' && charCode <= '\ud7ff' || charCode >= '\ue000' && charCode <= '\ufffd' || charCode >= '\u10000' && charCode <= '\u10ffff') {
                if (charCode == '&') {
                    out.append("&amp;");
                } else if (charCode == '\"') {
                    out.append("&quot;");
                } else if (charCode == '<') {
                    out.append("&lt;");
                } else if (charCode == '>') {
                    out.append("&gt;");
                } else if (charCode == '\'') {
                    out.append("&apos;");
                } else {
                    out.append(c);
                }
            }
            ++i;
        }
        return out;
    }

    public static StringBuffer stripNonAsciiRetainQuote(String s) {
        StringBuffer out = new StringBuffer();
        if (s == null) {
            return out;
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            char charCode = c;
            if (charCode >= ' ' && charCode <= '~') {
                if (charCode == '&') {
                    out.append("&amp;");
                } else if (charCode == '<') {
                    out.append("&lt;");
                } else if (charCode == '>') {
                    out.append("&gt;");
                } else {
                    out.append(c);
                }
            } else {
                out.append(c);
            }
            ++i;
        }
        return out;
    }

    protected static InputStream wrapInputStream(InputStream in) {
        UnicodeInputStream uin = new UnicodeInputStream(in, "UTF-8");
        return uin;
    }

    protected static ZipEntry getEntry(ZipFile f, String name) {
        return f.getEntry(name);
    }

    protected static ArrayList parseRels(InputStream ii) {
        ArrayList<String[]> contentList = new ArrayList<String[]>();
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput(new InputStreamReader(ii));
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                try {
                    String tnm;
                    if (eventType == 2 && (tnm = xpp.getName()) != null && tnm.equals("Relationship")) {
                        String type = "";
                        String target = "";
                        String rId = "";
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String nm = xpp.getAttributeName(i);
                            String v = xpp.getAttributeValue(i);
                            if (nm.equalsIgnoreCase("Type")) {
                                type = OOXMLAdapter.getRelationshipTypeAbbrev(v);
                            } else if (nm.equalsIgnoreCase("Target")) {
                                target = v;
                            } else if (nm.equalsIgnoreCase("id")) {
                                rId = v;
                            }
                            ++i;
                        }
                        if (target.indexOf("comments") == -1) {
                            contentList.add(new String[]{type, target, rId});
                        } else {
                            contentList.add(0, new String[]{type, target, rId});
                        }
                    }
                }
                catch (Exception ea) {
                    Logger.logErr("XML Exception in OOXMLAdapter.parseRels. Input file is out of spec.", ea);
                }
                eventType = xpp.next();
            }
        }
        catch (XmlPullParserException ex) {
            Logger.logErr("XML Exception in OOXMLAdapter.parseRels. Input file is out of spec.", ex);
        }
        catch (Exception e) {
            Logger.logErr("OOXMLAdapter.parseRels. " + e.toString());
        }
        return contentList;
    }

    public static String getNextText(XmlPullParser xpp) throws IOException, XmlPullParserException {
        int eventType = xpp.next();
        String ret = "";
        while (eventType != 1 && eventType != 3 && eventType != 2 && eventType != 4) {
            eventType = xpp.next();
        }
        if (eventType == 4) {
            ret = xpp.getText();
        }
        try {
            return new String(ret.getBytes(), inputEncoding);
        }
        catch (Exception exception) {
            return ret;
        }
    }

    protected void reorderWbContentList(ArrayList wbContentList) {
        String[] wb;
        int j = 0;
        while (j < wbContentList.size()) {
            wb = (String[])wbContentList.get(j);
            if (!wb[0].equals("sheet")) {
                wbContentList.remove(j);
                wbContentList.add(0, wb);
            }
            ++j;
        }
        j = 0;
        while (j < wbContentList.size()) {
            wb = (String[])wbContentList.get(j);
            if (wb[0].equals("theme")) {
                wbContentList.remove(j);
                wbContentList.add(0, wb);
                break;
            }
            ++j;
        }
    }

    protected static String getFilename(ArrayList contentList, String rId) {
        int j = 0;
        while (j < contentList.size()) {
            String[] s = (String[])contentList.get(j);
            if (s[2].equals(rId)) {
                return s[1];
            }
            ++j;
        }
        return null;
    }

    protected Stack cloneStack(Stack origStack) {
        Stack s = new Stack();
        int i = 0;
        while (i < origStack.size()) {
            s.push(origStack.elementAt(i));
            ++i;
        }
        return s;
    }

    public static boolean deleteDir(File f) {
        if (f.isDirectory()) {
            String[] children = f.list();
            int i = 0;
            while (i < children.length) {
                boolean bl = OOXMLAdapter.deleteDir(new File(f, children[i]));
                ++i;
            }
        }
        f.deleteOnExit();
        return f.delete();
    }

    public static String getTempDir(String f) throws IOException {
        String s = System.getProperty("java.io.tmpdir");
        if (!s.endsWith("/") && !s.endsWith("\\")) {
            s = String.valueOf(s) + "/";
        }
        f = StringTool.stripPath(f);
        s = String.valueOf(s) + "extentech/";
        s = f.indexOf(46) > 0 ? String.valueOf(s) + f.substring(0, f.indexOf(46)) + "/" : String.valueOf(s) + f + "/";
        return s;
    }

    protected static void sortSheets(ArrayList cl) throws Exception {
        TreeMap<Integer, String[]> sorted = new TreeMap<Integer, String[]>();
        for (String[] c : cl) {
            String shtnm = c[1];
            int st = shtnm.indexOf("worksheets/sheet");
            if (st <= -1) continue;
            shtnm = shtnm.substring(st += 16);
            shtnm = shtnm.substring(0, shtnm.toLowerCase().indexOf(".xml"));
            try {
                int ti = Integer.parseInt(shtnm);
                sorted.put(ti, c);
            }
            catch (Exception e) {
                Logger.logErr("Could not sort sheets", e);
                return;
            }
        }
        Iterator its = cl.iterator();
        Iterator sort = sorted.values().iterator();
        int clpos = -1;
        while (sort.hasNext()) {
            String[] c = (String[])sort.next();
            boolean found = false;
            while (its.hasNext() && !found) {
                ++clpos;
                String[] cx = (String[])its.next();
                if (!cx[0].equals("sheet")) continue;
                cl.set(clpos, c);
                found = true;
            }
        }
    }

    public static void refreshPassThroughFiles(WorkBookHandle wbh) {
        try {
            ZipFile sourceZip = new ZipFile(wbh.getFile());
            OOXMLReader.refreshExternalFiles(sourceZip, OOXMLAdapter.getTempDir(wbh.getWorkBook().getFactory().getFileName()));
            wbh.setFile(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

