/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.XLSCellRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;

public final class NumberRec
extends XLSCellRecord {
    private static final long serialVersionUID = 7489308348300854345L;
    double fpnum;

    public NumberRec(int val) {
        this.setOpcode((short)515);
        this.setLength(14);
        this.setData(new byte[14]);
        this.originalsize = 14;
        this.setNumberVal(val);
        this.isIntNumber = true;
        this.isFPNumber = false;
    }

    public NumberRec(long val) {
        this((double)val);
    }

    public NumberRec(double val) {
        this.setOpcode((short)515);
        this.setLength(14);
        this.setData(new byte[14]);
        this.originalsize = 14;
        this.setNumberVal(val);
    }

    @Override
    public void init() {
        String d;
        super.init();
        boolean l = false;
        boolean m = false;
        super.initRowCol();
        short s = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.ixfe = s;
        this.fpnum = ByteTools.eightBytetoLEDouble(this.getBytesAt(6, 8));
        this.setIsValueForCell(true);
        if (this.DEBUGLEVEL > 5) {
            Logger.logInfo("NumberRec: " + this.getCellAddress() + ":" + this.getStringVal());
        }
        if ((d = String.valueOf(this.fpnum)).length() > 12) {
            this.isDoubleNumber = true;
            this.isFPNumber = true;
            this.isIntNumber = false;
        } else if (d.substring(d.length() - 2, d.length()).equals(".0") && this.fpnum < 2.147483647E9) {
            this.isIntNumber = true;
            this.isFPNumber = false;
            this.isDoubleNumber = false;
        } else if (this.fpnum < 3.4028234663852886E38 || this.fpnum * -1.0 < 3.4028234663852886E38) {
            this.isFPNumber = true;
            this.isIntNumber = false;
        } else {
            this.isDoubleNumber = true;
            this.isIntNumber = false;
        }
    }

    @Override
    public float getFloatVal() {
        return (float)this.fpnum;
    }

    @Override
    public int getIntVal() {
        if (this.fpnum > 2.147483647E9) {
            throw new NumberFormatException("Cell value is larger than the maximum java signed int size");
        }
        if (this.fpnum < -2.147483648E9) {
            throw new NumberFormatException("Cell value is smaller than the minimum java signed int size");
        }
        return (int)this.fpnum;
    }

    @Override
    public double getDblVal() {
        return this.fpnum;
    }

    @Override
    public String getStringVal() {
        if (this.isIntNumber) {
            return String.valueOf((int)this.fpnum);
        }
        return ExcelTools.getNumberAsString(this.fpnum);
    }

    @Override
    public void setDoubleVal(double v) {
        this.setNumberVal(v);
    }

    @Override
    public void setFloatVal(float d) {
        this.setNumberVal(new Double(new Float(d).toString()));
    }

    public NumberRec() {
    }

    @Override
    public void setIntVal(int i) {
        double d = i;
        this.setNumberVal(d);
    }

    void setNumberVal(long d) {
        byte[] rkdata = this.getData();
        byte[] b = ByteTools.toBEByteArray(d);
        System.arraycopy(b, 0, rkdata, 6, 8);
        this.setData(rkdata);
        this.init();
    }

    void setNumberVal(double d) {
        byte[] rkdata = this.getData();
        byte[] b = ByteTools.toBEByteArray(d);
        System.arraycopy(b, 0, rkdata, 6, 8);
        this.setData(rkdata);
        this.init();
    }
}

