/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.Sheet;
import com.extentech.formats.XLS.Unicodestring;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;

public final class Headerrec
extends XLSRecord {
    private static final long serialVersionUID = -8302043395108298631L;
    int cch = -1;
    String rgch = "";
    boolean DEBUG = false;

    @Override
    public void setSheet(Sheet bs) {
        super.setSheet(bs);
        bs.setHeader(this);
    }

    public void setHeaderText(String t) {
        try {
            if (ByteTools.isUnicode(t)) {
                byte[] bts = t.getBytes("UTF-16LE");
                this.cch = bts.length / 2;
                byte[] newbytes = new byte[this.cch + 3];
                byte[] cchx = ByteTools.shortToLEBytes((short)this.cch);
                newbytes[0] = cchx[0];
                newbytes[1] = cchx[1];
                newbytes[2] = 1;
                System.arraycopy(bts, 0, newbytes, 3, bts.length);
                this.setData(newbytes);
            } else {
                byte[] bts = t.getBytes("ISO-8859-1");
                this.cch = bts.length;
                byte[] newbytes = new byte[this.cch + 3];
                byte[] cchx = ByteTools.shortToLEBytes((short)this.cch);
                newbytes[0] = cchx[0];
                newbytes[1] = cchx[1];
                newbytes[2] = 0;
                System.arraycopy(bts, 0, newbytes, 3, bts.length);
                this.setData(newbytes);
            }
        }
        catch (Exception e) {
            Logger.logInfo("setting Footer text failed: " + e);
        }
        this.rgch = t;
    }

    public String getHeaderText() {
        return this.rgch;
    }

    @Override
    public void init() {
        super.init();
        byte[] b = this.getData();
        if (this.getLength() > 4) {
            byte cch = this.getByteAt(0);
            byte[] namebytes = this.getBytesAt(0, this.getLength() - 4);
            Unicodestring fstr = new Unicodestring();
            fstr.init(namebytes, false);
            this.rgch = fstr.toString();
            if (this.DEBUGLEVEL > 50) {
                Logger.logInfo("Header text: " + this.getHeaderText());
            }
        }
    }
}

