/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.Sst;
import com.extentech.formats.XLS.Unicodestring;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.StringTool;

public final class Format
extends XLSRecord {
    private static final long serialVersionUID = 1199947552103220748L;
    private short ifmt = (short)-1;
    private String pattern;
    private Unicodestring ustring;

    public Format() {
        this.setOpcode((short)1054);
    }

    public Format(WorkBook book, String pattern) {
        this(book, -1, pattern);
    }

    public Format(WorkBook book, short id, String pattern) {
        this();
        byte[] idbytes;
        this.setWorkBook(book);
        this.pattern = pattern;
        this.ustring = Sst.createUnicodeString(pattern, null, WorkBook.STRING_ENCODING_AUTO);
        if (id > 0) {
            this.ifmt = id;
            idbytes = ByteTools.shortToLEBytes(id);
        } else {
            idbytes = new byte[2];
        }
        this.setData(ByteTools.append(this.ustring.read(), idbytes));
        book.insertFormat(this);
    }

    @Override
    public void init() {
        if (this.pattern != null) {
            throw new IllegalStateException("the record has already been parsed");
        }
        super.init();
        this.ifmt = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.ustring = new Unicodestring();
        this.ustring.init(this.getBytesAt(2, this.getLength() - 2), false);
        this.pattern = this.ustring.toString();
        this.pattern = StringTool.replaceText(this.pattern, "\"", "", 0);
        this.pattern = StringTool.replaceText(this.pattern, "\\", "", 0);
        this.getWorkBook().addFormat(this);
    }

    @Override
    public void setWorkBook(WorkBook book) {
        super.setWorkBook(book);
        if (this.ifmt != -1) {
            book.addFormat(this);
        }
    }

    public void setIfmt(short id) {
        this.ifmt = id;
        System.arraycopy(ByteTools.shortToLEBytes(this.ifmt), 0, this.getData(), 0, 2);
    }

    public String getFormat() {
        return this.pattern;
    }

    public short getIfmt() {
        return this.ifmt;
    }

    @Override
    public String toString() {
        return this.getFormat();
    }
}

