/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.Supbook;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.WorkSheetNotFoundException;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.IxtiListener;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.Logger;
import java.io.Serializable;
import java.util.Iterator;

public final class Externsheet
extends XLSRecord {
    private static final long serialVersionUID = -4460757130836967839L;
    short cXTI = 0;
    CompatibleVector rgs = new CompatibleVector();

    @Override
    public void preStream() {
        this.update();
    }

    @Override
    public void setWorkBook(WorkBook bk) {
        super.setWorkBook(bk);
        Iterator it = this.rgs.iterator();
        while (it.hasNext()) {
            ((rgxti)it.next()).setWorkBook(bk);
        }
    }

    public void addPtgListener(IxtiListener p) throws WorkSheetNotFoundException {
        short ix = p.getIxti();
        if (this.rgs.size() > ix) {
            rgxti rg = (rgxti)this.rgs.get(ix);
            rg.addListener(p);
        } else {
            rgxti rg = new rgxti();
            rg.setWorkBook(this.wkbook);
            rg.setSheet1(ix);
            rg.setSheet2(ix);
            this.rgs.add(rg);
            rg.addListener(p);
            this.update();
        }
    }

    public Boundsheet[] getBoundSheets(int cLoc) {
        if (this.rgs.size() == 0) {
            return null;
        }
        if (cLoc > this.rgs.size() - 1) {
            cLoc = this.rgs.size() - 1;
        }
        rgxti rg = (rgxti)this.rgs.get(cLoc);
        int first = rg.sheet1num;
        short last = rg.sheet2num;
        if (first == -2) {
            return null;
        }
        if (first == -1) {
            return null;
        }
        int numshts = (last = (short)(last + 1)) - first;
        if (numshts < 1) {
            numshts = 1;
        }
        Boundsheet[] bs = new Boundsheet[numshts];
        int p = 0;
        int t = first;
        while (t < last) {
            block8: {
                try {
                    bs[p++] = this.wkbook.getWorkSheetByNumber(t);
                }
                catch (WorkSheetNotFoundException e) {
                    if (this.DEBUGLEVEL <= 1 || t == 65535 || rg.bIsExternal) break block8;
                    Logger.logWarn("Attempt to access Externsheet reference for sheet failed: " + e);
                }
            }
            ++t;
        }
        return bs;
    }

    public String[] getBoundSheetNames(int cLoc) {
        if (this.rgs.size() == 0) {
            return null;
        }
        if (cLoc > this.rgs.size() - 1) {
            cLoc = this.rgs.size() - 1;
        }
        rgxti rg = (rgxti)this.rgs.get(cLoc);
        int first = rg.sheet1num;
        short last = rg.sheet2num;
        if (first == -2) {
            return new String[]{"AddIn"};
        }
        if (first == -1) {
            return new String[]{"#REF!"};
        }
        int numshts = (last = (short)(last + 1)) - first;
        if (numshts < 1) {
            numshts = 1;
        }
        if (first < 0) {
            first = 1;
        }
        String[] sheets = new String[numshts];
        if (first == last) {
            return new String[]{"#REF!"};
        }
        int p = 0;
        int t = first;
        while (t < last) {
            block10: {
                try {
                    sheets[p++] = rg.getSheetName(t);
                }
                catch (WorkSheetNotFoundException we) {
                    if (this.DEBUGLEVEL <= 1) break block10;
                    Logger.logWarn("Attempt to access Externsheet reference for sheet failed: " + we);
                }
            }
            ++t;
        }
        return sheets;
    }

    public boolean getIsExternalLink(int loc) {
        if (this.rgs.size() == 0) {
            return false;
        }
        rgxti rg = (rgxti)this.rgs.get(loc);
        return rg.getIsExternal();
    }

    public int getcXTI() {
        return this.cXTI;
    }

    @Override
    public void init() {
        super.init();
        this.cXTI = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        int pos = 2;
        int t = 0;
        while (t < this.cXTI) {
            block5: {
                try {
                    byte[] bts = this.getBytesAt(pos, 6);
                    rgxti rg = new rgxti(bts);
                    this.rgs.add(rg);
                    if (this.wkbook != null) {
                        rg.setWorkBook(this.wkbook);
                    }
                }
                catch (Exception e) {
                    if (this.DEBUGLEVEL <= 10) break block5;
                    Logger.logWarn("init of Externsheet record failed: " + e);
                }
            }
            pos += 6;
            ++t;
        }
        if (this.DEBUGLEVEL > 10) {
            Logger.logInfo("Done Creating Externsheet");
        }
    }

    void update() {
        int blen = this.rgs.size() * 6;
        byte[] newbytes = new byte[blen += 2];
        this.cXTI = (short)(this.rgs.size() - 1);
        byte[] cx = ByteTools.shortToLEBytes((short)this.rgs.size());
        System.arraycopy(cx, 0, newbytes, 0, 2);
        int pos = 2;
        Iterator it = this.rgs.iterator();
        while (it.hasNext()) {
            byte[] btx = ((rgxti)it.next()).getBytes();
            System.arraycopy(btx, 0, newbytes, pos, 6);
            pos += 6;
        }
        this.setData(newbytes);
    }

    void removeSheet(int sheetnum) throws WorkSheetNotFoundException {
        if (this.DEBUGLEVEL > 10) {
            Logger.logInfo("Removing Sheet from Externsheet");
        }
        for (rgxti rg : this.rgs) {
            short first = rg.sheet1num;
            short last = rg.sheet2num;
            if (sheetnum == first && sheetnum == last) {
                rg.setSheet1(65535);
                rg.setSheet2(65535);
                this.cXTI = (short)(this.cXTI - 1);
                continue;
            }
            if (sheetnum >= first && sheetnum <= last) {
                rg.setSheet2(rg.getSheet2() - 1);
                continue;
            }
            if (sheetnum > first) continue;
            rg.setSheet1(rg.getSheet1() - 1);
            rg.setSheet2(rg.getSheet2() - 1);
        }
        this.update();
    }

    void addSheet(int sheetnum) throws WorkSheetNotFoundException {
        this.addSheet(sheetnum, sheetnum);
    }

    private byte getAddInIndex(Supbook[] sb) {
        int i = 0;
        while (i < sb.length) {
            if (sb[i].isAddInRecord()) {
                return (byte)i;
            }
            ++i;
        }
        return -1;
    }

    private byte getGlobalSupBookIndex(Supbook[] sb) {
        int i = 0;
        while (i < sb.length) {
            if (sb[i].isGlobalRecord()) {
                return (byte)i;
            }
            ++i;
        }
        return -1;
    }

    void addSheet(int firstSheet, int lastSheet) throws WorkSheetNotFoundException {
        if (this.DEBUGLEVEL > 10) {
            Logger.logInfo("Adding new Sheet to Externsheet");
        }
        byte[] bts = new byte[6];
        if (this.wkbook != null) {
            Supbook[] sb = this.wkbook.getSupBooks();
            bts[0] = firstSheet == 65534 ? this.getAddInIndex(sb) : this.getGlobalSupBookIndex(sb);
        }
        rgxti newcXTI = new rgxti(bts);
        newcXTI.setWorkBook(this.wkbook);
        if (firstSheet == 65534) {
            newcXTI.setIsAddIn(true);
        }
        if (!newcXTI.getIsAddIn()) {
            newcXTI.setSheet1(firstSheet);
            newcXTI.setSheet2(lastSheet);
        }
        this.rgs.add(newcXTI);
        this.cXTI = (short)(this.cXTI + 1);
        this.update();
    }

    public short addExternalSheetRef(String externalWorkbook, String externalSheetName) {
        Supbook sb = this.wkbook.getExternalSupbook(externalWorkbook, true);
        short sheetRef = sb.addExternalSheetReference(externalSheetName);
        short sbRef = (short)this.wkbook.getSupbookIndex(sb);
        Iterator it = this.rgs.iterator();
        int i = 0;
        while (it.hasNext()) {
            rgxti rg = (rgxti)it.next();
            if (rg.sheet1num == sheetRef && rg.sheet2num == sheetRef && rg.sbs == sbRef) {
                return (short)i;
            }
            ++i;
        }
        byte[] bts = new byte[6];
        System.arraycopy(ByteTools.shortToLEBytes(sbRef), 0, bts, 0, 2);
        System.arraycopy(ByteTools.shortToLEBytes(sheetRef), 0, bts, 2, 2);
        System.arraycopy(ByteTools.shortToLEBytes(sheetRef), 0, bts, 4, 2);
        rgxti newcXTI = new rgxti(bts);
        newcXTI.setIsExternalRef(true);
        newcXTI.setWorkBook(this.wkbook);
        this.rgs.add(newcXTI);
        this.cXTI = (short)(this.cXTI + 1);
        this.update();
        return this.cXTI;
    }

    public int insertLocation(int firstBound, int lastBound) throws WorkSheetNotFoundException {
        Iterator it = this.rgs.iterator();
        int i = 0;
        while (it.hasNext()) {
            rgxti rg = (rgxti)it.next();
            short first = rg.sheet1num;
            short last = rg.sheet2num;
            if (first == firstBound && last == lastBound && rg.sb.isGlobalRecord()) {
                return i;
            }
            ++i;
        }
        this.addSheet(firstBound, lastBound);
        return this.rgs.size() - 1;
    }

    protected static XLSRecord getPrototype() {
        Externsheet x = new Externsheet();
        x.setLength(8);
        x.setOpcode((short)23);
        byte[] dta = new byte[8];
        dta[0] = 1;
        x.setData(dta);
        x.originalsize = 8;
        x.init();
        return x;
    }

    protected static XLSRecord getPrototype(int sheetNum1, int sheetNum2, WorkBook bk) {
        Externsheet x = (Externsheet)Externsheet.getPrototype();
        try {
            x.cXTI = (short)(x.cXTI - 1);
            x.rgs.remove(0);
            x.setWorkBook(bk);
        }
        catch (Exception e) {
            Logger.logWarn("ExternSheet.getPrototype error:" + e.toString());
        }
        return x;
    }

    public int getXtiReference(String firstSheet, String secondSheet) {
        int i = 0;
        while (i < this.rgs.size()) {
            block4: {
                rgxti thisXti = (rgxti)this.rgs.elementAt(i);
                try {
                    if (thisXti.getSheetName(thisXti.sheet1num).equalsIgnoreCase(firstSheet) && thisXti.getSheetName(thisXti.sheet2num).equalsIgnoreCase(secondSheet)) {
                        return i;
                    }
                }
                catch (WorkSheetNotFoundException we) {
                    if (this.DEBUGLEVEL <= 10) break block4;
                    Logger.logWarn("Externsheet.getXtiReference:  Attempt to find Externsheet reference for sheet failed: " + we);
                }
            }
            ++i;
        }
        return -1;
    }

    public int getVirtualReference() {
        int i = 0;
        while (i < this.rgs.size()) {
            rgxti thisXti = (rgxti)this.rgs.elementAt(i);
            if (thisXti.sheet1num == -2 && thisXti.sheet2num == -2) {
                return i;
            }
            ++i;
        }
        byte[] bts = new byte[6];
        if (this.wkbook != null) {
            Supbook[] sb = this.wkbook.getSupBooks();
            bts[0] = this.getAddInIndex(sb);
        }
        rgxti newcXTI = new rgxti(bts);
        newcXTI.setWorkBook(this.wkbook);
        newcXTI.setSheet1(65534);
        newcXTI.setSheet2(65534);
        this.rgs.add(newcXTI);
        this.cXTI = (short)(this.cXTI + 1);
        this.update();
        return this.rgs.size() - 1;
    }

    public int getBrokenXtiReference() {
        int i = 0;
        while (i < this.rgs.size()) {
            rgxti thisXti = (rgxti)this.rgs.elementAt(i);
            if (thisXti.sheet1num == 65535 && thisXti.sheet2num == 65535) {
                return i;
            }
            ++i;
        }
        byte[] bts = new byte[6];
        if (this.wkbook != null) {
            Supbook[] sb = this.wkbook.getSupBooks();
            bts[0] = this.getGlobalSupBookIndex(sb);
        }
        rgxti newcXTI = new rgxti(bts);
        newcXTI.setWorkBook(this.wkbook);
        newcXTI.setSheet1(65535);
        newcXTI.setSheet2(65535);
        this.rgs.add(newcXTI);
        this.cXTI = (short)(this.cXTI + 1);
        this.update();
        return this.rgs.size() - 1;
    }

    @Override
    public void close() {
        while (this.rgs.size() > 0) {
            this.rgs.remove(0);
        }
    }

    class rgxti
    implements Serializable {
        private static final long serialVersionUID = -1591367957030959727L;
        short sbs = 0;
        short sheet1num;
        short sheet2num;
        Supbook sb = null;
        WorkBook wkbook = null;
        byte[] bts = null;
        private boolean bIsAddIn = false;
        private boolean bIsExternal = false;
        CompatibleVector listeners = new CompatibleVector();

        public void addListener(IxtiListener p) {
            this.listeners.add(p);
        }

        public void notifyListeners() {
            Iterator it = this.listeners.iterator();
            int locp = Externsheet.this.rgs.indexOf(this);
            while (it.hasNext()) {
                IxtiListener p = (IxtiListener)it.next();
                if (locp == -1) {
                    ((Ptg)((Object)p)).getParentRec().remove(true);
                    continue;
                }
                p.setIxti((short)locp);
            }
        }

        rgxti() {
        }

        void setWorkBook(WorkBook bk) {
            this.wkbook = bk;
            this.sbs = ByteTools.readShort(this.bts[0], this.bts[1]);
            this.sb = this.wkbook.getSupBooks()[this.sbs];
            this.sheet1num = ByteTools.readShort(this.bts[2], this.bts[3]);
            this.sheet2num = ByteTools.readShort(this.bts[4], this.bts[5]);
            if (this.sheet1num == 65534) {
                this.bIsAddIn = true;
            }
            if (this.sb.isExternalRecord()) {
                this.bIsExternal = true;
            }
        }

        rgxti(byte[] initbytes) {
            this.bts = initbytes;
        }

        public byte[] getBytes() {
            if (this.bts == null) {
                this.bts = new byte[6];
            }
            byte[] shtbt = ByteTools.shortToLEBytes(this.sheet1num);
            System.arraycopy(shtbt, 0, this.bts, 2, 2);
            shtbt = ByteTools.shortToLEBytes(this.sheet2num);
            System.arraycopy(shtbt, 0, this.bts, 4, 2);
            return this.bts;
        }

        public String getSheetName(int sheetNum) throws WorkSheetNotFoundException {
            if (this.bIsAddIn) {
                return "Virtual Sheet Range 0xFFFE - 0xFFFE";
            }
            if (this.bIsExternal) {
                return this.sb.getExternalSheetName(sheetNum);
            }
            if (sheetNum == 65535) {
                return "Deleted Sheet";
            }
            return this.wkbook.getWorkSheetByNumber(sheetNum).getSheetName();
        }

        public void setIsAddIn(boolean bIsAddin) {
            this.bIsAddIn = bIsAddin;
        }

        public boolean getIsAddIn() {
            return this.bIsAddIn;
        }

        public void setIsExternalRef(boolean bIsExternal) {
            this.bIsExternal = bIsExternal;
        }

        public boolean getIsExternal() {
            return this.bIsExternal;
        }

        public void setSheet1(int sh1) {
            this.sheet1num = (short)sh1;
        }

        public int getSheet1() {
            return this.sheet1num;
        }

        public void setSheet2(int sh2) {
            this.sheet2num = (short)sh2;
        }

        public int getSheet2() {
            return this.sheet2num;
        }

        public String toString() {
            try {
                return "rgxti range: " + this.getSheetName(this.sheet1num) + "-" + this.getSheetName(this.sheet2num);
            }
            catch (WorkSheetNotFoundException workSheetNotFoundException) {
                return "rgxti range: sheets not initialized";
            }
        }
    }
}

