/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import java.util.ArrayList;

public class Crn
extends XLSRecord {
    private static final long serialVersionUID = 3162130963170092322L;
    private byte lc;
    private byte fc;
    private int rowIndex;
    private ArrayList cachedValues = new ArrayList();

    @Override
    public void init() {
        super.init();
        this.lc = this.getByteAt(0);
        this.fc = this.getByteAt(1);
        this.rowIndex = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        int pos = 4;
        int i = 0;
        while (i < this.lc - this.fc + 1) {
            try {
                byte type = this.getByteAt(pos++);
                switch (type) {
                    case 0: {
                        pos += 8;
                        break;
                    }
                    case 1: {
                        this.cachedValues.add(new Float(ByteTools.eightBytetoLEDouble(this.getBytesAt(pos, 8))));
                        pos += 8;
                        break;
                    }
                    case 2: {
                        short ln = ByteTools.readShort(this.getByteAt(pos), this.getByteAt(pos + 1));
                        byte encoding = this.getByteAt(pos + 2);
                        pos += 3;
                        if (encoding == 0) {
                            this.cachedValues.add(new String(this.getBytesAt(pos, ln)));
                            pos += ln;
                            break;
                        }
                        this.cachedValues.add(new String(this.getBytesAt(pos, ln * 2), "UTF-16LE"));
                        pos += ln * 2;
                        break;
                    }
                    case 4: {
                        this.cachedValues.add(this.getByteAt(pos + 1) == 1);
                        pos += 8;
                        break;
                    }
                    case 16: {
                        this.cachedValues.add(new String("Error Code: " + this.getByteAt(pos + 1)));
                        pos += 8;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    @Override
    public String toString() {
        String ret = "CRN: lc=" + this.lc + " fc=" + this.fc + " rowIndex=" + this.rowIndex;
        int i = 0;
        while (i < this.cachedValues.size()) {
            ret = String.valueOf(ret) + " (" + i + ")=" + this.cachedValues.get(i);
            ++i;
        }
        return ret;
    }
}

