/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Book;
import com.extentech.formats.XLS.ByteStreamer;
import com.extentech.formats.XLS.Continue;
import com.extentech.formats.XLS.MSODrawing;
import com.extentech.formats.XLS.MSODrawingGroup;
import com.extentech.formats.XLS.Name;
import com.extentech.formats.XLS.Obj;
import com.extentech.formats.XLS.Sst;
import com.extentech.formats.XLS.StringRec;
import com.extentech.formats.XLS.Txo;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.Logger;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;

public class ContinueHandler
implements Serializable,
XLSConstants {
    private static final long serialVersionUID = 164009339243774537L;
    private static int DEBUGLEVEL = 0;
    private static boolean processContinues = true;
    private BiffRec continued;
    private boolean handleTxo = false;
    private boolean handleObj = false;
    private Txo lastTxo;
    private Obj lastObj;
    private Continue lastCont;
    private WorkBook book;
    private BiffRec splitPrevRec;
    private BiffRec splitContRec;

    public ContinueHandler(WorkBook b) {
        this.book = b;
    }

    public void addRec(BiffRec rec, int datalen) {
        short opcode = rec.getOpcode();
        int nextOpcode = 0;
        if (opcode != 10) {
            nextOpcode = this.book.getFactory().lookAhead(rec);
        }
        if (nextOpcode == 60 && DEBUGLEVEL > 11) {
            Logger.logInfo("Next OPCODE IS CONTINUE: " + Integer.toHexString(nextOpcode));
        }
        if (nextOpcode == 60 && opcode != 60) {
            if (this.continued != null) {
                this.continued.init();
                this.continued = null;
            }
            this.splitPrevRec = this.continued = rec;
            if (this.continued instanceof Txo) {
                this.handleTxo = true;
                this.lastTxo = (Txo)this.continued;
                this.lastObj = null;
                this.handleObj = false;
            } else if (this.continued instanceof Obj) {
                this.handleObj = true;
                this.lastObj = (Obj)this.continued;
                this.lastObj.init();
                this.lastTxo = null;
                this.handleTxo = false;
            } else {
                this.handleTxo = false;
                this.handleObj = false;
            }
            this.lastCont = null;
        } else if (opcode == 60) {
            this.splitContRec = rec;
            rec.init();
            if (this.continued == null && this.lastCont == null) {
                if (this.splitPrevRec != null) {
                    ((Continue)rec).setPredecessor(this.splitContRec);
                }
                if (DEBUGLEVEL > 0) {
                    Logger.logWarn("Warning:  Out of spec split txo continue record found, reconstructing." + this.splitPrevRec.toString());
                }
            } else {
                if (this.lastCont != null) {
                    ((Continue)rec).setPredecessor(this.lastCont);
                } else {
                    ((Continue)rec).setPredecessor(this.continued);
                }
                if (this.continued.getOpcode() == 252 || this.continued.getOpcode() == 519) {
                    if (DEBUGLEVEL > 2) {
                        Logger.logInfo("Sst Continue.  grbit:" + ((Continue)rec).getGrbit());
                    }
                } else {
                    ((Continue)rec).setHasGrbit(false);
                }
            }
            if (this.handleTxo) {
                if (this.lastTxo.text == null) {
                    if (!this.isMaskedMSODrawingRec(rec.getData())) {
                        this.lastTxo.text = (Continue)rec;
                    } else {
                        this.continued = this.createMSODrawingFromContinue(rec);
                        ((Continue)rec).maskedMso = (MSODrawing)this.continued;
                    }
                } else if (this.lastTxo.formattingruns == null) {
                    this.lastTxo.formattingruns = (Continue)rec;
                } else {
                    block47: {
                        try {
                            if (this.isMaskedMSODrawingRec(rec.getData())) {
                                this.continued = this.createMSODrawingFromContinue(rec);
                                ((Continue)rec).maskedMso = (MSODrawing)this.continued;
                            } else if (this.continued != null) {
                                this.continued.addContinue((Continue)rec);
                                ((XLSRecord)this.continued).mergeContinues();
                                this.continued.removeContinues();
                            }
                        }
                        catch (Exception e) {
                            if (DEBUGLEVEL <= 0) break block47;
                            Logger.logErr("ContinueHandler.txo parsing- encountered unknown Continue record");
                        }
                    }
                    this.lastCont = (Continue)rec;
                }
            } else if (this.handleObj) {
                try {
                    if (this.isMaskedMSODrawingRec(rec.getData())) {
                        this.continued = this.createMSODrawingFromContinue(rec);
                        ((Continue)rec).maskedMso = (MSODrawing)this.continued;
                    } else if (this.continued != null) {
                        this.continued.addContinue((Continue)rec);
                        ((XLSRecord)this.continued).mergeContinues();
                        this.continued.removeContinues();
                    }
                    this.lastCont = (Continue)rec;
                }
                catch (Exception e) {
                    if (DEBUGLEVEL > 0) {
                        Logger.logErr("ContinueHandler.Obj parsing- encountered unknown Continue record");
                    }
                }
            } else {
                if (this.continued != null) {
                    this.continued.addContinue((Continue)rec);
                }
                this.lastCont = (Continue)rec;
            }
        } else {
            if (this.continued != null) {
                this.continued.init();
                if (this.continued.getOpcode() == 519) {
                    this.book.lastFormula.setCachedValue(((StringRec)this.continued).getStringVal());
                }
                this.continued = null;
            }
            if (this.book.getLastbound() != null && opcode == 6) {
                rec.setSheet(this.book.getLastbound());
            }
            if (opcode != 24) {
                rec.init();
            } else {
                ((Name)rec).init(false);
            }
            this.lastCont = null;
        }
    }

    private boolean isMaskedMSODrawingRec(byte[] data) {
        if (data.length > 3) {
            int id = (0xFF & data[3]) << 8 | 0xFF & data[2];
            return id == 61444 || id == 61445 || id == 61443 || id == 61453;
        }
        return false;
    }

    private MSODrawing createMSODrawingFromContinue(BiffRec rec) {
        MSODrawing mso = new MSODrawing();
        mso.setOpcode((short)236);
        mso.setWorkBook(rec.getWorkBook());
        mso.setData(rec.getData());
        mso.setLength(rec.getData().length);
        mso.setDebugLevel(DEBUGLEVEL);
        mso.setStreamer(this.book.getStreamer());
        return mso;
    }

    public static boolean createContinues(BiffRec rec, OutputStream out, ByteStreamer streamer) {
        int datalen = rec.getLength();
        short opc = rec.getOpcode();
        if (opc == 60) {
            if (((Continue)rec).isBigRecContinue()) {
                return true;
            }
            if (((Continue)rec).maskedMso != null && ((Continue)rec).maskedMso.getLength() - 4 > 8224) {
                ((Continue)rec).maskedMso.setOpcode((short)60);
                ContinueHandler.createBigRecContinues(((Continue)rec).maskedMso, out, streamer);
                ((Continue)rec).maskedMso.setOpcode((short)236);
                return true;
            }
        } else {
            if (opc == 252) {
                ContinueHandler.createSstContinues((Sst)rec, out, streamer);
                return true;
            }
            if (opc == 438) {
                ContinueHandler.createTxoContinues((Txo)rec, out, streamer);
                return true;
            }
            if (opc == 235) {
                ContinueHandler.createMSODGContinues(rec, out, streamer);
                return true;
            }
            if (datalen - 4 > 8224) {
                ContinueHandler.createBigRecContinues(rec, out, streamer);
                return true;
            }
        }
        return false;
    }

    static int createContinues(BiffRec rec, int insertLoc) {
        int datalen = rec.getLength();
        if (rec instanceof Obj || rec instanceof MSODrawing || rec instanceof MSODrawingGroup) {
            return ContinueHandler.createObjContinues(rec);
        }
        if (rec instanceof Sst) {
            return ContinueHandler.createSstContinues((Sst)rec, insertLoc);
        }
        if (datalen > 8224 && !(rec instanceof Continue)) {
            return ContinueHandler.createBigContinues(rec, insertLoc);
        }
        if (rec instanceof Txo) {
            return ContinueHandler.createTxoContinues((Txo)rec);
        }
        return 0;
    }

    public static int createSstContinues(Sst rec, int insertLoc) {
        byte[] dta = rec.getData();
        int datalen = dta.length;
        if (datalen < 8224) {
            return 0;
        }
        Object[] continuedef = Sst.getContinueDef(rec, false);
        Integer[] continuesizes = (Integer[])continuedef[0];
        Byte[] sstgrbits = (Byte[])continuedef[1];
        int numconts = continuesizes.length - 1;
        ContinueHandler.removeContinues(rec);
        int sizer = 0;
        int dtapos = 0;
        int i = 1;
        while (i <= numconts) {
            if (continuesizes[i] == 0) break;
            Byte thisgr = sstgrbits[i - 1];
            dtapos += continuesizes[i - 1].intValue();
            boolean hasGrbit = false;
            if (thisgr != null) {
                boolean bl = hasGrbit = thisgr < 2 && thisgr >= 0;
            }
            if (continuesizes[i] == 8224) {
                hasGrbit = false;
            }
            sizer = continuesizes[i];
            if (i == numconts) {
                sizer = datalen - dtapos;
            }
            if (hasGrbit) {
                ++sizer;
            }
            byte[] continuedata = new byte[sizer];
            if (hasGrbit) {
                if (DEBUGLEVEL > 1) {
                    Logger.logInfo("New Continue. HAS grbit.");
                    Logger.logInfo("Continue GRBIT: " + String.valueOf(thisgr));
                }
                continuedata[0] = thisgr;
                System.arraycopy(dta, dtapos, continuedata, 1, continuedata.length - 1);
            } else {
                if (DEBUGLEVEL > 1) {
                    Logger.logInfo("New Continue. NO grbit.");
                    Logger.logInfo("Continue GRBIT: " + String.valueOf(dta[dtapos] & 1));
                }
                System.arraycopy(dta, dtapos, continuedata, 0, continuedata.length);
            }
            Continue thiscont = ContinueHandler.addContinue(rec, continuedata, insertLoc, rec.wkbook);
            if (hasGrbit) {
                thiscont.setHasGrbit(true);
            }
            ++insertLoc;
            ++i;
        }
        int sstsize = continuesizes[0];
        ContinueHandler.trimRecSize(rec, sstsize);
        return numconts;
    }

    private static void writeRec(BiffRec rec, OutputStream out, ByteStreamer streamer) {
        if (rec.getOpcode() == 60) {
            rec.preStream();
        }
        try {
            streamer.writeRecord(out, rec);
        }
        catch (Exception a) {
            Logger.logErr("Streaming WorkBook Bytes for record:" + rec.toString() + " failed: " + a + " Output Corrupted.");
        }
    }

    public static void createSstContinues(Sst rec, OutputStream out, ByteStreamer streamer) {
        byte[] dta = rec.getData();
        int datalen = dta.length;
        Object[] continuedef = Sst.getContinueDef(rec, false);
        Integer[] continuesizes = (Integer[])continuedef[0];
        int sstsize = 0;
        if (continuesizes.length > 0) {
            Integer sstz = continuesizes[0];
            if (sstz != null) {
                sstsize = sstz;
            }
            ContinueHandler.trimRecSize(rec, sstsize);
        }
        ContinueHandler.writeRec(rec, out, streamer);
        Byte[] sstgrbits = (Byte[])continuedef[1];
        int numconts = continuesizes.length - 1;
        ContinueHandler.removeContinues(rec);
        int sizer = 0;
        int dtapos = 0;
        int i = 1;
        while (i <= numconts) {
            if (continuesizes[i] == 0) break;
            Byte thisgr = sstgrbits[i - 1];
            dtapos += continuesizes[i - 1].intValue();
            boolean hasGrbit = false;
            if (thisgr != null) {
                boolean bl = hasGrbit = thisgr < 2 && thisgr >= 0;
            }
            if (continuesizes[i] == 8224) {
                hasGrbit = false;
            }
            sizer = continuesizes[i];
            if (i == numconts) {
                sizer = datalen - dtapos;
            }
            if (hasGrbit) {
                ++sizer;
            }
            byte[] continuedata = new byte[sizer];
            if (hasGrbit) {
                if (DEBUGLEVEL > 1) {
                    Logger.logInfo("New Continue. HAS grbit.");
                    Logger.logInfo("Continue GRBIT: " + String.valueOf(thisgr));
                }
                continuedata[0] = thisgr;
                System.arraycopy(dta, dtapos, continuedata, 1, continuedata.length - 1);
            } else {
                if (DEBUGLEVEL > 1) {
                    Logger.logInfo("New Continue. NO grbit.");
                    Logger.logInfo("Continue GRBIT: " + String.valueOf(dta[dtapos] & 1));
                }
                System.arraycopy(dta, dtapos, continuedata, 0, continuedata.length);
            }
            Continue thiscont = ContinueHandler.createContinue(continuedata, rec.wkbook);
            if (hasGrbit) {
                thiscont.setHasGrbit(true);
            }
            ContinueHandler.writeRec(thiscont, out, streamer);
            ++i;
        }
    }

    public static void removeContinues(BiffRec rec) {
        List oldconts = rec.getContinueVect();
        if (oldconts == null) {
            return;
        }
        if (oldconts.size() > 0) {
            for (Object ob : oldconts) {
                rec.getStreamer().removeRecord((BiffRec)ob);
                Object var3_3 = null;
            }
            rec.removeContinues();
        }
    }

    public static void createBigRecContinues(BiffRec rec, OutputStream out, ByteStreamer streamer) {
        byte[] dta = rec.getData();
        int datalen = dta.length;
        int numconts = datalen / 8224;
        if (datalen <= 8224) {
            ContinueHandler.writeRec(rec, out, streamer);
            return;
        }
        ContinueHandler.trimRecSize(rec, 8224);
        ContinueHandler.writeRec(rec, out, streamer);
        int[] boundaries = ContinueHandler.getBoundaries(numconts);
        int sizer = 8224;
        int i = 0;
        while (i < numconts) {
            if (datalen - boundaries[i] < 8224) {
                sizer = datalen - boundaries[i];
            }
            byte[] continuedata = new byte[sizer];
            System.arraycopy(dta, boundaries[i], continuedata, 0, continuedata.length);
            Continue cr = ContinueHandler.createContinue(continuedata, rec.getWorkBook());
            ContinueHandler.writeRec(cr, out, streamer);
            ++i;
        }
    }

    public static int createBigContinues(BiffRec rec, int insertLoc) {
        byte[] dta = rec.getData();
        int datalen = dta.length;
        int numconts = datalen / 8224;
        Continue[] conts = new Continue[numconts];
        int[] boundaries = ContinueHandler.getBoundaries(numconts);
        ContinueHandler.removeContinues(rec);
        int sizer = 8224;
        int i = 0;
        while (i < numconts) {
            if (datalen - boundaries[i] < 8224) {
                sizer = datalen - boundaries[i];
            }
            byte[] continuedata = new byte[sizer];
            System.arraycopy(dta, boundaries[i], continuedata, 0, continuedata.length);
            conts[i] = ContinueHandler.addContinue(rec, continuedata, insertLoc, rec.getWorkBook());
            ++insertLoc;
            ++i;
        }
        ContinueHandler.trimRecSize(rec, 8224);
        return numconts;
    }

    public static Continue createContinue(byte[] data, Book book) {
        Continue cont = new Continue();
        cont.setWorkBook((WorkBook)book);
        cont.setData(data);
        cont.setStreamer(book.getStreamer());
        int len = data.length;
        cont.setOpcode((short)60);
        cont.setLength((short)len);
        return cont;
    }

    public static Continue addContinue(BiffRec rec, byte[] data, int streampos, Book book) {
        Continue cont = new Continue();
        rec.addContinue(cont);
        cont.setWorkBook((WorkBook)book);
        cont.setData(data);
        int len = data.length;
        cont.setOpcode((short)60);
        cont.setLength((short)len);
        return cont;
    }

    public static int createTxoContinues(Txo rec) {
        List txoConts = rec.getContinueVect();
        if (txoConts == null) {
            return 0;
        }
        if (rec.getLength() > 8228) {
            ContinueHandler.trimRecSize(rec, 8224);
        }
        return 0;
    }

    public static void createTxoContinues(Txo rec, OutputStream out, ByteStreamer streamer) {
        byte[] dta = rec.getBytes();
        WorkBook book = rec.getWorkBook();
        if (dta.length > 8228) {
            ContinueHandler.trimRecSize(rec, 8224);
            ContinueHandler.writeRec(rec, out, streamer);
            Continue[] myconts = ContinueHandler.getContinues(dta, 8224, book);
            int x = 0;
            while (x < myconts.length) {
                ContinueHandler.writeRec(myconts[x], out, streamer);
                ++x;
            }
        } else {
            ContinueHandler.writeRec(rec, out, streamer);
        }
    }

    public static void createMSODGContinues(BiffRec rec, OutputStream out, ByteStreamer streamer) {
        byte[] dta = rec.getData();
        int datalen = dta.length;
        int numconts = datalen / 8224;
        if (datalen <= 8224) {
            ContinueHandler.writeRec(rec, out, streamer);
            return;
        }
        ContinueHandler.trimRecSize(rec, 8224);
        ContinueHandler.writeRec(rec, out, streamer);
        int[] boundaries = ContinueHandler.getBoundaries(numconts);
        int sizer = 8224;
        int i = 0;
        while (i < numconts) {
            if (datalen - boundaries[i] < 8224) {
                sizer = datalen - boundaries[i];
            }
            if (sizer == 0) break;
            byte[] continuedata = new byte[sizer];
            System.arraycopy(dta, boundaries[i], continuedata, 0, continuedata.length);
            XLSRecord cr = null;
            if (i == 0) {
                cr = MSODrawingGroup.getPrototype();
                cr.setData(continuedata);
            } else {
                cr = ContinueHandler.createContinue(continuedata, rec.getWorkBook());
            }
            ContinueHandler.writeRec(cr, out, streamer);
            ++i;
        }
        rec.setData(dta);
    }

    private static Continue[] getContinues(byte[] dta, int start, WorkBook book) {
        int clen = dta.length - start;
        int len = 0;
        boolean pos = false;
        int numconts = clen / 8224;
        Continue[] retconts = new Continue[++numconts];
        Logger.logInfo("Creating continues: " + numconts);
        byte[] dtx = null;
        int x = 0;
        while (x < numconts) {
            len = clen > 8224 ? 8224 : clen;
            if (len > 0) {
                dtx = new byte[len];
            } else {
                dtx = new byte[clen];
                len = clen;
            }
            System.arraycopy(dta, start, dtx, 0, len);
            retconts[x] = ContinueHandler.createContinue(dtx, book);
            clen -= len;
            ++x;
        }
        return retconts;
    }

    public static int createObjContinues(BiffRec rec) {
        if (rec.getLength() > 8228) {
            ContinueHandler.trimRecSize(rec, 8224);
        }
        return 0;
    }

    static int[] getBoundaries(int x) {
        int[] boundaries = new int[x];
        int thisbound = 0;
        int i = 0;
        while (i < x) {
            boundaries[i] = thisbound += 8224;
            ++i;
        }
        return boundaries;
    }

    public static void trimRecSize(BiffRec rec, int CONTINUESIZE) {
        byte[] dta = rec.getData();
        byte[] newdata = new byte[CONTINUESIZE];
        System.arraycopy(dta, 0, newdata, 0, CONTINUESIZE);
        rec.setData(newdata);
    }

    public void close() {
        this.continued = null;
        this.lastTxo = null;
        this.lastObj = null;
        this.lastCont = null;
        this.book = null;
    }
}

