/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.CellAddressible;
import java.io.Serializable;

public interface ColumnRange {
    public int getColFirst();

    public int getColLast();

    public boolean isSingleCol();

    public static final class Comparator
    implements java.util.Comparator<ColumnRange>,
    Serializable {
        private static final long serialVersionUID = -4506187924019516336L;

        @Override
        public int compare(ColumnRange r1, ColumnRange r2) {
            int first;
            boolean single1 = r1.isSingleCol();
            boolean single2 = r2.isSingleCol();
            if ((single1 || single2) && single1 != single2) {
                ColumnRange single;
                ColumnRange range = single1 ? r2 : r1;
                ColumnRange columnRange = single = single1 ? r1 : r2;
                if (range.getColFirst() <= single.getColFirst() && range.getColLast() >= single.getColLast()) {
                    if (single instanceof CellAddressible.RangeBoundary) {
                        int value = ((CellAddressible.RangeBoundary)single).comareToRange();
                        return single2 ? -value : value;
                    }
                    return 0;
                }
            }
            if ((first = r1.getColFirst() - r2.getColFirst()) != 0) {
                return first;
            }
            return r2.getColLast() - r1.getColLast();
        }
    }

    public static final class Reference
    implements ColumnRange,
    Serializable {
        private static final long serialVersionUID = -2240322394559418980L;
        private final int first;
        private final int last;

        public Reference(int first, int last) {
            this.first = first;
            this.last = last;
        }

        @Override
        public int getColFirst() {
            return this.first;
        }

        @Override
        public int getColLast() {
            return this.last;
        }

        @Override
        public boolean isSingleCol() {
            return this.first == this.last;
        }
    }
}

