/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.UnsupportedEncodingException;

public class Codename
extends XLSRecord {
    private static final long serialVersionUID = -8327865068784623792L;
    private String stCodeName;
    byte cch;
    byte grbitChr;

    @Override
    public void init() {
        super.init();
        byte[] wtf = this.getBytesAt(0, this.getLength());
        this.cch = this.getByteAt(0);
        this.grbitChr = this.getByteAt(2);
        byte[] namebytes = this.getBytesAt(3, this.cch);
        try {
            this.stCodeName = this.grbitChr == 1 ? new String(namebytes, "UTF-16LE") : new String(namebytes, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            Logger.logWarn("UnsupportedEncodingException in setting codename: " + e);
        }
    }

    public void setName(String newname) {
        int modnamelen = 0;
        int oldnamelen = 0;
        oldnamelen = this.grbitChr == 0 ? this.stCodeName.length() : this.stCodeName.length() * 2;
        this.cch = (byte)newname.length();
        byte[] namebytes = newname.getBytes();
        if (!ByteTools.isUnicode(newname)) {
            this.grbitChr = 0;
            modnamelen = newname.length();
        } else {
            this.grbitChr = 1;
            modnamelen = newname.length() * 2;
        }
        byte[] newdata = new byte[this.getData().length - oldnamelen + modnamelen];
        try {
            namebytes = this.grbitChr == 1 ? newname.getBytes("UTF-16LE") : newname.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            Logger.logInfo("UnsupportedEncodingException in setting sheet name: " + e);
        }
        System.arraycopy(namebytes, 0, newdata, 3, namebytes.length);
        newdata[0] = this.cch;
        newdata[2] = this.grbitChr;
        this.setData(newdata);
        this.init();
    }
}

