/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.ExpressionParser;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.Sheet;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.FormulaCalculator;
import com.extentech.formats.XLS.formulas.FormulaParser;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArray;
import com.extentech.formats.XLS.formulas.PtgExp;
import com.extentech.formats.XLS.formulas.PtgMemArea;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.Stack;

public final class Array
extends XLSRecord {
    private static final long serialVersionUID = -7316545663448065447L;
    private short rwFirst;
    private short rwLast;
    private short colFirst;
    private short colLast;
    private short cce;
    private short grbit;
    private byte[] rgce;
    private Formula parentRec = null;
    private Stack expression;

    public int getFirstRow() {
        return this.rwFirst;
    }

    public int getLastRow() {
        return this.rwLast;
    }

    public int getFirstCol() {
        return this.colFirst;
    }

    public int getLastCol() {
        return this.colLast;
    }

    @Override
    public int getRowNumber() {
        return this.getFirstRow();
    }

    public int getCol() {
        return this.getFirstCol();
    }

    public void setFirstRow(int i) {
        this.rwFirst = (short)i;
    }

    public void setLastRow(int i) {
        this.rwLast = (short)i;
    }

    public void setFirstCol(int i) {
        this.colFirst = (byte)i;
    }

    public void setLastCol(int i) {
        this.colLast = (byte)i;
    }

    @Override
    public void init() {
        super.init();
        this.setOpcode((short)545);
        this.rwFirst = (short)ByteTools.readInt(this.getByteAt(0), this.getByteAt(1), (byte)0, (byte)0);
        this.rwLast = (short)ByteTools.readInt(this.getByteAt(2), this.getByteAt(3), (byte)0, (byte)0);
        this.colFirst = (short)ByteTools.readUnsignedShort(this.getByteAt(4), (byte)0);
        this.colLast = (short)ByteTools.readUnsignedShort(this.getByteAt(5), (byte)0);
        this.grbit = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
        this.cce = ByteTools.readShort(this.getByteAt(12), this.getByteAt(13));
        this.rgce = this.getBytesAt(14, this.cce);
        this.expression = ExpressionParser.parseExpression(this.rgce, this);
        int posExtraData = this.cce + 14;
        int len = this.getData().length;
        int i = 0;
        while (i < this.expression.size()) {
            if (this.expression.get(i) instanceof PtgArray) {
                try {
                    byte[] b = new byte[len - posExtraData];
                    System.arraycopy(this.getData(), posExtraData, b, 0, len - posExtraData);
                    PtgArray pa = (PtgArray)this.expression.get(i);
                    posExtraData += pa.setArrVals(b);
                }
                catch (Exception e) {
                    Logger.logErr("Array: error getting Constants " + e.getLocalizedMessage());
                }
            } else if (this.expression.get(i) instanceof PtgMemArea) {
                try {
                    PtgMemArea pm = (PtgMemArea)this.expression.get(i);
                    byte[] b = new byte[pm.getnTokens() + 8];
                    System.arraycopy(pm.getRecord(), 0, b, 0, 7);
                    System.arraycopy(this.getData(), posExtraData, b, 7, pm.getnTokens());
                    pm.init(b);
                    posExtraData += pm.getnTokens();
                }
                catch (Exception e) {
                    Logger.logErr("Array: error getting memarea constants " + e.toString());
                }
            }
            ++i;
        }
        if (this.DEBUGLEVEL > 50) {
            Logger.logInfo("Array encountered at: " + this.wkbook.getLastbound().getSheetName() + "!" + ExcelTools.getAlphaVal(this.colFirst) + (this.rwFirst + 1) + ":" + ExcelTools.getAlphaVal(this.colLast) + (this.rwLast + 1));
        }
    }

    @Override
    public void setSheet(Sheet b) {
        this.worksheet = b;
        if (this.expression != null) {
            String loc = ExcelTools.formatLocation(new int[]{this.rwFirst, this.colFirst});
            String ref = ExcelTools.formatRangeRowCol(new int[]{this.rwFirst, this.colFirst, this.rwLast, this.colLast});
            ((Boundsheet)b).addParentArrayRef(loc, ref);
        }
    }

    public void init(String fmla, int rw, int col) {
        Stack newptgs;
        this.setOpcode((short)545);
        this.rwFirst = (short)rw;
        this.rwLast = (short)rw;
        this.colFirst = (byte)col;
        this.colLast = (byte)col;
        this.grbit = (short)2;
        fmla = fmla.substring(1, fmla.length() - 1);
        this.expression = newptgs = FormulaParser.getPtgsFromFormulaString(this, fmla);
        this.updateRecord();
    }

    public void updateRecord() {
        this.cce = 0;
        int i = 0;
        while (i < this.expression.size()) {
            Ptg ptg = (Ptg)this.expression.elementAt(i);
            this.cce = (short)(this.cce + ptg.getRecord().length);
            if (ptg instanceof PtgRef) {
                ((PtgRef)ptg).setArrayTypeRef();
            }
            ++i;
        }
        byte[] newdata = new byte[14 + this.cce];
        int pos = 0;
        this.setOpcode((short)545);
        System.arraycopy(ByteTools.shortToLEBytes(this.rwFirst), 0, newdata, pos, 2);
        System.arraycopy(ByteTools.shortToLEBytes(this.rwLast), 0, newdata, pos += 2, 2);
        pos += 2;
        newdata[pos++] = (byte)this.colFirst;
        newdata[pos++] = (byte)this.colLast;
        System.arraycopy(ByteTools.shortToLEBytes(this.grbit), 0, newdata, pos, 2);
        pos = 12;
        System.arraycopy(ByteTools.shortToLEBytes(this.cce), 0, newdata, pos, 2);
        pos += 2;
        this.rgce = new byte[this.cce];
        pos = 0;
        byte[] arraybytes = new byte[]{};
        int i2 = 0;
        while (i2 < this.expression.size()) {
            Ptg ptg = (Ptg)this.expression.elementAt(i2);
            if (ptg instanceof PtgArray) {
                PtgArray pa = (PtgArray)ptg;
                arraybytes = ByteTools.append(pa.getPostRecord(), arraybytes);
            } else if (ptg instanceof PtgMemArea) {
                PtgMemArea pm = (PtgMemArea)ptg;
                arraybytes = ByteTools.append(pm.getPostRecord(), arraybytes);
            }
            byte[] b = ptg.getRecord();
            System.arraycopy(b, 0, this.rgce, pos, ptg.getLength());
            pos += ptg.getLength();
            ++i2;
        }
        System.arraycopy(this.rgce, 0, newdata, 14, this.cce);
        newdata = ByteTools.append(arraybytes, newdata);
        this.setData(newdata);
    }

    public String getParentLocation() {
        int[] in = new int[]{this.colFirst, this.rwFirst};
        String s = ExcelTools.formatLocation(in);
        return s;
    }

    boolean isInRange(String addr) {
        return ExcelTools.isInRange(addr, this.rwFirst, this.rwLast, this.colFirst, this.colLast);
    }

    public Object getValue(PtgExp pxp) {
        return FormulaCalculator.calculateFormula(this.expression);
    }

    public void setParentRec(Formula f) {
        this.parentRec = f;
    }

    public Formula getParentRec() {
        return this.parentRec;
    }

    public String getFormulaString() {
        String expressString = FormulaParser.getExpressionString(this.expression);
        if (!"".equals(expressString)) {
            return expressString.substring(1);
        }
        return "";
    }

    public Stack getExpression() {
        return this.expression;
    }

    public String getArrayRefs() {
        int[] rc = new int[]{this.rwFirst, this.colFirst};
        String rowcol1 = ExcelTools.formatLocation(rc);
        rc[0] = this.rwLast;
        rc[1] = this.colLast;
        String rowcol2 = ExcelTools.formatLocation(rc);
        return String.valueOf(rowcol1) + ":" + rowcol2;
    }
}

