/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;

class TabColor
implements OOXMLElement {
    private static final long serialVersionUID = -2862996863147633555L;
    private HashMap<String, String> attrs;

    public TabColor(HashMap<String, String> attrs) {
        this.attrs = attrs;
    }

    public TabColor(TabColor t) {
        this.attrs = t.attrs;
    }

    public static TabColor parseOOXML(XmlPullParser xpp) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("tabColor")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                            ++i;
                        }
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("tabColor")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("tabColor.parseOOXML: " + e.toString());
        }
        TabColor t = new TabColor(attrs);
        return t;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<tabColor");
        for (String key : this.attrs.keySet()) {
            String val = this.attrs.get(key);
            ooxml.append(" " + key + "=\"" + val + "\"");
        }
        ooxml.append("/>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new TabColor(this);
    }
}

