/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.EffectRef;
import com.extentech.formats.OOXML.FillRef;
import com.extentech.formats.OOXML.FontRef;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.lnRef;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class Style
implements OOXMLElement {
    private static final long serialVersionUID = -583023685473342509L;
    private EffectRef effectRef;
    private FontRef fontRef;
    private FillRef fillRef;
    private lnRef lRef;

    public Style(lnRef lr, FillRef flr, EffectRef er, FontRef fr) {
        this.lRef = lr;
        this.fillRef = flr;
        this.effectRef = er;
        this.fontRef = fr;
    }

    public Style(Style s) {
        this.lRef = s.lRef;
        this.fillRef = s.fillRef;
        this.effectRef = s.effectRef;
        this.fontRef = s.fontRef;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        EffectRef er = null;
        FontRef fr = null;
        FillRef flr = null;
        lnRef lr = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block7: {
                    String endTag;
                    block5: {
                        String tnm;
                        block9: {
                            block8: {
                                block6: {
                                    if (eventType != 2) break block5;
                                    tnm = xpp.getName();
                                    if (!tnm.equals("effectRef")) break block6;
                                    lastTag.push(tnm);
                                    er = EffectRef.parseOOXML(xpp, lastTag, bk);
                                    break block7;
                                }
                                if (!tnm.equals("fontRef")) break block8;
                                lastTag.push(tnm);
                                fr = FontRef.parseOOXML(xpp, lastTag, bk);
                                break block7;
                            }
                            if (!tnm.equals("fillRef")) break block9;
                            lastTag.push(tnm);
                            flr = FillRef.parseOOXML(xpp, lastTag, bk);
                            break block7;
                        }
                        if (!tnm.equals("lnRef")) break block7;
                        lastTag.push(tnm);
                        lr = lnRef.parseOOXML(xpp, lastTag, bk);
                        break block7;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("style")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("style.parseOOXML: " + e.toString());
        }
        Style s = new Style(lr, flr, er, fr);
        return s;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<xdr:style>");
        ooxml.append(this.lRef.getOOXML());
        ooxml.append(this.fillRef.getOOXML());
        ooxml.append(this.effectRef.getOOXML());
        ooxml.append(this.fontRef.getOOXML());
        ooxml.append("</xdr:style>");
        return ooxml.toString();
    }

    public String toString() {
        return this.getOOXML();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Style(this);
    }
}

