/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.Color;
import com.extentech.formats.OOXML.ColorTransform;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.Theme;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class SchemeClr
implements OOXMLElement {
    private static final long serialVersionUID = 2127868578801669266L;
    private String val;
    private ColorTransform clrTransform;
    private Theme theme;

    public SchemeClr(String val, ColorTransform clrTransform, Theme t) {
        this.val = val;
        this.clrTransform = clrTransform;
        this.theme = t;
    }

    public SchemeClr(SchemeClr sc) {
        this.val = sc.val;
        this.clrTransform = sc.clrTransform;
        this.theme = sc.theme;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SchemeClr parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        String val = null;
        ColorTransform clrTransform = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block7: {
                    String endTag;
                    block6: {
                        if (eventType != 2) break block6;
                        String tnm = xpp.getName();
                        if (tnm.equals("schemeClr")) {
                            val = xpp.getAttributeValue(0);
                            break block7;
                        } else {
                            clrTransform = ColorTransform.parseOOXML(xpp, lastTag);
                            return new SchemeClr(val, clrTransform, bk.getWorkBook().getTheme());
                        }
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("schemeClr")) {
                        lastTag.pop();
                        return new SchemeClr(val, clrTransform, bk.getWorkBook().getTheme());
                    }
                }
                eventType = xpp.next();
            }
            return new SchemeClr(val, clrTransform, bk.getWorkBook().getTheme());
        }
        catch (Exception e) {
            Logger.logErr("schemeClr.parseOOXML: " + e.toString());
        }
        return new SchemeClr(val, clrTransform, bk.getWorkBook().getTheme());
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:schemeClr val=\"" + this.val + "\">");
        if (this.clrTransform != null) {
            ooxml.append(this.clrTransform.getOOXML());
        }
        ooxml.append("</a:schemeClr>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new SchemeClr(this);
    }

    public int getColor() {
        double tint = this.clrTransform == null ? 0 : this.clrTransform.getTint();
        Object[] o = Color.parseThemeColor(this.val, tint, (short)0, this.theme);
        return (Integer)o[0];
    }
}

