/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.EffectPropsGroup;
import com.extentech.formats.OOXML.FillGroup;
import com.extentech.formats.OOXML.Ln;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class RPr
implements OOXMLElement {
    private static final long serialVersionUID = 228716184734751439L;
    private HashMap<String, String> attrs;
    private Ln l;
    private FillGroup fill;
    private EffectPropsGroup effect;
    private String latin;
    private String ea;
    private String cs;

    public RPr(HashMap<String, String> attrs, Ln l, FillGroup fill, EffectPropsGroup effect, String latin, String ea, String cs) {
        this.attrs = attrs;
        this.l = l;
        this.fill = fill;
        this.effect = effect;
        this.latin = latin;
        this.ea = ea;
        this.cs = cs;
    }

    public RPr(RPr rp) {
        this.attrs = rp.attrs;
        this.l = rp.l;
        this.fill = rp.fill;
        this.effect = rp.effect;
        this.latin = rp.latin;
        this.ea = rp.ea;
        this.cs = rp.cs;
    }

    public static RPr parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        Ln l = null;
        FillGroup fill = null;
        EffectPropsGroup effect = null;
        String latin = null;
        String ea = null;
        String cs = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block8: {
                    String endTag;
                    block6: {
                        String tnm;
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            block7: {
                                                if (eventType != 2) break block6;
                                                tnm = xpp.getName();
                                                if (!tnm.equals("rPr")) break block7;
                                                int i = 0;
                                                while (i < xpp.getAttributeCount()) {
                                                    attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                                                    ++i;
                                                }
                                                break block8;
                                            }
                                            if (!tnm.equals("ln")) break block9;
                                            lastTag.push(tnm);
                                            l = (Ln)Ln.parseOOXML(xpp, lastTag, bk);
                                            break block8;
                                        }
                                        if (!tnm.equals("solidFill") && !tnm.equals("noFill") && !tnm.equals("gradFill") && !tnm.equals("grpFill") && !tnm.equals("pattFill") && !tnm.equals("blipFill")) break block10;
                                        lastTag.push(tnm);
                                        fill = (FillGroup)FillGroup.parseOOXML(xpp, lastTag, bk);
                                        break block8;
                                    }
                                    if (!tnm.equals("effectLst") && !tnm.equals("effectDag")) break block11;
                                    lastTag.push(tnm);
                                    effect = (EffectPropsGroup)EffectPropsGroup.parseOOXML(xpp, lastTag);
                                    break block8;
                                }
                                if (!tnm.equals("latin")) break block12;
                                latin = xpp.getAttributeValue(0);
                                break block8;
                            }
                            if (!tnm.equals("ea")) break block13;
                            ea = xpp.getAttributeValue(0);
                            break block8;
                        }
                        if (!tnm.equals("cs")) break block8;
                        cs = xpp.getAttributeValue(0);
                        break block8;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("rPr")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("rPr.parseOOXML: " + e.toString());
        }
        RPr rp = new RPr(attrs, l, fill, effect, latin, ea, cs);
        return rp;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:rPr");
        if (this.attrs != null) {
            for (String key : this.attrs.keySet()) {
                String val = this.attrs.get(key);
                ooxml.append(" " + key + "=\"" + val + "\"");
            }
        }
        ooxml.append(">");
        if (this.l != null) {
            ooxml.append(this.l.getOOXML());
        }
        if (this.fill != null) {
            ooxml.append(this.fill.getOOXML());
        }
        if (this.effect != null) {
            ooxml.append(this.effect.getOOXML());
        }
        if (this.latin != null) {
            ooxml.append("<a:latin typeface=\"" + this.latin + "\"/>");
        }
        if (this.ea != null) {
            ooxml.append("<a:ea typeface=\"" + this.ea + "\"/>");
        }
        if (this.cs != null) {
            ooxml.append("<a:cs typeface=\"" + this.cs + "\"/>");
        }
        ooxml.append("</a:rPr>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new RPr(this);
    }

    public HashMap<String, String> getTextProperties() {
        HashMap<String, String> textprops = new HashMap<String, String>();
        textprops.putAll(this.attrs);
        if (this.latin != null) {
            textprops.put("latin_typeface", this.latin);
        }
        if (this.ea != null) {
            textprops.put("ea_typeface", this.ea);
        }
        if (this.cs != null) {
            textprops.put("cs_typeface", this.cs);
        }
        return textprops;
    }
}

