/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.DefRPr;
import com.extentech.formats.OOXML.EndParaRPr;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.PPr;
import com.extentech.formats.OOXML.TextRun;
import com.extentech.formats.XLS.Font;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class P
implements OOXMLElement {
    private static final long serialVersionUID = 6302706683933521698L;
    private TextRun run = null;
    private PPr ppr = null;
    private EndParaRPr ep = null;

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        PPr ppr = null;
        TextRun run = null;
        EndParaRPr ep = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block7: {
                    String endTag;
                    block5: {
                        String tnm;
                        block8: {
                            block6: {
                                if (eventType != 2) break block5;
                                tnm = xpp.getName();
                                if (!tnm.equals("pPr")) break block6;
                                lastTag.push(tnm);
                                ppr = PPr.parseOOXML(xpp, lastTag, bk);
                                break block7;
                            }
                            if (!tnm.equals("r") && !tnm.equals("br") && !tnm.equals("fld")) break block8;
                            lastTag.push(tnm);
                            run = (TextRun)TextRun.parseOOXML(xpp, lastTag, bk);
                            break block7;
                        }
                        if (!tnm.equals("endParaRPr")) break block7;
                        lastTag.push(tnm);
                        ep = EndParaRPr.parseOOXML(xpp, lastTag, bk);
                        break block7;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("p")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("p.parseOOXML: " + e.toString());
        }
        P pr = new P(ppr, run, ep);
        return pr;
    }

    public P(String s) {
        this.run = new TextRun(s);
        this.ppr = new PPr(new DefRPr(), null);
    }

    public P(PPr ppr, TextRun run, EndParaRPr ep) {
        this.ppr = ppr;
        this.ep = ep;
        this.run = run;
    }

    public P(P p) {
        this.ppr = p.ppr;
        this.ep = p.ep;
        this.run = p.run;
    }

    public P(String fontFace, int sz, boolean b, boolean i, String u, String strike, String clr) {
        this.ppr = new PPr(fontFace, sz, b, i, u, strike, clr);
    }

    public P(Font f, String s) {
        int u = f.getUnderlineStyle();
        String usty = "none";
        switch (u) {
            case 1: {
                usty = "sng";
                break;
            }
            case 2: {
                usty = "dbl";
                break;
            }
            case 33: {
                usty = "sng";
                break;
            }
            case 34: {
                usty = "dbl";
            }
        }
        String strike = f.getStricken() ? "sngStrike" : "noStrike";
        String clr = FormatHandle.colorToHexString(FormatHandle.getColor(f.getColor())).substring(1);
        this.ppr = new PPr(f.getFontName(), (int)f.getFontHeightInPoints() * 100, f.getBold(), f.getItalic(), usty, strike, clr);
        this.run = new TextRun(s);
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:p>");
        if (this.ppr != null) {
            ooxml.append(this.ppr.getOOXML());
        }
        if (this.run != null) {
            ooxml.append(this.run.getOOXML());
        }
        if (this.ep != null) {
            ooxml.append(this.ep.getOOXML());
        }
        ooxml.append("</a:p>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new P(this);
    }

    public String getTitle() {
        if (this.run != null) {
            return this.run.getTitle();
        }
        return "";
    }

    public HashMap<String, String> getTextProperties() {
        HashMap<String, String> textprops = new HashMap<String, String>();
        if (this.ppr != null) {
            textprops.putAll(this.ppr.getTextProperties());
            textprops.putAll(this.ppr.getDefaultTextProperties());
        }
        if (this.run != null) {
            textprops.putAll(this.run.getTextProperties());
        }
        return textprops;
    }
}

