/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class ManualLayout
implements OOXMLElement {
    private static final long serialVersionUID = 6460833211809500902L;
    String[] modes;
    String[] offs;
    String target;

    public ManualLayout(String target, String[] modes, String[] offs) {
        this.modes = modes;
        this.target = target;
        this.offs = offs;
    }

    public ManualLayout(ManualLayout ml) {
        this.modes = ml.modes;
        this.target = ml.target;
        this.offs = ml.offs;
    }

    public static ManualLayout parseOOXML(XmlPullParser xpp, Stack lastTag) {
        String[] modes = new String[4];
        String[] offs = new String[4];
        String target = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block8: {
                    String endTag;
                    block6: {
                        String tnm;
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        block12: {
                                            block11: {
                                                block10: {
                                                    block9: {
                                                        block7: {
                                                            if (eventType != 2) break block6;
                                                            tnm = xpp.getName();
                                                            if (!tnm.equals("manualLayout")) break block7;
                                                            int i = 0;
                                                            while (i < xpp.getAttributeCount()) {
                                                                String n = xpp.getAttributeName(i);
                                                                n.equals("ATTR");
                                                                ++i;
                                                            }
                                                            break block8;
                                                        }
                                                        if (!tnm.equals("layoutTarget")) break block9;
                                                        target = xpp.getAttributeValue(0);
                                                        break block8;
                                                    }
                                                    if (!tnm.equals("xMode")) break block10;
                                                    modes[0] = xpp.getAttributeValue(0);
                                                    break block8;
                                                }
                                                if (!tnm.equals("yMode")) break block11;
                                                modes[1] = xpp.getAttributeValue(0);
                                                break block8;
                                            }
                                            if (!tnm.equals("wMode")) break block12;
                                            modes[2] = xpp.getAttributeValue(0);
                                            break block8;
                                        }
                                        if (!tnm.equals("hMode")) break block13;
                                        modes[3] = xpp.getAttributeValue(0);
                                        break block8;
                                    }
                                    if (!tnm.equals("x")) break block14;
                                    offs[0] = xpp.getAttributeValue(0);
                                    break block8;
                                }
                                if (!tnm.equals("y")) break block15;
                                offs[1] = xpp.getAttributeValue(0);
                                break block8;
                            }
                            if (!tnm.equals("w")) break block16;
                            offs[2] = xpp.getAttributeValue(0);
                            break block8;
                        }
                        if (!tnm.equals("h")) break block8;
                        offs[3] = xpp.getAttributeValue(0);
                        break block8;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("manualLayout")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("manualLayout.parseOOXML: " + e.toString());
        }
        ManualLayout l = new ManualLayout(target, modes, offs);
        return l;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<c:manualLayout>");
        if (this.target != null) {
            ooxml.append("<c:layoutTarget val=\"" + this.target + "\"/>");
        }
        if (this.modes[0] != null) {
            ooxml.append("<c:xMode val=\"" + this.modes[0] + "\"/>");
        }
        if (this.modes[1] != null) {
            ooxml.append("<c:yMode val=\"" + this.modes[1] + "\"/>");
        }
        if (this.modes[2] != null) {
            ooxml.append("<c:wMode val=\"" + this.modes[2] + "\"/>");
        }
        if (this.modes[3] != null) {
            ooxml.append("<c:hMode val=\"" + this.modes[3] + "\"/>");
        }
        if (this.offs[0] != null) {
            ooxml.append("<c:x val=\"" + this.offs[0] + "\"/>");
        }
        if (this.offs[1] != null) {
            ooxml.append("<c:y val=\"" + this.offs[1] + "\"/>");
        }
        if (this.offs[2] != null) {
            ooxml.append("<c:w val=\"" + this.offs[2] + "\"/>");
        }
        if (this.offs[3] != null) {
            ooxml.append("<c:h val=\"" + this.offs[3] + "\"/>");
        }
        ooxml.append("</c:manualLayout>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new ManualLayout(this);
    }
}

