/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.DashGroup;
import com.extentech.formats.OOXML.FillGroup;
import com.extentech.formats.OOXML.HeadEnd;
import com.extentech.formats.OOXML.JoinGroup;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.PrstDash;
import com.extentech.formats.OOXML.SolidFill;
import com.extentech.formats.OOXML.TailEnd;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class Ln
implements OOXMLElement {
    private static final long serialVersionUID = -161619607936083688L;
    private HashMap<String, String> attrs = null;
    private FillGroup fill = null;
    private JoinGroup join = null;
    private DashGroup dash = null;
    private HeadEnd h = null;
    private TailEnd t = null;

    public Ln(int w, String clr) {
        this.fill = new FillGroup(null, null, null, null, new SolidFill(clr));
        this.dash = new DashGroup(new PrstDash("solid"));
        this.setWidth(w);
    }

    public Ln() {
        this.fill = new FillGroup(null, null, null, null, new SolidFill());
        this.join = new JoinGroup("800000", true, false, false);
        this.h = new HeadEnd();
        this.t = new TailEnd();
    }

    public Ln(HashMap<String, String> attrs, FillGroup fill, JoinGroup join, DashGroup dash, HeadEnd h, TailEnd t) {
        this.attrs = attrs;
        this.fill = fill;
        this.join = join;
        this.dash = dash;
        this.t = t;
        this.h = h;
    }

    public Ln(Ln l) {
        this.attrs = l.attrs;
        this.fill = l.fill;
        this.join = l.join;
        this.dash = l.dash;
        this.t = l.t;
        this.h = l.h;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        FillGroup fill = null;
        JoinGroup join = null;
        DashGroup dash = null;
        HeadEnd h = null;
        TailEnd t = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block8: {
                    String endTag;
                    block6: {
                        String tnm;
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block7: {
                                            if (eventType != 2) break block6;
                                            tnm = xpp.getName();
                                            if (!tnm.equals("ln")) break block7;
                                            int i = 0;
                                            while (i < xpp.getAttributeCount()) {
                                                attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                                                ++i;
                                            }
                                            break block8;
                                        }
                                        if (!tnm.equals("noFill") && !tnm.equals("solidFill") && !tnm.equals("pattFill") && !tnm.equals("gradFill")) break block9;
                                        lastTag.push(tnm);
                                        fill = (FillGroup)FillGroup.parseOOXML(xpp, lastTag, bk);
                                        break block8;
                                    }
                                    if (!tnm.equals("bevel") && !tnm.equals("round") && !tnm.equals("miter")) break block10;
                                    lastTag.push(tnm);
                                    join = JoinGroup.parseOOXML(xpp, lastTag);
                                    break block8;
                                }
                                if (!tnm.equals("prstDash") && !tnm.equals("custDash")) break block11;
                                lastTag.push(tnm);
                                dash = DashGroup.parseOOXML(xpp, lastTag);
                                break block8;
                            }
                            if (!tnm.equals("headEnd")) break block12;
                            lastTag.push(tnm);
                            h = HeadEnd.parseOOXML(xpp, lastTag);
                            break block8;
                        }
                        if (!tnm.equals("tailEnd")) break block8;
                        lastTag.push(tnm);
                        t = TailEnd.parseOOXML(xpp, lastTag);
                        break block8;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("ln")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("ln.parseOOXML: " + e.toString());
        }
        Ln l = new Ln(attrs, fill, join, dash, h, t);
        return l;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:ln");
        for (String key : this.attrs.keySet()) {
            String val = this.attrs.get(key);
            ooxml.append(" " + key + "=\"" + val + "\"");
        }
        ooxml.append(">");
        if (this.fill != null) {
            ooxml.append(this.fill.getOOXML());
        }
        if (this.dash != null) {
            ooxml.append(this.dash.getOOXML());
        }
        if (this.join != null) {
            ooxml.append(this.join.getOOXML());
        }
        if (this.h != null) {
            ooxml.append(this.h.getOOXML());
        }
        if (this.t != null) {
            ooxml.append(this.t.getOOXML());
        }
        ooxml.append("</a:ln>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Ln(this);
    }

    public void setWidth(int w) {
        if (this.attrs == null) {
            this.attrs = new HashMap();
        }
        this.attrs.put("w", String.valueOf(w));
    }

    public int getWidth() {
        if (this.attrs != null && this.attrs.get("w") != null) {
            return Integer.valueOf(this.attrs.get("w")) / 12700;
        }
        return 0;
    }

    public int getColor() {
        if (this.fill == null) {
            return -1;
        }
        return this.fill.getColor();
    }

    public void setColor(String clr) {
        if (this.fill == null) {
            this.fill = new FillGroup(null, null, null, null, new SolidFill());
        }
        this.fill.setColor(clr);
    }

    public int getLineStyle() {
        if (this.dash != null) {
            String style = this.dash.getPresetDashingScheme();
            if (style.equals("solid")) {
                return 0;
            }
            if (style.equals("dash") || style.equals("sysDash") || style.equals("lgDash")) {
                return 1;
            }
            if (style.equals("sysDot")) {
                return 2;
            }
            if (style.equals("dashDot") || style.equals("sysDashDot") || style.equals("lgDashDot")) {
                return 3;
            }
            if (style.equals("sysDashDashDot") || style.equals("lgDashDotDot")) {
                return 4;
            }
        }
        return 0;
    }
}

