/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.HSLColor;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.Theme;
import com.extentech.toolkit.Logger;
import org.xmlpull.v1.XmlPullParser;

public class Color
implements OOXMLElement {
    private static final long serialVersionUID = 2546003092245407502L;
    private boolean auto = false;
    public static int COLORTYPEINDEXED = 0;
    public static int COLORTYPERGB = 1;
    public static int COLORTYPETHEME = 2;
    private int colortype = -1;
    private String colorval = null;
    private double tint = 0.0;
    private String element = null;
    private int colorint = -1;
    private String colorstr = null;
    private Theme theme = null;

    public Color() {
    }

    public Color(String element, boolean auto, int colortype, String colorval, double tint, short type, Theme t) {
        this.element = element;
        this.auto = auto;
        this.colortype = colortype;
        this.colorval = colorval;
        this.tint = tint;
        this.theme = t;
        this.parseColor(type);
    }

    public Color(Color c) {
        this.element = c.element;
        this.auto = c.auto;
        this.colortype = c.colortype;
        this.colorval = c.colorval;
        this.tint = c.tint;
        this.colorint = c.colorint;
        this.colorstr = c.colorstr;
        this.theme = c.theme;
    }

    public Color(java.awt.Color c, String element, Theme t) {
        this.colortype = COLORTYPERGB;
        this.colorval = "FF" + FormatHandle.colorToHexString(c).substring(1);
        this.element = element;
        this.theme = t;
        this.parseColor((short)0);
    }

    public Color(String clr, String element, Theme t) {
        this.colortype = COLORTYPERGB;
        this.colorval = clr.startsWith("#") ? "FF" + clr.substring(1) : (clr.length() == 6 ? "FF" + clr : clr);
        this.element = element;
        this.theme = t;
        this.parseColor((short)0);
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, short type, WorkBookHandle bk) {
        String element = null;
        boolean auto = false;
        int colortype = -1;
        String colorval = null;
        double tint = 0.0;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("color") || tnm.equals("fgColor") || tnm.equals("bgColor")) {
                        element = tnm;
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String n = xpp.getAttributeName(i);
                            String val = xpp.getAttributeValue(i);
                            if (n.equals("auto")) {
                                auto = true;
                            } else if (n.equals("indexed")) {
                                colortype = COLORTYPEINDEXED;
                                colorval = val;
                            } else if (n.equals("rgb")) {
                                colortype = COLORTYPERGB;
                                colorval = val;
                            } else if (n.equals("theme")) {
                                colortype = COLORTYPETHEME;
                                colorval = val;
                            } else if (n.equals("tint")) {
                                tint = new Double(val);
                            }
                            ++i;
                        }
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals(element)) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("color.parseOOXML: " + e.toString());
        }
        Color c = new Color(element, auto, colortype, colorval, tint, type, bk.getWorkBook().getTheme());
        return c;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<" + this.element);
        if (this.auto) {
            ooxml.append(" auto=\"1\"");
        } else if (this.colortype == COLORTYPERGB) {
            ooxml.append(" rgb=\"" + this.colorstr + "\"");
        } else if (this.colortype == COLORTYPEINDEXED) {
            ooxml.append(" indexed=\"" + this.colorval + "\"");
        } else if (this.colortype == COLORTYPETHEME) {
            ooxml.append(" theme=\"" + this.colorval + "\"");
        }
        if (this.tint != 0.0) {
            ooxml.append(" tint=\"" + this.tint + "\"");
        }
        ooxml.append("/>");
        return ooxml.toString();
    }

    public static String getOOXML(String element, int colortype, int colorval, String colorstr, double tint) {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<" + element);
        if (colortype == COLORTYPERGB) {
            ooxml.append(" rgb=\"" + colorstr + "\"");
        } else if (colortype == COLORTYPEINDEXED) {
            ooxml.append(" indexed=\"" + colorval + "\"");
        } else if (colortype == COLORTYPETHEME) {
            ooxml.append(" theme=\"" + colorval + "\"");
        }
        if (tint != 0.0) {
            ooxml.append(" tint=\"" + tint + "\"");
        }
        ooxml.append("/>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Color(this);
    }

    public String toString() {
        String ret = "";
        if (this.colortype == COLORTYPERGB) {
            ret = " rgb=" + this.colorstr;
        } else if (this.colortype == COLORTYPEINDEXED) {
            ret = " indexed=" + this.colorval;
        } else if (this.colortype == COLORTYPETHEME) {
            ret = " theme=" + this.colorval;
        }
        if (this.tint != 0.0) {
            ret = " tint=" + this.tint;
        }
        return ret;
    }

    public int getColorInt() {
        return this.colorint;
    }

    public int getColorType() {
        return this.colortype;
    }

    public String getColorAsOOXMLRBG() {
        return this.colorstr;
    }

    public java.awt.Color getColorAsColor() {
        return FormatHandle.HexStringToColor(this.getColorAsOOXMLRBG());
    }

    public void setColorInt(int clr) {
        this.colorint = clr;
        this.colortype = 0;
        this.colorstr = clr > -1 ? FormatHandle.colorToHexString(FormatHandle.COLORTABLE[clr]).substring(1) : null;
        this.tint = 0.0;
        this.auto = false;
    }

    public void setColor(java.awt.Color c) {
        this.colortype = COLORTYPERGB;
        this.colorval = "FF" + FormatHandle.colorToHexString(c).substring(1);
        this.parseColor((short)0);
        this.tint = 0.0;
        this.auto = false;
    }

    public void setColor(String clr) {
        this.colortype = COLORTYPERGB;
        this.colorval = clr.startsWith("#") ? "FF" + clr.substring(1) : (clr.length() == 6 ? "FF" + clr : clr);
        this.parseColor((short)0);
    }

    public static String parseColor(String val, int colortype, short type, Theme t) {
        Color c = new Color("", false, colortype, val, 0.0, type, t);
        return c.colorstr;
    }

    public static int parseColorInt(String val, int colortype, short type, Theme t) {
        Color c = new Color("", false, colortype, val, 0.0, type, t);
        return c.colorint;
    }

    private void parseColor(short type) {
        try {
            if (this.colortype == COLORTYPERGB) {
                this.colorint = FormatHandle.HexStringToColorInt(this.colorval, type);
                this.colorstr = this.colorval;
            } else if (this.colortype == COLORTYPEINDEXED) {
                this.colorint = Integer.valueOf(this.colorval);
                this.colorstr = this.colorint == 64 && type == FormatHandle.colorFONT ? FormatHandle.colorToHexString(FormatHandle.getColor(0)) : FormatHandle.colorToHexString(FormatHandle.getColor(this.colorint));
            } else if (this.colortype == COLORTYPETHEME) {
                Object[] o = Color.parseThemeColor(this.colorval, this.tint, type, this.theme);
                this.colorint = (Integer)o[0];
                this.colorstr = (String)o[1];
            }
        }
        catch (Exception e) {
            Logger.logWarn("color.parseColor: " + this.colortype + ":" + this.colorval + ": " + e.toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Object[] parseThemeColor(String colorval, double tint, short type, Theme t) {
        block6: {
            themeColors = new String[][]{{"dk1", "000000"}, {"lt1", "FFFFFF"}, {"dk2", "1F497D"}, {"lt2", "EEECE1"}, {"accent1", "4F81BD"}, {"accent1", "C0504D"}, {"accent3", "9BBB59"}, {"accent4", "8064A2"}, {"accent5", "4BACC6"}, {"accent6", "F79646"}, {"hlink", "0000FF"}, {"folHlink", "800080"}};
            o = new Object[2];
            i = 0;
            clr = "";
            try {
                i = Integer.valueOf(colorval);
                clr = t.genericThemeClrs[i];
                break block6;
            }
            catch (Exception e) {
                i = 0;
                ** while (i < themeColors.length)
            }
lbl-1000:
            // 1 sources

            {
                if (themeColors[i][0].equals(colorval)) {
                    clr = themeColors[i][1];
                    break;
                }
                ++i;
                continue;
            }
        }
        if (Math.abs(tint) > 0.005) {
            c = Color.applyTint(tint, clr);
            o[0] = FormatHandle.getColorInt(c);
            o[1] = FormatHandle.colorToHexString(c).substring(1);
        } else {
            o[0] = FormatHandle.HexStringToColorInt("#" + clr, type);
            o[1] = "#" + clr;
        }
        return o;
    }

    private static java.awt.Color applyTint(double tint, String clr) {
        int HLSMAX = 255;
        int r2 = Integer.parseInt(clr.substring(0, 2), 16);
        int g = Integer.parseInt(clr.substring(2, 4), 16);
        int b = Integer.parseInt(clr.substring(4, 6), 16);
        HSLColor hsl = new HSLColor();
        hsl.initHSLbyRGB(r2, g, b);
        double l = hsl.getLuminence();
        l = tint < 0.0 ? (l *= 1.0 + tint) : l * (1.0 - tint) + (255.0 - 255.0 * (1.0 - tint));
        l = Math.round(l);
        hsl.initRGBbyHSL(hsl.getHue(), hsl.getSaturation(), new Double(l).intValue());
        return new java.awt.Color(hsl.getRed(), hsl.getGreen(), hsl.getBlue());
    }
}

