/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.BorderElement;
import com.extentech.formats.OOXML.OOXMLConstants;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.XLS.Xf;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;

public class Border
implements OOXMLElement {
    private static final long serialVersionUID = 4340789910636828223L;
    private HashMap<String, String> attrs = null;
    private HashMap<String, BorderElement> borderElements = null;

    public Border() {
    }

    public Border(HashMap<String, String> attrs, HashMap<String, BorderElement> borderElements) {
        this.attrs = attrs;
        this.borderElements = borderElements;
    }

    public Border(Border b) {
        this.attrs = b.attrs;
        this.borderElements = b.borderElements;
    }

    public Border(WorkBookHandle bk, int[] styles, int[] colors) {
        this.borderElements = new HashMap();
        String[] borderElements = new String[]{"top", "left", "bottom", "right"};
        int i = 0;
        while (i < 4) {
            if (styles[i] > 0) {
                String style = OOXMLConstants.borderStyle[styles[i]];
                this.borderElements.put(borderElements[i], new BorderElement(style, colors[i], borderElements[i], bk));
            }
            ++i;
        }
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, WorkBookHandle bk) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        HashMap<String, BorderElement> borderElements = new HashMap<String, BorderElement>();
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("border")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                            ++i;
                        }
                    } else if (tnm.equals("left")) {
                        borderElements.put("left", BorderElement.parseOOXML(xpp, bk));
                    } else if (tnm.equals("right")) {
                        borderElements.put("right", BorderElement.parseOOXML(xpp, bk));
                    } else if (tnm.equals("top")) {
                        borderElements.put("top", BorderElement.parseOOXML(xpp, bk));
                    } else if (tnm.equals("bottom")) {
                        borderElements.put("bottom", BorderElement.parseOOXML(xpp, bk));
                    } else if (tnm.equals("diagonal")) {
                        borderElements.put("diagonal", BorderElement.parseOOXML(xpp, bk));
                    } else if (tnm.equals("vertical")) {
                        borderElements.put("vertical", BorderElement.parseOOXML(xpp, bk));
                    } else if (tnm.equals("horizontal")) {
                        borderElements.put("horizontal", BorderElement.parseOOXML(xpp, bk));
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("border")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("border.parseOOXML: " + e.toString());
        }
        Border b = new Border(attrs, borderElements);
        return b;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<border");
        if (this.attrs != null) {
            for (String key : this.attrs.keySet()) {
                String val = this.attrs.get(key);
                ooxml.append(" " + key + "=\"" + val + "\"");
            }
        }
        ooxml.append(">");
        if (this.borderElements.get("left") != null) {
            ooxml.append(this.borderElements.get("left").getOOXML());
        }
        if (this.borderElements.get("right") != null) {
            ooxml.append(this.borderElements.get("right").getOOXML());
        }
        if (this.borderElements.get("top") != null) {
            ooxml.append(this.borderElements.get("top").getOOXML());
        }
        if (this.borderElements.get("bottom") != null) {
            ooxml.append(this.borderElements.get("bottom").getOOXML());
        }
        if (this.borderElements.get("diagonal") != null) {
            ooxml.append(this.borderElements.get("diagonal").getOOXML());
        }
        if (this.borderElements.get("vertical") != null) {
            ooxml.append(this.borderElements.get("vertical").getOOXML());
        }
        if (this.borderElements.get("horizontal") != null) {
            ooxml.append(this.borderElements.get("horizontal").getOOXML());
        }
        ooxml.append("</border>");
        return ooxml.toString();
    }

    public int[] getBorderSizes() {
        int[] sizes = new int[5];
        if (this.borderElements.get("top") != null) {
            sizes[0] = this.borderElements.get("top").getBorderSize();
        }
        if (this.borderElements.get("left") != null) {
            sizes[1] = this.borderElements.get("left").getBorderSize();
        }
        if (this.borderElements.get("bottom") != null) {
            sizes[2] = this.borderElements.get("bottom").getBorderSize();
        }
        if (this.borderElements.get("right") != null) {
            sizes[3] = this.borderElements.get("right").getBorderSize();
        }
        if (this.borderElements.get("diagonal") != null) {
            sizes[4] = this.borderElements.get("diagonal").getBorderSize();
        }
        return sizes;
    }

    public int[] getBorderStyles() {
        int[] styles = new int[5];
        if (this.borderElements.get("top") != null) {
            styles[0] = this.borderElements.get("top").getBorderStyle();
        }
        if (this.borderElements.get("left") != null) {
            styles[1] = this.borderElements.get("left").getBorderStyle();
        }
        if (this.borderElements.get("bottom") != null) {
            styles[2] = this.borderElements.get("bottom").getBorderStyle();
        }
        if (this.borderElements.get("right") != null) {
            styles[3] = this.borderElements.get("right").getBorderStyle();
        }
        if (this.borderElements.get("diagonal") != null) {
            styles[4] = this.borderElements.get("diagonal").getBorderStyle();
        }
        return styles;
    }

    public String[] getBorderColors() {
        try {
            String[] clrs = new String[5];
            if (this.borderElements.get("top") != null) {
                clrs[0] = this.borderElements.get("top").getBorderColor();
            }
            if (this.borderElements.get("left") != null) {
                clrs[1] = this.borderElements.get("left").getBorderColor();
            }
            if (this.borderElements.get("bottom") != null) {
                clrs[2] = this.borderElements.get("bottom").getBorderColor();
            }
            if (this.borderElements.get("right") != null) {
                clrs[3] = this.borderElements.get("right").getBorderColor();
            }
            if (this.borderElements.get("diagonal") != null) {
                clrs[4] = this.borderElements.get("diagonal").getBorderColor();
            }
            return clrs;
        }
        catch (NullPointerException e) {
            return new String[5];
        }
    }

    public int[] getBorderColorInts() {
        try {
            int[] clrs = new int[5];
            if (this.borderElements.get("top") != null) {
                clrs[0] = this.borderElements.get("top").getBorderColorInt();
            }
            if (this.borderElements.get("left") != null) {
                clrs[1] = this.borderElements.get("left").getBorderColorInt();
            }
            if (this.borderElements.get("bottom") != null) {
                clrs[2] = this.borderElements.get("bottom").getBorderColorInt();
            }
            if (this.borderElements.get("right") != null) {
                clrs[3] = this.borderElements.get("right").getBorderColorInt();
            }
            if (this.borderElements.get("diagonal") != null) {
                clrs[4] = this.borderElements.get("diagonal").getBorderColorInt();
            }
            return clrs;
        }
        catch (NullPointerException e) {
            return new int[5];
        }
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Border(this);
    }

    public String toString() {
        if (this.borderElements != null) {
            return this.borderElements.toString();
        }
        return "<none>";
    }

    public static String getOOXML(Xf xf) {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<border>");
        int[] lineStyles = new int[]{xf.getLeftBorderLineStyle(), xf.getRightBorderLineStyle(), xf.getTopBorderLineStyle(), xf.getBottomBorderLineStyle(), xf.getDiagBorderLineStyle()};
        int[] colors = new int[]{xf.getLeftBorderColor(), xf.getRightBorderColor(), xf.getTopBorderColor(), xf.getBottomBorderColor(), xf.getDiagBorderColor()};
        if (lineStyles[0] > 0) {
            ooxml.append("<left");
            ooxml.append(" style=\"" + OOXMLConstants.borderStyle[lineStyles[0]] + "\"");
            if (colors[0] > 0) {
                ooxml.append("><color rgb=\"" + FormatHandle.colorToHexString(FormatHandle.COLORTABLE[colors[0]]).substring(1) + "\"/></left>");
            } else {
                ooxml.append("/>");
            }
        }
        if (lineStyles[1] > 0) {
            ooxml.append("<right");
            ooxml.append(" style=\"" + OOXMLConstants.borderStyle[lineStyles[1]] + "\"");
            if (colors[1] > 0) {
                ooxml.append("><color rgb=\"" + FormatHandle.colorToHexString(FormatHandle.COLORTABLE[colors[1]]).substring(1) + "\"/></right>");
            } else {
                ooxml.append("/>");
            }
        }
        if (lineStyles[2] > 0) {
            ooxml.append("<top");
            ooxml.append(" style=\"" + OOXMLConstants.borderStyle[lineStyles[2]] + "\"");
            if (colors[2] > 0) {
                ooxml.append("><color rgb=\"" + FormatHandle.colorToHexString(FormatHandle.COLORTABLE[colors[2]]).substring(1) + "\"/></top>");
            } else {
                ooxml.append("/>");
            }
        }
        if (lineStyles[3] > 0) {
            ooxml.append("<bottom");
            ooxml.append(" style=\"" + OOXMLConstants.borderStyle[lineStyles[3]] + "\"");
            if (colors[3] > 0) {
                ooxml.append("><color rgb=\"" + FormatHandle.colorToHexString(FormatHandle.COLORTABLE[colors[3]]).substring(1) + "\"/></bottom>");
            } else {
                ooxml.append("/>");
            }
        }
        if (lineStyles[4] > 0) {
            ooxml.append("<diagonal");
            ooxml.append(" style=\"" + OOXMLConstants.borderStyle[lineStyles[4]] + "\"");
            if (colors[4] > 0) {
                ooxml.append("><color rgb=\"" + FormatHandle.colorToHexString(FormatHandle.COLORTABLE[colors[4]]).substring(1) + "\"/></diagonal>");
            } else {
                ooxml.append("/>");
            }
        }
        ooxml.append("</border>");
        return ooxml.toString();
    }

    public static String getOOXML(int[] styles, int[] colors) {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<border>");
        if (styles[0] > 0) {
            ooxml.append("<left");
            ooxml.append(" style=\"" + OOXMLConstants.borderStyle[styles[1]] + "\"");
            if (colors[0] > 0) {
                ooxml.append("><color rgb=\"" + FormatHandle.colorToHexString(FormatHandle.COLORTABLE[colors[0]]).substring(1) + "\"/></left>");
            } else {
                ooxml.append("/>");
            }
        }
        if (styles[1] > 0) {
            ooxml.append("<right");
            ooxml.append(" style=\"" + OOXMLConstants.borderStyle[styles[3]] + "\"");
            if (colors[1] > 0) {
                ooxml.append("><color rgb=\"" + FormatHandle.colorToHexString(FormatHandle.COLORTABLE[colors[1]]).substring(1) + "\"/></right>");
            } else {
                ooxml.append("/>");
            }
        }
        if (styles[2] > 0) {
            ooxml.append("<top");
            ooxml.append(" style=\"" + OOXMLConstants.borderStyle[styles[0]] + "\"");
            if (colors[2] > 0) {
                ooxml.append("><color rgb=\"" + FormatHandle.colorToHexString(FormatHandle.COLORTABLE[colors[2]]).substring(1) + "\"/></top>");
            } else {
                ooxml.append("/>");
            }
        }
        if (styles[3] > 0) {
            ooxml.append("<bottom");
            ooxml.append(" style=\"" + OOXMLConstants.borderStyle[styles[2]] + "\"");
            if (colors[3] > 0) {
                ooxml.append("><color rgb=\"" + FormatHandle.colorToHexString(FormatHandle.COLORTABLE[colors[3]]).substring(1) + "\"/></top>");
            } else {
                ooxml.append("/>");
            }
        }
        if (styles[4] > 0) {
            ooxml.append("<diagonal");
            ooxml.append(" style=\"" + OOXMLConstants.borderStyle[styles[4]] + "\"");
            if (colors[4] > 0) {
                ooxml.append("><color rgb=\"" + FormatHandle.colorToHexString(FormatHandle.COLORTABLE[colors[4]]).substring(1) + "\"/></diagonal>");
            } else {
                ooxml.append("/>");
            }
        }
        ooxml.append("</border>");
        return ooxml.toString();
    }
}

