/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class Blip
implements OOXMLElement {
    private static final long serialVersionUID = 5188967633123620513L;
    private HashMap<String, String> attrs = new HashMap();

    public Blip() {
    }

    public Blip(HashMap<String, String> attrs) {
        this.attrs = attrs;
    }

    public Blip(Blip b) {
        this.attrs = b.attrs;
    }

    public static Blip parseOOXML(XmlPullParser xpp, Stack<String> lastTag) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("blip")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            if (xpp.getAttributePrefix(i) != null) {
                                attrs.put(String.valueOf(xpp.getAttributePrefix(i)) + ":" + xpp.getAttributeName(i), xpp.getAttributeValue(i));
                            } else {
                                attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                            }
                            ++i;
                        }
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("blip")) {
                    lastTag.pop();
                    break;
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("blip.parseOOXML: " + e.toString());
        }
        Blip b = new Blip(attrs);
        return b;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:blip xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" ");
        for (String key : this.attrs.keySet()) {
            String val = this.attrs.get(key);
            ooxml.append(" " + key + "=\"" + val + "\"");
        }
        ooxml.append("/>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Blip(this);
    }

    public String getEmbed() {
        if (this.attrs != null && this.attrs.get("r:embed") != null) {
            return this.attrs.get("r:embed");
        }
        return null;
    }

    public String getLink() {
        if (this.attrs != null && this.attrs.get("link") != null) {
            return this.attrs.get("link");
        }
        return null;
    }

    public void setEmbed(String embed) {
        this.attrs.put("r:embed", embed);
    }

    public void setLink(String link) {
        this.attrs.put("link", link);
    }
}

