/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.LEO;

import com.extentech.formats.LEO.BIGBLOCK;
import com.extentech.formats.LEO.Block;
import com.extentech.formats.LEO.BlockByteReader;
import com.extentech.formats.LEO.BlockFactory;
import com.extentech.formats.LEO.InvalidFileException;
import com.extentech.formats.LEO.LEOFile;
import com.extentech.formats.LEO.LEOHeader;
import com.extentech.formats.LEO.LEOIndexingException;
import com.extentech.formats.LEO.RootStorage;
import com.extentech.formats.LEO.SMALLBLOCK;
import com.extentech.formats.LEO.Storage;
import com.extentech.formats.LEO.StorageNotFoundException;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.WorkBookException;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.XLSRecordFactory;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class StorageTable
implements Serializable {
    private static final long serialVersionUID = 3399830613453524580L;
    public static final int TABLE_SIZE = 512;
    public static final int DIRECTORY_SIZE = 128;
    public static final int BIGSTORAGE_SIZE = 4096;
    private LEOHeader myheader;
    CompatibleVector directoryVector = new CompatibleVector();
    Hashtable directoryHashtable = new Hashtable(100, 0.9f);
    private int dupct = 0;
    int[] miniFAT = null;

    public void close() {
        this.myheader = null;
        Iterator ii = this.directoryHashtable.keySet().iterator();
        while (ii.hasNext()) {
            Storage s = (Storage)this.directoryHashtable.get(ii.next());
            s.close();
        }
        this.directoryHashtable = new Hashtable(100, 0.9f);
        int i = 0;
        while (i < this.directoryVector.size()) {
            Storage s = (Storage)this.directoryVector.get(i);
            s.close();
            ++i;
        }
        this.directoryVector.clear();
    }

    public void init(ByteBuffer dta, LEOHeader h, List blockvect, int[] FAT) {
        this.myheader = h;
        byte[] data = LEOFile.getBytes(this.initDirectoryStream(blockvect, FAT));
        int psbsize = data.length;
        int numRecs = psbsize / 128;
        int pos = 0;
        int i = 0;
        while (i < numRecs) {
            ByteBuffer b = ByteBuffer.allocate(128);
            b.order(ByteOrder.LITTLE_ENDIAN);
            b.put(data, pos, 128);
            pos += 128;
            Storage rec = null;
            try {
                rec = new Storage(b);
            }
            catch (Exception ex) {
                throw new WorkBookException("StorageTable.init failed:" + ex.toString(), 3);
            }
            if (i == 0 && !(rec = new RootStorage(b)).getName().equals("Root Entry")) {
                rec.setName("Root Entry");
            }
            this.addStorage(rec, -1);
            ++i;
        }
    }

    public int getNumDirectories() {
        return this.directoryVector.size();
    }

    public Storage createStorage(String name, int type, int insertIdx) {
        Storage s = null;
        try {
            ByteBuffer b = ByteBuffer.allocate(128);
            b.order(ByteOrder.LITTLE_ENDIAN);
            b.put(new byte[128]);
            s = new Storage(b);
            s.setName(name);
            s.setStorageType(type);
            s.setBlocks(new Block[0]);
            s.setPrevStorageID(-1);
            s.setNextStorageID(-1);
            s.setChildStorageID(-1);
            this.addStorage(s, insertIdx);
        }
        catch (Exception ex) {
            throw new WorkBookException("Storage.createStorage failed:" + ex.toString(), 3);
        }
        return s;
    }

    public void initDirectories(List blockvect, int[] FAT) {
        Enumeration rcs = this.directoryVector.elements();
        List miniStream = null;
        int totrecsize = 0;
        while (rcs.hasMoreElements()) {
            Storage rec = (Storage)rcs.nextElement();
            String name = rec.getName();
            int recsize = rec.getActualFileSize();
            totrecsize += recsize;
            if (name.equals("Root Entry")) {
                miniStream = this.initMiniStream(blockvect, FAT);
                continue;
            }
            if (recsize > 0 && recsize < 4096) {
                rec.setBlockType(0);
                this.initStorage(rec, miniStream, this.miniFAT, 0);
                continue;
            }
            if (recsize >= 4096) {
                this.initStorage(rec, blockvect, FAT, 1);
                continue;
            }
            if (recsize != 0) continue;
            rec.setBlocks(new Block[0]);
        }
    }

    public List initMiniStream(List blockvect, int[] FAT) {
        int pos = this.myheader.getMiniFATStart();
        if (pos == -2) {
            return null;
        }
        List miniFATSectors = this.getMiniFAT(pos, blockvect, FAT);
        if (miniFATSectors.size() > 0) {
            try {
                RootStorage rootStore;
                for (BIGBLOCK sbb : miniFATSectors) {
                    sbb.setIsDepotBlock(true);
                }
                this.miniFAT = LEOFile.readFAT(miniFATSectors);
                try {
                    rootStore = (RootStorage)this.getDirectoryByName("Root Entry");
                }
                catch (StorageNotFoundException e) {
                    throw new InvalidFileException("Error parsing OLE File. OLE FileSystem Out of Spec: No Root Entry.");
                }
                int miniStreamStart = rootStore.getStartBlock();
                int miniStreamSize = rootStore.getActualFileSize();
                Storage miniStream = new Storage();
                miniStream.setStartBlock(miniStreamStart);
                miniStream.setActualFileSize(miniStreamSize);
                miniStream.setName("miniStream");
                this.initStorage(miniStream, blockvect, FAT, 1);
                byte[] b = new byte[miniStreamSize];
                System.arraycopy(miniStream.getBytes(), 0, b, 0, miniStreamSize);
                Block[] miniStreamBlocks = BlockFactory.getBlocksFromByteArray(b, 0);
                ArrayList<Block> miniStreamBlockList = new ArrayList<Block>();
                int i = 0;
                while (i < miniStreamBlocks.length) {
                    miniStreamBlockList.add(miniStreamBlocks[i]);
                    ++i;
                }
                return miniStreamBlockList;
            }
            catch (LEOIndexingException e) {
                Logger.logWarn("initSBStorages: Error obtaining sbdIdx");
            }
        }
        return null;
    }

    private List getMiniFAT(int pos, List blockvect, int[] FAT) {
        Storage miniFATContainer = null;
        miniFATContainer = new Storage();
        miniFATContainer.setBlockType(1);
        miniFATContainer.setStartBlock(pos);
        miniFATContainer.setStorageType(5);
        miniFATContainer.init(blockvect, FAT, true);
        return miniFATContainer.getBlockVect();
    }

    void addStorage(Storage rec, int insertIdx) {
        String nm = rec.getName();
        if (this.directoryHashtable.get(nm) != null) {
            nm.equals("");
        }
        this.directoryHashtable.put(rec.getName(), rec);
        if (insertIdx == -1) {
            this.directoryVector.add(rec);
        } else {
            this.directoryVector.add(insertIdx, rec);
            int i = 0;
            while (i < this.directoryVector.size()) {
                Storage s = (Storage)this.directoryVector.get(i);
                if (s.getChildStorageID() >= insertIdx) {
                    s.setChildStorageID(s.getChildStorageID() + 1);
                }
                if (s.getPrevStorageID() >= insertIdx) {
                    s.setPrevStorageID(s.getPrevStorageID() + 1);
                }
                if (s.getNextStorageID() >= insertIdx) {
                    s.setNextStorageID(s.getNextStorageID() + 1);
                }
                ++i;
            }
        }
    }

    void removeStorage(Storage st) {
        this.directoryHashtable.remove(st);
        this.directoryVector.remove(st);
    }

    void initStorage(Storage rec, List sourceblocks, int[] idx, int blocktype) {
        String name = rec.getName();
        int recsize = rec.getActualFileSize();
        rec.setBlockType(blocktype);
        if ("Root Entry".equals(name)) {
            return;
        }
        if (rec.getBlockType() == 1) {
            rec.init(sourceblocks, idx, false);
        } else if (rec.getBlockType() == 0) {
            rec.initFromMiniStream(sourceblocks, idx);
        }
        rec.idxs = null;
    }

    List initDirectoryStream(List blockvect, int[] FAT) {
        Storage directories = null;
        directories = new Storage();
        int pstart = this.myheader.getRootStartPos() / 512 - 1;
        directories.setStartBlock(pstart);
        directories.setBlockType(1);
        directories.setStorageType(5);
        directories.init(blockvect, FAT, true);
        return directories.getBlockVect();
    }

    byte[] rebuildRootStore() {
        while (this.directoryVector.size() % 4 != 0) {
            this.createStorage("", 0, -1);
        }
        Enumeration e = this.directoryVector.elements();
        byte[] bytebuff = new byte[this.directoryVector.size() * 128];
        int pos = 0;
        while (e.hasMoreElements()) {
            Storage s = (Storage)e.nextElement();
            ByteBuffer buff = this.getDirectoryHeaderBytes(s);
            System.arraycopy(buff.array(), 0, bytebuff, pos, 128);
            pos += 128;
        }
        return bytebuff;
    }

    Hashtable getStorageHash() {
        return this.directoryHashtable;
    }

    CompatibleVector getAllDirectories() {
        return this.directoryVector;
    }

    RootStorage getRootStorage() throws StorageNotFoundException {
        return (RootStorage)this.getDirectoryByName("Root Entry");
    }

    public Storage getDirectoryByName(String name) throws StorageNotFoundException {
        if (this.directoryHashtable.get(name) != null) {
            return (Storage)this.directoryHashtable.get(name);
        }
        throw new StorageNotFoundException("Storage: " + name + " not located");
    }

    public int getDirectoryStreamID(String name) throws StorageNotFoundException {
        int i = 0;
        while (i < this.directoryVector.size()) {
            Storage s = (Storage)this.directoryVector.get(i);
            if (s.getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Storage getChild(String name) throws StorageNotFoundException {
        int child;
        Storage s = this.getDirectoryByName(name);
        if (s != null && (child = s.getChildStorageID()) > -1) {
            return (Storage)this.directoryVector.get(child);
        }
        return null;
    }

    public Storage getNext(String name) throws StorageNotFoundException {
        int next;
        Storage s = this.getDirectoryByName(name);
        if (s != null && (next = s.getNextStorageID()) > -1) {
            return (Storage)this.directoryVector.get(next);
        }
        return null;
    }

    public Storage getPrevious(String name) throws StorageNotFoundException {
        int prev;
        Storage s = this.getDirectoryByName(name);
        if (s != null && (prev = s.getNextStorageID()) > -1) {
            return (Storage)this.directoryVector.get(prev);
        }
        return null;
    }

    ByteBuffer getDirectoryHeaderBytes(Storage thisStorage) {
        ByteBuffer buff = null;
        buff = thisStorage.getHeaderData();
        return buff;
    }

    public static final void writeitout(List blocks, String name) {
        try {
            FileOutputStream fos = new FileOutputStream(new File(String.valueOf(System.getProperty("user.dir")) + "\\storages\\" + name));
            fos.write(LEOFile.getBytes(blocks));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void DEBUG() {
        System.out.println("DIRECTORY CONTENTS:");
        int i = 0;
        while (i < this.directoryVector.size()) {
            int zz;
            Storage s = (Storage)this.directoryVector.get(i);
            String n = s.getName();
            Logger.logInfo("Storage: " + n + " storageType: " + s.getStorageType() + " directoryColor:" + s.getDirectoryColor() + " prevSID:" + s.getPrevStorageID() + " nextSID:" + s.getNextStorageID() + " childSID:" + s.getChildStorageID() + " sz:" + s.getActualFileSize());
            if (n.equals("Root Entry")) {
                Logger.logInfo("Root Header: " + Arrays.toString(s.getHeaderData().array()));
                if (s.myblocks != null) {
                    zz = 0;
                    if (s.myblocks.get(zz) instanceof BIGBLOCK) {
                        System.out.println("BLOCK 1:\t" + zz + "-" + Arrays.toString(((BIGBLOCK)s.myblocks.get(zz)).getBytes()));
                    } else {
                        System.out.println("BLOCK 1:\t" + zz + "-" + Arrays.toString(((SMALLBLOCK)s.myblocks.get(zz)).getBytes()));
                    }
                }
            } else if (!n.equals("Workbook")) {
                int len;
                if (n.equals("\u0001CompObj")) {
                    BlockByteReader bytes = s.getBlockReader();
                    len = bytes.getLength();
                    XLSRecord rec = new XLSRecord();
                    rec.setByteReader(bytes);
                    rec.setLength(len);
                    int slen = ByteTools.readInt(rec.getBytesAt(24, 4));
                    if (slen >= 0) {
                        String ss = new String(rec.getBytesAt(28, slen));
                        System.out.println("\tOLE Object:" + ss);
                    }
                } else if (n.startsWith("000")) {
                    if (s.myblocks != null) {
                        zz = 0;
                        while (zz < s.myblocks.size()) {
                            if (s.myblocks.get(zz) instanceof BIGBLOCK) {
                                System.out.println("\t" + zz + "-" + Arrays.toString(((BIGBLOCK)s.myblocks.get(zz)).getBytes()));
                            } else {
                                System.out.println("\t" + zz + "-" + Arrays.toString(((SMALLBLOCK)s.myblocks.get(zz)).getBytes()));
                            }
                            ++zz;
                        }
                    }
                    BlockByteReader bytes = s.getBlockReader();
                    len = bytes.getLength();
                    int z = 0;
                    while (z <= len - 4) {
                        byte[] headerbytes = bytes.getHeaderBytes(z);
                        short opcode = ByteTools.readShort(headerbytes[0], headerbytes[1]);
                        short reclen = ByteTools.readShort(headerbytes[2], headerbytes[3]);
                        BiffRec rec = XLSRecordFactory.getBiffRecord(opcode);
                        rec.setByteReader(bytes);
                        rec.setOffset(z);
                        rec.setLength(reclen);
                        rec.init();
                        System.out.println("\t\t" + rec.toString());
                        z += reclen + 4;
                    }
                } else if (s.myblocks != null) {
                    zz = 0;
                    while (zz < s.myblocks.size()) {
                        if (s.myblocks.get(zz) instanceof BIGBLOCK) {
                            System.out.println("\t" + zz + "-" + Arrays.toString(((BIGBLOCK)s.myblocks.get(zz)).getBytes()));
                        } else {
                            System.out.println("\t" + zz + "-" + Arrays.toString(((SMALLBLOCK)s.myblocks.get(zz)).getBytes()));
                        }
                        ++zz;
                    }
                }
            }
            ++i;
        }
    }
}

