/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.LEO;

import com.extentech.formats.LEO.Block;
import com.extentech.formats.LEO.BlockByteReader;
import com.extentech.formats.LEO.BlockFactory;
import com.extentech.formats.LEO.LEOFile;
import com.extentech.formats.LEO.LEOIndexingException;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.Logger;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Storage
extends BlockByteReader {
    private static final long serialVersionUID = -2065921767253066667L;
    static byte TYPE_INVALID = 0;
    static byte TYPE_DIRECTORY = 1;
    static byte TYPE_STREAM = (byte)2;
    static byte TYPE_LOCKBYTES = (byte)3;
    static byte TYPE_PROPERTY = (byte)4;
    static byte TYPE_ROOT = (byte)5;
    byte DIR_COLOR_RED = 0;
    byte DIR_COLOR_BLACK = 1;
    private transient ByteBuffer headerData = ByteBuffer.allocate(128);
    String name = "";
    int nameSize = -1;
    public byte storageType = (byte)-1;
    public byte directoryColor = (byte)-1;
    public int prevStorageID = -1;
    public int nextStorageID = -1;
    public int childStorageID = -1;
    public int sz = -1;
    public boolean miniStreamStorage = false;
    private boolean isSpecial = false;
    protected List myblocks;
    private int startBlock = 0;
    private int SIZE = -1;
    private int blockType = -1;
    private boolean initialized = false;
    AbstractList idxs = new CompatibleVector();
    Block lastblock = null;

    public void setBlocks(Block[] blks) {
        this.myblocks = new ArrayList();
        int t = 0;
        while (t < blks.length) {
            this.addBlock(blks[t]);
            ++t;
        }
    }

    public BlockByteReader getBlockReader() {
        BlockByteReader ret = new BlockByteReader(this.myblocks, this.getActualFileSize());
        return ret;
    }

    public List getBlockVect() {
        return this.myblocks;
    }

    public void setIsSpecial(boolean b) {
        this.isSpecial = b;
    }

    public boolean getIsSpecial() {
        return this.isSpecial;
    }

    public boolean getInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean b) {
        this.initialized = b;
    }

    void removeBlock(Block b) {
        this.myblocks.remove(b);
    }

    public void setBlockType(int type) {
        this.blockType = type;
        switch (type) {
            case 1: {
                this.SIZE = 512;
                break;
            }
            case 0: {
                this.SIZE = 64;
            }
        }
    }

    public int getBlockType() {
        return this.blockType;
    }

    public int getStorageType() {
        return this.storageType;
    }

    public int getDirectoryColor() {
        return this.directoryColor;
    }

    public void setDirectoryColor(int o) {
        int pos = 67;
        this.headerData.position(pos);
        this.headerData.put((byte)o);
        this.directoryColor = (byte)o;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + " n:" + this.nextStorageID + " p:" + this.prevStorageID + " c:" + this.childStorageID + " sz:" + this.sz;
    }

    public void setName(String nm) {
        try {
            byte[] b = nm.getBytes("UTF-16LE");
            int pos = 0;
            this.headerData.position(pos);
            this.headerData.put(b);
            pos = 64;
            this.headerData.position(pos);
            this.headerData.putShort((short)(b.length + 2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.name = nm;
    }

    protected Storage() {
    }

    protected Storage(ByteBuffer buff) {
        this.headerData = buff;
        int pos = 64;
        this.headerData.position(pos);
        this.nameSize = this.headerData.getShort();
        if (this.nameSize > 0) {
            pos = 0;
            byte[] namebuf = new byte[this.nameSize];
            try {
                int i = 0;
                while (i < this.nameSize) {
                    namebuf[i] = this.headerData.get(i);
                    ++i;
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            try {
                this.name = new String(namebuf, "UTF-16LE");
            }
            catch (UnsupportedEncodingException e) {
                Logger.logWarn("Storage error decoding storage name " + e);
            }
            this.name = this.name.substring(0, this.name.length() - 1);
        }
        pos = 66;
        this.headerData.position(pos);
        this.storageType = this.headerData.get();
        this.directoryColor = this.headerData.get();
        this.prevStorageID = this.headerData.getInt();
        this.nextStorageID = this.headerData.getInt();
        this.childStorageID = this.headerData.getInt();
        this.sz = this.getActualFileSize();
        if (this.sz > 0 && this.sz < 512) {
            this.miniStreamStorage = true;
        }
    }

    public int getPrevStorageID() {
        return this.prevStorageID;
    }

    public void setPrevStorageID(int o) {
        int pos = 68;
        this.headerData.position(pos);
        this.headerData.putInt(o);
        this.prevStorageID = o;
    }

    public int getNextStorageID() {
        return this.nextStorageID;
    }

    public void setNextStorageID(int o) {
        int pos = 72;
        this.headerData.position(pos);
        this.headerData.putInt(o);
        this.nextStorageID = o;
    }

    public int getChildStorageID() {
        return this.childStorageID;
    }

    public void setChildStorageID(int o) {
        int pos = 76;
        this.headerData.position(pos);
        this.headerData.putInt(o);
        this.childStorageID = o;
    }

    public int getFilePos() {
        int ret = (this.getStartBlock() + 1) * this.SIZE;
        return ret;
    }

    public ByteBuffer getHeaderData() {
        return this.headerData;
    }

    public byte[] getBytes() {
        return LEOFile.getBytes(this.myblocks);
    }

    public OutputStream getByteStream() {
        return LEOFile.getByteStream(this.myblocks);
    }

    public void writeBytes(OutputStream out) {
        Iterator itx = this.myblocks.iterator();
        while (itx.hasNext()) {
            ((Block)itx.next()).writeBytes(out);
        }
    }

    public void writeBytes(OutputStream out, int blen) {
        Block[] bs = BlockFactory.getBlocksFromOutputStream(out, blen, 1);
        if (this.myblocks != null) {
            this.myblocks.clear();
            this.lastblock = null;
        } else {
            this.myblocks = new ArrayList(bs.length);
        }
        int d = 0;
        while (d < bs.length) {
            this.addBlock(bs[d]);
            ++d;
        }
    }

    public void setOutputBytes(OutputStream b, int blen) {
        Block[] bs = BlockFactory.getBlocksFromOutputStream(b, blen, 1);
        if (this.myblocks != null) {
            this.myblocks.clear();
            this.lastblock = null;
        } else {
            this.myblocks = new ArrayList(bs.length);
        }
        int d = 0;
        while (d < bs.length) {
            this.addBlock(bs[d]);
            ++d;
        }
    }

    public void setBytes(byte[] b) {
        if (this.miniStreamStorage) {
            this.setMiniFATSectorBytes(b);
            return;
        }
        Block[] bs = BlockFactory.getBlocksFromByteArray(b, 1);
        if (this.myblocks != null) {
            this.myblocks.clear();
            this.lastblock = null;
        } else {
            this.myblocks = new ArrayList(bs.length);
        }
        int d = 0;
        while (d < bs.length) {
            this.addBlock(bs[d]);
            ++d;
        }
    }

    private void setMiniFATSectorBytes(byte[] b) {
        Block[] bs = BlockFactory.getBlocksFromByteArray(b, 0);
        if (this.myblocks != null) {
            this.myblocks.clear();
            this.lastblock = null;
        } else {
            this.myblocks = new ArrayList(bs.length);
        }
        int d = 0;
        while (d < bs.length) {
            this.addBlock(bs[d]);
            ++d;
        }
    }

    public void setBytesWithOverage(byte[] newbytes) {
        int actuallen = newbytes.length;
        this.myblocks = new ArrayList();
        if (newbytes.length < 4096) {
            int overage = newbytes.length % 128;
            if (overage > 0) {
                byte[] b = new byte[128 - overage];
                newbytes = ByteTools.append(b, newbytes);
            }
            Block[] smallblocks = BlockFactory.getBlocksFromByteArray(newbytes, 0);
            int i = 0;
            while (i < smallblocks.length) {
                this.addBlock(smallblocks[i]);
                ++i;
            }
            this.setBlockType(0);
        } else {
            int overage = newbytes.length % 512;
            if (overage > 0) {
                byte[] b = new byte[512 - overage];
                newbytes = ByteTools.append(b, newbytes);
            }
            Block[] blocks = BlockFactory.getBlocksFromByteArray(newbytes, 1);
            int i = 0;
            while (i < blocks.length) {
                this.addBlock(blocks[i]);
                ++i;
            }
            this.setBlockType(1);
        }
        this.setActualFileSize(actuallen);
    }

    public void initFromMiniStream(List miniStream, int[] miniFAT) throws LEOIndexingException {
        if (this.getStartBlock() < 0) {
            return;
        }
        if (miniFAT == null) {
            return;
        }
        this.myblocks = new ArrayList();
        boolean endloop = false;
        Block thisBlock = null;
        int idx = this.getStartBlock();
        while (idx >= 0) {
            switch (idx) {
                case -2: 
                case -1: {
                    endloop = true;
                    break;
                }
                default: {
                    if (idx >= miniStream.size()) {
                        Logger.logWarn("MiniStream Error initting Storage: " + this.getName());
                        break;
                    }
                    thisBlock = (Block)miniStream.get(idx);
                    this.addBlock(thisBlock);
                }
            }
            if (endloop) break;
            idx = miniFAT[idx];
        }
        this.setInitialized(true);
    }

    public void init(List dta, int[] FAT, boolean keepStartBlock) {
        this.myblocks = new ArrayList();
        boolean endloop = false;
        if (this.getStartBlock() < 0) {
            return;
        }
        Block thisbb = null;
        int nextIdx = 0;
        if (keepStartBlock) {
            thisbb = (Block)dta.get(this.startBlock + 1);
            this.addBlock(thisbb);
        }
        int i = this.startBlock;
        while (i < FAT.length) {
            nextIdx = FAT[i];
            switch (nextIdx) {
                case -4: {
                    Logger.logInfo("INFO: Storage.init() encountered extra DIFAT sector.");
                    break;
                }
                case -3: {
                    if (this.getActualFileSize() > 0) {
                        this.setIsSpecial(true);
                        thisbb = (Block)dta.get(i++);
                        if (!thisbb.getIsSpecialBlock()) {
                            this.addBlock(thisbb);
                        }
                        nextIdx = i;
                        break;
                    }
                    endloop = true;
                    break;
                }
                case -1: {
                    endloop = true;
                    break;
                }
                case -2: {
                    if (i + 1 < dta.size()) {
                        thisbb = (Block)dta.get(i + 1);
                        if (thisbb == null) break;
                        this.addBlock(thisbb);
                    }
                    endloop = true;
                    break;
                }
                default: {
                    if (dta.size() > nextIdx) {
                        thisbb = (Block)dta.get(nextIdx);
                    }
                    if (thisbb == null) break;
                    if (nextIdx != i + 1) {
                        Block skipbb = (Block)dta.get(i + 1);
                        this.addBlock(skipbb);
                        break;
                    }
                    if (thisbb.getIsSpecialBlock()) break;
                    this.addBlock(thisbb);
                }
            }
            i = nextIdx;
            if (endloop) break;
        }
        this.setInitialized(true);
    }

    public void addBlock(Block b) {
        if (this.lastblock != null) {
            this.lastblock.setNextBlock(b);
        }
        if (b.getInitialized()) {
            return;
        }
        b.setStorage(this);
        b.setInitialized(true);
        if (this.myblocks == null) {
            this.myblocks = new ArrayList();
        }
        this.myblocks.add(b);
        this.lastblock = b;
    }

    public void setStorageType(int i) {
        int pos = 66;
        this.headerData.position(pos);
        this.headerData.put((byte)i);
        this.storageType = (byte)i;
    }

    public void setActualFileSize(int i) {
        int pos = 120;
        this.sz = i;
        this.headerData.position(pos);
        this.headerData.putInt(i);
    }

    public int getActualFileSize() {
        int pos = 120;
        this.headerData.position(pos);
        this.sz = this.headerData.getInt();
        return this.sz;
    }

    public void setStartBlock(int i) {
        this.startBlock = i;
        int pos = 116;
        this.headerData.position(pos);
        this.headerData.putInt(i);
    }

    public int getStartBlock() {
        int pos = 116;
        this.headerData.position(pos);
        this.startBlock = this.headerData.getInt();
        return this.startBlock;
    }

    Block[] getBlocks() {
        if (this.myblocks.size() < 1) {
            return this.initBigBlocks();
        }
        Block[] blox = new Block[this.myblocks.size()];
        blox = this.myblocks.toArray(blox);
        return blox;
    }

    private Block[] initBigBlocks() {
        if (this.getLength() > 0) {
            Block[] blks = BlockFactory.getBlocksFromByteArray(this.getBytes(), 1);
            int t = 0;
            this.myblocks.clear();
            while (t < blks.length) {
                if (t + 1 < blks.length) {
                    blks[t].setNextBlock(blks[t + 1]);
                }
                this.addBlock(blks[t]);
                ++t;
            }
            return blks;
        }
        return null;
    }

    public int getSizeInBlocks() {
        return this.myblocks.size();
    }

    public void addIdx(int x) {
        this.idxs.add(x);
    }

    @Override
    public boolean equals(Object other) {
        return other.toString().equals(this.toString());
    }

    public void close() {
        if (this.myblocks != null) {
            this.myblocks.clear();
        }
        if (this.idxs != null) {
            this.idxs.clear();
        }
        this.lastblock = null;
    }
}

