/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.LEO;

import com.extentech.formats.LEO.BIGBLOCK;
import com.extentech.formats.LEO.BlockFactory;
import com.extentech.formats.LEO.InvalidFileException;
import com.extentech.toolkit.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class LEOHeader
implements Serializable {
    private static final long serialVersionUID = -422489164065975273L;
    public static final int HEADER_SIZE = 512;
    private transient ByteBuffer data;
    private static int DIFATPOSITION = 76;
    private int numFATSectors = -1;
    private int rootstart = -1;
    private int miniFATStart = -2;
    private int extraDIFATStart = -1;
    private int numExtraDIFATSectors = -1;
    private int numMiniFATSectors = 0;
    private int minStreamSize = 4096;
    public static final byte[] majick;

    static {
        byte[] byArray = new byte[16];
        byArray[0] = -48;
        byArray[1] = -49;
        byArray[2] = 17;
        byArray[3] = -32;
        byArray[4] = -95;
        byArray[5] = -79;
        byArray[6] = 26;
        byArray[7] = -31;
        majick = byArray;
    }

    protected boolean init() {
        return this.init(this.data);
    }

    private static void displayHeader(ByteBuffer data) {
        int i = 0;
        while (i < data.capacity()) {
            System.out.println("[" + i + "] " + data.get(i));
            ++i;
        }
    }

    protected boolean init(ByteBuffer dta) {
        this.data = dta;
        if (dta.limit() < 1) {
            throw new InvalidFileException("Empty input file.");
        }
        try {
            int t = 0;
            while (t < 16) {
                if (dta.get(t) != majick[t]) {
                    throw new InvalidFileException("File is not valid OLE format: Bad Majick.");
                }
                ++t;
            }
        }
        catch (Exception e) {
            throw new InvalidFileException("File is not valid OLE format:" + dta.limit());
        }
        int pos = 48;
        this.data.position(pos);
        this.rootstart = this.data.getInt();
        ++this.rootstart;
        this.rootstart *= 512;
        pos = 68;
        this.data.position(pos);
        this.extraDIFATStart = this.data.getInt();
        this.numExtraDIFATSectors = this.data.getInt();
        pos = 56;
        this.data.position(pos);
        this.minStreamSize = this.data.getInt();
        pos = 44;
        this.data.position(pos);
        this.numFATSectors = this.data.getInt();
        pos = 60;
        this.data.position(pos);
        this.miniFATStart = this.data.getInt();
        pos = 64;
        this.data.position(pos);
        this.numMiniFATSectors = this.data.getInt();
        return true;
    }

    public int getNumExtraDIFATSectors() {
        return this.numExtraDIFATSectors;
    }

    public int getExtraDIFATStart() {
        return this.extraDIFATStart;
    }

    public int getRootStartPos() {
        return this.rootstart;
    }

    public int getMiniFATStart() {
        return this.miniFATStart;
    }

    public int[] getDIFAT() {
        int numblks = Math.min(this.numFATSectors, 109);
        int[] FAT = new int[numblks];
        int pos = DIFATPOSITION;
        this.data.position(pos);
        int i = 0;
        while (i < numblks) {
            FAT[i] = this.data.getInt();
            int n = i++;
            FAT[n] = FAT[n] + 1;
        }
        return FAT;
    }

    public ByteBuffer getBytes() {
        return this.data;
    }

    static final LEOHeader getPrototype(int[] FAT) {
        LEOHeader retval = new LEOHeader();
        BIGBLOCK retblock = (BIGBLOCK)BlockFactory.getPrototypeBlock(1);
        retval.setData(retblock.data);
        retval.initMajickBytes();
        retval.initConstants();
        retval.setFAT(FAT);
        retval.setMiniFATStart(-2);
        retval.setRootStorageStart(1);
        retval.setExtraDIFATStart(-2);
        retval.setNumExtraDIFATSectors(0);
        return retval;
    }

    void initConstants() {
        int pos = 8;
        this.data.position(pos);
        this.data.putInt(0);
        pos = 12;
        this.data.position(pos);
        this.data.putInt(0);
        pos = 16;
        this.data.position(pos);
        this.data.putInt(0);
        pos = 20;
        this.data.position(pos);
        this.data.putInt(0);
        pos = 24;
        this.data.position(pos);
        this.data.putShort((short)62);
        pos = 26;
        this.data.position(pos);
        this.data.putShort((short)3);
        pos = 28;
        this.data.position(pos);
        this.data.putShort((short)-2);
        pos = 30;
        this.data.position(pos);
        this.data.putShort((short)9);
        pos = 32;
        this.data.position(pos);
        this.data.putInt(6);
        pos = 36;
        this.data.position(pos);
        this.data.putInt(0);
        pos = 40;
        this.data.position(pos);
        this.data.putInt(0);
        pos = 52;
        this.data.position(pos);
        this.data.putInt(0);
        pos = 56;
        this.data.position(pos);
        this.data.putInt(4096);
    }

    void initMajickBytes() {
        this.data.position(0);
        this.data.put(majick);
    }

    void setData(ByteBuffer dta) {
        this.data = dta;
    }

    void setFAT(int[] FAT) {
        int pos = DIFATPOSITION;
        this.data.position(pos);
        int i = 0;
        while (i < FAT.length) {
            if (FAT.length * 4 >= this.data.limit() - 4) {
                Logger.logWarn("WARNING: LEOHeader.setFAT() creating Extra FAT Sectors Not Implemented.  Output file too large.");
            } else {
                this.data.putInt(FAT[i] - 1);
            }
            ++i;
        }
        i = this.data.position();
        while (i < 512) {
            this.data.putInt(-1);
            i += 4;
        }
        this.setNumFATSectors(FAT.length);
    }

    void setRootStorageStart(int i) {
        int pos = 48;
        this.data.position(pos);
        this.data.putInt(i);
    }

    void setMiniFATStart(int i) {
        int pos = 60;
        this.miniFATStart = i;
        this.data.position(pos);
        this.data.putInt(i);
        this.miniFATStart = i;
    }

    void setExtraDIFATStart(int i) {
        int pos = 68;
        this.data.position(pos);
        this.data.putInt(i);
        this.extraDIFATStart = i;
    }

    void setNumExtraDIFATSectors(int i) {
        int pos = 72;
        this.data.position(pos);
        this.data.putInt(i);
        this.numExtraDIFATSectors = i;
    }

    void setNumFATSectors(int i) {
        int pos = 44;
        this.data.position(pos);
        this.data.putInt(i);
        this.numFATSectors = i;
    }

    int getNumFATSectors() {
        return this.numFATSectors;
    }

    void setNumMiniFATSectors(int i) {
        int pos = 64;
        this.data.position(pos);
        this.data.putInt(i);
        this.numMiniFATSectors = i;
    }

    int getNumMiniFATSectors() {
        return this.numMiniFATSectors;
    }

    int getMinStreamSize() {
        return this.minStreamSize;
    }
}

