/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.LEO;

import com.extentech.formats.LEO.Block;
import com.extentech.formats.LEO.Storage;
import com.extentech.toolkit.CompatibleVectorHints;
import com.extentech.toolkit.Logger;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;

public abstract class BlockImpl
implements Block,
CompatibleVectorHints,
Serializable {
    private static final long serialVersionUID = 4833713921208834278L;
    boolean DEBUG = false;
    transient int recordIdx = -1;
    transient int lastidx = -1;
    transient ByteBuffer data = null;
    private List blockvec = null;
    public Block nextblock = null;
    private boolean isXBAT = false;
    int originalidx;
    int originalpos;
    boolean isBBDepotBlock = false;
    boolean isSBDepotBlock = false;
    boolean isSpecialBlock = false;
    private boolean initialized = false;
    private boolean streamed = false;
    public Storage mystore = null;

    public void close() {
        if (this.blockvec != null) {
            this.blockvec.clear();
            this.blockvec = null;
        }
        if (this.nextblock != null && this.nextblock != this) {
            this.nextblock = null;
        }
        this.mystore = null;
        if (this.data != null) {
            this.data.clear();
            this.data = null;
        }
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.data;
    }

    @Override
    public void writeBytes(OutputStream out) {
        try {
            out.write(this.getBytes());
        }
        catch (Exception exp) {
            Logger.logErr("BlockImpl.writeBytes failed.", exp);
        }
    }

    @Override
    public byte[] getBytes(int start, int end) {
        int SIZE = end - start;
        if (end > this.getBlockSize()) {
            throw new RuntimeException("WARNING: BlockImpl.getBytes(): read position > block size:" + SIZE + start);
        }
        byte[] ret = new byte[SIZE];
        int capcheck = this.data.capacity();
        if (capcheck <= SIZE) {
            this.originalpos = 0;
        }
        if (capcheck < SIZE + this.originalpos) {
            SIZE = capcheck - this.originalpos;
        }
        try {
            this.data.position(start += this.originalpos);
            this.data.get(ret, 0, SIZE);
        }
        catch (Exception e) {
            Logger.logWarn("BlockImpl.getBytes() start: " + start + " size: " + SIZE + ": " + e);
        }
        return ret;
    }

    @Override
    public int getBlockSize() {
        if (this.getBlockType() == 1) {
            return 512;
        }
        if (this.getBlockType() == 0) {
            return 64;
        }
        return 0;
    }

    @Override
    public byte[] getBytes() {
        int SIZE = 0;
        if (this.getBlockType() == 1) {
            SIZE = 512;
        } else if (this.getBlockType() == 0) {
            SIZE = 64;
        }
        byte[] ret = new byte[SIZE];
        int capcheck = this.data.capacity();
        if (capcheck <= this.originalpos) {
            this.originalpos = 0;
        }
        if (capcheck < SIZE + this.originalpos) {
            SIZE = capcheck - this.originalpos;
        }
        try {
            this.data.position(this.originalpos);
            this.data.get(ret, 0, SIZE);
        }
        catch (Exception e) {
            Logger.logWarn("BlockImpl.getBytes(0," + SIZE + "): " + e);
        }
        return ret;
    }

    @Override
    public void setBytes(ByteBuffer b) {
        this.data = b;
    }

    @Override
    public int getRecordIndexHint() {
        return this.recordIdx;
    }

    @Override
    public void setRecordIndexHint(int i) {
        this.recordIdx = i;
    }

    @Override
    public void setBlockVector(List v) {
        this.blockvec = v;
    }

    @Override
    public int getBlockIndex() {
        if (this.blockvec == null) {
            return this.recordIdx;
        }
        return this.blockvec.indexOf(this);
    }

    @Override
    public void setOriginalIdx(int x) {
        this.originalidx = x;
    }

    @Override
    public void setNextBlock(Block b) {
        this.nextblock = b;
    }

    @Override
    public boolean hasNext() {
        return this.nextblock != null;
    }

    public Object next() {
        return this.nextblock;
    }

    @Override
    public void remove() {
        this.mystore.removeBlock(this);
        this.nextblock = null;
    }

    @Override
    public void setStorage(Storage s) {
        this.mystore = s;
    }

    @Override
    public Storage getStorage() {
        return this.mystore;
    }

    @Override
    public int getOriginalIdx() {
        return this.originalidx;
    }

    @Override
    public boolean getStreamed() {
        return this.streamed;
    }

    @Override
    public void setStreamed(boolean b) {
        this.streamed = b;
    }

    @Override
    public void setInitialized(boolean b) {
        this.initialized = b;
    }

    @Override
    public boolean getInitialized() {
        return this.initialized;
    }

    @Override
    public boolean getIsSpecialBlock() {
        return this.isSpecialBlock;
    }

    @Override
    public boolean getIsDepotBlock() {
        return this.isBBDepotBlock;
    }

    @Override
    public void setIsDepotBlock(boolean b) {
        this.isSpecialBlock = b;
        this.isBBDepotBlock = b;
    }

    @Override
    public void init(ByteBuffer d, int origidx, int origp) {
        this.originalidx = origidx;
        this.originalpos = origp;
        this.setBytes(d);
    }

    @Override
    public int getOriginalPos() {
        return this.originalpos;
    }

    @Override
    public boolean isXBAT() {
        return this.isXBAT;
    }

    @Override
    public void setIsExtraSector(boolean b) {
        this.isXBAT = b;
    }
}

