/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.toolkit;

import com.extentech.toolkit.Logger;
import com.extentech.toolkit.TempFileGenerator;
import java.io.File;
import java.io.IOException;

public class DefaultTempFileGeneratorImpl
implements TempFileGenerator {
    @Override
    public File createTempFile(String prefix, String extension) throws IOException {
        String tmpdir = System.getProperty("java.io.tmpdir");
        String lastchar = tmpdir.substring(tmpdir.length() - 1, tmpdir.length());
        if (!lastchar.equals(File.separator)) {
            tmpdir = String.valueOf(tmpdir) + File.separator;
        }
        tmpdir = String.valueOf(tmpdir) + "extentech/";
        File target = null;
        try {
            File tdir = new File(tmpdir);
            if (!tdir.exists()) {
                tdir.mkdirs();
            }
            tdir.deleteOnExit();
            target = File.createTempFile(prefix, extension, tdir);
        }
        catch (Exception e) {
            Logger.logInfo("Could not access temp dir: " + tmpdir);
            target = File.createTempFile(prefix, extension);
        }
        target.deleteOnExit();
        return target;
    }
}

