/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.escher;

import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.formats.escher.EscherRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;

public class MsofbtOPT
extends EscherRecord {
    private static final long serialVersionUID = 465530579513265882L;
    byte[] recordData = new byte[0];
    boolean bBackground;
    boolean bActive;
    boolean bPrint;
    int imageIndex = -1;
    Color fillColor = null;
    int fillType = 0;
    String imageName = "";
    String shapeName = "";
    String alternateText = "";
    int[] lineprops = null;
    static final int LINEPROPTS_STYLE = 0;
    static final int LINEPROPTS_WEIGHT = 1;
    static final int LINEPROPTS_COLOR = 2;
    boolean hasTextId = false;
    LinkedHashMap props = new LinkedHashMap();

    public MsofbtOPT(int fbt, int inst, int version) {
        super(fbt, inst, version);
    }

    public void setImageIndex(int value) {
        this.imageIndex = value;
        if (this.imageIndex > -1) {
            this.setProperty(260, true, false, value, null);
        } else {
            this.props.remove(260);
        }
    }

    public boolean hasTextId() {
        return this.hasTextId;
    }

    public void setImageName(String name) {
        try {
            this.imageName = name;
            if (this.imageName == null || this.imageName.equals("")) {
                this.props.remove(261);
                return;
            }
            byte[] imageNameBytes = name.getBytes("UTF-16LE");
            byte[] newbytes = new byte[imageNameBytes.length];
            System.arraycopy(imageNameBytes, 0, newbytes, 0, imageNameBytes.length);
            imageNameBytes = newbytes;
            this.setProperty(261, true, true, imageNameBytes.length, imageNameBytes);
        }
        catch (Exception e) {
            Logger.logErr("Msofbt.setImageName failed.", e);
        }
    }

    public void setShapeName(String name) {
        try {
            this.shapeName = name;
            if (this.shapeName == null || this.shapeName.equals("")) {
                this.props.remove(896);
                return;
            }
            byte[] shapeNameBytes = name.getBytes("UTF-16LE");
            byte[] newbytes = new byte[shapeNameBytes.length];
            System.arraycopy(shapeNameBytes, 0, newbytes, 0, shapeNameBytes.length);
            shapeNameBytes = newbytes;
            this.setProperty(896, true, true, shapeNameBytes.length, shapeNameBytes);
        }
        catch (Exception e) {
            Logger.logErr("Msofbt.setShapeName failed.", e);
        }
    }

    @Override
    protected byte[] getData() {
        if (this.isDirty) {
            byte[] tmp = new byte[this.inst * 6];
            byte[] complexData = new byte[]{};
            int pos = 0;
            ArrayList keys = new ArrayList(this.props.keySet());
            Object[] k = keys.toArray();
            Arrays.sort(k);
            int i = 0;
            while (i < k.length) {
                int dtx;
                Integer propId = (Integer)k[i];
                Object[] o = (Object[])this.props.get(propId);
                boolean isComplex = (Boolean)o[0];
                boolean isBid = (Boolean)o[2];
                int flag = 0;
                if (isComplex) {
                    flag |= 0x80;
                }
                if (isBid) {
                    flag |= 0x40;
                }
                if (!isComplex) {
                    dtx = (Integer)o[1];
                } else {
                    dtx = ((byte[])o[1]).length + 2;
                    complexData = ByteTools.append((byte[])o[1], complexData);
                    complexData = ByteTools.append(new byte[2], complexData);
                }
                tmp[pos++] = (byte)(0xFF & propId);
                tmp[pos++] = (byte)(flag | (0x3F00 & propId) >> 8);
                byte[] dtxBytes = ByteTools.cLongToLEBytes(dtx);
                System.arraycopy(dtxBytes, 0, tmp, pos, 4);
                pos += 4;
                ++i;
            }
            this.recordData = new byte[tmp.length + complexData.length];
            System.arraycopy(tmp, 0, this.recordData, 0, tmp.length);
            System.arraycopy(complexData, 0, this.recordData, tmp.length, complexData.length);
            this.isDirty = false;
        }
        this.setLength(this.recordData.length);
        return this.recordData;
    }

    public void setData(byte[] b) {
        this.recordData = b;
        this.props.clear();
        this.imageIndex = -1;
        this.imageName = "";
        this.shapeName = "";
        this.alternateText = "";
        this.parseData();
    }

    private void parseData() {
        int pos = 0;
        if (this.inst == 0 && this.recordData.length > 0) {
            byte[] dat = new byte[8];
            System.arraycopy(this.recordData, 0, dat, 0, 8);
            this.version = 0xF & dat[0];
            this.inst = (0xFF & dat[1]) << 4 | (0xF0 & dat[0]) >> 4;
            this.fbt = (0xFF & dat[3]) << 8 | 0xFF & dat[2];
            pos = 8;
        }
        int i = 0;
        while (i < this.inst) {
            int propertyId = (0x3F & this.recordData[pos + 1]) << 8 | 0xFF & this.recordData[pos];
            int fBid = (0x40 & this.recordData[pos + 1]) >> 6;
            int fComplex = (0x80 & this.recordData[pos + 1]) >> 7;
            int dtx = ByteTools.readInt(this.recordData[pos + 2], this.recordData[pos + 3], this.recordData[pos + 4], this.recordData[pos + 5]);
            if (propertyId == 260) {
                this.imageIndex = dtx;
            } else if (propertyId == 384) {
                this.fillType = dtx;
            } else if (propertyId == 385) {
                this.fillColor = this.setFillColor(dtx);
            } else if (propertyId == 831) {
                this.bBackground = dtx != 0;
            } else if (propertyId != 959) {
                if (propertyId == 319) {
                    this.bActive = dtx != 0;
                } else if (propertyId == 459) {
                    if (this.lineprops == null) {
                        this.lineprops = new int[3];
                    }
                    this.lineprops[1] = dtx;
                } else if (propertyId == 448) {
                    if (this.lineprops == null) {
                        this.lineprops = new int[3];
                    }
                    this.lineprops[2] = dtx;
                } else if (propertyId == 461) {
                    if (this.lineprops == null) {
                        this.lineprops = new int[3];
                    }
                    this.lineprops[0] = dtx;
                } else if (propertyId == 128) {
                    this.hasTextId = true;
                }
            }
            this.props.put(propertyId, new Object[]{fComplex != 0, dtx, fBid != 0});
            pos += 6;
            ++i;
        }
        for (Integer propId : this.props.keySet()) {
            int len;
            Object[] o = (Object[])this.props.get(propId);
            if (!((Boolean)o[0]).booleanValue() || (len = ((Integer)o[1]).intValue()) < 2) continue;
            byte[] complexdata = new byte[len - 2];
            System.arraycopy(this.recordData, pos, complexdata, 0, complexdata.length);
            this.props.put(propId, new Object[]{o[0], complexdata, o[2]});
            if (propId == 261) {
                try {
                    this.imageName = new String(complexdata, "UTF-16LE");
                }
                catch (Exception e) {
                    this.imageName = "Unnamed";
                }
            } else if (propId == 896) {
                try {
                    this.shapeName = new String(complexdata, "UTF-16LE");
                }
                catch (Exception exception) {}
            } else if (propId == 897) {
                try {
                    this.alternateText = new String(complexdata, "UTF-16LE");
                }
                catch (Exception exception) {}
            } else if (propId == 391) {
                try {
                    String string = new String(complexdata, "UTF-16LE");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            pos += complexdata.length + 2;
        }
    }

    public void setProperty(int propId, boolean isBid, boolean isComplex, int dtx, byte[] complexBytes) {
        if (isComplex) {
            this.props.put(propId, new Object[]{isComplex, complexBytes, isBid});
        } else {
            this.props.put(propId, new Object[]{isComplex, dtx, isBid});
        }
        this.inst = this.props.size();
        this.isDirty = true;
    }

    public boolean hasBorder() {
        return this.lineprops != null && this.lineprops[1] > 1;
    }

    public int getBorderLineWidth() {
        if (this.lineprops != null) {
            return this.lineprops[1];
        }
        return -1;
    }

    public int getImageIndex() {
        return this.imageIndex;
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getShapeName() {
        return this.shapeName;
    }

    public String debugOutput() {
        StringBuffer log = new StringBuffer();
        int n = this.inst;
        int fBid = 0;
        int fComplex = 0;
        int end = this.recordData.length;
        int pos = 0;
        while (pos < end) {
            int propertyId = (0x3F & this.recordData[pos + 1]) << 8 | 0xFF & this.recordData[pos];
            fBid = (0x40 & this.recordData[pos + 1]) >> 6;
            fComplex = (0x80 & this.recordData[pos + 1]) >> 7;
            int dtx = ByteTools.readInt(this.recordData[pos + 2], this.recordData[pos + 3], this.recordData[pos + 4], this.recordData[pos + 5]);
            if (fComplex != 0) {
                end -= dtx;
            }
            log.append("\t\t" + propertyId + "/" + fBid + "/" + fComplex + "/" + dtx);
            pos += 6;
        }
        return log.toString();
    }

    private Color setFillColor(int clrStructure) {
        boolean bSysIndex;
        byte[] b = ByteTools.longToByteArray(clrStructure);
        boolean bPaletteIndex = (b[4] & 1) == 1;
        boolean bSchemeIndex = (b[4] & 8) == 8;
        boolean bl = bSysIndex = (b[4] & 0x10) == 16;
        if (bSchemeIndex) {
            short fillclr = b[7];
            if (fillclr > FormatHandle.COLORTABLE.length) {
                fillclr = FormatHandle.interpretSpecialColorIndex(fillclr);
            }
            this.fillColor = FormatHandle.COLORTABLE[fillclr];
            return this.fillColor;
        }
        if (bSysIndex) {
            short fillclr = ByteTools.readShort(b[6], b[7]);
            if (fillclr == 240 || fillclr == 241 || fillclr == 242 || fillclr == 243 || fillclr == 244 || fillclr == 245 || fillclr == 246 || fillclr == 247) {
                fillclr = 1;
            }
            if (fillclr == 64) {
                fillclr = 1;
            } else if (fillclr == 65) {
                fillclr = 1;
            } else {
                if (fillclr == 77) {
                    this.fillColor = null;
                    return this.fillColor;
                }
                if (fillclr == 78) {
                    fillclr = 1;
                } else if (fillclr == 79) {
                    fillclr = 0;
                }
            }
            if (fillclr < 0 || fillclr > FormatHandle.COLORTABLE.length) {
                fillclr = 1;
            }
            this.fillColor = FormatHandle.COLORTABLE[fillclr];
            return this.fillColor;
        }
        int bl2 = b[5] < 0 ? 255 + b[5] : b[5];
        int g = b[6] < 0 ? 255 + b[6] : b[6];
        int r2 = b[7] < 0 ? 255 + b[7] : b[7];
        this.fillColor = new Color(r2, g, bl2);
        return this.fillColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public int getFillType() {
        return this.fillType;
    }
}

