/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.ExtenXLS.DateConverter;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.FormatConstants;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.Labelsst;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.Xf;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgBool;
import com.extentech.formats.XLS.formulas.PtgCalculator;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.formats.XLS.formulas.PtgInt;
import com.extentech.formats.XLS.formulas.PtgNumber;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.formats.XLS.formulas.PtgStr;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Date;

public class TextCalculator {
    protected static Ptg calcAsc(Ptg[] operands) {
        if (operands == null || operands[0] == null) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        WorkBook bk = operands[0].getParentRec().getWorkBook();
        if (bk.defaultLanguageIsDBCS()) {
            byte[] strbytes = TextCalculator.getUnicodeBytesFromOp(operands[0]);
            if (strbytes == null) {
                strbytes = operands[0].getValue().toString().getBytes();
            }
            try {
                return new PtgStr(new String(strbytes, "UTF-16LE"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new PtgStr(operands[0].getValue().toString());
    }

    protected static Ptg calcChar(Ptg[] operands) {
        Object o = operands[0].getValue();
        Byte s = new Byte(o.toString());
        if (s.intValue() > 255 || s.intValue() < 1) {
            return PtgCalculator.getError();
        }
        byte[] b = new byte[]{s};
        String str = "";
        try {
            str = new String(b, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new PtgStr(str);
    }

    protected static Ptg calcClean(Ptg[] operands) {
        String retString = "";
        try {
            Object o = operands[0].getValue();
            String s = o.toString();
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (c >= ' ') {
                    retString = String.valueOf(retString) + (char)c;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new PtgStr(retString);
    }

    protected static Ptg calcCode(Ptg[] operands) {
        Object o = operands[0].getValue();
        String s = o.toString();
        byte[] b = null;
        try {
            b = s.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Integer i = b[0];
        return new PtgInt(i);
    }

    protected static Ptg calcConcatenate(Ptg[] operands) {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        Ptg[] allops = PtgCalculator.getAllComponents(operands);
        String s = "";
        int i = 0;
        while (i < allops.length) {
            s = String.valueOf(s) + allops[i].getValue().toString();
            ++i;
        }
        PtgStr str = new PtgStr(s);
        str.setParentRec(operands[0].getParentRec());
        return str;
    }

    protected static Ptg calcDollar(Ptg[] operands) {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        int pop = 0;
        if (operands.length > 1) {
            pop = operands[1].getIntVal();
        }
        double d = operands[0].getDoubleVal();
        d *= Math.pow(10.0, pop);
        d = Math.round(d);
        String res = "$" + String.valueOf(d /= Math.pow(10.0, pop));
        return new PtgStr(res);
    }

    protected static Ptg calcExact(Ptg[] operands) {
        String s2;
        if (operands.length != 2) {
            return PtgCalculator.getError();
        }
        String s1 = operands[0].getValue().toString();
        if (s1.equals(s2 = operands[1].getValue().toString())) {
            return new PtgBool(true);
        }
        return new PtgBool(false);
    }

    protected static Ptg calcFind(Ptg[] operands) {
        String instring = "";
        String wholestr = "";
        int start = 0;
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        if (operands.length == 3) {
            start = operands[2].getIntVal() - 1;
        }
        Object o = operands[0].getValue();
        Object oo = operands[1].getValue();
        if (o == null || oo == null) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        instring = o.toString();
        wholestr = oo.toString();
        int i = wholestr.indexOf(instring, start);
        if (i != -1) {
            i = wholestr.indexOf(instring);
            return new PtgInt(++i);
        }
        return new PtgErr(PtgErr.ERROR_VALUE);
    }

    protected static Ptg calcFindB(Ptg[] operands) {
        if (operands == null || operands.length < 2 || operands[0] == null) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        WorkBook bk = operands[0].getParentRec().getWorkBook();
        if (!bk.defaultLanguageIsDBCS()) {
            return TextCalculator.calcFind(operands);
        }
        int startnum = 0;
        if (operands.length > 2) {
            startnum = operands[2].getIntVal();
        }
        byte[] strToFind = TextCalculator.getUnicodeBytesFromOp(operands[0]);
        byte[] str = TextCalculator.getUnicodeBytesFromOp(operands[1]);
        int index = -1;
        if (strToFind == null || strToFind.length == 0 || str == null || startnum < 0 || str.length < startnum) {
            return new PtgInt(startnum);
        }
        int i = startnum;
        while (i < str.length && index == -1) {
            if (strToFind[0] == str[i]) {
                index = i;
                int j = 0;
                while (j < strToFind.length && i + j < str.length && index == i) {
                    if (strToFind[j] != str[i + j]) {
                        index = -1;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (index == -1) {
            new PtgErr(PtgErr.ERROR_VALUE);
        }
        return new PtgInt(index + 1);
    }

    protected static Ptg calcFixed(Ptg[] operands) {
        double dub;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        boolean nocommas = false;
        if (operands.length == 3) {
            Boolean boo = (Boolean)operands[2].getValue();
            nocommas = boo;
        }
        if ((dub = operands[0].getDoubleVal()) == Double.NaN) {
            dub = 0.0;
        }
        int pop = operands[1].getIntVal();
        dub *= Math.pow(10.0, pop);
        dub = Math.round(dub);
        String res = String.valueOf(dub /= Math.pow(10.0, pop));
        if (pop == 0 && res.indexOf(".") > -1) {
            res = res.substring(0, res.indexOf("."));
            return new PtgStr(res);
        }
        if (res.indexOf(".") == -1 && pop > 0) {
            res = String.valueOf(res) + ".0";
        }
        String mantissa = res.substring(res.indexOf("."));
        while (mantissa.length() <= pop) {
            res = String.valueOf(res) + 0;
            mantissa = res.substring(res.indexOf("."));
        }
        if (nocommas || dub < 999.99) {
            return new PtgStr(res);
        }
        int e = res.indexOf(".");
        String mant = res.substring(e);
        String begin = res.substring(0, e);
        int counter = 0;
        int s = begin.length();
        int v = 0;
        while (v < s) {
            String ch = begin.substring(s - v - 1, s - v);
            mant = String.valueOf(ch) + mant;
            if (counter == 2 && ++v != s) {
                mant = "," + mant;
            }
            if (++counter != 3) continue;
            counter = 0;
        }
        return new PtgStr(mant);
    }

    protected static Ptg calcJIS(Ptg[] operands) {
        if (operands == null || operands[0] == null) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        WorkBook bk = operands[0].getParentRec().getWorkBook();
        if (bk.defaultLanguageIsDBCS()) {
            byte[] strbytes = TextCalculator.getUnicodeBytesFromOp(operands[0]);
            if (strbytes == null) {
                strbytes = operands[0].getValue().toString().getBytes();
            }
            try {
                return new PtgStr(new String(strbytes, "Shift_JIS"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new PtgStr(operands[0].getValue().toString());
    }

    protected static Ptg calcLeft(Ptg[] operands) {
        Object o;
        int numchars = 1;
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        if (operands[0] instanceof PtgErr) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        if (operands.length == 2) {
            if (operands[1] instanceof PtgErr) {
                return new PtgErr(PtgErr.ERROR_VALUE);
            }
            numchars = operands[1].getIntVal();
        }
        if ((o = operands[0].getValue()) == null) {
            return new PtgStr("");
        }
        String str = String.valueOf(o);
        if (str == null || numchars > str.length()) {
            return new PtgStr("");
        }
        String res = str.substring(0, numchars);
        return new PtgStr(res);
    }

    protected static Ptg calcLeftB(Ptg[] operands) {
        WorkBook bk = operands[0].getParentRec().getWorkBook();
        if (bk.defaultLanguageIsDBCS()) {
            int numchars = 1;
            if (operands.length < 1) {
                return new PtgErr(PtgErr.ERROR_VALUE);
            }
            if (operands.length == 2) {
                if (operands[1] instanceof PtgErr) {
                    return new PtgErr(PtgErr.ERROR_VALUE);
                }
                try {
                    numchars = operands[1].getIntVal();
                    byte[] b = new byte[numchars];
                    System.arraycopy(TextCalculator.getUnicodeBytesFromOp(operands[0]), 0, b, 0, numchars);
                    return new PtgStr(new String(b, "UTF-16LE"));
                }
                catch (Exception e) {
                    return new PtgErr(PtgErr.ERROR_VALUE);
                }
            }
        }
        return TextCalculator.calcLeft(operands);
    }

    protected static Ptg calcLen(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getError();
        }
        String s = String.valueOf(operands[0].getValue());
        return new PtgInt(s.length());
    }

    protected static Ptg calcLenB(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getError();
        }
        WorkBook bk = operands[0].getParentRec().getWorkBook();
        if (bk.defaultLanguageIsDBCS()) {
            return new PtgInt(TextCalculator.getUnicodeBytesFromOp(operands[0]).length);
        }
        String s = String.valueOf(operands[0].getValue());
        return new PtgInt(s.length());
    }

    protected static Ptg calcLower(Ptg[] operands) {
        if (operands.length > 1) {
            return PtgCalculator.getError();
        }
        String s = String.valueOf(operands[0].getValue());
        s = s.toLowerCase();
        return new PtgStr(s);
    }

    protected static Ptg calcMid(Ptg[] operands) {
        String s = String.valueOf(operands[0].getValue());
        if (s == null || s.equals("")) {
            return new PtgStr("");
        }
        if (operands[1] instanceof PtgErr || operands[2] instanceof PtgErr) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        int start = operands[1].getIntVal() - 1;
        int len = operands[2].getIntVal();
        if (len < 0) {
            len = start + len;
        }
        if (s.length() < start) {
            return new PtgStr("");
        }
        if (start == -1) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        if (len > (s = s.substring(start)).length()) {
            return new PtgStr(s);
        }
        s = s.substring(0, len);
        return new PtgStr(s);
    }

    protected static Ptg calcProper(Ptg[] operands) {
        String s = String.valueOf(operands[0].getValue());
        s = StringTool.proper(s);
        return new PtgStr(s);
    }

    protected static Ptg calcReplace(Ptg[] operands) {
        String origstr = String.valueOf(operands[0].getValue());
        int start = operands[1].getIntVal();
        int repamount = operands[2].getIntVal();
        String repstr = String.valueOf(operands[3].getValue());
        String begin = origstr.substring(0, start - 1);
        String end = origstr.substring(start + repamount - 1);
        String returnstr = String.valueOf(begin) + repstr + end;
        return new PtgStr(returnstr);
    }

    protected static Ptg calcRept(Ptg[] operands) {
        String origstr = String.valueOf(operands[0].getValue());
        int numtimes = operands[1].getIntVal();
        String retstr = "";
        int i = 0;
        while (i < numtimes) {
            retstr = String.valueOf(retstr) + origstr;
            ++i;
        }
        return new PtgStr(retstr);
    }

    protected static Ptg calcRight(Ptg[] operands) {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        String origstr = String.valueOf(operands[0].getValue());
        if (origstr.equals("")) {
            return new PtgStr("");
        }
        int numchars = operands[1].getIntVal();
        if (numchars > origstr.length()) {
            numchars = origstr.length();
        }
        if (numchars < 0) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        String res = origstr.substring(origstr.length() - numchars);
        return new PtgStr(res);
    }

    protected static Ptg calcSearch(Ptg[] operands) {
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        int start = 0;
        if (operands.length == 3) {
            start = operands[2].getIntVal() - 1;
        }
        String search = operands[0].getValue().toString().toLowerCase();
        String orig = operands[1].getValue().toString().toLowerCase();
        String tmp = orig.substring(start).toLowerCase();
        int i = tmp.indexOf(search);
        if (i == -1) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        i = orig.indexOf(search);
        return new PtgInt(++i);
    }

    protected static Ptg calcSearchB(Ptg[] operands) {
        if (operands == null || operands.length < 2 || operands[0] == null) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        WorkBook bk = operands[0].getParentRec().getWorkBook();
        if (!bk.defaultLanguageIsDBCS()) {
            return TextCalculator.calcSearch(operands);
        }
        int startnum = 0;
        if (operands.length > 2) {
            startnum = operands[2].getIntVal();
        }
        byte[] strToFind = TextCalculator.getUnicodeBytesFromOp(operands[0]);
        byte[] str = TextCalculator.getUnicodeBytesFromOp(operands[1]);
        int index = -1;
        if (strToFind == null || strToFind.length == 0 || str == null || startnum < 0 || str.length < startnum) {
            return new PtgInt(startnum);
        }
        String search = operands[0].getValue().toString().toLowerCase();
        String orig = operands[1].getValue().toString().toLowerCase();
        String tmp = orig.substring(startnum).toLowerCase();
        index = tmp.indexOf(search);
        if (index == -1) {
            new PtgErr(PtgErr.ERROR_VALUE);
        } else {
            index *= 2;
        }
        return new PtgInt(index + 1);
    }

    protected static Ptg calcSubstitute(Ptg[] operands) {
        int whichreplace = 0;
        if (operands.length < 3) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        if (operands.length == 4) {
            whichreplace = operands[3].getIntVal() - 1;
        }
        String origstr = operands[0].getValue().toString();
        String srchstr = operands[1].getValue().toString();
        String repstr = operands[2].getValue().toString();
        String finalstr = StringTool.replaceText(origstr, srchstr, repstr, whichreplace, true);
        return new PtgStr(finalstr);
    }

    protected static Ptg calcT(Ptg[] operands) {
        String res = "";
        try {
            res = (String)operands[0].getValue();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return new PtgStr(res);
    }

    protected static Ptg calcText(Ptg[] operands) {
        String fmx;
        if (operands.length != 2) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        String res = "#ERR!";
        try {
            res = String.valueOf(operands[0].getValue());
        }
        catch (Exception e) {
            res = operands[0].toString();
        }
        String fmt = operands[1].toString();
        Format fmtx = null;
        int t = 0;
        while (t < FormatConstants.NUMERIC_FORMATS.length) {
            fmx = FormatConstants.NUMERIC_FORMATS[t][0];
            if (fmx.equals(fmt)) {
                fmt = FormatConstants.NUMERIC_FORMATS[t][2];
                fmtx = new DecimalFormat(fmt);
            }
            ++t;
        }
        if (fmtx == null) {
            t = 0;
            while (t < FormatConstants.CURRENCY_FORMATS.length) {
                fmx = FormatConstants.CURRENCY_FORMATS[t][0];
                if (fmx.equals(fmt)) {
                    fmt = FormatConstants.CURRENCY_FORMATS[t][2];
                    fmtx = new DecimalFormat(fmt);
                }
                ++t;
            }
        }
        if (fmtx != null) {
            try {
                if (res != null && !res.equals("")) {
                    return new PtgStr(fmtx.format(new Float(res)));
                }
                if (res != null) {
                    return new PtgStr(fmtx.format(0));
                }
            }
            catch (Exception e) {
                try {
                    return new PtgStr(res);
                }
                catch (NumberFormatException fmx2) {
                    // empty catch block
                }
            }
        }
        int x = 0;
        while (x < FormatConstants.DATE_FORMATS.length) {
            fmx = FormatConstants.DATE_FORMATS[x][0];
            if (fmx.equals(fmt)) {
                fmt = FormatConstants.DATE_FORMATS[x][2];
                try {
                    Date d;
                    block31: {
                        try {
                            d = DateConverter.getDateFromNumber(new Double(res));
                        }
                        catch (NumberFormatException e) {
                            d = DateConverter.getDate(res);
                            if (d != null) break block31;
                            d = new Date("1/1/1990");
                        }
                    }
                    try {
                        WorkBookHandle.simpledateformat.applyPattern(fmt);
                    }
                    catch (Exception ex) {
                        Logger.logWarn("Simple Date Format could not parse: " + fmt + ". Returning default.");
                    }
                    return new PtgStr(WorkBookHandle.simpledateformat.format(d));
                }
                catch (Exception e) {
                    Logger.logErr("Unable to calcText formatting correctly for a date" + e);
                }
            }
            ++x;
        }
        try {
            if (Xf.isDatePattern(fmt)) {
                WorkBookHandle.simpledateformat.applyPattern(fmt);
                fmtx = WorkBookHandle.simpledateformat;
            } else {
                fmtx = new DecimalFormat(fmt);
            }
            if (res != null && !res.equals("")) {
                return new PtgStr(fmtx.format(new Float(res)));
            }
            if (res != null) {
                return new PtgStr(fmtx.format(0));
            }
        }
        catch (Exception e) {
            try {
                return new PtgStr(res);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new PtgStr(res);
    }

    protected static Ptg calcTrim(Ptg[] operands) {
        Object o = operands[0].getValue();
        String res = o instanceof Double ? ExcelTools.getNumberAsString((Double)o) : String.valueOf(o);
        if (res == null || res.equals(new PtgErr(PtgErr.ERROR_NA).toString())) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        if (res.length() > 0) {
            while (res.substring(0, 1).equals(" ")) {
                res = res.substring(1, res.length());
            }
            while (res.substring(res.length() - 1, res.length()).equals(" ")) {
                res = res.substring(0, res.length() - 1);
            }
            while (res.indexOf("  ") != -1) {
                int i = res.indexOf("  ");
                String prestring = res.substring(0, i);
                String poststring = res.substring(i + 1, res.length());
                res = String.valueOf(prestring) + poststring;
            }
        }
        return new PtgStr(res);
    }

    protected static Ptg calcUpper(Ptg[] operands) {
        if (operands.length > 1) {
            return PtgCalculator.getError();
        }
        String s = String.valueOf(operands[0].getValue());
        s = s.toUpperCase();
        return new PtgStr(s);
    }

    protected static Ptg calcValue(Ptg[] operands) {
        try {
            String s = String.valueOf(operands[0].getValue());
            if (s.equals("")) {
                s = "0";
            }
            Double d = new Double(s);
            return new PtgNumber(d);
        }
        catch (NumberFormatException e) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    private static byte[] getUnicodeBytesFromOp(Ptg op) {
        byte[] strbytes = null;
        if (op instanceof PtgRef) {
            BiffRec rec = ((PtgRef)op).getRefCells()[0];
            if (rec instanceof Labelsst) {
                strbytes = ((Labelsst)rec).getUnsharedString().readStr();
            } else if (rec instanceof Formula) {
                strbytes = op.getValue().toString().getBytes();
            } else {
                Logger.logWarn("getUnicodeBytes: Unexpected rec encountered: " + op.getClass());
            }
        } else if (op instanceof PtgStr) {
            strbytes = new byte[((PtgStr)op).record.length - 3];
            System.arraycopy(((PtgStr)op).record, 3, strbytes, 0, strbytes.length);
        } else {
            Logger.logWarn("getUnicodeBytes: Unexpected operand encountered: " + op.getClass());
        }
        return strbytes;
    }
}

