/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.formats.XLS.formulas.PtgInt;
import com.extentech.formats.XLS.formulas.PtgNumber;
import com.extentech.toolkit.Logger;

public class PtgUMinus
extends GenericPtg
implements Ptg {
    private static final long serialVersionUID = 8448419489380791823L;

    public PtgUMinus() {
        this.ptgId = (byte)19;
        this.record = new byte[1];
        this.record[0] = 19;
    }

    @Override
    public boolean getIsOperator() {
        return true;
    }

    @Override
    public boolean getIsPrimitiveOperator() {
        return true;
    }

    @Override
    public boolean getIsUnaryOperator() {
        return true;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public Ptg calculatePtg(Ptg[] form) {
        if (form.length != 1) {
            Logger.logWarn("PtgMinus calculating formula failed, wrong number of values.");
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        try {
            Ptg p = form[0];
            GenericPtg ret = null;
            if (p instanceof PtgInt) {
                int val = p.getIntVal();
                ret = new PtgInt(val *= -1);
            } else {
                double val = p.getDoubleVal();
                ret = new PtgNumber(val *= -1.0);
            }
            return ret;
        }
        catch (Exception e) {
            Logger.logWarn("PtgMinus calculating formula failed, could not negate operand " + form[0].toString() + " : " + e.toString());
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    @Override
    public String getString() {
        return "-";
    }

    public String toString() {
        return "u-";
    }
}

