/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArray;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.formats.XLS.formulas.PtgInt;
import com.extentech.formats.XLS.formulas.PtgNumber;
import com.extentech.formats.XLS.formulas.PtgStr;
import com.extentech.toolkit.Logger;
import java.lang.reflect.Array;

public class PtgSub
extends GenericPtg
implements Ptg {
    private static final long serialVersionUID = -3252464873846778499L;

    @Override
    public boolean getIsOperator() {
        return true;
    }

    @Override
    public boolean getIsPrimitiveOperator() {
        return true;
    }

    @Override
    public boolean getIsBinaryOperator() {
        return true;
    }

    public PtgSub() {
        this.ptgId = (byte)4;
        this.record = new byte[1];
        this.record[0] = 4;
    }

    @Override
    public String getString() {
        return "-";
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public Ptg calculatePtg(Ptg[] form) {
        try {
            Object[] o = GenericPtg.getValuesFromPtgs(form);
            if (o == null) {
                return new PtgErr(PtgErr.ERROR_VALUE);
            }
            if (!o[0].getClass().isArray()) {
                if (o.length != 2) {
                    Logger.logWarn("calculating formula failed, wrong number of values in PtgSub");
                    return new PtgErr(PtgErr.ERROR_VALUE);
                }
                if (form[0].isBlank()) {
                    o[0] = new Double(0.0);
                }
                if (form[1].isBlank()) {
                    o[1] = new Double(0.0);
                }
                if (!(o[0] instanceof Double) || !(o[1] instanceof Double)) {
                    if (this.parent_rec == null) {
                        return new PtgErr(PtgErr.ERROR_VALUE);
                    }
                    if (this.parent_rec.getSheet().getWindow2().getShowZeroValues()) {
                        return new PtgInt(0);
                    }
                    return new PtgStr("");
                }
                double returnVal = (Double)o[0] - (Double)o[1];
                PtgNumber n = new PtgNumber(returnVal);
                return n;
            }
            String retArry = "";
            int nArrays = Array.getLength(o);
            if (nArrays != 2) {
                return new PtgErr(PtgErr.ERROR_VALUE);
            }
            int nVals = Array.getLength(o[0]);
            int i = 0;
            while (i < nArrays - 1) {
                Object secondOp = null;
                boolean comparitorIsArray = o[i + 1].getClass().isArray();
                if (!comparitorIsArray) {
                    secondOp = o[i + 1];
                }
                int j = 0;
                while (j < nVals) {
                    Object firstOp = Array.get(o[i], j);
                    if (comparitorIsArray) {
                        secondOp = Array.get(o[i + 1], j);
                    }
                    if (!(firstOp instanceof Double) || !(secondOp instanceof Double)) {
                        if (this.parent_rec == null) {
                            return new PtgErr(PtgErr.ERROR_VALUE);
                        }
                        if (this.parent_rec.getSheet().getWindow2().getShowZeroValues()) {
                            return new PtgInt(0);
                        }
                        return new PtgStr("");
                    }
                    double retVal = (Double)firstOp - (Double)secondOp;
                    retArry = String.valueOf(retArry) + retVal + ",";
                    ++j;
                }
                i += 2;
            }
            retArry = "{" + retArry.substring(0, retArry.length() - 1) + "}";
            PtgArray pa = new PtgArray();
            pa.setVal(retArry);
            return pa;
        }
        catch (NumberFormatException e) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_VALUE);
            return perr;
        }
        catch (Exception e) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_VALUE);
            return perr;
        }
    }
}

