/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.formats.XLS.formulas.PtgNumber;
import com.extentech.toolkit.Logger;

public class PtgPower
extends GenericPtg
implements Ptg {
    private static final long serialVersionUID = 4675566993519011450L;

    @Override
    public boolean getIsOperator() {
        return true;
    }

    @Override
    public boolean getIsPrimitiveOperator() {
        return true;
    }

    @Override
    public boolean getIsBinaryOperator() {
        return true;
    }

    public PtgPower() {
        this.ptgId = (byte)7;
        this.record = new byte[1];
        this.record[0] = 7;
    }

    @Override
    public String getString() {
        return "^";
    }

    @Override
    public int getLength() {
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Ptg calculatePtg(Ptg[] form) {
        Object[] o;
        block3: {
            try {
                o = GenericPtg.getValuesFromPtgs(form);
                if (o[0].getClass().isArray()) return new PtgErr(PtgErr.ERROR_VALUE);
                if (o != null && o.length == 2) break block3;
                Logger.logWarn("calculating formula failed, wrong number of values in PtgPower");
                return null;
            }
            catch (Exception e) {
                return new PtgErr(PtgErr.ERROR_VALUE);
            }
        }
        double returnVal = Math.pow((Double)o[0], (Double)o[1]);
        return new PtgNumber(returnVal);
    }
}

