/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.ExpressionParser;
import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.formulas.CalculationException;
import com.extentech.formats.XLS.formulas.FormulaCalculator;
import com.extentech.formats.XLS.formulas.FormulaParser;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArea;
import com.extentech.formats.XLS.formulas.PtgArea3d;
import com.extentech.formats.XLS.formulas.PtgAreaErr3d;
import com.extentech.formats.XLS.formulas.PtgCalculator;
import com.extentech.formats.XLS.formulas.PtgIsect;
import com.extentech.formats.XLS.formulas.PtgName;
import com.extentech.formats.XLS.formulas.PtgParen;
import com.extentech.formats.XLS.formulas.PtgRange;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.formats.XLS.formulas.PtgRef3d;
import com.extentech.formats.XLS.formulas.PtgUnion;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.FastAddVector;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.Stack;

public class PtgMemFunc
extends GenericPtg {
    public static final long serialVersionUID = 666555444333222L;
    Stack<?> subexpression = null;
    Ptg[] ptgs = null;
    int cce;
    byte[] subexp;
    ArrayList<String> refsheets = new ArrayList();
    int calc_id = 1;
    PtgRef[] colrefs = null;
    PtgRef[] comps = null;
    private boolean useReferenceTracker = true;

    @Override
    public boolean getIsOperand() {
        return true;
    }

    @Override
    public boolean getIsReference() {
        return true;
    }

    @Override
    public void init(byte[] b) {
        this.ptgId = b[0];
        this.record = b;
        try {
            this.populateVals();
        }
        catch (Exception e) {
            Logger.logErr("PtgMemFunc init: " + e.toString());
        }
    }

    void populateVals() throws Exception {
        this.cce = ByteTools.readShort(this.record[1], this.record[2]);
        this.subexp = new byte[this.cce];
        System.arraycopy(this.record, 3, this.subexp, 0, this.cce);
        this.subexpression = ExpressionParser.parseExpression(this.subexp, this.parent_rec);
    }

    @Override
    public byte[] getRecord() {
        int len = 0;
        int i = 0;
        while (i < this.subexpression.size()) {
            Ptg p = (Ptg)this.subexpression.get(i);
            len += p.getRecord().length;
            ++i;
        }
        byte[] b = new byte[len + 3];
        byte[] leng = ByteTools.shortToLEBytes((short)len);
        b[0] = 41;
        b[1] = leng[0];
        b[2] = leng[1];
        int offset = 3;
        int i2 = 0;
        while (i2 < this.subexpression.size()) {
            Ptg p = (Ptg)this.subexpression.get(i2);
            System.arraycopy(p.getRecord(), 0, b, offset, p.getRecord().length);
            offset += p.getRecord().length;
            ++i2;
        }
        this.record = b;
        return this.record;
    }

    @Override
    public int getLength() {
        return this.cce + 3;
    }

    @Override
    public Object getValue() {
        double[] dub;
        if (this.ptgs == null) {
            this.parseSubexpression();
        }
        try {
            dub = PtgCalculator.getDoubleValueArray(this.ptgs);
        }
        catch (CalculationException e) {
            return null;
        }
        try {
            double result = 0.0;
            int i = 0;
            while (i < dub.length) {
                result += dub[i];
                ++i;
            }
            return new Double(result);
        }
        catch (FunctionNotSupportedException e) {
            Logger.logWarn("Function Unsupported error in PtgMemFunction: " + e);
            return null;
        }
    }

    public Ptg[] getColComponents(int colNum) {
        if (this.colrefs != null) {
            return this.colrefs;
        }
        FastAddVector v = new FastAddVector();
        Ptg[] allComponents = this.getComponents();
        int i = 0;
        while (i < allComponents.length) {
            PtgRef p = (PtgRef)allComponents[i];
            int[] x = p.getIntLocation();
            if (x[1] == colNum) {
                v.add(p);
            }
            ++i;
        }
        this.colrefs = new PtgRef[v.size()];
        v.toArray(this.colrefs);
        return this.colrefs;
    }

    private void parseSubexpression() {
        Object o = FormulaCalculator.calculateFormula(this.subexpression);
        ArrayList<Ptg> components = new ArrayList<Ptg>();
        if (o != null && o instanceof Ptg[]) {
            int i = 0;
            while (i < this.subexpression.size()) {
                try {
                    ((PtgRef)this.subexpression.get(i)).removeFromRefTracker();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            this.ptgs = (Ptg[])o;
            i = 0;
            while (i < this.ptgs.length) {
                try {
                    if (!this.refsheets.contains(((PtgRef)this.ptgs[i]).getSheetName())) {
                        this.refsheets.add(((PtgRef)this.ptgs[i]).getSheetName());
                    }
                    ((PtgRef)this.ptgs[i]).addToRefTracker();
                    if (this.ptgs[i] instanceof PtgArea & !(this.ptgs[i] instanceof PtgAreaErr3d)) {
                        Ptg[] p = this.ptgs[i].getComponents();
                        int j = 0;
                        while (j < p.length) {
                            components.add(p[j]);
                            ++j;
                        }
                    } else {
                        components.add(this.ptgs[i]);
                    }
                }
                catch (Exception e) {
                    Logger.logErr("PtgMemFunc init: " + e.toString());
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.subexpression.size()) {
                try {
                    PtgRef pr = (PtgRef)this.subexpression.get(i);
                    if (!this.refsheets.contains(pr.getSheetName())) {
                        this.refsheets.add(pr.getSheetName());
                    }
                    if (pr instanceof PtgArea) {
                        Ptg[] pa = pr.getComponents();
                        int j = 0;
                        while (j < pa.length) {
                            components.add(pa[j]);
                            ++j;
                        }
                    } else {
                        components.add(pr);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        this.ptgs = new Ptg[components.size()];
        components.toArray(this.ptgs);
    }

    @Override
    public Ptg[] getComponents() {
        if (this.ptgs == null) {
            this.parseSubexpression();
        }
        return this.ptgs;
    }

    public Ptg getFirstloc() {
        if (this.ptgs == null) {
            this.parseSubexpression();
        }
        if (this.ptgs != null) {
            return this.ptgs[0];
        }
        return null;
    }

    public void setUseReferenceTracker(boolean b) {
        this.useReferenceTracker = b;
    }

    public boolean getUseReferenceTracker() {
        return this.useReferenceTracker;
    }

    public Stack<?> getSubExpression() {
        return this.subexpression;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setLocation(String complexrange) {
        byte[] newData = new byte[3];
        String sheetName = "";
        WorkBook bk = null;
        ArrayList<String> sheets = new ArrayList<String>();
        try {
            bk = this.getParentRec().getWorkBook();
            int i = 0;
            while (true) {
                if (i >= bk.getSheetVect().size()) {
                    sheetName = String.valueOf(this.getParentRec().getSheet().getSheetName()) + "!";
                    break;
                }
                sheets.add(bk.getWorkSheetByNumber(i).getSheetName());
                ++i;
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        if (complexrange.startsWith("(") && complexrange.endsWith(")")) {
            complexrange = complexrange.substring(0, complexrange.length() - 1);
        }
        Stack<Comparable> refs = this.parseFmla(complexrange);
        try {
            while (refs.size() != 0) {
                while (refs.size() > 0) {
                    block25: {
                        block23: {
                            Character cOp;
                            block26: {
                                block24: {
                                    if (!(refs.get(0) instanceof Character)) break block23;
                                    cOp = (Character)refs.get(0);
                                    if (cOp.charValue() != ',') break block24;
                                    PtgUnion pu = new PtgUnion();
                                    this.cce += pu.getRecord().length;
                                    newData = ByteTools.append(pu.getRecord(), newData);
                                    break block25;
                                }
                                if (cOp.charValue() != ' ') break block26;
                                PtgIsect pi = new PtgIsect();
                                this.cce += pi.getRecord().length;
                                newData = ByteTools.append(pi.getRecord(), newData);
                                break block25;
                            }
                            if (cOp.charValue() == ':') {
                                PtgRange pr = new PtgRange();
                                this.cce += pr.getRecord().length;
                                newData = ByteTools.append(pr.getRecord(), newData);
                                break block25;
                            } else if (cOp.charValue() == ')') {
                                PtgParen pp = new PtgParen();
                                this.cce += pp.getRecord().length;
                                newData = ByteTools.append(pp.getRecord(), newData);
                            }
                            break block25;
                        }
                        Object o = refs.get(0);
                        if (o instanceof Ptg) {
                            this.cce += ((Ptg)o).getRecord().length;
                            newData = ByteTools.append(((Ptg)o).getRecord(), newData);
                        } else {
                            String ref = (String)o;
                            boolean isName = this.getParentRec().getWorkBook().getName(ref) != null;
                            GenericPtg p = null;
                            if (isName) {
                                p = new PtgName();
                                p.setParentRec(this.parent_rec);
                                ((PtgName)p).setName(ref);
                                this.cce += p.getRecord().length;
                                newData = ByteTools.append(p.getRecord(), newData);
                            } else if (ref.indexOf(":") > 0) {
                                if (ref.indexOf("!") == -1) {
                                    ref = String.valueOf(sheetName) + ref;
                                }
                                p = new PtgArea3d();
                                p.setParentRec(this.parent_rec);
                                p.setLocation(ref);
                                this.cce += p.getRecord().length;
                                newData = ByteTools.append(p.getRecord(), newData);
                            } else {
                                if (ref.indexOf("!") == -1) {
                                    ref = String.valueOf(sheetName) + ref;
                                }
                                p = new PtgRef3d();
                                p.setParentRec(this.parent_rec);
                                p.setLocation(ref);
                                ((PtgRef3d)p).setPtgType((short)1);
                                this.cce += p.getRecord().length;
                                newData = ByteTools.append(p.getRecord(), newData);
                            }
                        }
                    }
                    refs.remove(0);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("PtgMemFunc Error Parsing Location " + complexrange + ":" + e.toString());
        }
        byte[] ix = ByteTools.shortToLEBytes((short)this.cce);
        System.arraycopy(ix, 0, newData, 1, 2);
        newData[0] = 41;
        this.record = newData;
        try {
            this.populateVals();
            return;
        }
        catch (Exception e) {
            Logger.logErr("PtgMemFunc setLocation failed for: " + complexrange + " " + e.toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    private Stack<Comparable> parseFmla(String complexrange) {
        ops = new Stack<Comparable>();
        lastOp = 0;
        finishRange = false;
        refs = new Stack<Comparable>();
        ref = "";
        inquote = false;
        range = null;
        i = 0;
        while (i < complexrange.length()) {
            block30: {
                block31: {
                    block34: {
                        block35: {
                            block33: {
                                block32: {
                                    block29: {
                                        c = complexrange.charAt(i);
                                        if (c != '\'') break block29;
                                        inquote = inquote == false;
                                        ref = String.valueOf(ref) + c;
                                        break block30;
                                    }
                                    if (inquote) break block31;
                                    if (c != ',' && c != ' ' && c != ')' && (c != ':' || !finishRange)) break block32;
                                    if (c != ' ' || lastOp != 32) {
                                        if (finishRange) {
                                            refs.push((Comparable)(String.valueOf(range) + ref));
                                            if (!refs.isEmpty() && !ops.isEmpty()) {
                                                refs = PtgMemFunc.handleOpearatorPreference(refs, ops);
                                            }
                                            while (!ops.isEmpty()) {
                                                refs.push(ops.pop());
                                            }
                                            range = null;
                                            ref = "";
                                            finishRange = false;
                                            ops.push(new Character(c));
                                        } else if (refs.isEmpty()) {
                                            if (!ref.equals("")) {
                                                refs.push((Comparable)ref);
                                            }
                                            ref = "";
                                            ops.push(new Character(c));
                                        } else {
                                            if (!ref.equals("")) {
                                                refs.push((Comparable)ref);
                                            }
                                            while (!ops.isEmpty()) {
                                                refs.push((Comparable)ops.pop());
                                            }
                                            ref = "";
                                            ops.push(new Character(c));
                                        }
                                        lastOp = c;
                                    }
                                    break block30;
                                }
                                if (c != ':') break block33;
                                if (this.getParentRec().getWorkBook().getName(ref) == null) {
                                    if (!ref.equals("")) {
                                        range = String.valueOf(ref) + c;
                                        finishRange = true;
                                    } else {
                                        ops.push(new Character(c));
                                    }
                                    ref = "";
                                } else {
                                    refs.push((Comparable)ref);
                                    ref = "";
                                    ops.push(new Character(c));
                                    finishRange = false;
                                }
                                break block30;
                            }
                            if (c != '(') break block34;
                            endparen = FormulaParser.getMatchOperator(complexrange, i, '(', ')');
                            if (endparen != -1) break block35;
                            endparen = complexrange.length() - 1;
                            ** GOTO lbl-1000
                        }
                        if (!ref.equals("")) {
                            f = String.valueOf(ref) + "(" + complexrange.substring(i + 1, endparen + 1);
                            ref = "";
                            refs = this.mergeStacks(refs, FormulaParser.getPtgsFromFormulaString(this.getParentRec(), f, true));
                            i = endparen;
                            if (!ops.isEmpty()) {
                                refs = PtgMemFunc.handleOpearatorPreference(refs, ops);
                            }
                            while (!ops.isEmpty()) {
                                refs.push(ops.pop());
                            }
                        } else lbl-1000:
                        // 2 sources

                        {
                            refs = this.mergeStacks(refs, this.parseFmla(complexrange.substring(i + 1, endparen + 1)));
                            i = endparen;
                            if (!ops.isEmpty()) {
                                refs = PtgMemFunc.handleOpearatorPreference(refs, ops);
                            }
                            while (!ops.isEmpty()) {
                                refs.push(ops.pop());
                            }
                        }
                        break block30;
                    }
                    ref = String.valueOf(ref) + c;
                    break block30;
                }
                ref = String.valueOf(ref) + c;
            }
            ++i;
        }
        if (finishRange) {
            if (!ops.isEmpty() && ((Character)ops.peek()).charValue() == ':' && !refs.isEmpty() && refs.peek() instanceof Character) {
                while (refs.peek() instanceof Character) {
                    if (((Character)refs.peek()).charValue() == ':') break;
                    ops.add(0, refs.pop());
                }
            }
            if (!ref.equals("")) {
                refs.push((Comparable)(String.valueOf(range) + ref));
            } else {
                refs.push((Comparable)range.substring(0, range.length() - 1));
                ops.push(Character.valueOf(':'));
            }
        } else if (!ref.equals("")) {
            refs.push((Comparable)ref);
        }
        while (!ops.isEmpty()) {
            refs.push((Comparable)ops.pop());
        }
        return refs;
    }

    private static Stack<Comparable> handleOpearatorPreference(Stack<Comparable> refs, Stack<Comparable> ops) {
        char lastOp = ((Character)ops.pop()).charValue();
        if (refs.peek() instanceof Character) {
            char curOp = ((Character)refs.pop()).charValue();
            int group1 = PtgMemFunc.rankPrecedence(lastOp);
            int group2 = PtgMemFunc.rankPrecedence(curOp);
            if (group2 >= group1) {
                ops.push(new Character(lastOp));
                refs.push(new Character(curOp));
            } else {
                ops.push(new Character(curOp));
                refs.push(new Character(lastOp));
            }
        } else {
            ops.push(new Character(lastOp));
        }
        return refs;
    }

    static int rankPrecedence(char curOp) {
        if (curOp == '\u0000') {
            return -1;
        }
        if (curOp == ')') {
            return 6;
        }
        if (curOp == ':') {
            return 5;
        }
        if (curOp == ',' || curOp == ' ') {
            return 4;
        }
        return 0;
    }

    private Stack<Comparable> mergeStacks(Stack<Comparable> first, Stack<Comparable> last) {
        first.addAll(last);
        return first;
    }

    public String toString() {
        return FormulaParser.getExpressionString(this.subexpression).substring(1);
    }

    public Boundsheet[] getSheets(WorkBook b) {
        if (this.ptgs == null) {
            this.parseSubexpression();
        }
        if (this.refsheets != null || this.refsheets.size() != 0) {
            try {
                Boundsheet[] sheets = new Boundsheet[this.refsheets.size()];
                int i = 0;
                while (i < sheets.length) {
                    sheets[i] = b.getWorkSheetByName(this.refsheets.get(i));
                    ++i;
                }
                return sheets;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void close() {
        if (this.ptgs != null) {
            int i = 0;
            while (i < this.ptgs.length) {
                if (this.ptgs[i] instanceof PtgRef) {
                    ((PtgRef)this.ptgs[i]).close();
                } else {
                    ((GenericPtg)this.ptgs[i]).close();
                }
                ++i;
            }
        }
        this.ptgs = null;
        super.close();
    }
}

