/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.formulas.CalculationException;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.MathFunctionCalculator;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.toolkit.ByteTools;

public class PtgAtr
extends GenericPtg
implements Ptg {
    private static final long serialVersionUID = -2825828785221803436L;
    byte grbit = 0;
    int bitAttrVolatile = 0;
    int bitAttrIf = 0;
    int bitAttrChoose = 0;
    int bitAttrGoto = 0;
    int bitAttrSum = 0;
    int bitAttrAssign = 0;
    int bitAttrSpace = 0;
    int bitAttrSpaceVolatile = 0;
    Ptg[] alloperands = null;

    public PtgAtr() {
    }

    public PtgAtr(byte type) {
        this.record = new byte[4];
        this.record[0] = 25;
        this.record[1] = type;
    }

    @Override
    public String getString() {
        this.init();
        if (this.bitAttrIf > 0) {
            return "";
        }
        if (this.bitAttrSum > 0) {
            return "SUM(";
        }
        if (this.bitAttrVolatile > 0) {
            return "";
        }
        if (this.bitAttrAssign > 0) {
            return " EQUALS ";
        }
        if (this.bitAttrChoose > 0) {
            return "CHOOSE(";
        }
        if (this.bitAttrSpace > 0) {
            return " ";
        }
        if (this.bitAttrGoto > 0) {
            return "";
        }
        return "UNKNOWN(";
    }

    public String toString() {
        return String.valueOf(this.getString()) + this.getString2();
    }

    @Override
    public String getString2() {
        if (this.bitAttrIf > 0) {
            return "";
        }
        if (this.bitAttrSum > 0) {
            return ")";
        }
        if (this.bitAttrVolatile > 0) {
            return "";
        }
        if (this.bitAttrAssign > 0) {
            return ")";
        }
        if (this.bitAttrChoose > 0) {
            return ")";
        }
        if (this.bitAttrGoto > 0) {
            return "";
        }
        return "";
    }

    @Override
    public boolean getIsControl() {
        this.init();
        if (this.getIsPrimitiveOperator()) {
            return false;
        }
        if (this.bitAttrIf > 0) {
            return false;
        }
        if (this.bitAttrSum > 0) {
            return true;
        }
        if (this.bitAttrVolatile > 0) {
            return false;
        }
        if (this.bitAttrAssign > 0) {
            return true;
        }
        if (this.bitAttrGoto > 0) {
            return false;
        }
        if (this.bitAttrChoose > 0) {
            return false;
        }
        return false;
    }

    @Override
    public boolean getIsPrimitiveOperator() {
        this.init();
        return this.bitAttrSpace > 0;
    }

    @Override
    public boolean getIsUnaryOperator() {
        if (this.bitAttrIf > 0) {
            return false;
        }
        return this.bitAttrChoose <= 0;
    }

    @Override
    public boolean getIsOperator() {
        return false;
    }

    public boolean getIsSpace() {
        return this.bitAttrSpace > 0;
    }

    @Override
    public boolean getIsOperand() {
        return this.bitAttrVolatile > 0;
    }

    public void init() {
        this.grbit = this.getRecord()[1];
        if ((this.grbit & 1) == 1) {
            this.bitAttrVolatile = 1;
        }
        if ((this.grbit & 2) == 2) {
            this.bitAttrIf = 1;
        }
        if ((this.grbit & 4) == 4) {
            this.bitAttrChoose = 1;
        }
        if ((this.grbit & 8) == 8) {
            this.bitAttrGoto = 1;
        }
        if ((this.grbit & 0x10) == 16) {
            this.bitAttrSum = 1;
        }
        if ((this.grbit & 0x20) == 32) {
            this.bitAttrAssign = 1;
        }
        if ((this.grbit & 0x40) == 64) {
            this.bitAttrSpace = 1;
        }
        if ((this.grbit & 0x41) == 65) {
            this.bitAttrSpaceVolatile = 1;
        }
    }

    public int getLength(byte[] b) {
        if ((b[0] & 4) == 4) {
            int i = ByteTools.readShort(b[1], b[2]);
            return i += 4;
        }
        return this.getLength();
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public Ptg calculatePtg(Ptg[] pthing) throws FunctionNotSupportedException, CalculationException {
        Ptg returnPtg = null;
        if (this.bitAttrSum > 0) {
            returnPtg = MathFunctionCalculator.calcSum(pthing);
        }
        return returnPtg;
    }
}

