/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.Shrfmla;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.PtgArea;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.formats.XLS.formulas.PtgRefN;

public class PtgAreaN
extends PtgArea {
    private static final long serialVersionUID = -8433468704529379504L;
    PtgRefN firstPtgN;
    PtgRefN lastPtgN;
    private PtgArea parea = null;

    @Override
    public boolean getIsOperand() {
        return true;
    }

    @Override
    public boolean getIsReference() {
        return true;
    }

    @Override
    public void populateVals() {
        byte[] temp1 = new byte[5];
        byte[] temp2 = new byte[5];
        temp1[0] = 36;
        temp2[0] = 36;
        System.arraycopy(this.record, 1, temp1, 1, 2);
        System.arraycopy(this.record, 5, temp1, 3, 2);
        System.arraycopy(this.record, 3, temp2, 1, 2);
        System.arraycopy(this.record, 7, temp2, 3, 2);
        this.firstPtgN = new PtgRefN(false);
        this.firstPtgN.setParentRec(this.parent_rec);
        this.firstPtgN.init(temp1);
        this.lastPtgN = new PtgRefN(false);
        this.lastPtgN.setParentRec(this.parent_rec);
        this.lastPtgN.init(temp2);
        if (this.parent_rec != null && this.parent_rec instanceof Shrfmla) {
            this.lastPtgN.setFormulaRow(((Shrfmla)this.parent_rec).getLastRow());
            this.lastPtgN.setFormulaCol(((Shrfmla)this.parent_rec).getLastCol());
        }
    }

    @Override
    public int[] getRowCol() {
        if (this.firstPtgN == null) {
            int[] rc1 = this.firstPtgN.getRowCol();
            int[] ret = new int[]{rc1[0], rc1[1], rc1[0], rc1[1]};
            return ret;
        }
        int[] rc1 = this.firstPtgN.getRowCol();
        int[] rc2 = this.lastPtgN.getRowCol();
        int[] ret = new int[]{rc1[0], rc1[1], rc2[0], rc2[1]};
        return ret;
    }

    public int[] getRealRowCol() {
        return new int[]{this.firstPtgN.rw, this.firstPtgN.col, this.lastPtgN.rw, this.lastPtgN.col};
    }

    public PtgArea convertToPtgArea(XLSRecord r2) {
        PtgRef p1 = this.firstPtgN.convertToPtgRef(r2);
        PtgRef p2 = this.lastPtgN.convertToPtgRef(r2);
        PtgArea par = new PtgArea(p1, p2, r2);
        return par;
    }

    @Override
    public void updateRecord() {
        byte[] first = this.firstPtgN.getRecord();
        byte[] last = this.lastPtgN.getRecord();
        byte[] newrecord = new byte[9];
        newrecord[0] = this.record[0];
        System.arraycopy(first, 1, newrecord, 1, 2);
        System.arraycopy(last, 1, newrecord, 3, 2);
        System.arraycopy(first, 3, newrecord, 5, 2);
        System.arraycopy(last, 3, newrecord, 7, 2);
        this.record = newrecord;
    }

    @Override
    public String getLocation() {
        if (this.firstPtgN == null || this.lastPtgN == null) {
            this.populateVals();
            if (this.firstPtgN == null || this.lastPtgN == null) {
                throw new AssertionError((Object)"PtgAreaN.getLocation null ptgs");
            }
        }
        String s = this.firstPtgN.getLocation();
        String y = this.lastPtgN.getLocation();
        return String.valueOf(s) + ":" + y;
    }

    @Override
    public int[] getIntLocation() {
        int[] returning = new int[4];
        try {
            int[] first = this.firstPtgN.getIntLocation();
            int[] last = this.lastPtgN.getIntLocation();
            System.arraycopy(first, 0, returning, 0, 2);
            System.arraycopy(last, 0, returning, 2, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returning;
    }

    public PtgRefN getLastPtgN() {
        return this.lastPtgN;
    }

    public PtgRefN getFirstPtgN() {
        return this.firstPtgN;
    }

    public PtgArea getArea() {
        Shrfmla sh = (Shrfmla)this.getParentRec();
        int[] i = new int[]{this.fRwRel ? sh.getFirstRow() + this.firstPtgN.rw : this.firstPtgN.rw, this.fColRel ? sh.getFirstCol() + this.firstPtgN.col : this.firstPtgN.col, this.fRwRel ? sh.getLastRow() + this.lastPtgN.rw : this.lastPtgN.rw, this.fColRel ? sh.getLastCol() + this.lastPtgN.col : this.lastPtgN.col};
        if (i[1] >= 256 && !this.parent_rec.getWorkBook().getIsExcel2007()) {
            i[1] = i[1] - 256;
        }
        if (i[3] >= 256 && !this.parent_rec.getWorkBook().getIsExcel2007()) {
            i[3] = i[3] - 256;
        }
        PtgArea parea = new PtgArea(i, (XLSRecord)sh, true);
        return parea;
    }

    @Override
    public void addToRefTracker() {
        short iParent = this.getParentRec().getOpcode();
        if (iParent == 1212) {
            PtgArea parea = this.getArea();
            parea.addToRefTracker();
        }
    }

    @Override
    public void removeFromRefTracker() {
        short iParent = this.getParentRec().getOpcode();
        if (iParent == 1212) {
            PtgArea parea = this.getArea();
            parea.removeFromRefTracker();
        }
    }

    @Override
    public void close() {
        this.removeFromRefTracker();
        if (this.parea != null) {
            this.parea.close();
        }
        this.parea = null;
        if (this.firstPtgN != null) {
            this.firstPtgN.close();
        }
        this.firstPtgN = null;
        if (this.lastPtgN != null) {
            this.lastPtgN.close();
        }
        this.lastPtgN = null;
    }
}

